/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import com.jcraft.jsch.Session;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.StringReader;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.readers.DataReadable;
import oracle.dbtools.raptor.data.readers.DataReaderRegistry;
import oracle.dbtools.raptor.data.readers.HSVReader;
import oracle.dbtools.raptor.data.ui.DataPreviewPage;
import oracle.dbtools.raptor.data.ui.ImportFormatOptionsPanel;
import oracle.dbtools.raptor.datatools.DataToolsArb;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.hadoop.core.HadoopFileHelper;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.core.HadoopUtils;
import oracle.dbtools.raptor.hadoop.core.OSCHImportDataFormat;
import oracle.dbtools.raptor.hadoop.ui.HadoopFileChooserPanel;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.dialogs.MessageDetailsDialog;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class OSCHIDataPreviewPage
extends DataPreviewPage {
    private static final long serialVersionUID = 1L;
    private TraversableContext _ctx;
    private HadoopProperties _hProps;
    private String _hostName;
    private String _rootDir;
    private String _lastSelectedDir;
    private HadoopFileHelper _fileHelper;
    private JPanel _uiPanel;
    protected JLabel _uiRootLabel;
    protected HadoopFileChooserPanel _uiRootCmp;
    private JLabel _uiLabel;
    private JComboBox<String> _uiSampleCmp;
    private JButton _uiButton;
    private String _uiButtonString;
    private HSVReader reader;

    public OSCHIDataPreviewPage() {
        this._lastSelectedDir = this._rootDir = "/user";
        this._uiLabel = new JLabel();
        this._uiButton = new JButton();
        this._uiButtonString = HadoopWizArb.getString("OPEN");
        this.reader = new HSVReader();
    }

    protected JPanel getDataChooser() {
        return this._uiPanel;
    }

    protected void setDataChooserText(String string) {
        this._uiSampleCmp.setSelectedItem(string);
    }

    protected String getDataChooserText() {
        return (String)this._uiSampleCmp.getSelectedItem();
    }

    protected ImportDataFormat getDefaultFormat(int n) {
        return new OSCHImportDataFormat(n, BaseDataFormat.HSV);
    }

    protected void initDataChooser() {
        this._uiButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OSCHIDataPreviewPage.this.open();
            }
        });
        this._uiButton.setEnabled(false);
        this.initSourceRootLabel();
        this.initSourceRootCmp();
        this.initSampleCmp();
        ResourceUtils.resLabel((JLabel)this._uiLabel, this._uiSampleCmp, (String)HadoopWizArb.getString("SAMPLE_FILE"));
        ResourceUtils.resButton((AbstractButton)this._uiButton, (String)this._uiButtonString);
        this._uiPanel = new JPanel(new GridBagLayout());
        this.setLayout(new GridBagLayout());
        int n = 0;
        this._uiPanel.add((Component)this._uiRootLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE));
        this._uiPanel.add((Component)this._uiRootCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this._uiPanel.add((Component)this._uiLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE));
        this._uiPanel.add(this._uiSampleCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this._uiPanel.add((Component)this._uiButton, LayoutControl.GBC.gbc((int)2, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP));
        LayoutControl.GBC.addVSpring((JPanel)this._uiPanel, (int)(++n));
    }

    protected void initSampleCmp() {
        this._uiSampleCmp = new JComboBox();
        this._uiSampleCmp.setEditable(false);
        this._uiSampleCmp.setToolTipText(HadoopWizArb.getString("SAMPLE_FILE_TIP"));
        this._uiSampleCmp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)OSCHIDataPreviewPage.this._uiSampleCmp.getSelectedItem();
                OSCHIDataPreviewPage.this._uiButton.setEnabled(OSCHIDataPreviewPage.this._uiButton != null && string != null && !string.isEmpty());
            }
        });
        this._uiSampleCmp.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                OSCHIDataPreviewPage.this._uiSampleCmp.removeAllItems();
                OSCHIDataPreviewPage.this.loadRootCmp();
                Vector<String> vector = OSCHIDataPreviewPage.this._fileHelper.getFileChildren(OSCHIDataPreviewPage.this._uiRootCmp.getText());
                for (String string : vector) {
                    OSCHIDataPreviewPage.this._uiSampleCmp.addItem(string);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    private Vector<String> loadRootCmp() {
        String string = this._uiRootCmp.getText() == null ? this._lastSelectedDir : this._uiRootCmp.getText();
        this._fileHelper.setHost(this._hostName);
        this._fileHelper.setRootDir(string);
        return this._fileHelper.getDirs();
    }

    protected void initSourceRootLabel() {
        if (this._uiRootLabel == null) {
            this._uiRootLabel = new JLabel(HadoopWizArb.getString("S_HDFS_DIR"));
        }
    }

    protected void initSourceRootCmp() {
        if (null == this._uiRootCmp) {
            this._fileHelper = new HadoopFileHelper(this._hostName, "/user/" + this._hProps.get(HadoopKeys.SSH_USER));
            this._uiRootCmp = new HadoopFileChooserPanel(HadoopWizArb.getString("HDFS_DIR_BROWSER"), this._fileHelper, "", false);
            this._uiRootCmp.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getPropertyName();
                    if (string.equals("APPLY")) {
                        String string2 = (String)propertyChangeEvent.getNewValue();
                        OSCHIDataPreviewPage.this._uiSampleCmp.removeAllItems();
                        Vector<String> vector = OSCHIDataPreviewPage.this._fileHelper.getFileChildren(string2);
                        for (String string3 : vector) {
                            OSCHIDataPreviewPage.this._uiSampleCmp.addItem(string3);
                        }
                    }
                    if (string.equals("RESET")) {
                        OSCHIDataPreviewPage.this._uiSampleCmp.removeAllItems();
                    }
                }
            });
        }
    }

    private void addChildren(JComboBox<String> jComboBox, String string, Vector<String> vector) {
        String[] stringArray = string.split("/");
        for (String string2 : vector) {
            String[] stringArray2 = string2.split("/");
            if (stringArray.length + 1 != stringArray2.length || !string2.startsWith(string)) continue;
            jComboBox.addItem(string2);
        }
    }

    private void open() {
        String string = (String)this._uiSampleCmp.getSelectedItem();
        String string2 = "hadoop fs -cat " + string + " | head -105 ";
        Session session = HadoopUtils.getSshSession(this._hostName);
        ScriptOutput scriptOutput = HadoopUtils.executeCommand(session, string2);
        if (scriptOutput.rc != 0 && scriptOutput.stdout.isEmpty()) {
            String string3 = "STDOUT: " + scriptOutput.stdout + HadoopUtils.getTerm() + "STDERR: " + scriptOutput.stderr + HadoopUtils.getTerm();
            MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
            messageDetailsDialog.showErrorDialog(HadoopWizArb.format("HDFS_FILE_ERROR", string), string3);
        } else {
            File file = null;
            try {
                String string4 = HadoopUtils.getTempName("hdfs");
                file = File.createTempFile(string4, this.getExtension());
                FileWriter fileWriter = new FileWriter(file);
                StringReader stringReader = new StringReader(scriptOutput.stdout);
                char[] cArray = new char[1];
                while (stringReader.read(cArray) != -1) {
                    fileWriter.write(cArray);
                }
                this._loadFile = new LoadFile(file.getPath());
                fileWriter.flush();
                fileWriter.close();
                stringReader.close();
                if (this._datareader != null) {
                    this._datareader.closeFile();
                }
                this._dataFormat = this.getDefaultFormat(BaseDataFormat.IMPORT_WIZARD);
                this._dataFormat.isHeader(false);
                this._dataFormat.setRecordTerminator(DataToolsArb.getString((String)"STANDARD"));
                this._formatOptions = new ImportFormatOptionsPanel((BaseDataFormat)this._dataFormat);
                this.newFileInit(this._loadFile.getType());
                this._hProps.put(ImportKeys.SELECTED_COLUMNS, null);
                this._hProps.put(ImportKeys.SELECTABLE_COLUMNS, null);
                SwingUtilities.invokeLater(() -> this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false)));
            }
            catch (Exception exception) {
                String string5 = "STDOUT: " + scriptOutput.stdout + HadoopUtils.getTerm() + "STDERR: " + scriptOutput.stderr + HadoopUtils.getTerm();
                MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
                messageDetailsDialog.showErrorDialog(HadoopWizArb.format("TMP_FILE_ERROR", file.getPath()), exception.getMessage());
            }
        }
    }

    public String getExtension() {
        return ".hsv";
    }

    protected String getDefaultFileType() {
        return "hsv";
    }

    public void onEntry(TraversableContext traversableContext) {
        this._hProps = (HadoopProperties)((Object)traversableContext.get("HADOOP_PROPERTIES"));
        DataReaderRegistry.registerReader((DataReadable)this.reader);
        this._ctx = traversableContext;
        this._hostName = (String)this._hProps.get(HadoopKeys.SSH_HOST);
        super.showConfigPanel(false);
        super.isBackEnabled(true);
        if (this._loadFile != null) {
            this._hProps.put(ImportKeys.LOAD_FILE, this._loadFile);
        }
        super.onEntry(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        super.resetData(true);
        super.onExit(traversableContext);
        this._hProps.put(HadoopKeys.SOURCE_ROOT_DIR, this._uiRootCmp.getText());
        DataReaderRegistry.unregisterReader((DataReadable)this.reader);
    }

    public Object getExitTransition() {
        return this.getTransition();
    }

    private Object getTransition() {
        return "C";
    }
}

