/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.ui.ColumnMapMediator;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.hadoop.ui.OSCHIColumnPanel;
import oracle.dbtools.raptor.hadoop.ui.OSCHIDataPreviewPage;
import oracle.dbtools.raptor.hadoop.ui.OSCHIGeneralPage;
import oracle.dbtools.raptor.hadoop.ui.OSCHIOptionalParmsPage;
import oracle.dbtools.raptor.hadoop.ui.OSCHIPredicatePage;
import oracle.dbtools.raptor.hadoop.ui.OSCHIWelcomePage;
import oracle.dbtools.raptor.hadoop.ui.OSCHIWizSummaryPage;
import oracle.dbtools.raptor.hadoop.ui.OSCHImportMethodPage;
import oracle.dbtools.raptor.ui.wizard.BigWizardDialog;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;

public class OSCHIWizMain
extends AbstractMenuAction {
    static final String STATE_A = "StateA";
    static final String TRANSITION_A = "A";
    static final String STATE_B = "StateB";
    static final String TRANSITION_B = "B";
    static final String STATE_C = "StateC";
    static final String TRANSITION_C = "C";
    static final String STATE_D = "StateD";
    static final String TRANSITION_D = "D";
    static final String STATE_E = "StateE";
    static final String TRANSITION_E = "E";
    static final String STATE_F = "StateF";
    static final String TRANSITION_F = "F";
    static final String TRANSITION_FIN = "Fin";
    static final String STATE_FIN = "StateFin";
    public static final String WIZARD_TYPE_TOOL = "1";
    static final String KEY_FILENAME = "FILENAME";
    static final String KEY_CONN = "CONNECTION";
    static final String KEY_CNAME = "CONNECTION_NAME";
    static final String KEY_TARGETFORMAT = "TARGETFORMAT";
    static final String KEY_DATA_LIST = "DATA_LIST";
    static final String KEY_ACTION_OBJECT_LIST = "ACTION_OBJECT_LIST";
    static final String KEY_WIZARD_TYPE = "WIZARD_TYPE";
    public static final String OLHI_NAME = "raptor.olhiWizard";
    public static final int OLHI_ACTION = Ide.findOrCreateCmdID((String)"raptor.olhiWizard");
    private static OSCHIWizMain INSTANCE;
    private DBObject _dbo;

    private static FSM getFSMforDBTool() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(HadoopWizArb.getString("OLH_STEPINTRO"), OSCHIWelcomePage.class, "f1_help_id_for_oschintro");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_A, (Object)STATE_A);
        Step step2 = new Step(HadoopWizArb.getString("OLH_STEP1"), OSCHIGeneralPage.class, "f1_help_id_for_oschstep1");
        fSMBuilder.newState((Object)STATE_A, step2, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_B, (Object)STATE_B);
        fSMBuilder.addStateTrans((Object)TRANSITION_C, (Object)STATE_C);
        fSMBuilder.addStateTrans((Object)TRANSITION_FIN, (Object)STATE_FIN);
        Step step3 = new Step(HadoopWizArb.getString("OLH_STEP2"), OSCHIDataPreviewPage.class, "f1_help_id_for_oschstep2");
        fSMBuilder.newState((Object)STATE_B, step3, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_C, (Object)STATE_C);
        fSMBuilder.addStateTrans((Object)TRANSITION_FIN, (Object)STATE_FIN);
        Step step4 = new Step(HadoopWizArb.getString("OLH_STEP3"), OSCHImportMethodPage.class, "f1_help_id_for_oschstep3");
        fSMBuilder.newState((Object)STATE_C, step4, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_D, (Object)STATE_D);
        fSMBuilder.addStateTrans((Object)TRANSITION_E, (Object)STATE_E);
        Step step5 = new Step(HadoopWizArb.getString("OLH_STEP4"), OSCHIColumnPanel.class, "f1_help_id_for_oschstep4");
        fSMBuilder.newState((Object)STATE_D, step5, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_E, (Object)STATE_E);
        fSMBuilder.addStateTrans((Object)TRANSITION_F, (Object)STATE_F);
        Step step6 = new Step(HadoopWizArb.getString("OLH_STEP5"), OSCHIPredicatePage.class, "f1_help_id_for_oschstep5");
        fSMBuilder.newState((Object)STATE_E, step6, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_F, (Object)STATE_F);
        Step step7 = new Step(HadoopWizArb.getString("OLH_STEP6"), OSCHIOptionalParmsPage.class, "f1_help_id_for_olhstep5");
        fSMBuilder.newState((Object)STATE_F, step7, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_FIN, (Object)STATE_FIN);
        Step step8 = new Step(HadoopWizArb.getString("STEP_SUMMARY"), OSCHIWizSummaryPage.class, "f1_help_id_for_olhsummary");
        fSMBuilder.newFinalState((Object)STATE_FIN, step8);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    public void launchForDBTool() {
        FSM fSM = OSCHIWizMain.getFSMforDBTool();
        this.launchWizard(fSM, WIZARD_TYPE_TOOL);
    }

    public void launchWizard(FSM fSM, String string) {
        Namespace namespace = new Namespace();
        namespace.put(KEY_WIZARD_TYPE, (Object)string);
        HadoopProperties hadoopProperties = new HadoopProperties();
        namespace.put("HADOOP_PROPERTIES", (Object)hadoopProperties);
        namespace.put("IMPORT_PROPERTIES", (Object)hadoopProperties.getIProps());
        hadoopProperties.put(ImportKeys.DBOBJECT, this._dbo);
        hadoopProperties.put(ImportKeys.CONNECTION_NAME, this._dbo.getConnectionName());
        hadoopProperties.put(HadoopKeys.DEST_CONN_NAME, this._dbo.getConnectionName());
        hadoopProperties.put(ImportKeys.IS_CONFIGFILE, false);
        hadoopProperties.put(ImportKeys.IS_EXISTING_TABLE, this._dbo.getObjectName() != null);
        hadoopProperties.put(ImportKeys.OBJECTACTION, this.getObjectAction());
        ExtractDataFormat extractDataFormat = new ExtractDataFormat(ExtractDataFormat.EXPORT_WIZARD, ExtractDataFormat.DELIMITED);
        hadoopProperties.put(HadoopKeys.EXTRACT_DATA_FORMAT, extractDataFormat);
        FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
        BigWizardDialog bigWizardDialog = new BigWizardDialog((BaseWizard)fSMWizard, (Frame)Ide.getMainWindow());
        fSMWizard.setDialog((WizardDialog)bigWizardDialog);
        Dimension dimension = new Dimension(bigWizardDialog.getMinimumSize());
        fSMWizard.setWizardTitle(HadoopWizArb.getString("OSCH_MAIN_TITLE"));
        fSMWizard.setShowStepNumber(true);
        fSMWizard.updateImage(ExportWizArb.getImage((String)"WIZ_IMAGE"));
        fSMWizard.setLogoImage(ExportWizArb.getImage((String)"WIZ_LOGO"));
        fSMWizard.setRoadmapVisible(true);
        WizardLauncher.runDialog((JDialog)bigWizardDialog);
    }

    public static void initMenu() {
        IdeAction ideAction = IdeAction.get((int)OLHI_ACTION);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
    }

    public void launch() {
        ColumnMapMediator.getInstance().clearMap();
        this._dbo = this.getDBObject();
        this.launchForDBTool();
    }

    public static OSCHIWizMain getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new OSCHIWizMain();
        }
        return INSTANCE;
    }

    static boolean acquireLock(String string) {
        return LockedConnection.acquireLock(string);
    }

    static void freeLock() {
        LockedConnection.freeLock();
    }

    private static class LockedConnection {
        private static String _connName;
        private static boolean _locked;

        private LockedConnection() {
        }

        static synchronized boolean acquireLock(String string) {
            boolean bl = false;
            LockedConnection.freeLock();
            bl = _locked = Connections.getInstance().lock(string, true);
            if (bl) {
                _connName = string;
            }
            return bl;
        }

        static synchronized void freeLock() {
            if (_connName != null && _locked) {
                Connections.getInstance().unlock(_connName);
                _locked = false;
                _connName = null;
            }
        }

        static {
            _locked = false;
        }
    }
}

