<?xml version="1.0" ?>
<!--
NAME
    cmkuseq.xsl
DESCRIPTION
    Convert mdapi SEQUENCE_T document to SEQUENCE document (editable XML)

MODIFIED    MM/DD/YY
    pkaliren    05/15/08 - Merge 11GC functionality
    xshen       03/08/05 - fix schema mapping 
    abodge      09/02/04 - Do schema mapping stuff 
    lhan        08/18/04 - 
    lhan        08/17/04 - lhan_cm_0817
    lhan        08/17/04 - creation
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Top level imports -->
<xsl:import href="cmkucommon.xsl"/>

<!-- Top level template for all objects -->
<xsl:template match="/">
 <xsl:apply-templates/>
</xsl:template>

<xsl:template match="RESULTSET | ROWSET">
  <xsl:for-each select="ROW">
    <xsl:apply-templates/>
  </xsl:for-each>
</xsl:template>

<xsl:template match="SEQUENCE_T">
<SEQUENCE>

 <xsl:call-template name="DoSchemaWithMapping">
  <xsl:with-param name="CurrentSchema" select="SCHEMA_OBJ/OWNER_NAME"/>
 </xsl:call-template>
 <!-- name -->
 <NAME>
   <xsl:value-of select="SCHEMA_OBJ/NAME"/>
 </NAME> 

 <MINVALUE>
  <xsl:value-of select="MINVALUE"/>
 </MINVALUE>

 <MAXVALUE>
  <xsl:value-of select="MAXVALUE"/>
 </MAXVALUE>

 <INCREMENT>
  <xsl:value-of select="INCRE"/>
 </INCREMENT>

 <START_WITH>
  <xsl:value-of select="HIGHWATER"/>
 </START_WITH>

 <xsl:element name="CACHE">
  <xsl:value-of select="CACHE"/>
 </xsl:element> 

 <xsl:element name="ORDER">
  <xsl:choose>
    <xsl:when test="SEQ_ORDER=1">
      <xsl:text>Y</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>N</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
 </xsl:element> 

 <xsl:element name="CYCLE">
  <xsl:choose>
    <xsl:when test="CYCLE=1">
      <xsl:text>Y</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>N</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
 </xsl:element> 

</SEQUENCE>
</xsl:template>


</xsl:stylesheet>


