<?xml version="1.0" ?>
<!--
NAME
    cmkutable.xsl
DESCRIPTION
    Convert mdapi TABLE_T document to TABLE document (editable XML)

MODIFIED        MM/DD/YY
    pkaliren    05/15/08 - Merge 11GC functionality
    xshen       07/27/05 - 4510728
    xshen       06/16/05 - remove ignore_partition conditions 
    xshen       06/13/05 - get at ts_list for hash partitioning 
    xshen       05/16/05 - support ignore partition option 
    xshen       04/27/05 - add support to ignore column position 
    xshen       04/21/05 - restrict constraints definition to only column list 
    lhan        04/18/05 - make constraint col_num for EMO only
    lhan        04/18/05 - fix 4301322: add COL_NUM for UK constraint
    xshen       03/08/05 - using l_schema and r_schema 
    xshen       03/08/05 - fix schema mapping for foreign keys
    lhan        03/04/05 - support OPAQUE TYPE lob storage
    lhan        11/05/04 - treat NOT NULL as check constraint for emo 
    lhan        10/27/04 - special handling of temp table
    lhan        10/12/04 - cluster table support
    lhan        10/05/04 - add col_num for constraints (primary)
    lhan        10/04/04 - fix segments attr for partitioned iots
    xshen       09/22/04 - add compare options
    lhan        08/25/04 - unique constraint for xmltype
    lhan        08/11/04 - add xmltype table support
    ngade       08/09/04 - 
    xshen       08/05/04 - fix column_sortby using local-name()
    ngade       08/02/04 - 
    xshen       08/02/04 - add compare statistics or not 
    xshen       07/30/04 - temporary type: on_commit
    lhan        07/30/04 - cache, degree, monitoring
    xshen       07/29/04 - support table statistics 
    xshen       07/27/04 - support partitioned iots 
    lhan        07/26/04 - fix constraint columns
    lhan        07/22/04 - more constraint attr
    lhan        07/20/04 - add row_movement in table properties
    lhan        07/15/04 - add partition/subpartition support
    xshen       07/14/04 - add name as constraint attr, schema map
    lhan        07/14/04 - add storage table support (lob, nested tbl, etc.)
    lhan        07/13/04 - iot type
    lhan        07/12/04 - more on table xsl
    xshen       07/10/04 - xshen_changemgr_differ
    xshen       07/06/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Top level imports -->
<xsl:import href="cmkucommon.xsl"/>
<xsl:import href="cmkucolumn.xsl"/>
<xsl:import href="cmkustorage.xsl"/>
<xsl:import href="cmkuiot.xsl"/>
<xsl:import href="cmkuprtobj.xsl"/>
<xsl:import href="cmkuobjtbl.xsl"/>

<!-- Comparison Directives -->
<xsl:param name="COLUMN_SORTBY">NAME</xsl:param>
<xsl:param name="IGNORE_NAME_DIFFERENCES">1</xsl:param>
<xsl:param name="INCLUDE_STATISTICS">0</xsl:param>
<xsl:param name="MATCH_COLUMN_BY_NAME">1</xsl:param>
<xsl:param name="MATCH_CONSTR_BY_DEFINITION">1</xsl:param>

<!-- Note: Any Sub-Tree that needs to be computed as part of constr. definition -->
<!--       needs to include an attribute to identify this to object differ.     -->
<!--       COMPUTE_CONSTR_DEF=TRUE - If this attribute does not exist, or the   -->
<!--       value is not 'TRUE' | 'true', it will not be factored into def. when -->
<!--       matching constraints by definition.  The name defined in             -->
<!--       Currently primary, unique, foreign, check constraints use this.      -->
<!-- See:  oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.CMDiffConstants      -->

<!-- Top level template for all objects -->
<xsl:template match="/">
 <xsl:apply-templates/>
</xsl:template>

<xsl:template match="RESULTSET | ROWSET">
  <xsl:for-each select="ROW">
    <xsl:apply-templates/>
  </xsl:for-each>
</xsl:template>

<xsl:template match="TABLE_T">
<TABLE>
 <xsl:if test="(PROPERTY mod 8388608)>=4194304">
  <xsl:element name="GLOBAL_TEMPORARY">
  </xsl:element>
  </xsl:if>

  <!-- major object name -->
  <xsl:call-template name="DoSchemaWithMapping">
    <xsl:with-param name="CurrentSchema" select="SCHEMA_OBJ/OWNER_NAME"/>
  </xsl:call-template>

 <NAME>
  <xsl:value-of select="SCHEMA_OBJ/NAME"/>
 </NAME>

 <!-- XMLschema object tables -->
 <xsl:if test="(PROPERTY mod 2)=1">
  <xsl:if test="COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/OPQMD/SCHEMA_ELMT">
   <xsl:element name="OF_TYPE">
    <xsl:element name="SCHEMA">
     <xsl:text>SYS</xsl:text>
    </xsl:element>
    <xsl:element name="NAME">
     <xsl:text>XMLTYPE</xsl:text>
    </xsl:element>
   </xsl:element>
   <xsl:apply-templates 
            select="COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/OPQMD/SCHEMA_ELMT"/>
  </xsl:if>
 </xsl:if>

 <COL_LIST>
   <!-- exclude hidden columns                            - prop bit 0x000020
        (but do include hidden snapshot base table column - prop bit 0x100000
         and do include RLS hidden column                 - prop bit 0x800000)
     -->
     <xsl:for-each select="COL_LIST/COL_LIST_ITEM[(PROPERTY mod 64)&lt;32
                           or (PROPERTY mod 2097152)>=1048576
                           or (PROPERTY mod 8388608)>=4194304]">
       <xsl:sort select="*[local-name()=$COLUMN_SORTBY]"/>
       <COL_LIST_ITEM NAME="{NAME}"> 
        <NAME>
         <xsl:value-of select="NAME"/>
        </NAME>
        <xsl:apply-templates select="TYPE_NUM">
           <xsl:with-param name="ADT_type">TABLE</xsl:with-param>
        </xsl:apply-templates>
       </COL_LIST_ITEM>
     </xsl:for-each>

 </COL_LIST>

 <xsl:if test="CON1_LIST/CON1_LIST_ITEM[$USAGE=2 or COL_LIST/COL_LIST_ITEM/OID_OR_SETID=0]
              or CON2_LIST/CON2_LIST_ITEM[SRC_COL_LIST/SRC_COL_LIST_ITEM/OID_OR_SETID=0]
              or COL_LIST/COL_LIST_ITEM/CON[$USAGE=2]">
  <xsl:element name="CONSTRAINTS">

  <!-- get not null constraint for emo display -->
  <xsl:if test="CON1_LIST/CON1_LIST_ITEM[CONTYPE=1]
               or COL_LIST/COL_LIST_ITEM/CON[$USAGE=2 and CONTYPE=7]">
   <xsl:element name="CHECK_CONSTRAINT_LIST">
    <xsl:for-each select="COL_LIST/COL_LIST_ITEM/CON[$USAGE=2 and CONTYPE=7]">
     <xsl:sort select="*[local-name()=$COLUMN_SORTBY]"/>
     <CHECK_CONSTRAINT_LIST_ITEM NAME="{NAME}" 
           MATCH_CONSTR_BY_DEFINITION="{$MATCH_CONSTR_BY_DEFINITION}"
           IGNORE_NAME_DIFFERENCES="{$IGNORE_NAME_DIFFERENCES}">    

      <COL_LIST COMPUTE_CONSTR_DEF="TRUE">
        <xsl:element name="COL_LIST_ITEM">
         <xsl:element name="NAME">
          <xsl:value-of select="../NAME"/>
         </xsl:element>
         <xsl:if test="$USAGE=2">
          <xsl:element name="COL_NUM">
           <xsl:value-of select="../COL_NUM"/>
          </xsl:element>
         </xsl:if>
        </xsl:element>     
      </COL_LIST>

      <xsl:call-template name="DoFlags"/>
      <xsl:apply-templates select="ENABLED"/>
     </CHECK_CONSTRAINT_LIST_ITEM>
    </xsl:for-each>

    <xsl:for-each select="CON1_LIST/CON1_LIST_ITEM[CONTYPE=1]">
     <xsl:sort select="*[local-name()=$COLUMN_SORTBY]"/>
     <CHECK_CONSTRAINT_LIST_ITEM NAME="{NAME}" 
           MATCH_CONSTR_BY_DEFINITION="{$MATCH_CONSTR_BY_DEFINITION}"
           IGNORE_NAME_DIFFERENCES="{$IGNORE_NAME_DIFFERENCES}">    
      <!-- xsl:if test="(FLAGS mod 16) &lt; 8">
       <xsl:element name="NAME">
        <xsl:value-of select="NAME"/>
       </xsl:element>
      </xsl:if -->
      <CONDITION COMPUTE_CONSTR_DEF="TRUE">
 <!-- problem if CONDITION contains escape char, e.g., d &lt; 5 -->
       <xsl:value-of select="CONDITION"/>
      </CONDITION>
      <xsl:element name="POS_NUM">
       <xsl:value-of select="POS_NUM"/>
      </xsl:element>     
      <xsl:call-template name="DoFlags"/>
      <xsl:apply-templates select="ENABLED"/>
     </CHECK_CONSTRAINT_LIST_ITEM>
    </xsl:for-each>
   </xsl:element>
  </xsl:if>

  <xsl:if test="CON1_LIST/CON1_LIST_ITEM[CONTYPE=2]">
   <xsl:element name="PRIMARY_KEY_CONSTRAINT_LIST">
    <xsl:for-each select="CON1_LIST/CON1_LIST_ITEM[CONTYPE=2]">
      <xsl:sort select="*[local-name()=$COLUMN_SORTBY]"/>
      <PRIMARY_KEY_CONSTRAINT_LIST_ITEM NAME="{NAME}" 
           MATCH_CONSTR_BY_DEFINITION="{$MATCH_CONSTR_BY_DEFINITION}"
           IGNORE_NAME_DIFFERENCES="{$IGNORE_NAME_DIFFERENCES}">       
      <!-- xsl:if test="(FLAGS mod 16) &lt; 8">
       <xsl:element name="NAME">
       <xsl:value-of select="NAME"/>
       </xsl:element>
      </xsl:if -->

      <COL_LIST COMPUTE_CONSTR_DEF="TRUE">
       <xsl:for-each select="COL_LIST/COL_LIST_ITEM">
        <xsl:element name="COL_LIST_ITEM">
         <xsl:element name="NAME">
          <xsl:value-of select="COL/NAME"/>
         </xsl:element>
         <xsl:if test="$USAGE=2">
          <xsl:element name="COL_NUM">
           <xsl:value-of select="COL/COL_NUM"/>
          </xsl:element>
         </xsl:if>
         <xsl:element name="POS_NUM">
          <xsl:value-of select="POS_NUM"/>
         </xsl:element>     
        </xsl:element>     
       </xsl:for-each>
      </COL_LIST>

      <xsl:call-template name="DoUsingIndex">
       <xsl:with-param name="ParentNode" select="IND"/>
      </xsl:call-template>

      <xsl:call-template name="DoFlags"/>
      <xsl:apply-templates select="ENABLED"/>

     </PRIMARY_KEY_CONSTRAINT_LIST_ITEM>
    </xsl:for-each>
   </xsl:element>
  </xsl:if>

  <xsl:if test="CON1_LIST/CON1_LIST_ITEM[CONTYPE=3 and ($USAGE=2 or COL_LIST/COL_LIST_ITEM/OID_OR_SETID=0)]">
   <xsl:element name="UNIQUE_KEY_CONSTRAINT_LIST">
    <xsl:for-each select="CON1_LIST/CON1_LIST_ITEM[CONTYPE=3
              and ($USAGE=2 or COL_LIST/COL_LIST_ITEM/OID_OR_SETID=0)]">
     <xsl:sort select="*[local-name()=$COLUMN_SORTBY]"/>
     <UNIQUE_KEY_CONSTRAINT_LIST_ITEM NAME="{NAME}"
           MATCH_CONSTR_BY_DEFINITION="{$MATCH_CONSTR_BY_DEFINITION}"
           IGNORE_NAME_DIFFERENCES="{$IGNORE_NAME_DIFFERENCES}">    

      <!-- xsl:if test="(FLAGS mod 16) &lt; 8">
       <xsl:element name="NAME">
       <xsl:value-of select="NAME"/>
       </xsl:element>
      </xsl:if -->

      <COL_LIST COMPUTE_CONSTR_DEF="TRUE">
       <xsl:for-each select="COL_LIST/COL_LIST_ITEM">
        <xsl:element name="COL_LIST_ITEM">
         <xsl:element name="NAME">
          <xsl:value-of select="COL/NAME"/>
         </xsl:element>
         <xsl:if test="$USAGE=2">
          <xsl:element name="COL_NUM">
           <xsl:value-of select="COL/COL_NUM"/>
          </xsl:element>
         </xsl:if>
         <xsl:element name="POS_NUM">
          <xsl:value-of select="POS_NUM"/>
         </xsl:element>     
        </xsl:element>     
       </xsl:for-each>
      </COL_LIST>

      <xsl:call-template name="DoUsingIndex">
       <xsl:with-param name="ParentNode" select="IND"/>
      </xsl:call-template>

      <xsl:call-template name="DoFlags"/>
      <xsl:apply-templates select="ENABLED"/>

     </UNIQUE_KEY_CONSTRAINT_LIST_ITEM>
    </xsl:for-each>
   </xsl:element>
  </xsl:if>

  <xsl:if test="CON2_LIST/CON2_LIST_ITEM[CONTYPE=4]">
   <xsl:element name="FOREIGN_KEY_CONSTRAINT_LIST">
    <xsl:for-each select="CON2_LIST/CON2_LIST_ITEM[CONTYPE=4]">
     <xsl:sort select="*[local-name()=$COLUMN_SORTBY]"/>
     <FOREIGN_KEY_CONSTRAINT_LIST_ITEM NAME="{NAME}"
           MATCH_CONSTR_BY_DEFINITION="{$MATCH_CONSTR_BY_DEFINITION}"
           IGNORE_NAME_DIFFERENCES="{$IGNORE_NAME_DIFFERENCES}">    

      <!-- xsl:if test="(FLAGS mod 16) &lt; 8">
       <xsl:element name="NAME">
        <xsl:value-of select="NAME"/>
       </xsl:element>
      </xsl:if -->

      <COL_LIST COMPUTE_CONSTR_DEF="TRUE">
       <xsl:for-each select="SRC_COL_LIST/SRC_COL_LIST_ITEM">
        <xsl:element name="COL_LIST_ITEM">
         <xsl:element name="NAME">
          <xsl:value-of select="COL/NAME"/>
         </xsl:element>
         <xsl:element name="POS_NUM">
          <xsl:value-of select="POS_NUM"/>
         </xsl:element>     
        </xsl:element>     
       </xsl:for-each>
      </COL_LIST>

      <REFERENCE COMPUTE_CONSTR_DEF="TRUE">
       <!-- foreign key reference object schema -->
       <xsl:call-template name="DoSchemaWithMapping">
        <xsl:with-param name="CurrentSchema" select="SCHEMA_OBJ/OWNER_NAME"/>
       </xsl:call-template>
       <NAME>
        <xsl:value-of select="SCHEMA_OBJ/NAME"/>
       </NAME>

      <xsl:element name="COL_LIST">
       <xsl:for-each select="TGT_COL_LIST/TGT_COL_LIST_ITEM">
        <xsl:element name="COL_LIST_ITEM">
         <xsl:element name="NAME">
          <xsl:value-of select="COL/NAME"/>
         </xsl:element>
         <xsl:element name="POS_NUM">
          <xsl:value-of select="POS_NUM"/>
         </xsl:element>     
        </xsl:element>     
       </xsl:for-each>
      </xsl:element>

      </REFERENCE>

      <xsl:call-template name="DoFlags"/>
      <xsl:apply-templates select="ENABLED"/>
      <xsl:apply-templates select="REFACT"/>      
            
     </FOREIGN_KEY_CONSTRAINT_LIST_ITEM>
     </xsl:for-each>
   </xsl:element>
  </xsl:if>

  </xsl:element>
 </xsl:if>

 <!-- TEMPORARY TABLE: ON_COMMIT -->
 <xsl:if test="(PROPERTY mod 8388608)>=4194304">   <!-- temporary table -->
  <ON_COMMIT>
   <xsl:choose>
    <xsl:when test="(PROPERTY mod 16777216)>=8388608">
     <xsl:text>PRESERVE</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>DELETE</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </ON_COMMIT>
 </xsl:if> 

 <!-- Physical properties -->
 <xsl:if test="4194304>(PROPERTY mod 8388608)"> <!-- non-temporary table -->
  <xsl:call-template name="GenTablePhysicalProps"/>
 </xsl:if>

 <!-- Table Statistics -->
 <xsl:if test="$INCLUDE_STATISTICS=1">
   <xsl:call-template name="GenTableStatistics"/>
 </xsl:if>

 <!-- Table properties -->
 <!-- xsl:if test="(PROPERTY mod 64)>=32 or
        COL_LIST/COL_LIST_ITEM[TYPE_NUM=122 or TYPE_NUM=123
                or TYPE_NUM=112 or TYPE_NUM=113]" -->
  <xsl:element name="TABLE_PROPERTIES">
   <xsl:if test="COL_LIST/COL_LIST_ITEM[TYPE_NUM=122 or TYPE_NUM=123
                or TYPE_NUM=58 or TYPE_NUM=112 or TYPE_NUM=113]">
   <xsl:element name="COLUMN_PROPERTIES">
    <xsl:element name="COL_LIST">
     <xsl:for-each select="NT/NTS/NTS_ITEM">
       <xsl:sort select="*[local-name()=$COLUMN_SORTBY]"/>
        <COL_LIST_ITEM NAME="{COL/NAME}">
          <NAME>
            <xsl:value-of select="COL/NAME"/>
          </NAME>
        <xsl:element name="DATATYPE">
          <xsl:text>NESTED_TABLE</xsl:text>
        </xsl:element>
        <xsl:element name="STORAGE_TABLE">
          <xsl:apply-templates select="SCHEMA_OBJ"/>
          <xsl:if test="$IGNORE_PHYSICAL_ATTS=0">
            <PHYSICAL_PROPERTIES>
              <xsl:call-template name="DoSegmentAttributes">
                <xsl:with-param name="ParentNode" select="HNT"/>
              </xsl:call-template>
            </PHYSICAL_PROPERTIES>
          </xsl:if>
       </xsl:element>
       <xsl:element name="RETURN_AS">
        <xsl:choose>
         <xsl:when test="(FLAGS mod 64)>=32">LOCATOR</xsl:when>
         <xsl:otherwise>VALUE</xsl:otherwise>
        </xsl:choose>
       </xsl:element>
     </COL_LIST_ITEM>
     </xsl:for-each>
     <xsl:for-each
           select="COL_LIST/COL_LIST_ITEM[TYPE_NUM=58 or TYPE_NUM=112 or TYPE_NUM=113]">
       <xsl:sort select="*[local-name()=$COLUMN_SORTBY]"/>
      <COL_LIST_ITEM NAME="{NAME}"> 
       <NAME>
       <xsl:value-of select="NAME"/>
       </NAME>
       <xsl:element name="DATATYPE">
        <xsl:choose>
         <xsl:when test="TYPE_NUM='58'">OPAQUE TYPE</xsl:when>
         <xsl:when test="TYPE_NUM='112'">CLOB</xsl:when>
         <xsl:when test="TYPE_NUM='113'">BLOB</xsl:when>
        </xsl:choose>
       </xsl:element>
       <xsl:element name="STORAGE_TABLE">
        <xsl:call-template name="DoSchemaWithMapping">
         <xsl:with-param name="CurrentSchema" select="LOBMD/SCHEMA_OBJ/OWNER_NAME"/>
        </xsl:call-template>
        <xsl:if test="4>(LOBMD/SCHEMA_OBJ/FLAGS mod 8)">	<!-- not sys-generated name -->        
         <NAME>
          <xsl:value-of select="LOBMD/SCHEMA_OBJ/NAME"/>
         </NAME>
        </xsl:if>

       <xsl:if test="$IGNORE_PHYSICAL_ATTS=0">
        <PHYSICAL_PROPERTIES>
         <SEGMENT_ATTRIBUTES>
          <xsl:call-template name="DoTablespace">
           <xsl:with-param name="ParentNode" select="LOBMD"/>
          </xsl:call-template>
          <ENABLE_STORAGE_IN_ROW>
           <xsl:choose>
            <xsl:when test="(LOBMD/PROPERTY mod 4)>=2">Y</xsl:when>
            <xsl:otherwise>N</xsl:otherwise>
           </xsl:choose>
          </ENABLE_STORAGE_IN_ROW>
          <CHUNK>
           <xsl:value-of select="(LOBMD/CHUNK) * (LOBMD/BLOCKSIZE)"/>
          </CHUNK>
          <PCTVERSION>
           <xsl:value-of select="LOBMD/PCTVERSION"/>
          </PCTVERSION>
  <!-- TBD: CACHE -->
          <xsl:call-template name="DoStorage">
           <xsl:with-param name="BlkSize" select="LOBMD/BLOCKSIZE"/>
           <xsl:with-param name="ParentNode" select="LOBMD/STORAGE"/>
          </xsl:call-template>
         </SEGMENT_ATTRIBUTES>
        </PHYSICAL_PROPERTIES>
      </xsl:if>

       </xsl:element>
      </COL_LIST_ITEM> 
     </xsl:for-each>
    </xsl:element>
   </xsl:element>
  </xsl:if>

  <xsl:if test="(PROPERTY mod 64)>=32">
  <xsl:choose>
   <xsl:when test="PART_OBJ/PARTOBJ/PARTTYPE=1 or PART_OBJ/TABPARTOBJ/PARTTYPE=1">
    <xsl:element name="RANGE_PARTITIONING">
     <xsl:apply-templates select="PART_OBJ/PARTCOLS"/>
     <xsl:apply-templates select="PART_OBJ/PARTOBJ | PART_OBJ/TABPARTOBJ"/>
      <xsl:choose>
        <xsl:when test="(PART_OBJ/PARTOBJ/SPARE2 mod 256)=2 or (PART_OBJ/TABPARTOBJ/SPARE2 mod 256)=2"> <!-- hash subpart -->
        <xsl:element name="HASH_SUBPARTITIONING">
         <xsl:apply-templates select="PART_OBJ/SUBPARTCOLS"/>
         <xsl:apply-templates select="PART_OBJ/COMPART_LIST">
           <xsl:with-param name="Sub_type">HASH</xsl:with-param>
         </xsl:apply-templates>
        </xsl:element>
       </xsl:when>
       <xsl:when test="(PART_OBJ/PARTOBJ/SPARE2 mod 256)=4 or (PART_OBJ/TABPARTOBJ/SPARE2 mod 256)=4"> <!-- list subpart -->
        <xsl:element name="LIST_SUBPARTITIONING">
         <xsl:apply-templates select="PART_OBJ/SUBPARTCOLS"/>
         <xsl:apply-templates select="PART_OBJ/COMPART_LIST"/>
        </xsl:element>
       </xsl:when>
       <xsl:otherwise>  <!-- regular range partition -->
        <xsl:apply-templates select="PART_OBJ/PART_LIST"/>
       </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
   </xsl:when>

   <xsl:when test="PART_OBJ/PARTOBJ/PARTTYPE=2 or PART_OBJ/TABPARTOBJ/PARTTYPE=2">
    <xsl:element name="HASH_PARTITIONING">
     <xsl:apply-templates select="PART_OBJ/PARTCOLS"/>
     <!-- get ts_list for hash partitioning -->
     <xsl:call-template name="GetHashPartTSList">
       <xsl:with-param name="PartList" select="PART_OBJ/PART_LIST"/>
     </xsl:call-template>
     <xsl:apply-templates select="PART_OBJ/PARTOBJ | PART_OBJ/TABPARTOBJ"/>
     <xsl:apply-templates select="PART_OBJ/PART_LIST"/>
    </xsl:element>
   </xsl:when>

   <xsl:when test="PART_OBJ/PARTOBJ/PARTTYPE=4 or PART_OBJ/TABPARTOBJ/PARTTYPE=4">
    <xsl:element name="LIST_PARTITIONING">
     <xsl:apply-templates select="PART_OBJ/PARTCOLS"/>
     <xsl:apply-templates select="PART_OBJ/PARTOBJ | PART_OBJ/TABPARTOBJ"/>
     <xsl:apply-templates select="PART_OBJ/PART_LIST"/>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
  </xsl:if>

  <xsl:if test="PART_OBJ/PARTOBJ | PART_OBJ/TABPARTOBJ">
    <xsl:apply-templates select="PART_OBJ/PARTOBJ | PART_OBJ/TABPARTOBJ"/>
  </xsl:if>

  <xsl:if test="(PART_OBJ)">
   <xsl:choose>
     <xsl:when test="(PROPERTY mod 128)&lt;64">
      <xsl:element name="ROW_MOVEMENT">
       <xsl:choose>
        <xsl:when test="(FLAGS mod 262144)>=131072">
         <xsl:text>Y</xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:text>N</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
     </xsl:element>
    </xsl:when>
   </xsl:choose>
  </xsl:if>

  <xsl:call-template name="DoParallel">
   <xsl:with-param name="FlagsParent" select="current()"/>
  </xsl:call-template>

  </xsl:element>
 <!-- /xsl:if -->

</TABLE>
</xsl:template>

<xsl:template match="REFACT">
  <xsl:element name ="ON_DELETE">
  <xsl:choose>
    <xsl:when test=".='1'">
     <xsl:text>CASCADE</xsl:text>
    </xsl:when>
    <xsl:when test=".='2'">
     <xsl:text>SET_NULL</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>SET_DEFAULT</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  </xsl:element>
</xsl:template>

<xsl:template name="DoUsingIndex">
 <xsl:param name="ParentNode" select="''"/>

      <USING_INDEX>
    <xsl:if test="$IGNORE_PHYSICAL_ATTS=0">
      <PHYSICAL_PROPERTIES>
       <SEGMENT_ATTRIBUTES>
        <PCTFREE>
         <xsl:value-of select="$ParentNode/PCT_FREE"/>
        </PCTFREE>
        <INITRANS>
         <xsl:value-of select="$ParentNode/INITRANS"/>
        </INITRANS>
        <xsl:call-template name="DoTablespace">
         <xsl:with-param name="ParentNode" select="$ParentNode"/>
        </xsl:call-template>
        <xsl:call-template name="DoStorage">
         <xsl:with-param name="BlkSize" select="$ParentNode/BLOCKSIZE"/>
         <xsl:with-param name="ParentNode" select="$ParentNode/STORAGE"/>
        </xsl:call-template>
       </SEGMENT_ATTRIBUTES>
      </PHYSICAL_PROPERTIES>
    </xsl:if>
      </USING_INDEX>
</xsl:template>

<!-- table physical properties -->

<xsl:template name="GenTablePhysicalProps">
 <xsl:if test="32>=(PROPERTY mod 64) and $IGNORE_PHYSICAL_ATTS=0">
  <PHYSICAL_PROPERTIES>
   <xsl:choose>
    <xsl:when test="(PROPERTY mod 128)>=64">                <!-- IOT -->
     <xsl:element name="ORGANIZATION">
      <xsl:text>INDEX</xsl:text>
     </xsl:element>

     <xsl:choose>
      <xsl:when test="(PART_OBJ)">              <!-- Partitioned IOT -->
       <xsl:call-template name="DoSegmentAttributes">
         <xsl:with-param name="ParentNode" select="./PART_OBJ/INDPARTOBJ"/>
       </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
       <xsl:call-template name="DoSegmentAttributes">
        <xsl:with-param name="ParentNode" select="."/>
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>

     <xsl:if test = "(FLAGS mod 536870912) >= 268435456">
      <xsl:element name="MAPPING_TABLE">
      </xsl:element>
     </xsl:if>
     
     <xsl:element name="PCTTHRESHOLD">
      <xsl:value-of select="PCT_THRESH"/>
     </xsl:element>

     <xsl:element name="COMPRESS">               <!-- key_compression -->
      <xsl:if test="NUMKEYCOLS>0">
       <xsl:value-of select="NUMKEYCOLS"/>
      </xsl:if>
     </xsl:element>

     <xsl:if test="(PROPERTY mod 256)>=128">     <!-- IOV -->
      <xsl:call-template name="DoIOV">
       <xsl:with-param name="Node" select="current()"/>
      </xsl:call-template>
     </xsl:if>
    </xsl:when>

    <xsl:when test="(PROPERTY mod 4294967296)>=2147483648">   <!-- External -->
     <xsl:element name="ORGANIZATION">
      <xsl:text>EXTERNAL</xsl:text>
     </xsl:element>

     <xsl:element name="ACCESS_DRIVER_TYPE">
      <xsl:value-of select = "EXTTAB/TYPE"/>
     </xsl:element>

     <xsl:element name="DEFAULT_DIRECTORY">
      <xsl:value-of select = "EXTTAB/DEFAULT_DIR"/>
     </xsl:element>

     <xsl:if test = "EXTTAB/PARAM_CLOB">
      <xsl:element name="ACCESS_PARAMETERS">
       <xsl:value-of select = "EXTTAB/PARAM_CLOB"/>
      </xsl:element>
     </xsl:if>

     <LOCATION>
     <xsl:for-each select = "EXTTAB/LOCATION/LOCATION_ITEM">
     <xsl:sort select="NAME"/>
       <LOCATION_ITEM NAME="{NAME}"> 
        <NAME>
         <xsl:value-of select="NAME"/>
        </NAME>
        <xsl:if test = "DIR">
         <DIRECTORY>
          <xsl:value-of select="DIR"/>
         </DIRECTORY>
        </xsl:if>
       </LOCATION_ITEM>
      </xsl:for-each>
     </LOCATION>

     <xsl:if test = "EXTTAB/REJECT_LIMIT > 0">
      <REJECT_LIMIT>
       <xsl:choose>
        <xsl:when test = "EXTTAB/REJECT_LIMIT = 2147483647">
         <xsl:text>UNLIMITED</xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:value-of select = "EXTTAB/REJECT_LIMIT"/>
        </xsl:otherwise>
       </xsl:choose>
      </REJECT_LIMIT>
     </xsl:if>

     <xsl:if test = "DEGREE">
      <xsl:element name="PARALLEL">               <!-- paralell -->
       <xsl:value-of select = "DEGREE"/>
      </xsl:element>
     </xsl:if>

    </xsl:when>

    <xsl:when test="(PROPERTY mod 2048)>=1024">   <!-- clustered table -->
     <xsl:apply-templates select="TABCLUSTER"/>
     <xsl:call-template name="DoSegmentAttributes">
      <xsl:with-param name="ParentNode" select="."/>
     </xsl:call-template>
    </xsl:when>

    <xsl:otherwise>
     <xsl:call-template name="DoSegmentAttributes">
      <xsl:with-param name="ParentNode" select="."/>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </PHYSICAL_PROPERTIES>
 </xsl:if>

</xsl:template>

<xsl:template match="TABCLUSTER">
 <CLUSTER>
  <xsl:apply-templates select="SCHEMA_OBJ"/>
  <xsl:apply-templates select="COL_LIST"/>
 </CLUSTER>
</xsl:template>

<xsl:template name="DoFlags">
 <xsl:element name="ALWAYS">
  <xsl:choose>
   <xsl:when test="(FLAGS mod 128)>=64">
    <xsl:text>Y</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>N</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:element>
 <xsl:element name="DEFERRABLE">
  <xsl:choose>
   <xsl:when test="(FLAGS mod 2)=1">
    <xsl:text>Y</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>N</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:element>
 <xsl:element name="DEFERRED">
  <xsl:choose>
   <xsl:when test="(FLAGS mod 4)>=2">
    <xsl:text>Y</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>N</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:element>
 <xsl:element name="RELY">
  <xsl:choose>
   <xsl:when test="(FLAGS mod 64)>=32">
    <xsl:text>Y</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>N</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:element>
</xsl:template>

<xsl:template match="ENABLED">

 <xsl:choose>                           <!-- process [en/dis]able syntax -->
  <xsl:when test=".='0'">
   <xsl:element name="ENABLE">
    <xsl:text>N</xsl:text>
   </xsl:element>
   <!-- novalidate is default for disable, so check for validate only -->
   <xsl:element name="VALIDATE">
    <xsl:choose>
     <xsl:when test="(../FLAGS mod 8) >= 4">
      <xsl:text>Y</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>N</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
  </xsl:when>

  <xsl:otherwise>
   <xsl:element name="ENABLE">
    <xsl:text>Y</xsl:text>
   </xsl:element>
   <!-- validate is default for enable, so check for novalidate only -->
   <xsl:element name="VALIDATE">
    <xsl:choose>
     <xsl:when test="../FLAGS">
      <xsl:choose>
       <xsl:when test="(../FLAGS mod 8) &lt; 4">
        <xsl:text>N</xsl:text>
       </xsl:when>
       <xsl:otherwise>
        <xsl:text>Y</xsl:text>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:when>
     <xsl:otherwise> <!-- this is NULL value -->
       <xsl:text>N</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
  </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- Table Statistics -->
<xsl:template name="GenTableStatistics">
  <xsl:if test="ANALYZETIME">
    <STATISTICS>
      <ANALYZETIME>
        <xsl:value-of select="ANALYZETIME"/>
      </ANALYZETIME>
      <AVGRLN>
        <xsl:value-of select="AVGRLN"/>
      </AVGRLN>
      <AVGSPC>
        <xsl:value-of select="AVGSPC"/>
      </AVGSPC>
      <AVGSPC_FLB>
        <xsl:value-of select="AVGSPC_FLB"/>
      </AVGSPC_FLB>
      <CHNCNT>
        <xsl:value-of select="CHNCNT"/>
      </CHNCNT>
      <EMPCNT>
        <xsl:value-of select="EMPCNT"/>
      </EMPCNT>
      <FLBCNT>
        <xsl:value-of select="FLBCNT"/>
      </FLBCNT>
      <ROWCNT>
        <xsl:value-of select="ROWCNT"/>
      </ROWCNT>
      <SAMPLESIZE>
        <xsl:value-of select="SAMPLESIZE"/>
      </SAMPLESIZE>
    </STATISTICS>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>


