<?xml version="1.0"?>
<!-- Copyright (c) 2005, 2009, Oracle and/or its affiliates. 
All rights reserved. -->
<!--
NAME
    kuscommd.xsl
DESCRIPTION
    Templates for common and utility functions (SXML-DDL conversion)

MODIFIED        MM/DD/YY
    rapayne     08/15/08 - fix undefined templates reported via the java based
                           xsl engine.
    lbarton     10/09/06 - import kuscommc
    slynn       10/15/06 - smartfile->securefile
    htseng      07/31/06 - LOBRETENTION support/lrg 2433400
    lbarton     11/18/05 - bug 4724986: STORAGE param 
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    lbarton     08/10/05 - lbarton_mddiff
    lbarton     01/24/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommc.xsl"/>
 <xsl:import href="kuspard.xsl"/>
 <xsl:import href="kuscnstd.xsl"/>
 <!-- All DDL is text, and this is the only way to correctly render '<' -->
 <xsl:output method="text"/>
 <!-- Templates -->
 <!-- *******************************************************************
Top level template for all objects
******************************************************************** -->
 <xsl:template match="/">
  <xsl:apply-templates/>
 </xsl:template>
 <xsl:template match="RESULTSET | ROWSET">
  <xsl:for-each select="ROW">
   <xsl:apply-templates/>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="DoTerminator">
  <xsl:param name="Text"/>
 <!-- *******************************************************************
Template: DoTerminator - Emits terminating / with or without preceding lf
Parameters:
 Text: text of last line
******************************************************************** -->
  <xsl:if test="$SQLTERMINATOR=1">
   <!-- test whether Text ends in lf; if not, insert lf before / -->
   <xsl:choose>
    <xsl:when test="substring($Text,string-length($Text),1)!=
            substring(normalize-space($Text),
                         string-length(normalize-space($Text)),1)">/</xsl:when>
    <xsl:otherwise>
/</xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
