rem  %1 DBA login id
rem  %2 password
rem  %3 database name
rem  %4 database server name
rem  %5 end or column delimiter
rem  %6 end of row delimiter

echo OfflinePluginIdentifier=oracle.dbtools.migration.workbench.plugin.SQLServer7Plugin>sqlserver7.ocp

rem store the delimiters
bcp "select null " queryout ROW.TXT -c -e ROW.ERR -t "\t%5\t" -r "%6" -U%1 -P%2 -S%4
bcp "select null " queryout COLUMN.TXT -c -e COLUMN.ERR -t "\t%6\t" -r "%5" -U%1 -P%2 -S%4

rem export the required system tables in the master database
bcp master.dbo.syslogins out master\SS7_SYSLOGINS.DAT -c -e master\SS7_SYSLOGINS.ERR -t "\t%5\t" -r "\t%5\t%6\n" -U%1 -P%2 -S%4
bcp master.dbo.sysdatabases out master\SS7_SYSDATABASES.DAT -c -e master\SS7_SYSDATABASES.ERR -t "\t%5\t" -r "\t%5\t%6\n" -U%1 -P%2 -S%4

rem export the required system tables in the database to be migrated
bcp %3.dbo.sysusers out %3\SS7_SYSUSERS.DAT -c -e %3\SS7_SYSUSERS.ERR -t "\t%5\t" -r "\t%5\t%6\n" -U%1 -P%2 -S%4
bcp %3.dbo.syspermissions out %3\SS7_SYSPERMISSIONS.DAT -c -e %3\SS7_SYSPERMISSIONS.ERR -t "\t%5\t" -r "\t%5\t%6\n" -U%1 -P%2 -S%4
bcp %3.dbo.sysprotects out %3\SS7_SYSPROTECTS.DAT -c -e %3\SS7_SYSPROTECTS.ERR -t "\t%5\t" -r "\t%5\t%6\n" -U%1 -P%2 -S%4
bcp "select * from %3.dbo.sysobjects where name <> 'dtproperties'" queryout %3\SS7_SYSOBJECTS.DAT -c -e %3\SS7_SYSOBJECTS.ERR -t "\t%5\t" -r "\t%5\t%6\n" -U%1 -P%2 -S%4
bcp "select name, id, xtype, typestat, xusertype, length, xprec, xscale, colid, xoffset, bitpos, reserved, colstat, cdefault, domain, number, colorder, autoval, offset, status, type, usertype, prec, scale, iscomputed, isoutparam, isnullable  from %3..syscolumns" queryout %3\SS7_SYSCOLUMNS.dat -c -e %3\SS7_SYSCOLUMNS.ERR -t "\t%5\t" -r "\t%5\t%6\n" -U%1 -P%2 -S%4
bcp %3.dbo.systypes out %3\SS7_SYSTYPES.DAT -c -e %3\SS7_SYSTYPES.ERR -t "\t%5\t" -r "\t%5\t%6\n" -U%1 -P%2 -S%4
bcp %3.dbo.sysindexkeys out %3\SS7_SYSINDEXKEYS.DAT -c -e %3\SS7_SYSINDEXKEYS.ERR -t "\t%5\t" -r "\t%5\t%6\n" -U%1 -P%2 -S%4
bcp %3.dbo.sysreferences out %3\SS7_SYSREFERENCES.DAT -c -e %3\SS7_SYSREFERENCES.ERR -t "\t%5\t" -r "\t%5\t%6\n" -U%1 -P%2 -S%4
bcp %3.dbo.sysconstraints out %3\SS7_SYSCONSTRAINTS.DAT -c -e %3\SS7_SYSCONSTRAINTS.ERR -t "\t%5\t" -r "\t%5\t%6\n" -U%1 -P%2 -S%4
bcp "select id, number, colid, status, texttype, language, encrypted, compressed, CASE WHEN (encrypted = 1) then '/* ddl not accessible */' else  CAST(text AS VARCHAR(4000)) end from %3.dbo.syscomments" queryout %3\SS7_SYSCOMMENTS.dat -c -e %3\SS7_SYSCOMMENTS.ERR -t "\t%5\t" -r "\t%5\t%6\n" -U%1 -P%2 -S%4
bcp %3.dbo.sysfiles out %3\SS7_SYSFILES.DAT -c -e %3\SS7_SYSFILES.ERR -t "\t%5\t" -r "\t%5\t%6\n" -U%1 -P%2 -S%4
bcp %3.dbo.sysmembers out %3\SS7_SYSMEMBERS.DAT -c -e %3\SS7_SYSMEMBERS.ERR -t "\t%5\t" -r "\t%5\t%6\n" -U%1 -P%2 -S%4
bcp %3.dbo.sysforeignkeys out %3\SS7_SYSFOREIGNKEYS.DAT -c -e %3\SS7_SYSFOREIGNKEYS.ERR -t "\t%5\t" -r "\t%5\t%6\n" -U%1 -P%2 -S%4
bcp %3.dbo.sysproperties out %3\SS7_SYSPROPERTIES.DAT -c -e %3\SS7_SYSPROPERTIES.ERR -t "\t%5\t" -r "\t%5\t%6\n" -U%1 -P%2 -S%4



isql -U%1 -P%2 -S%4 -d%3  -i create_ss7_emulation_views.sql
rem export view which emulate SQL Server 7 SYSINDEXES table
bcp %3.dbo.mtg_sysindexes out %3\SS7_SYSINDEXES.DAT -c -e %3\SS7_SYSINDEXES.ERR -t "\t%5\t" -r "\t%5\t%6\n" -U%1 -P%2 -S%4
rem remove views that emulated sqlserver 7 tables
isql -U%1 -P%2 -S%4 -d%3  -i drop_ss7_emulation_views.sql

