/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.model.spi;

import java.net.URI;

import java.util.prefs.Preferences;

import javax.ide.model.java.JavaModel;
import javax.ide.net.URIPath;

public interface ProjectImpl extends DocumentImpl
{
  public URIPath getSourcePath();
  
  public void addClassPath( URIPath path );
  
  public URIPath getClassPath();
  
  public void setClassPath( URIPath path );
  
  public URI getOutputDirectory();
  
  public void setOutputDirectory( URI outputDirectory );
  
  public Preferences getPreferences();
  
  public void setPreferences( Preferences preferences );
  
  public JavaModel getJavaModel();
}
