package javax.ide.util;

/**
 * A marker interface for a MetaClass "aware" ClassLoader implementation.
 * If the ClassLoader used with MetaClass implements this interface, then
 * MetaClass will delegate to the loadMetaClass(className) method instead
 * of calling Class.forName()
 */
public interface MetaClassAwareClassLoader
{
  
  /**
   * Load the class identified by the given name. In a lazy-loading setting, 
   * this method will also initialize the extension associated where the 
   * respective class resides. If <code>triggerTopmost</code> is <code>true</code> 
   * classloader to be initialized, will be the classloader be the topmost 
   * classloader.  
   * 
   * @param className the FQN of the class that needs to be loaded
   * @param triggerTopMost whether the topmost classloader is to be initialized
   * @return
   */
  public Class loadMetaClass(String className, boolean triggerTopMost) throws ClassNotFoundException;

}
