/*
 * Licensed Materials - Property of Rogue Wave Software, Inc. 
 * © Copyright Rogue Wave Software, Inc. 2014, 2015 
 * © Copyright IBM Corp. 2009, 2014
 * © Copyright ILOG 1996, 2009
 * All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * The Software and Documentation were developed at private expense and
 * are "Commercial Items" as that term is defined at 48 CFR 2.101,
 * consisting of "Commercial Computer Software" and
 * "Commercial Computer Software Documentation", as such terms are
 * used in 48 CFR 12.212 or 48 CFR 227.7202-1 through 227.7202-4,
 * as applicable.
 */

if (typeof(IlvConstants) == "undefined" || typeof(IlvConstants.CoreBundleDefined) == "undefined") {
if(typeof (IlvConstants)=="undefined"){
IlvConstants={};
IlvConstants.ilvImagePath="script/images/";
}
if(typeof (IlvConstants.ilvLibraryVersion)=="undefined"){
IlvConstants.ilvLibraryVersion="8.9";
}
IlvConstants.CoreBundleDefined=true;
if(typeof (OpenAjax)!="undefined"){
OpenAjax.hub.registerLibrary("Ilv","http://xmlns.ilog.com/JViews/AjaxLibrary",IlvConstants.ilvLibraryVersion);
}
IlvObject=function(){
};
IlvObject.inherits=function(_1,_2,_3){
_2.prototype=new _1();
_2.prototype.constructor=_2;
if(!_3){
_3=_2.toString().match(/function\s*(\w+)/)[1];
}
_2.prototype.setClassName(_3);
};
IlvObject.prototype.getClassName=function(){
return this._className;
};
IlvObject.prototype.toString=function(){
return this.getClassName()+"_"+this.hashCode();
};
IlvObject.prototype.hashCode=function(){
if(!this._hashCode){
this._hashCode=IlvObject._nextHashCode||1;
IlvObject._nextHashCode=this._hashCode+1;
}
return this._hashCode;
};
IlvObject.prototype.instanceOf=function(_4){
if(typeof (_4)=="undefined"){
return false;
}else{
if(typeof (_4)=="string"){
_4=eval(_4);
}
}
return this instanceof _4;
};
IlvObject.prototype.invoke=function(_5,_6,_7){
if(typeof (_5)=="string"){
_5=this[_5];
}
if(typeof (_5)!="function"){
alert(IlvUtil.formatStr(jviews.messages.IlvObject.methodNotFound,_5));
}else{
return _5.apply(this,Array.prototype.slice.call(arguments,1));
}
};
IlvObject.prototype.superConstructor=function(_8,_9){
var _a=this.__constructor__||this.getClassName();
this.__constructor__=IlvObject._superClass[_a];
var _b=eval(this.__constructor__).apply(this,arguments);
this.__constructor__=null;
return _b;
};
IlvObject.prototype.superInvoke=function(_c,_d,_e){
if(typeof (_c)!="string"){
alert(jviews.messages.IlvObject.superInvokeOnlyBeStringParam);
}
if(!this.__callstack__){
this.__callstack__=[];
}
var _f,_10;
do{
if(!this.__callstack__[_c]){
if(!_f){
_f=eval("this."+_c);
}
this.__callstack__[_c]=this.getClassName();
}else{
if(!_f){
_f=eval(this.__callstack__[_c]+".prototype."+_c);
}
this.__callstack__[_c]=IlvObject._superClass[this.__callstack__[_c]];
}
_10=eval(this.__callstack__[_c]+".prototype."+_c);
if(!_10){
alert(IlvUtil.formatStr(jviews.messages.IlvObject.methodNotFoundInSuperInvoke,this.__callstack__[_c],_c));
}
}while(_10==_f);
var ret=_10.apply(this,Array.prototype.slice.call(arguments,1));
this.__callstack__[_c]=null;
return ret;
};
IlvObject.prototype.setClassName=function(_12){
if(!IlvObject._superClass){
IlvObject._superClass=[];
}
IlvObject._superClass[_12]=this._className;
this._className=_12;
this._hashCode=null;
return this;
};
IlvObject.prototype.dispose=function(){
IlvObject.removeInstance(this);
};
IlvObject.prototype.registerDispose=function(){
IlvObject.disposeInstances[this.toString()]=this;
};
IlvObject.prototype.registerDisposeByClientId=function(_13){
IlvObject.disposeProxyInstances[_13]=this;
};
IlvObject.prototype.setClassName("IlvObject");
IlvObject.disposeInstances={};
IlvObject.disposeProxyInstances={};
IlvObject.prototype.removeHTML=function(){
};
IlvObject.prototype.updateVisibility=function(){
};
IlvObject.callDispose=function(){
for(var i in IlvObject.disposeInstances){
var _15=IlvObject.disposeInstances[i];
if(_15){
_15.dispose();
}
}
IlvObject.disposeInstances=null;
};
IlvObject.removeInstance=function(_16){
for(var i in IlvObject.disposeInstances){
var _18=IlvObject.disposeInstances[i];
if(_18==_16){
IlvObject.disposeInstances[i]=null;
delete (IlvObject.disposeInstances[i]);
break;
}
}
};
IlvObject.disposeByClientId=function(_19){
for(var _1a in IlvObject.disposeProxyInstances){
if(_1a!=_19){
continue;
}
var _1b=IlvObject.disposeProxyInstances[_1a];
if(_1b){
_1b.dispose();
}
IlvObject.disposeProxyInstances[_1a]=null;
delete (IlvObject.disposeProxyInstances[_1a]);
}
};
IlvPageId=function(){
};
IlvPageId.prototype.setPageId=function(_1c){
document.getElementById(IlvPageId.pageIdKey).value=_1c;
};
IlvPageId.prototype.getPageId=function(){
return document.getElementById(IlvPageId.pageIdKey).value;
};
IlvPageId.pageIdKey="jviewsPageId";
IlvPageId.instance=new IlvPageId();
IlvBrowserInfo=function(){
var agt=navigator.userAgent.toLowerCase();
var dav=navigator.appVersion;
var _1f=function(r){
return r.test(agt);
};
this.major=parseInt(navigator.appVersion);
this.minor=parseFloat(navigator.appVersion);
this.nav=((agt.indexOf("mozilla")!=-1)&&(agt.indexOf("spoofer")==-1)&&(agt.indexOf("compatible")==-1)&&(agt.indexOf("opera")==-1)&&(agt.indexOf("webtv")==-1)&&(agt.indexOf("hotjava")==-1));
var _21=agt.indexOf("rv:");
var rev=agt.substring(_21+3,_21+6);
var _23=parseInt(rev);
var _24=rev.substring(2,4);
this.moz17=(this.nav&&(_23==1)&&(_24==7));
this.moz17up=this.nav&&(((_23==1)&&(_24>=7))||_23>=2);
this.moz18=(this.nav&&(_23==1)&&(_24==8));
this.moz18up=this.nav&&(((_23==1)&&(_24>=8))||_23>=2);
this.moz19=(this.nav&&(_23==1)&&(_24==9));
this.moz19up=this.nav&&(((_23==1)&&(_24>=9))||_23>=2);
this.ff4=(this.nav&&_23>=2);
if(document.all){
this.isIE=parseFloat(dav.split("MSIE ")[1])||undefined;
var _25=document.documentMode;
if(_25&&_25!=5&&Math.floor(this.isIE)!=_25){
this.isIE=_25;
}
this.isQuirks=document.compatMode=="BackCompat";
}
this.ie5up=(this.isIE>=5);
this.ie5_5=(this.isIE==5.5);
this.ie5_5up=(this.isIE>=5.5);
this.ie6=(this.isIE==6);
this.ie6up=(this.isIE>=6);
this.ie7=(this.isIE==7);
this.ie7up=(this.isIE>=7);
this.ie8=(this.isIE==8);
this.ie8up=(this.isIE>=8);
this.ie9up=(this.isIE>=9);
this.ie10up=(this.isIE>=10);
this.ie11up=(this.isIE>=11);
this.opera=(agt.indexOf("opera")!=-1);
this.webkit=_1f(/webkit/);
this.chrome=_1f(/chrome/);
this.safari=!this.chrome&&_1f(/safari/);
this.isSafari=this.safari&&_1f(/version\/3|4|5/);
this.ipad=(this.webkit&&agt.indexOf("ipad")!=-1);
this.ipod=(this.webkit&&agt.indexOf("ipod")!=-1);
this.iphone=(!this.isIpad&&agt.indexOf("iphone")!=-1);
this.ios=(this.ipad||this.ipod||this.iphone);
this.android=(this.webkit&&agt.indexOf("android")!=-1);
this.bb6=(this.webkit&&agt.indexOf("blackberry")!=-1);
this.isMobile=(this.ios||this.android||this.bb6);
this.vml=this.ie5up&&!this.ie9up;
this.svg=this.moz18up|this.ff4|this.webkit|(this.ie9up&!this.isQuirks)|this.ie10up;
};
IlvBrowserInfo.instance=new IlvBrowserInfo();
IlvBrowserInfo.noVectorialAlert=function(){
alert(jviews.messages.IlvBrowserInfo.doNotSupportSVGorVML);
};
IlvPanel=function(_26,top,_28,_29){
this.superConstructor();
this._bounds={left:_26||0,top:top||0,width:_28||0,height:_29||0};
this.scrollX=0;
this.scrollY=0;
this._displayed=true;
this._opacity=1;
this.registerDispose();
};
IlvPanel.prototype=new IlvObject();
IlvPanel.prototype.setClassName("IlvPanel");
IlvPanel.prototype.dispose=function(){
this.superInvoke("dispose");
this._clip=null;
this._div=null;
};
IlvPanel.prototype.translate=function(dx,dy){
if(this._div){
this._div.style.left=parseInt(this._bounds.left)+dx+"px";
this._div.style.top=parseInt(this._bounds.top)+dy+"px";
}
};
IlvPanel.prototype.getLeft=function(){
return this._bounds.left;
};
IlvPanel.prototype.getTop=function(){
return this._bounds.top;
};
IlvPanel.prototype.getWidth=function(){
return this._bounds.width;
};
IlvPanel.prototype.getHeight=function(){
return this._bounds.height;
};
IlvPanel.prototype.updateLocation=function(){
var _2c=this._bounds.left;
var top=this._bounds.top;
if(this._div){
this._div.style.left=(_2c-this.scrollX)+"px";
this._div.style.top=(top-this.scrollY)+"px";
}
};
IlvPanel.prototype.setLocation=function(_2e,top){
if(this._bounds){
this._bounds.left=_2e;
this._bounds.top=top;
this.updateLocation();
}
};
IlvPanel.prototype.getBounds=function(){
return this._bounds;
};
IlvPanel.prototype.setBounds=function(_30,top,_32,_33){
this.setLocation(_30,top);
this.setSize(_32,_33);
};
IlvPanel.prototype.setBackgroundColor=function(_34){
if(this._div){
this._div.style.backgroundColor=_34;
}
};
IlvPanel.prototype.setZIndex=function(_35){
if(this._div){
this._div.style.zIndex=_35;
}
};
IlvPanel.prototype.getZIndex=function(){
if(this._div){
return this._div.style.zIndex;
}
};
IlvPanel.prototype.setBackgroundImage=function(_36){
if(this._div){
this._div.style.backgroundImage="url("+_36+")";
}
};
IlvPanel.prototype.setVisible=function(_37){
this._visible=_37;
if(!IlvPanel.visibilityLock){
if(this._div){
if(!_37){
this._div.style.visibility="hidden";
}else{
this._div.style.visibility="inherit";
}
if(IlvBrowserInfo.instance.moz17up){
var s=this._div.offsetLeft;
}
}
}
};
IlvPanel.prototype.setOpacity=function(_39){
this._opacity=_39;
if(this._div){
var _3a=this._div.style;
_3a.opacity=_39;
var _3b=_39*100;
_3a.filter="alpha(opacity="+_3b+")";
}
};
IlvPanel.prototype.getOpacity=function(){
return this._opacity;
};
IlvPanel.prototype.setDisplayed=function(_3c){
this._displayed=_3c;
if(this._div){
this._div.style.display=_3c?"block":"none";
}
};
IlvPanel.prototype.isDisplayed=function(){
return this._displayed;
};
IlvPanel.prototype.updateVisibility=function(){
if(this.isVisible()){
this.setVisible(true);
}
};
IlvPanel.prototype.isVisible=function(){
return this._visible;
};
IlvPanel.prototype.setSize=function(_3d,_3e){
if(this._div){
this._div.style.width=_3d+"px";
this._div.style.height=_3e+"px";
}
this._bounds.width=_3d;
this._bounds.height=_3e;
this.setClip(0,0,_3d,_3e);
};
IlvPanel.prototype.getScrollPosition=function(){
return {x:this.scrollX,y:this.scrollY};
};
IlvPanel.prototype.setScrollPosition=function(x,y){
this.scrollX=x;
this.scrollY=y;
var _41=this.getClip();
this.updateLocation();
this.setClip(_41.left,_41.top,_41.width,_41.height);
_41=null;
};
IlvPanel.prototype.getClipImpl=function(){
var _42=null;
if(this._div){
var _43=this._div.style.clip.split("rect(")[1].split("px");
_42={top:parseInt(_43[0]),left:parseInt(_43[3]),width:parseInt(_43[1])-_42.left,height:parseInt(_43[2])-_42.top};
_43=null;
}
return _42;
};
IlvPanel.prototype.setClipImpl=function(_44,top,_46,_47){
if(this._div){
var _48=0;
if(IlvBrowserInfo.instance.moz17up||IlvBrowserInfo.instance.isSafari){
_48=1;
}
this._div.style.clip="rect("+(top-_48)+"px "+(_44+_46+_48)+"px "+(top+_47+_48)+"px "+(_44-_48)+"px)";
}
};
IlvPanel.prototype.getClip=function(){
if(!this._clip){
var _49=this.getClipImpl();
this._clip={left:_49.left-this.scrollX,top:_49.top-this.scrollY,width:_49.width,height:_49.height};
_49=null;
}
return this._clip;
};
IlvPanel.prototype.setClip=function(_4a,top,_4c,_4d){
var _4e=this.scrollX;
var _4f=this.scrollY;
var _50=this._bounds.width;
var _51=this._bounds.height;
if(_4a<0){
_4a=0;
}
if(_4a>_50){
_4a=_50;
}
if(top<0){
top=0;
}
if(top>_51){
top=_51;
}
if(_4c<0){
_4c=0;
}
if(_4d<0){
_4d=0;
}
var _52=_50-_4a;
var _53=_51-top;
if(_4c>_52){
_4c=_52;
}
if(_4d>_53){
_4d=_53;
}
var c=this._clip;
if(!c){
c={};
this._clip=c;
}
c.left=_4a;
c.top=top;
c.width=_4c;
c.height=_4d;
_4a+=_4e;
top+=_4f;
this.setClipImpl(_4a,top,_4c,_4d);
};
IlvPanel.prototype.getMouseEventSource=function(){
if(this._div){
return this._div;
}
};
IlvPanel.prototype.setCursor=function(_55){
if(this._div){
this._div.style.cursor=_55;
}
};
IlvPanel.prototype.getCursor=function(){
if(this._div){
return this._div.style.cursor;
}
};
IlvHTMLPanel=function(_56,_57){
this.superConstructor();
this.parentNode=_57;
var _58=this.toString();
if(_57){
var div=document.createElement("div");
div.id=_58;
div.style.cssText="position:absolute;z-index:1;visibility:hidden;-moz-user-select:none";
_57.appendChild(div);
this._div=div;
}else{
document.write("<div id=\""+_58+"\" ");
document.write("style=\"position:absolute; z-index:1; ");
if(IlvBrowserInfo.instance.moz17up){
document.write("-moz-user-select:none;");
}
document.writeln("visibility:hidden;\">");
document.writeln("</div>");
this._div=document.getElementById(_58);
}
if(!_56){
_56="<table border=\"0\" width=\"100%\" height=\"100%\"><tr><td></td></tr></table>";
}
this.setContentImpl(_56);
if(!this._div){
alert(jviews.messages.IlvHTMLPanel.notCreateIlvHtmlPanel);
}
this.baseTextDirection="";
};
IlvHTMLPanel.prototype=new IlvPanel();
IlvHTMLPanel.prototype.setClassName("IlvHTMLPanel");
IlvHTMLPanel.prototype.dispose=function(){
this.superInvoke("dispose");
this.parentNode=null;
};
IlvHTMLPanel.prototype.setBaseTextDirection=function(_5a){
this.baseTextDirection=_5a;
};
IlvHTMLPanel.prototype.getBaseTextDirection=function(){
return this.baseTextDirection;
};
IlvHTMLPanel.prototype.removeHTML=function(){
if(this._div){
this._div.parentNode.removeChild(this._div);
}
};
IlvHTMLPanel.prototype.setContent=function(_5b,_5c){
if(_5b){
this.setContentImpl(_5b);
}
if(_5c){
if(typeof (_5c)=="function"){
_5c(this);
}else{
eval(_5c);
}
}
};
IlvHTMLPanel.prototype.setContentImpl=function(_5d){
var s=_5d;
if(this._div){
this._div.innerHTML=s;
}
};
IlvHTMLPanel.prototype.getDocument=function(){
if(this._div){
return this._div.document?this._div.document:this._div.ownerDocument;
}
};
IlvURLPanel=function(_5f,top,_61,_62){
this.superConstructor(_5f,top,_61,_62);
var _63=this.toString();
document.write("<div id=\""+_63+"\" ");
document.write("style=\"position:absolute; z-index:1; ");
document.write("left:"+_5f+"px; top:"+top+"px; width:"+_61+"px; height:"+_62+"px;");
document.writeln("visibility:hidden;\">");
var _64=_63+"Frame";
document.writeln("<iframe name=\""+_64+"\" id=\""+_64+"\" scrolling=\"no\" width=\""+_61+"\" height=\""+_62+"\" marginwidth=\"0\" marginheight=\"0\" frameborder=\"no\" >");
document.writeln("</iframe>");
document.writeln("</div>");
this._div=document.getElementById(_63);
this._env=window.frames[_64];
this.setClip(0,0,this._bounds.width,this._bounds.height);
this.registerDispose();
if((!this._div)||!this._env){
alert(jviews.messages.IlvURLPanel.notCreateIlvURLPanel);
}
};
IlvURLPanel.prototype=new IlvPanel();
IlvURLPanel.prototype.setClassName("IlvURLPanel");
IlvURLPanel.prototype.removeHTML=function(){
if(this._div){
this._div.parentNode.removeChild(this._div);
}
};
IlvURLPanel.prototype.dispose=function(){
this.superInvoke("dispose");
this._env=null;
};
IlvURLPanel.prototype.setURL=function(url){
this.setURLImpl(url);
};
IlvURLPanel.prototype.setURLImpl=function(url,_67){
if(this._div){
var doc=this._env.document;
doc.location=url;
}
};
IlvURLPanel.prototype.getContext=function(){
return this._env;
};
IlvDynPanel=function(_69){
this.superConstructor();
var _6a=this.toString();
if(!_69){
_69=document.body;
}
this._div=this.createDivElement(this.toString());
_69.appendChild(this._div);
if(!this._div){
alert(IlvUtil.formatStr(jviews.messages.IlvDynPanel.notCreateCorrectly,this.toString()));
return;
}
};
IlvDynPanel.prototype=new IlvPanel();
IlvDynPanel.prototype.setClassName("IlvDynPanel");
IlvDynPanel.prototype.createDivElement=function(id){
var div=document.createElement("div");
div.id=id;
div.style.cssText="position:absolute;visibility:hidden;-moz-user-select:none;left:0px;top:0px;";
if(IlvBrowserInfo.instance.ie5up){
var _6d=document.createElement("table");
_6d.border=0;
_6d.width="100%";
_6d.height="100%";
var _6e=document.createElement("tBody");
_6d.appendChild(_6e);
var tr=document.createElement("tr");
_6e.appendChild(tr);
var td=document.createElement("td");
tr.appendChild(td);
div.appendChild(_6d);
}
return div;
};
IlvDynPanel.prototype.setContent=function(_71){
if(this._div){
this._div.innerHTML=_71;
}
};
IlvDynPanel.prototype.getMouseEventSource=function(){
if(this._div){
return this._div;
}
};
IlvDynPanel.prototype.setURL=function(url){
if(this._div){
if(!this._env){
var _73=this.toString()+"Loader";
var h="<iframe name=\""+_73+"\" width=\"100\" height=\"100\" src=\""+url+"\"></iframe>";
this._div.innerHTML=h;
this._env=window.frames[_73];
}else{
this._env.document.location=url;
}
}
};
IlvDynPanel.prototype.getContext=function(){
return this._env;
};
IlvDynPanel.prototype.updateLocation=function(){
var _75=this._bounds.left;
var top=this._bounds.top;
if(this._div){
this._div.style.left=(_75-this.scrollX)+"px";
this._div.style.top=(top-this.scrollY)+"px";
if(IlvBrowserInfo.instance.moz17up){
var s=this._div.offsetLeft;
}
}
};
IlvDynPanel.prototype.removeHTML=function(){
if(this._div){
this._div.parentNode.removeChild(this._div);
}
};
IlvSelection=function(){
};
IlvSelection.prototype=new IlvObject();
IlvSelection.prototype.setClassName("IlvSelection");
IlvSelection.prototype.getObjectProperty=function(_78){
return this.properties[0][_78];
};
IlvSelection.prototype.setObjectProperty=function(_79,_7a){
this.properties[0][_79]=_7a;
if(!this.invalidated){
this.invalidated={};
}
this.invalidated[_79]=true;
};
IlvSelection.prototype.setResizable=function(_7b){
this.resizable=_7b;
};
IlvSelection.prototype.getObjectTag=function(){
return this.tag;
};
IlvSelection.prototype.setBounds=function(){
};
IlvSelection.prototype.recompute=function(){
};
IlvSelection.prototype.getProperties=function(){
return this.properties;
};
IlvSelection.prototype.getInvalidatedProperties=function(){
var r={};
var i;
if(this.invalidated){
for(i in this.invalidated){
r[i]=this.properties[0][i];
}
}
var _7e=[];
_7e[0]=r;
for(i=1;i<this.properties.length;i++){
_7e[i]=this.properties[i];
}
return _7e;
};
IlvSelection.prototype.getObjectPropertyNames=function(){
var _7f=[];
var _80=0;
for(var i in this.properties[0]){
_7f[_80++]=i;
}
return _7f;
};
IlvSelection.prototype.setObjectProperties=function(_82){
if(!this.invalidated){
this.invalidated={};
}
var i;
for(i in this.properties[0]){
this.properties[0][i]=null;
this.invalidated[i]=true;
}
for(i in _82){
this.properties[0][i]=_82[i];
this.invalidated[i]=true;
}
};
IlvSelection.prototype.getObjectProperties=function(){
var r={};
for(var i in this.properties[0]){
r[i]=this.properties[0][i];
}
return r;
};
IlvSelection.prototype.getObjectID=function(){
return this.id;
};
IlvSelection.prototype.getObjectType=function(){
return this.type;
};
IlvRectangle=function(_86,_87,_88){
if(_86!=null){
return;
}
this.parentNode=_87;
this.superConstructor();
this.fillOn=_88;
this.opacity=0.5;
this.createPanels();
this.setColor("#000000");
this.setThickness(1);
this.scrollX=0;
this.scrollY=0;
this.registerDispose();
};
IlvRectangle.prototype=new IlvSelection();
IlvRectangle.prototype.setClassName("IlvRectangle");
IlvRectangle.prototype.removeHTML=function(){
this.top.removeHTML();
this.bottom.removeHTML();
this.left.removeHTML();
this.right.removeHTML();
if(this.fill){
this.fill.removeHTML();
}
};
IlvRectangle.prototype.dispose=function(){
this.top.dispose();
this.bottom.dispose();
this.left.dispose();
this.right.dispose();
if(this.clip){
this.clip=null;
}
if(this.fill){
this.fill.dispose();
}
this.parentNode=null;
};
IlvRectangle.prototype.updateVisibility=function(){
this.top.updateVisibility();
this.bottom.updateVisibility();
this.left.updateVisibility();
this.right.updateVisibility();
if(this.fill){
this.fill.updateVisibility();
}
};
IlvRectangle.prototype.createPanel=function(){
return new IlvHTMLPanel("",this.parentNode);
};
IlvRectangle.prototype.createPanels=function(){
if(this.fillOn){
this.fill=this.createFillPanel();
}
this.top=this.createPanel();
this.left=this.createPanel();
this.right=this.createPanel();
this.bottom=this.createPanel();
};
IlvRectangle.prototype.createFillPanel=function(){
var _89=this.createPanel();
_89.setOpacity(this.opacity);
return _89;
};
IlvRectangle.prototype.setZIndex=function(_8a){
this.zIndex=_8a;
this.top.setZIndex(_8a);
this.bottom.setZIndex(_8a);
this.left.setZIndex(_8a);
this.right.setZIndex(_8a);
if(this.fill){
this.fill.setZIndex(_8a);
}
};
IlvRectangle.prototype.getZIndex=function(){
return this.zIndex;
};
IlvRectangle.prototype.setColor=function(_8b){
this.color=_8b;
if(this.fill){
this.fill.setBackgroundColor(_8b);
}
this.top.setBackgroundColor(_8b);
this.left.setBackgroundColor(_8b);
this.right.setBackgroundColor(_8b);
this.bottom.setBackgroundColor(_8b);
};
IlvRectangle.prototype.isFillOn=function(){
return this.fillOn;
};
IlvRectangle.prototype.setFillOn=function(_8c){
if(this.fillOn==_8c){
return;
}
this.fillOn=_8c;
if(_8c){
if(!this.fill){
this.fill=this.createFillPanel();
this.fill.setBackgroundColor(this.color);
this.fill.setZIndex(this.zIndex);
}
this.fill.setVisible(this.visible);
}else{
this.fill.setVisible(false);
}
if(this.visible){
this.recompute();
}
};
IlvRectangle.prototype.setOpacity=function(_8d){
this.opacity=_8d;
if(this.fill){
this.fill.setOpacity(this.opacity);
}
};
IlvRectangle.prototype.getOpacity=function(){
return this.opacity;
};
IlvRectangle.prototype.setVisible=function(_8e){
if(this.visible!=_8e){
this.visible=_8e;
this.top.setVisible(_8e);
this.left.setVisible(_8e);
this.right.setVisible(_8e);
this.bottom.setVisible(_8e);
if(this.fill){
this.fill.setVisible(_8e&&this.fillOn);
}
if(this.visible){
this.recompute();
}
}
};
IlvRectangle.prototype.isVisible=function(){
return this.visible;
};
IlvRectangle.prototype.setDisplayed=function(_8f){
if(this.displayed!=_8f){
this.displayed=_8f;
this.top.setDisplayed(_8f);
this.left.setDisplayed(_8f);
this.right.setDisplayed(_8f);
this.bottom.setDisplayed(_8f);
if(this.fill){
this.fill.setDisplayed(_8f&&this.fillOn);
}
if(this.displayed){
this.recompute();
}
}
};
IlvRectangle.prototype.isDisplayed=function(){
return this.displayed;
};
IlvRectangle.prototype.setThickness=function(_90){
if(this.thickness==_90){
return;
}
this.thickness=_90||0;
if(this.visible){
this.recompute();
}
};
IlvRectangle.prototype.getThickness=function(_91){
return this.thickness||0;
};
IlvRectangle.prototype.setBounds=function(_92,top,_94,_95){
this.bounds={left:_92,top:top,width:_94,height:_95};
if(this.visible){
this.recompute();
}
};
IlvRectangle.prototype.getBounds=function(){
if(!this.bounds){
this.bounds={left:0,top:0,width:0,height:0};
}
return this.bounds;
};
IlvRectangle.prototype.setClip=function(_96,top,_98,_99){
this.clip={left:_96,top:top,width:_98,height:_99};
if(this.visible){
this.recompute();
}
};
IlvRectangle.prototype.removeClip=function(){
this.clip=null;
if(this.visible){
this.recompute();
}
};
IlvRectangle.prototype.isClipped=function(){
return (this.clip!=null);
};
IlvRectangle.prototype.recompute=function(){
var b=this.bounds;
if(b){
var t=this.thickness;
if(this.fill){
var h=b.height-t>0?b.height-t:0;
var w=b.width-t>0?b.width-t:0;
this.draw(this.fill,b.left-this.scrollX,b.top-this.scrollY,w,h);
}
this.draw(this.top,b.left-this.scrollX,b.top-this.scrollY,b.width,t);
this.draw(this.left,b.left-this.scrollX,b.top-this.scrollY,t,b.height);
this.draw(this.bottom,b.left-this.scrollX,b.top+b.height-t-this.scrollY,b.width,t);
var rw=b.width;
if(this.clip){
rw=this.clip.width<b.width?this.clip.width:b.width;
}
var _9f=b.left+rw-t-this.scrollX;
this.draw(this.right,_9f,b.top-this.scrollY,t,b.height);
}
};
IlvRectangle.prototype.draw=function(_a0,_a1,top,_a3,_a4){
if(_a0){
if(this.clip){
var c=this.clip;
var x=_a1+_a3,cx=c.left+c.width;
var y=top+_a4,cy=c.top+c.height;
if(x>cx){
x=cx;
}
if(y>cy){
y=cy;
}
if(_a1<c.left){
_a1=c.left;
}
if(top<c.top){
top=c.top;
}
_a3=(x>_a1)?x-_a1:0;
_a4=(y>top)?y-top:0;
}
_a0.setBounds(_a1,top,_a3,_a4);
}
};
IlvRectangle.prototype.setScrollPosition=function(x,y){
this.scrollX=x;
this.scrollY=y;
if(this.visible){
this.recompute();
}
};
IlvRectangle.prototype.getScrollPosition=function(){
return {x:this.scrollX,y:this.scrollY};
};
IlvDynRectangle=function(_ac,_ad,_ae){
this.superConstructor(_ac,_ad,_ae);
};
IlvDynRectangle.prototype=new IlvRectangle("init");
IlvDynRectangle.prototype.setClassName("IlvDynRectangle");
IlvListenerList=function(){
this.superConstructor();
};
IlvListenerList.prototype=new IlvObject();
IlvListenerList.prototype.setClassName("IlvListenerList");
IlvListenerList.prototype.addListener=function(_af,_b0){
if(typeof (_b0)=="undefined"){
_b0=_af;
_af="NoType";
}
if(!_b0){
alert(jviews.messages.IlvListenerList.onlyFunctionsBeListeners);
}else{
if(!this._listeners){
this._listeners=[];
}
if(!this._listeners[_af]){
this._listeners[_af]=[];
}
var _b1=this._listeners[_af];
var l=_b1.length-1;
var _b3=_b1.length;
var i;
for(i=l;i>=0;i--){
if(_b1[i]==_b0){
return;
}else{
if(_b1[i]==null){
_b3=i;
}
}
}
_b1[_b3]=_b0;
}
this.registerDispose();
};
IlvListenerList.prototype.dispose=function(){
this.superInvoke("dispose");
this._listeners=null;
};
IlvListenerList.prototype.removeListener=function(_b5,_b6){
if(typeof (_b6)=="undefined"){
_b6=_b5;
_b5="NoType";
}
if(!_b6){
alert(jviews.messages.IlvListenerList.onlyFunctionsBeListeners);
}
if(this._listeners&&this._listeners[_b5]){
var _b7=this._listeners[_b5];
var l=_b7.length;
var v=new Array(l-1);
var i,ii=0;
for(i=0;i<l;i++){
if(_b7[i]!=_b6){
v[ii]=_b7[i];
ii++;
}
}
this._listeners[_b5]=v;
}
};
IlvListenerList.prototype.notify=function(_bc,_bd,_be){
var _bf=(typeof (_bc)=="string");
var _c0;
if(!_bf){
_c0="NoType";
}else{
_c0=_bc;
}
if(this._listeners&&this._listeners[_c0]){
var _c1=this._listeners[_c0];
var ii;
var ll=_c1.length-1;
for(ii=ll;ii>=0;ii--){
if(_c1[ii]){
var _c4=arguments;
if(_bf){
var _c4=new Array(arguments.length-1);
for(var i=0;i<_c4.length;i++){
_c4[i]=arguments[i+1];
}
}
_c1[ii].apply(null,_c4);
}
}
}
};
getForm=function(_c6){
return document.getElementById(_c6);
};
getImage=function(_c7){
return document.getElementById(_c7);
};
replaceImage=function(_c8,_c9,_ca,_cb,_cc){
IlvUtil.replaceImage(_c8,_c9,_ca,_cb,_cc);
};
replaceImageWithDimensions=function(_cd,_ce,_cf,_d0,_d1){
replaceImage(_cd,_ce,_cf,_d0,_d1);
};
listProperties=function(obj){
var msg=IlvUtil.formatStr(jviews.messages.listProperties.propertiesForObj,obj);
for(var i in obj){
var _d5=typeof (obj[i]);
if(_d5!="function"){
var _d6;
if(_d5=="unknown"){
_d6="<unknown>";
}else{
_d6=obj[i];
}
msg+="\n"+i+"="+_d6;
}
}
return msg;
};
listMethods=function(obj){
var msg=IlvUtil.formatStr(jviews.messages.listMethods.methodsForObj,obj);
for(var i in obj){
var _da=typeof (obj[i]);
if(_da=="function"){
var _db=obj[i];
msg+="\n"+i+"="+_db;
}
}
return msg;
};
displayProperties=function(obj){
alert(listProperties(obj));
};
displayMethods=function(obj){
alert(listMethods(obj));
};
evaluatorToHTML=function(_de,_df){
};
trace=function(_e0,_e1,_e2,_e3,_e4){
};
IlvDrawUtil=function(){
};
IlvDrawUtil.drawLine=function(x1,y1,x2,y2,_e9,_ea,_eb,_ec){
var div=_eb;
var _ee;
var _ef=document.getElementsByTagName("body").item(0);
if(IlvBrowserInfo.instance.svg){
var svg;
if(!div){
div=document.createElement("div");
div.setAttribute("style","z-index:3;position:absolute;left:0px;top:0;width:100%;height:100%");
svg=document.createElementNS("http://www.w3.org/2000/svg","svg");
_ee=document.createElementNS("http://www.w3.org/2000/svg","line");
}else{
svg=div.firstChild;
_ee=svg.firstChild;
}
_ee.setAttributeNS(null,"x1",x1);
_ee.setAttributeNS(null,"y1",y1);
_ee.setAttributeNS(null,"x2",x2);
_ee.setAttributeNS(null,"y2",y2);
_ee.setAttributeNS(null,"stroke",_ea);
_ee.setAttributeNS(null,"stroke-width",_e9);
if(!div.parentNode){
if(!svg.parentNode){
svg.appendChild(_ee);
div.appendChild(svg);
}
if(_ec){
_ec.appendChild(div);
}else{
_ef.appendChild(div);
}
}
return div;
}else{
if(IlvBrowserInfo.instance.vml){
if(!div){
div=document.createElement("div");
div.style.zIndex=3;
div.style.position="absolute";
div.style.left="0px";
div.style.top="0px";
div.style.width="100%";
div.style.height="100%";
_ee=document.createElement("line");
_ee.style.behavior="url(#default#VML)";
}else{
_ee=div.firstChild;
}
_ee.from=x1+","+y1;
_ee.to=x2+","+y2;
_ee.strokeweight=_e9;
_ee.strokecolor=_ea;
if(div.parentNode!=_ef){
if(_ee.parentNode!=div){
div.appendChild(_ee);
}
if(_ec){
_ec.appendChild(div);
}else{
_ef.appendChild(div);
}
}
return div;
}
}
};
IlvDrawUtil.releaseLine=function(_f1){
if(_f1&&_f1.parentNode){
_f1.parentNode.removeChild(_f1);
}
};
IlvRequestParameters={};
IlvRequestParameters.getRequestParameters=function(_f2){
var _f3=_f2.length;
var r=new Array(_f3*2);
for(var i=0;i<_f3;i+=2){
r[2*i]="&";
r[2*i+1]=_f2[i];
r[2*i+2]="=";
r[2*i+3]=escape(_f2[i+1]);
}
return r.join("");
};
IlvRequestParameters.setParameter=function(_f6,key,_f8){
var _f9=IlvRequestParameters.indexOfKey(_f6,key);
if(_f9!=-1){
if(_f8==null){
IlvRequestParameters.removeAt(_f6,_f9);
}else{
_f6[_f9+1]=_f8;
}
}else{
_f6[_f6.length]=key;
_f6[_f6.length]=_f8;
}
};
IlvRequestParameters.removeParameter=function(_fa,key){
var i=IlvRequestParameters.indexOfKey(_fa,key);
if(i!=-1){
IlvRequestParameters.removeAt(_fa,i);
}
};
IlvRequestParameters.indexOfKey=function(_fd,key){
var _ff=_fd.length;
for(var i=0;i<_ff;i+=2){
if(_fd[i]==key){
return i;
}
}
return -1;
};
IlvRequestParameters.removeAt=function(_101,_102){
var _103=_101.length;
for(var i=_102;i<_103-2;i+=2){
_101[i]=_101[i+2];
_101[i+1]=_101[i+3];
}
_101.length-=2;
};
IlvUtil={};
IlvUtil.isIntersect=function(_105,_106){
return ((_105.left<=_106.left+_106.width)&&(_105.left+_105.width>=_106.left)&&(_105.top<=_106.top+_106.height)&&(_105.top+_105.height>=_106.top));
};
IlvUtil.formatStr=function(){
var ary=[];
for(i=1;i<arguments.length;i++){
ary.push(arguments[i]);
}
return arguments[0].replace(/\{(\d+)\}/g,function(m,i){
return ary[i];
});
};
IlvUtil.isPrimaryMouseButton=function(_10a){
if(IlvBrowserInfo.instance.ie6up&&!IlvBrowserInfo.instance.ie10up){
if(IlvBrowserInfo.instance.ie9up&&!IlvBrowserInfo.instance.isQuirks){
return _10a.button==0;
}
return _10a.button==1;
}else{
return _10a.button==0;
}
};
IlvUtil.isSecondaryMouseButton=function(_10b){
return _10b.button==2;
};
IlvUtil.setCookie=function(name,_10d,_10e,path,_110,_111){
var _112=false;
var _113=name+"="+escape(_10d)+((_10e)?"; expires="+_10e.toGMTString():"")+((path)?"; path="+path:"")+((_110)?"; domain="+_110:"")+((_111)?"; secure":"");
if(!_112||(name+"="+escape(_10d)).length<=4000){
document.cookie=_113;
}else{
if(confirm(jviews.messages.IlvUtil.cookieExtends4K)){
document.cookie=_113;
}
}
};
IlvUtil.getCookie=function(name){
var _115=name+"=";
var _116=document.cookie.indexOf(_115);
if(_116==-1){
return null;
}
var _117=document.cookie.indexOf(";",_116+_115.length);
if(_117==-1){
_117=document.cookie.length;
}
return unescape(document.cookie.substring(_116+_115.length,_117));
};
IlvUtil.deleteCookie=function(name,path,_11a){
if(IlvUtil.getCookie(name)){
document.cookie=name+"="+((path)?"; path="+path:"")+((_11a)?"; domain="+_11a:"")+"; expires=Thu, 01-Jan-1970 00:00:01 GMT";
}
};
IlvUtil.disposeImageSource=function(_11b){
_11b.onabort=null;
_11b.onerror=null;
_11b.onload=null;
if(_11b.outerHTML){
try{
_11b.outerHTML="<img style=\"-webkit-user-drag:none\" width=\"10\" height=\"10\"/>";
}
catch(ee){
_11b.src=IlvConstants.ilvImagePath+jviews.messages.IlvUtil.emptyIcon;
}
}else{
_11b.src=IlvConstants.ilvImagePath+jviews.messages.IlvUtil.emptyIcon;
}
};
IlvUtil.replaceImage=function(_11c,_11d,_11e,_11f,_120){
var _121=document.getElementById(_11c);
if(!_121){
return;
}
_11d.alt=_121.alt;
_11d.id=_121.id;
_11d.name=_121.name;
if(_11f){
_11d.width=_11f;
}else{
_11d.width=_121.width;
}
if(_120){
_11d.height=_120;
}else{
_11d.height=_121.height;
}
_121.parentNode.replaceChild(_11d,_121);
if(_11e){
IlvUtil.disposeImageSource(_121);
}
};
IlvUtil.pageLoaded=false;
IlvUtil.attachedLoadEvents=[];
IlvUtil.addOnLoad=function(f){
if(IlvUtil.pageLoaded){
f.call();
}else{
IlvUtil.addOnEvt("load",f);
}
};
IlvUtil.addOnEvt=function(type,f){
if(window["attachEvent"]){
if(type=="load"){
IlvUtil.attachedLoadEvents.push(f);
}else{
window.attachEvent("on"+type,f);
}
}else{
if(window["addEventListener"]){
window.addEventListener(type,f,false);
}
}
};
if(window["attachEvent"]){
function fireAttacheLoadEvents(){
for(var i=0;i<IlvUtil.attachedLoadEvents.length;i++){
IlvUtil.attachedLoadEvents[i]();
IlvUtil.attachedLoadEvents[i]=null;
}
IlvUtil.attachedLoadEvents.length=0;
}
window.attachEvent("onload",fireAttacheLoadEvents);
}
IlvUtil.indexOf=function(_126,item){
if(Array.prototype.indexOf){
return _126.indexOf(item);
}else{
var _128=-1;
var l=_126.length;
for(var i=0;i<l;i++){
if(_126[i]==item){
_128=i;
break;
}
}
return _128;
}
};
IlvUtil.submitForm=function(form,_12c,_12d){
if(typeof iceSubmit!="undefined"){
iceSubmit(form,null,new Object());
}else{
if(_12d&&typeof TrPage!="undefined"){
TrPage.getInstance().sendPartialFormPost(form,{source:_12c,partial:"true",event:"autosub"});
}else{
form.submit();
}
}
};
IlvAjax=function(){
};
IlvAjax={};
IlvAjax.Util={};
IlvAjax.Util.asynchronous=true;
IlvAjax.Util.POST="POST";
IlvAjax.Util.GET="GET";
IlvAjax.Util.XHR_RUNNING=[];
function empty(){
}
IlvAjax.Util.getXMLHttpRequest=function(){
var _12e=false;
if(typeof XMLHttpRequest!="undefined"){
_12e=new XMLHttpRequest();
}else{
try{
_12e=new ActiveXObject("Msxml2.XMLHTTP");
}
catch(e1){
try{
_12e=new ActiveXObject("Microsoft.XMLHTTP");
}
catch(e2){
}
}
}
return _12e;
};
IlvAjax.loadJS=function(url){
var _130=IlvAjax.Util.getXMLHttpRequest();
if(_130){
_130.open(IlvAjax.Util.GET,url,false);
_130.send(null);
eval(_130.responseText);
}
};
IlvAjax.post=function(url,_132,xhr,_134,_135){
IlvAjax.Util.post(url,xhr,_134,_135);
};
IlvAjax.Util.post=function(url,_137,xhr,_139,_13a){
IlvAjax.Util.send(url,_137,xhr,IlvAjax.Util.POST,_139,_13a);
};
IlvAjax.get=function(url,xhr,_13d,_13e){
IlvAjax.Util.get(url,xhr,_13d,_13e);
};
IlvAjax.Util.get=function(url,xhr,_141,_142){
IlvAjax.Util.send(url,null,xhr,IlvAjax.Util.GET,_141,_142);
};
IlvAjax.Util.send=function(url,_144,xhr,_146,_147,_148){
if(!xhr){
xhr=IlvAjax.Util.getXMLHttpRequest();
}
var x=xhr;
if(x.readyState!=0&&!(x.readyState==4&&IlvUtil.indexOf(IlvAjax.Util.XHR_RUNNING,x)==-1)){
x=IlvAjax.Util.getXMLHttpRequest();
}
IlvAjax.Util.XHR_RUNNING.push(x);
x.open(_146,url,IlvAjax.Util.asynchronous);
x.onreadystatechange=function(){
if(x.readyState==4){
if(x.status==200||x.status==0){
if(_147){
_147.call(null,x);
_147=empty;
}
}else{
if(_148){
_148.call(null,x);
_148=empty;
}
}
IlvAjax.Util.XHR_RUNNING.splice(IlvUtil.indexOf(IlvAjax.Util.XHR_RUNNING,x),1);
x.onreadystatechange=empty;
}
};
if(_146==IlvAjax.Util.POST){
x.setRequestHeader("Content-length",_144.length);
x.setRequestHeader("Content-Type","application/json;charset=utf-8");
}
x.send(_144);
return xhr;
};
IlvAjax.HTMLRequest=function(obj,_14b,_14c){
IlvAjax.HTMLRequest.XHR=IlvAjax.Util.getXMLHttpRequest();
this._oncompleted=function(x){
var _14e=x.responseText;
_14b.call(obj,_14e);
this._oncompleted=null;
};
if(_14c){
this._onfailed=function(x){
_14c.call(obj,x);
this._onfailed=null;
};
}
};
IlvAjax.HTMLRequest.prototype.send=function(url){
IlvAjax.Util.send(url,null,IlvAjax.HTMLRequest.XHR,IlvAjax.Util.GET,this._oncompleted,this._onfailed);
};
IlvAjax.JSRequest=function(obj,_152,_153){
IlvAjax.JSRequest.XHR=IlvAjax.Util.getXMLHttpRequest();
this._oncompleted=function(x){
var _155;
if(x.responseText.length>0){
_155=eval("("+x.responseText+")");
}else{
_155={};
}
_152.call(obj,_155);
this._oncompleted=empty;
};
if(_153){
this._onfailed=function(x){
_153.call(obj,x);
this._onfailed=empty;
};
}
};
IlvAjax.JSRequest.prototype.send=function(url,_158){
IlvAjax.Util.send(url,null,IlvAjax.JSRequest.XHR,IlvAjax.Util.GET,this._oncompleted,this._onfailed);
};
IlvJSONUtil={};
IlvJSONUtil.escaped={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r","\"":"\\\"","\\":"\\\\"};
IlvJSONUtil.arrayToJSON=function(x){
var a=["["],b,f,i,l=x.length,v;
for(i=0;i<l;i+=1){
v=x[i];
if(v==null){
f=IlvJSONUtil.nullToJSON;
}else{
if(typeof (v)=="string"){
f=IlvJSONUtil.stringToJSON;
}else{
if(v instanceof Array){
f=IlvJSONUtil.arrayToJSON;
}else{
f=IlvJSONUtil.objectToJSON;
}
}
}
if(f){
v=f(v);
if(typeof v=="string"){
if(b){
a[a.length]=",";
}
a[a.length]=v;
b=true;
}
}
}
a[a.length]="]";
return a.join("");
};
IlvJSONUtil.nullToJSON=function(x){
return "null";
};
IlvJSONUtil.stringToJSON=function(x){
if(/["\\\x00-\x1f]/.test(x)){
x=x.replace(/([\x00-\x1f\\"])/g,function(a,b){
var c=IlvJSONUtil.escaped[b];
if(c){
return c;
}
c=b.charCodeAt();
return "\\u00"+Math.floor(c/16).toString(16)+(c%16).toString(16);
});
}
return "\""+x+"\"";
};
IlvJSONUtil.objectToJSON=function(x){
var a=["{"],b,f,i,v;
for(i in x){
v=x[i];
if(v==null){
f=IlvJSONUtil.nullToJSON;
}else{
if(typeof (v)=="string"){
f=IlvJSONUtil.stringToJSON;
}else{
if(v instanceof Array){
f=IlvJSONUtil.arrayToJSON;
}else{
f=IlvJSONUtil.objectToJSON;
}
}
}
if(f){
v=f(v);
if(typeof v=="string"){
if(b){
a[a.length]=",";
}
a.push(IlvJSONUtil.stringToJSON(i),":",v);
b=true;
}
}
}
a[a.length]="}";
return a.join("");
};
IlvUtil.loadLocalizedMessages=function(_16b){
var _16c=_16b;
if(IlvUtil.localeDeterminationServlet){
if(IlvUtil.localeDeterminationServlet.indexOf("?")<0){
_16c=IlvUtil.localeDeterminationServlet+"?request=scriptMessage&module="+_16b;
}else{
_16c=IlvUtil.localeDeterminationServlet+"&request=scriptMessage&module="+_16b;
}
if(typeof (IlvConstants.locale)!="undefined"){
_16c=_16c+"&locale="+IlvConstants.locale;
}
}
IlvAjax.loadJS(_16c);
};
IlvUtil.setLocaleDeterminationServlet=function(_16d){
IlvUtil.localeDeterminationServlet=_16d;
};
IlvUtil.getCS=function(node){
if(IlvBrowserInfo.instance.webkit){
var s;
if(node instanceof HTMLElement){
var dv=node.ownerDocument.defaultView;
s=dv.getComputedStyle(node,null);
if(!s&&node.style){
node.style.display="";
s=dv.getComputedStyle(node,null);
}
}
return s||{};
}else{
if(IlvBrowserInfo.instance.ie){
return node.nodeType==1?node.currentStyle:{};
}else{
return node instanceof HTMLElement?node.ownerDocument.defaultView.getComputedStyle(node,null):{};
}
}
};
IlvUtil._docScroll=function(){
var doc=document;
var _b=doc.body||doc.getElementsByTagName("body")[0];
var _w=window;
var de=doc.documentElement;
return {y:(_w.pageYOffset||de.scrollTop||_b.scrollTop||0),x:(_w.pageXOffset||de.scrollLeft||_b.scrollLeft||0)};
};
IlvUtil._toPixelValue=function(_175,_176){
if(!IlvBrowserInfo.instance.ie){
return parseFloat(_176)||0;
}else{
if(!_176){
return 0;
}
if(_176=="medium"){
return 4;
}
if(_176.slice&&(_176.slice(-2)=="px")){
return parseFloat(_176);
}
with(_175){
var _177=style.left;
var _178=runtimeStyle.left;
runtimeStyle.left=currentStyle.left;
try{
style.left=_176;
_176=style.pixelLeft;
}
catch(e){
_176=0;
}
style.left=_177;
runtimeStyle.left=_178;
}
return _176;
}
};
IlvUtil.getIeDocumentOffset=function(){
var de=document.documentElement;
if(IlvBrowserInfo.instance.isIE<8){
var r=de.getBoundingClientRect();
var l=r.left,t=r.top;
if(IlvBrowserInfo.instance.isIE<7){
l+=de.clientLeft;
t+=de.clientTop;
}
return {x:l<0?0:l,y:t<0?0:t};
}else{
return {x:0,y:0};
}
};
IlvUtil.getEncodedVisibleLayers=function(view,_17e){
if(!_17e){
return "";
}
var _17f=[];
for(var i=0;i<_17e.length;i++){
if(view.isLayerVisible(_17e[i])){
_17f[_17f.length]=_17e[i];
}
}
return IlvUtil.encodeStringAttribute(_17f.join(","));
};
IlvUtil.encodeStringAttribute=function(URI){
return encodeURIComponent(URI);
};
IlvUtil.decodeStringAttribute=function(URI){
return decodeURIComponent(URI);
};
IlvUtil.isArray=function(obj){
return Object.prototype.toString.call(obj)==="[object Array]";
};
IlvUtil.isFunction=function(fn){
return !!fn&&!fn.nodeName&&fn.constructor!=String&&fn.constructor!=RegExp&&fn.constructor!=Array&&/function/i.test(fn+"");
};
IlvUtil.trim=function(str){
if(String.prototype.trim){
return str.trim();
}else{
return str.replace(/^\s\s*/,"").replace(/\s\s*$/,"");
}
};
IlvUtil.keys={BACKSPACE:8,TAB:9,CLEAR:12,ENTER:13,SHIFT:16,CTRL:17,ALT:18,PAUSE:19,CAPS_LOCK:20,ESCAPE:27,SPACE:32,PAGE_UP:33,PAGE_DOWN:34,END:35,HOME:36,LEFT_ARROW:37,UP_ARROW:38,RIGHT_ARROW:39,DOWN_ARROW:40,INSERT:45,DELETE:46,HELP:47,LEFT_WINDOW:91,RIGHT_WINDOW:92,SELECT:93,NUMPAD_0:96,NUMPAD_1:97,NUMPAD_2:98,NUMPAD_3:99,NUMPAD_4:100,NUMPAD_5:101,NUMPAD_6:102,NUMPAD_7:103,NUMPAD_8:104,NUMPAD_9:105,NUMPAD_MULTIPLY:106,NUMPAD_PLUS:107,PLUS:107,NUMPAD_ENTER:108,NUMPAD_MINUS:109,MINUS:109,NUMPAD_PERIOD:110,NUMPAD_DIVIDE:111,EQUALS:187,DASH:189,F1:112,F2:113,F3:114,F4:115,F5:116,F6:117,F7:118,F8:119,F9:120,F10:121,F11:122,F12:123,F13:124,F14:125,F15:126,NUM_LOCK:144,SCROLL_LOCK:145};
IlvUtil.isBidiChar=function(c){
if(c>1424&&c<1791){
return true;
}else{
return false;
}
};
IlvUtil.isLatinChar=function(c){
if((c>64&&c<91)||(c>96&&c<123)){
return true;
}else{
return false;
}
};
IlvUtil.getContextualDir=function(text){
var len=text.length;
for(var i=0;i<len;i++){
symbol=text.charCodeAt(i);
if(IlvUtil.isBidiChar(symbol)){
return "rtl";
}else{
if(IlvUtil.isLatinChar(symbol)){
return "ltr";
}
}
}
return "";
};
IlvUtil.setMessageDirection=function(_18b,_18c){
if(_18c==null){
return _18b;
}
if(_18c.toLowerCase()=="contextual"){
return "<span dir='"+IlvUtil.getContextualDir(_18b)+"'>"+_18b+"</span>";
}else{
if(_18c.toLowerCase()=="rtl"){
return "<span dir='rtl'>"+_18b+"</span>";
}else{
if(_18c.toLowerCase()=="ltr"){
return "<span dir='ltr'>"+_18b+"</span>";
}else{
return _18b;
}
}
}
};
IlvUtil.setMessageUCCDirection=function(_18d,_18e){
if(_18e==null){
return _18d;
}
var LRE="\u202a";
var RLE="\u202b";
var PDF="\u202c";
var dir="";
if(_18e.toLowerCase()=="contextual"){
dir=IlvUtil.getContextualDir(_18d);
}else{
dir=_18e;
}
if(dir.toLowerCase()=="rtl"){
return RLE+_18d+PDF;
}else{
if(dir.toLowerCase()=="ltr"){
return LRE+_18d+PDF;
}else{
return _18d;
}
}
};
IlvUtil.removeMessageUCCDirection=function(_193){
var LRE="\u202a";
var RLE="\u202b";
var PDF="\u202c";
var _197=_193.replace(/\u202A/g,"");
_197=_197.replace(/\u202B/g,"");
return _197.replace(/\u202C/g,"");
};
IlvEmptyView=function(left,top,_19a,_19b,_19c){
this.superConstructor();
this.left=left||0;
this.top=top||0;
this.width=_19a||0;
this.height=_19b||0;
this.cookieName=this.toString();
if(_19c){
this.cookieName=_19c+":"+this.cookieName;
}
this.inHTML=false;
this.sizeListeners=null;
this.stateInCookie=true;
};
IlvEmptyView.prototype=new IlvObject();
IlvEmptyView.prototype.setClassName("IlvEmptyView");
IlvEmptyView.prototype.dispose=function(){
this.superInvoke("dispose");
if(this.sizeListeners){
this.sizeListeners.dispose();
this.sizeListeners=null;
}
this.parentNode=null;
};
IlvEmptyView.prototype.getBounds=function(){
return {left:this.left,top:this.top,width:this.width,height:this.height};
};
IlvEmptyView.prototype.setChildrenBounds=function(left,top,_19f,_1a0){
};
IlvEmptyView.prototype.setBounds=function(left,top,_1a3,_1a4){
this._resized=(_1a3!=this.width||_1a4!=this.height);
this.left=left;
this.top=top;
this.width=_1a3;
this.height=_1a4;
this.setChildrenBounds(left,top,_1a3,_1a4);
if(this._resized){
this.fireSizeChanged();
}
};
IlvEmptyView.prototype.setSize=function(_1a5,_1a6){
this.setBounds(this.left,this.top,_1a5,_1a6);
};
IlvEmptyView.prototype.setLocation=function(left,top){
this.setBounds(left,top,this.width,this.height);
};
IlvEmptyView.prototype.getSize=function(){
return this.getBounds();
};
IlvEmptyView.prototype.getLocation=function(){
return this.getBounds();
};
IlvEmptyView.prototype.getLeft=function(){
return this.left;
};
IlvEmptyView.prototype.getTop=function(){
return this.top;
};
IlvEmptyView.prototype.getWidth=function(){
return this.width;
};
IlvEmptyView.prototype.getHeight=function(){
return this.height;
};
IlvEmptyView.prototype.addSizeListener=function(_1a9){
if(!this.sizeListeners){
this.sizeListeners=new IlvListenerList();
}
this.sizeListeners.addListener(_1a9);
};
IlvEmptyView.prototype.removeSizeListener=function(_1aa){
if(this.sizeListeners){
this.sizeListeners.removeListener(_1aa);
}
};
IlvEmptyView.prototype.fireSizeChanged=function(){
if(this.sizeListeners){
this.sizeListeners.notify(this);
}
};
IlvEmptyView.prototype.childrenToHTML=function(_1ab){
this.parentNode=_1ab;
};
IlvEmptyView.prototype.toHTML=function(_1ac){
if(this.inHTML){
return;
}
this.childrenToHTML(_1ac);
this.inHTML=true;
};
IlvEmptyView.prototype.setStateInCookie=function(_1ad){
this.stateInCookie=_1ad;
};
IlvEmptyView.prototype.isStateInCookie=function(){
return this.stateInCookie;
};
IlvEmptyView.prototype.saveState=function(view){
};
IlvEmptyView.prototype.restoreState=function(view){
};
IlvEmptyView.prototype.saveSizeToCookie=function(_1b0){
if(this.isStateInCookie()){
IlvUtil.setCookie(this.cookieName+":width",this.getWidth(),_1b0);
IlvUtil.setCookie(this.cookieName+":height",this.getHeight(),_1b0);
}
};
IlvEmptyView.prototype.readSizeFromCookie=function(){
var size={};
var _1b2=IlvUtil.getCookie(this.cookieName+":width");
if(_1b2){
size.width=parseInt(_1b2);
}else{
size.width=this.getWidth();
}
_1b2=IlvUtil.getCookie(this.cookieName+":height");
if(_1b2){
size.height=parseInt(_1b2);
}else{
size.height=this.getHeight();
}
return size;
};
IlvImageView=function(left,top,_1b5,_1b6,_1b7){
this.superConstructor(left,top,_1b5,_1b6);
this.imageSrc=_1b7;
if(this.imageSrc){
this.imageSrc=this.imageSrc.replace(/&amp;/g,"&");
}
this.imageState=IlvImageView.NOT_LOADED;
this.cursor="auto";
this.visible=true;
this.tooltip="";
this.imageWidth=-1;
this.imageHeight=-1;
this.scrollX=0;
this.scrollY=0;
this.imageID=this.toString()+"IMG";
this.blendTransform=true;
this.imageScrollListeners=new IlvListenerList();
this.imageLoadingListeners=new IlvListenerList();
this.imagePreloadListeners=new IlvListenerList();
this.imageLoadListeners=new IlvListenerList();
this.errorListeners=new IlvListenerList();
this.timeoutListeners=new IlvListenerList();
this.timeout=600;
this.registerDispose();
};
if(!window.IlvEmptyView){
alert(jviews.messages.IlvImageView.requiresIlvEmptyView);
}
IlvImageView.prototype=new IlvEmptyView();
IlvImageView.prototype.setClassName("IlvImageView");
IlvImageView.NOT_LOADED=0;
IlvImageView.LOADING=1;
IlvImageView.LOADED=2;
IlvImageView.ERROR=3;
IlvImageView.prototype.dispose=function(){
this.imageScrollListeners.dispose();
this.imageLoadingListeners.dispose();
this.imagePreloadListeners.dispose();
this.imageLoadListeners.dispose();
this.errorListeners.dispose();
this.timeoutListeners.dispose();
this.abortImage();
var _1b8=getImage(this.imageID);
if(_1b8){
IlvUtil.disposeImageSource(_1b8);
}
if(this.offscreen){
this.offscreen.view=null;
this.offscreen.onload=empty;
this.offscreen.onabort=empty;
this.offscreen.onerror=empty;
this.offscreen=null;
}
if(this.imagePanel){
this.imagePanel.dispose();
}
this.imageSrc=null;
this.view=null;
this.superInvoke("dispose");
};
IlvImageView.prototype.removeHTML=function(){
this.imagePanel.removeHTML();
};
IlvImageView.prototype.updateVisibility=function(){
this.imagePanel.updateVisibility();
};
IlvImageView.prototype.getToolTipText=function(){
return this.tooltip;
};
IlvImageView.prototype.setToolTipText=function(_1b9){
this.tooltip=_1b9||"";
if(this.imagePanel){
var _1ba=getImage(this.imageID);
_1ba.title=_1b9;
}
};
IlvImageView.prototype.isVisible=function(){
return this.visible;
};
IlvImageView.prototype.setVisible=function(_1bb){
this.visible=_1bb;
if(this.imagePanel){
if(!_1bb||this.isImageLoaded()){
this.imagePanel.setVisible(_1bb);
}
}
};
IlvImageView.prototype.getCursor=function(){
return this.cursor;
};
IlvImageView.prototype.setCursor=function(_1bc){
this.cursor=_1bc;
if(this.imagePanel){
this.imagePanel.setCursor(_1bc);
}
};
IlvImageView.prototype.setBackgroundColor=function(_1bd){
this.bgColor=_1bd;
if(this.imagePanel){
this.imagePanel.setBackgroundColor(_1bd);
}
};
IlvImageView.prototype.setImageState=function(_1be){
if(this.imageState==_1be){
return;
}
this.imageState=_1be;
if(_1be==IlvImageView.LOADING){
this.imageLoadingListeners.notify(this);
}
};
IlvImageView.prototype.isImageLoaded=function(){
return this.imageState==IlvImageView.LOADED;
};
IlvImageView.prototype.setChildrenBounds=function(left,top,_1c1,_1c2){
this.superInvoke("setChildrenBounds",left,top,_1c1,_1c2);
var _1c3=this.imagePanel;
if(_1c3){
if(this._resized){
_1c3.setBounds(left,top,_1c1,_1c2);
if(this.imageWidth<0||this.imageHeight<0){
this.updateImagePanelContent();
}
}else{
_1c3.setLocation(left,top);
}
}
};
IlvImageView.prototype.childrenToHTML=function(_1c4){
this.imagePanel=new IlvHTMLPanel(this.getHTMLContent(),_1c4);
this.imagePanel.setBounds(this.left,this.top,this.width,this.height);
if(this.scrollX!=0||this.scrollY!=0){
this.imagePanel.setScrollPosition(this.scrollX,this.scrollY);
}
this.imagePanel.setCursor(this.getCursor());
if(this.bgColor){
this.imagePanel.setBackgroundColor(this.bgColor);
}
if(this.imageSrc){
this.loadImage();
}
};
IlvImageView.prototype.getHTMLContent=function(){
var div="<div style=\"position:relative; left:"+this.imageLeft+"px; top:"+this.imageTop+"px;\">";
var _1c6="<img style=\"-webkit-user-drag:none\" align=\"top\" border=\"0\" "+"id=\""+this.imageID+"\" "+"name=\""+this.imageID+"\" "+"galleryimg=\"false\" ";
var w=this.imageWidth>=0?this.imageWidth:this.getWidth();
var h=this.imageHeight>=0?this.imageHeight:this.getHeight();
_1c6+="width=\""+w+"\" height=\""+h+"\" ";
_1c6+="src=\""+IlvConstants.ilvImagePath+jviews.messages.IlvUtil.emptyIcon+"\" ";
if(this.tooltip!=""){
_1c6+=" title=\""+this.tooltip+"\" ";
}
_1c6+="/>";
if(this.imageLeft){
return div+_1c6+"</div>";
}
return _1c6;
};
IlvImageView.prototype.updateImagePanelContent=function(_1c9){
if(!this.imagePanel){
return;
}
this.setImageState(this.imageSrc?IlvImageView.LOADING:IlvImageView.NOT_LOADED);
if(this.imageSrc&&!_1c9){
var v=this;
var _1cb=function(p){
v.loadImage();
};
}
this.imagePanel.setContent(null,_1cb);
};
IlvImageView.prototype.getImage=function(){
return this.imageSrc;
};
IlvImageView.prototype.setImage=function(_1cd,_1ce,_1cf){
var _1d0=(_1ce!=null&&_1cf!=null);
var _1d1=_1cd?_1cd.replace(/&amp;/g,"&"):"";
if(_1d0){
this.imageSrc=_1d1;
this.setImageSize(_1ce,_1cf,false);
}else{
if(_1d1!=this.imageSrc){
this.imageSrc=_1d1;
if(_1cd&&this.inHTML){
this.loadImage();
}
}
}
};
IlvImageView.prototype.getImageSize=function(){
return {width:this.imageWidth>=0?this.imageWidth:this.getWidth(),height:this.imageHeight>=0?this.imageHeight:this.getHeight()};
};
IlvImageView.prototype.setImageSize=function(_1d2,_1d3,_1d4,left,top){
this.imageWidth=_1d2;
this.imageHeight=_1d3;
this.imageLeft=left?left:null;
this.imageTop=top?top:null;
this.updateImagePanelContent(_1d4);
};
IlvImageView.prototype.getBlendTransform=function(){
return this.blendTransform;
};
IlvImageView.prototype.setBlendTransform=function(set){
this.blendTransform=set;
};
IlvImageView.prototype.getScrollPosition=function(){
return {x:this.scrollX,y:this.scrollY};
};
IlvImageView.prototype.setScrollPosition=function(x,y){
if(this.scrollX!=x||this.scrollY!=y){
this.scrollX=x;
this.scrollY=y;
if(this.imagePanel){
this.imagePanel.setScrollPosition(x,y);
}
this.imageScrollListeners.notify(this);
}
};
IlvImageView.prototype.addScrollListener=function(_1da){
this.imageScrollListeners.addListener(_1da);
};
IlvImageView.prototype.removeScrollListener=function(_1db){
this.imageScrollListeners.removeListener(_1db);
};
IlvImageView.prototype.loadImage=function(){
this.abortImage();
this.setImageState(IlvImageView.LOADING);
var _1dc=new Image();
this.offscreen=_1dc;
_1dc.view=this;
_1dc.onload=IlvImageView.offscreenLoadListener;
_1dc.onabort=IlvImageView.offscreenAbortListener;
_1dc.onerror=IlvImageView.offscreenErrorListener;
this.startErrorTimer();
_1dc.src=this.imageSrc;
};
IlvImageView.offscreenLoadListener=function(){
var view=this.view;
if(!view){
return;
}
view.stopErrorTimer();
view.imagePreloadListeners.notify(view);
if(view.blendTransform&&IlvBrowserInfo.instance.ie5up){
var _1de=view.imagePanel.getMouseEventSource();
if(typeof (_1de)!="undefined"){
_1de.style.filter="blendTrans(duration=.4)";
if(_1de.filters&&_1de.filters.blendTrans.status!=2){
_1de.filters.blendTrans.apply();
if(!IlvPanel.visibilityLock){
_1de.style.visibility="inherit";
}
_1de.filters.blendTrans.play();
}
}
}
var dim=view.getImageSize();
replaceImage(view.imageID,this,true,dim.width,dim.height);
if(view.isVisible()){
view.imagePanel.setVisible(true);
}
this.onabort=null;
this.onerror=null;
this.onload=null;
view.setImageState(IlvImageView.LOADED);
view.imageLoadListeners.notify(view);
if(view.offscreen==this){
view.offscreen=null;
}
this.view=null;
};
IlvImageView.offscreenAbortListener=function(){
var view=this.view;
if(!view){
return;
}
view.stopErrorTimer();
view.setImageState(IlvImageView.ERROR);
IlvUtil.disposeImageSource(this);
view.errorListeners.notify(view);
if(view.offscreen==this){
view.offscreen=null;
}
this.view=null;
};
IlvImageView.offscreenErrorListener=function(){
var view=this.view;
if(!view){
return;
}
view.stopErrorTimer();
view.setImageState(IlvImageView.ERROR);
IlvUtil.disposeImageSource(this);
view.errorListeners.notify(view);
if(view.offscreen==this){
view.offscreen=null;
}
this.view=null;
};
IlvImageView.prototype.abortImage=function(){
var _1e2=this.offscreen;
if(!_1e2){
return;
}
this.offscreen=null;
this.stopErrorTimer();
IlvUtil.disposeImageSource(_1e2);
_1e2.view=null;
this.setImageState(IlvImageView.NOT_LOADED);
};
IlvImageView.prototype.addImageLoadingListener=function(_1e3){
this.imageLoadingListeners.addListener(_1e3);
};
IlvImageView.prototype.removeImageLoadingListener=function(_1e4){
this.imageLoadingListeners.removeListener(_1e4);
};
IlvImageView.prototype.addImagePreloadListener=function(_1e5){
this.imagePreloadListeners.addListener(_1e5);
};
IlvImageView.prototype.removeImagePreloadListener=function(_1e6){
this.imagePreloadListeners.removeListener(_1e6);
};
IlvImageView.prototype.addImageLoadListener=function(_1e7){
this.imageLoadListeners.addListener(_1e7);
};
IlvImageView.prototype.removeImageLoadListener=function(_1e8){
this.imageLoadListeners.removeListener(_1e8);
};
IlvImageView.prototype.setTimeoutInterval=function(_1e9){
this.timeout=_1e9;
};
IlvImageView.prototype.getTimeoutInterval=function(){
return this.timeout;
};
IlvImageView.prototype.startErrorTimer=function(){
this.stopErrorTimer();
var v=this;
var f=function(){
v.onTimeout(v);
};
this.errorInterval=window.setTimeout(f,this.timeout*1000);
};
IlvImageView.prototype.stopErrorTimer=function(){
var _1ec=this.errorInterval;
this.errorInterval=null;
if(_1ec){
window.clearTimeout(_1ec);
}
};
IlvImageView.prototype.onTimeout=function(view){
if(view!=null){
view.setImageState(IlvImageView.ERROR);
view.timeoutListeners.notify(view);
}
};
IlvImageView.prototype.addTimeoutErrorListener=function(_1ee){
this.timeoutListeners.addListener(_1ee);
};
IlvImageView.prototype.removeTimeoutErrorListener=function(_1ef){
this.timeoutListeners.removeListener(_1ef);
};
IlvImageView.prototype.addErrorListener=function(_1f0){
this.errorListeners.addListener(_1f0);
};
IlvImageView.prototype.removeErrorListener=function(_1f1){
this.errorsListeners.removeListener(_1f1);
};
IlvImageEventView=function(left,top,_1f4,_1f5,_1f6){
this.superConstructor(left,top,_1f4,_1f5,_1f6);
this.glassView=new IlvGlassView(left,top,_1f4,_1f5);
this.glassView.imageView=this;
this.glassView.getEventOriginLeft=function(){
return this.imageView.getEventOriginLeft();
};
this.glassView.getEventOriginTop=function(){
return this.imageView.getEventOriginTop();
};
};
IlvImageEventView.prototype=new IlvImageView();
IlvImageEventView.prototype.setClassName("IlvImageEventView");
IlvImageEventView.prototype.removeHTML=function(){
this.superInvoke("removeHTML");
this.glassView.removeHTML();
};
IlvImageEventView.prototype.dispose=function(){
this.superInvoke("dispose");
if(this.glassView){
this.glassView.imageView=null;
this.glassView.dispose();
}
};
IlvImageEventView.prototype.setCursor=function(_1f7){
this.superInvoke("setCursor",_1f7);
this.glassView.setCursor(_1f7);
};
IlvImageEventView.prototype.setVisible=function(_1f8){
this.superInvoke("setVisible",_1f8);
this.glassView.setVisible(_1f8);
};
IlvImageEventView.prototype.setToolTipText=function(_1f9){
this.superInvoke("setToolTipText",_1f9);
this.glassView.setToolTipText(this.tooltip);
};
IlvImageEventView.prototype.isEnabled=function(){
return this.glassView.isEnabled();
};
IlvImageEventView.prototype.setEnabled=function(_1fa){
this.glassView.setEnabled(_1fa);
};
IlvImageEventView.prototype.setTabIndex=function(_1fb){
this.glassView.setTabIndex(_1fb);
};
IlvImageEventView.prototype.getEventHandler=function(){
return this.glassView.getEventHandler();
};
IlvImageEventView.prototype.setEventHandler=function(_1fc){
this.glassView.setEventHandler(_1fc);
};
IlvImageEventView.prototype.getEventOriginLeft=function(){
return this.left;
};
IlvImageEventView.prototype.getEventOriginTop=function(){
return this.top;
};
IlvImageEventView.prototype.setChildrenBounds=function(left,top,_1ff,_200){
this.superInvoke("setChildrenBounds",left,top,_1ff,_200);
this.glassView.setBounds(left,top,_1ff,_200);
};
IlvImageEventView.prototype.childrenToHTML=function(_201){
this.superInvoke("childrenToHTML",_201);
this.glassView.setVisible(this.isVisible());
this.glassView.toHTML(_201);
};
IlvImageEventView.prototype.updateVisibility=function(){
this.superInvoke("updateVisibility");
this.glassView.updateVisibility();
};
IlvImageEventView.prototype.removeHTML=function(){
this.superInvoke("removeHTML");
this.glassView.removeHTML();
};
IlvGlassView=function(left,top,_204,_205){
this.superConstructor(left,top,_204,_205);
this.visible=true;
this.enabled=true;
this.cursor="auto";
this.tooltip="";
this.tabindex=-1;
this.registerDispose();
};
if(!window.IlvEmptyView){
alert(jviews.messages.IlvGlassView.requiresIlvEmptyView);
}
IlvGlassView.prototype=new IlvEmptyView;
IlvGlassView.prototype.setClassName("IlvGlassView");
IlvGlassView.prototype.removeHTML=function(){
if(this.eventPanel){
this.eventPanel.removeHTML();
}
};
IlvGlassView.prototype.updateVisibility=function(){
if(this.eventPanel){
this.eventPanel.updateVisibility();
}
};
IlvGlassView.prototype.dispose=function(){
var _206=this.getMouseEventSource();
this.superInvoke("dispose");
if(_206!=null){
if(_206.removeEventListener){
_206.removeEventListener("keypress",IlvGlassView.prototype._keyPress,true);
_206.removeEventListener("keyup",IlvGlassView.prototype._keyUp,true);
_206.removeEventListener("keydown",IlvGlassView.prototype._keyDown,true);
if(!IlvBrowserInfo.instance.android&&!IlvBrowserInfo.instance.ios){
_206.removeEventListener("dragstart",IlvGlassView.prototype._dragStart,true);
_206.removeEventListener("mousedown",IlvGlassView.prototype._mouseDown,true);
_206.removeEventListener("mousemove",IlvGlassView.prototype._mouseMove,true);
_206.removeEventListener("mouseover",IlvGlassView.prototype._mouseOver,true);
_206.removeEventListener("mouseout",IlvGlassView.prototype._mouseOut,true);
_206.removeEventListener("DOMMouseScroll",IlvGlassView.prototype._mouseWheel,true);
}
_206.removeEventListener("touchstart",IlvGlassView.prototype._touchStart,true);
_206.removeEventListener("touchcancel",IlvGlassView.prototype._touchCancel,true);
_206.removeEventListener("gesturestart",IlvGlassView.prototype._gestureStart,true);
}else{
_206.onkeypress=null;
_206.onkeyup=null;
_206.onkeydown=null;
_206.ondragstart=null;
_206.onmousedown=null;
_206.onmousemove=null;
_206.onmouseover=null;
_206.onmouseout=null;
_206.onmousewheel=null;
_206.ontouchstart=null;
_206.ontouchcancel=null;
_206.gesturestart=null;
}
_206._view=null;
}
if(this.eventPanel){
this.eventPanel.dispose();
}
};
IlvGlassView.prototype.getToolTipText=function(){
return this.tooltip;
};
IlvGlassView.prototype.setToolTipText=function(_207){
this.tooltip=_207||"";
if(!this.content){
this.updateEventPanelContent();
}
};
IlvGlassView.prototype.isVisible=function(){
return this.visible;
};
IlvGlassView.prototype.setVisible=function(_208){
if(this.visible==_208){
return;
}
this.visible=_208;
if(this.eventPanel){
this.eventPanel.setVisible(_208);
}
};
IlvGlassView.prototype.isEnabled=function(){
return this.enabled;
};
IlvGlassView.prototype.setEnabled=function(_209){
this.enabled=_209;
};
IlvGlassView.prototype.getCursor=function(){
return this.cursor;
};
IlvGlassView.prototype.setCursor=function(_20a){
this.cursor=_20a;
if(this.eventPanel){
this.eventPanel.setCursor(_20a);
}
};
IlvGlassView.prototype.setZIndex=function(_20b){
if(this.eventPanel){
this.eventPanel.setZIndex(_20b);
}
};
IlvGlassView.prototype.setTabIndex=function(_20c){
this.tabindex=_20c;
};
IlvGlassView.prototype.setBackgroundColor=function(_20d){
this.bgColor=_20d;
if(this.eventPanel){
this.eventPanel.setBackgroundColor(_20d);
}
};
IlvGlassView.prototype.setChildrenBounds=function(left,top,_210,_211){
this.superInvoke("setChildrenBounds",left,top,_210,_211);
var _212=this.eventPanel;
if(_212){
if(this._resized){
_212.setBounds(left,top,_210,_211);
this.updateEventPanelContent();
}else{
_212.setLocation(left,top);
}
}
};
IlvGlassView.prototype.getHTMLId=function(){
return this.eventPanel.toString();
};
IlvGlassView.prototype.setContent=function(_213,_214){
this.content=_213;
this.updateEventPanelContent(_214);
};
IlvGlassView.prototype.getContent=function(){
if(this.content){
return this.content;
}
var _215="<img style=\"-webkit-user-drag:none\" align=\"top\" border=\"0\" "+"width=\""+this.getWidth()+"\" "+"height=\""+this.getHeight()+"\" "+"src=\""+IlvConstants.ilvImagePath+jviews.messages.IlvUtil.emptyIcon+"\" "+"galleryimg=\"false\" ";
if(this.tooltip!=""){
_215+="alt=\""+this.tooltip+"\" title=\""+this.tooltip+"\" ";
}
_215+="/>";
return _215;
};
IlvGlassView.prototype.updateEventPanelContent=function(_216){
if(this.eventPanel){
this.eventPanel.setContent(this.getContent(),_216);
}else{
if(_216){
eval(_216);
}
}
};
IlvGlassView.prototype.childrenToHTML=function(_217){
this.superInvoke("childrenToHTML",_217);
this.eventPanel=new IlvHTMLPanel(this.getContent(),_217);
this.eventPanel.getMouseEventSource().tabIndex=this.tabindex;
this.eventPanel.setZIndex(4);
this.eventPanel.setBounds(this.left,this.top,this.width,this.height);
this.eventPanel.setVisible(this.isVisible());
this.eventPanel.setCursor(this.getCursor());
if(this.bgColor){
this.eventPanel.setBackgroundColor(this.bgColor);
}
this.enableEventCapture();
};
IlvGlassView.prototype.enableEventCapture=function(){
var _218=this.getMouseEventSource();
_218._view=this;
if(_218.addEventListener){
_218.addEventListener("keypress",IlvGlassView.prototype._keyPress,true);
_218.addEventListener("keyup",IlvGlassView.prototype._keyUp,true);
_218.addEventListener("keydown",IlvGlassView.prototype._keyDown,true);
if(!IlvBrowserInfo.instance.android&&!IlvBrowserInfo.instance.ios){
_218.addEventListener("dragstart",IlvGlassView.prototype._dragStart,true);
_218.addEventListener("mousedown",IlvGlassView.prototype._mouseDown,true);
_218.addEventListener("mousemove",IlvGlassView.prototype._mouseMove,true);
_218.addEventListener("mouseover",IlvGlassView.prototype._mouseOver,true);
_218.addEventListener("mouseout",IlvGlassView.prototype._mouseOut,true);
_218.addEventListener("draggesture",IlvGlassView.prototype._dummy,false);
_218.addEventListener("dragover",IlvGlassView.prototype._dummy,false);
_218.addEventListener("dragenter",IlvGlassView.prototype._dummy,false);
_218.addEventListener("dragexit",IlvGlassView.prototype._dummy,false);
_218.addEventListener("DOMMouseScroll",IlvGlassView.prototype._mouseWheel,true);
_218.addEventListener("mousewheel",IlvGlassView.prototype._mouseWheel,true);
}
_218.addEventListener("touchstart",IlvGlassView.prototype._touchStart,true);
_218.addEventListener("touchcancel",IlvGlassView.prototype._touchCancel,true);
_218.addEventListener("gesturestart",IlvGlassView.prototype._gestureStart,true);
}else{
_218.onkeypress=IlvGlassView.prototype._keyPress;
_218.onkeyup=IlvGlassView.prototype._keyUp;
_218.onkeydown=IlvGlassView.prototype._keyDown;
if(!IlvBrowserInfo.instance.android&&!IlvBrowserInfo.instance.ios){
_218.ondragstart=IlvGlassView.prototype._dragStart;
_218.onmousedown=IlvGlassView.prototype._mouseDown;
_218.onmousemove=IlvGlassView.prototype._mouseMove;
_218.onmouseover=IlvGlassView.prototype._mouseOver;
_218.onmouseout=IlvGlassView.prototype._mouseOut;
_218.onmousewheel=IlvGlassView.prototype._mouseWheel;
}
_218.ontouchstart=IlvGlassView.prototype._touchStart;
_218.ontouchcancel=IlvGlassView.prototype._touchCancel;
_218.ongesturestart=IlvGlassView.prototype._gestureStart;
}
};
IlvGlassView.prototype.disableEventCapture=function(){
var _219=this.getMouseEventSource();
if(_219.removeEventListener){
_219.removeEventListener("keypress",IlvGlassView.prototype._keyPress,true);
_219.removeEventListener("keyup",IlvGlassView.prototype._keyUp,true);
_219.removeEventListener("keydown",IlvGlassView.prototype._keyDown,true);
if(!IlvBrowserInfo.instance.android&&!IlvBrowserInfo.instance.ios){
_219.removeEventListener("dragStart",IlvGlassView.prototype._dragStart,true);
_219.removeEventListener("mousedown",IlvGlassView.prototype._mouseDown,true);
_219.removeEventListener("mousemove",IlvGlassView.prototype._mouseMove,true);
_219.removeEventListener("mouseover",IlvGlassView.prototype._mouseOver,true);
_219.removeEventListener("mouseout",IlvGlassView.prototype._mouseOut,true);
_219.removeEventListener("DOMMouseScroll",IlvGlassView.prototype._mouseWheel,true);
}
_219.removeEventListener("touchstart",IlvGlassView.prototype._touchStart,true);
_219.removeEventListener("touchcancel",IlvGlassView.prototype._touchCancel,true);
_219.removeEventListener("gesturestart",IlvGlassView.prototype._gestureStart,true);
}else{
_219.onkeypress=null;
_219.onkeyup=null;
_219.onkeydown=null;
_219.ondragstart=null;
_219.onmousedown=null;
_219.onmousemove=null;
_219.onmouseover=null;
_219.onmouseout=null;
_219.onmousewheel=null;
_219.ontouchstart=null;
_219.ontouchcancel=null;
_219.ongesturestart=null;
}
_219._view=null;
};
IlvGlassView.prototype._dummy=function(_21a){
if(_21a&&_21a.stopPropagation){
_21a.stopPropagation();
}
return false;
};
IlvGlassView.prototype.getEventOriginLeft=function(){
return this.left;
};
IlvGlassView.prototype.getEventOriginTop=function(){
return this.top;
};
IlvGlassView.prototype.setEventHandler=function(_21b){
this.eventHandler=_21b;
};
IlvGlassView.prototype.getEventHandler=function(){
return this.eventHandler;
};
IlvGlassView.prototype.getMouseEventSource=function(){
if(this.eventPanel){
return this.eventPanel.getMouseEventSource();
}else{
return null;
}
};
IlvGlassView.prototype.setReferenceNode=function(node){
if(node){
this.relativePosition=true;
this.refNode=node;
}else{
this.relativePosition=false;
this.refNode="";
}
};
IlvGlassView.prototype.getNodeCoords=function(node){
var _21e=node.ownerDocument;
var ret={x:0,y:0};
var db=document.body||document.getElementsByTagName("body")[0];
if(node["getBoundingClientRect"]){
var _221=node.getBoundingClientRect();
ret.x=_221.left;
ret.y=_221.top;
if(IlvBrowserInfo.instance.isIE){
var _222=IlvUtil.getIeDocumentOffset();
ret.x-=_222.x+(IlvBrowserInfo.instance.isQuirks?db.clientLeft+db.offsetLeft:0);
ret.y-=_222.y+(IlvBrowserInfo.instance.isQuirks?db.clientTop+db.offsetTop:0);
}else{
var dv=node.ownerDocument.defaultView;
var cs=dv.getComputedStyle(db.parentNode,null);
var x=IlvUtil._toPixelValue(db.parentNode,cs.marginLeft),y=IlvUtil._toPixelValue(db.parentNode,cs.marginTop);
ret.x-=x;
ret.y-=y;
}
}else{
if(node["offsetParent"]){
var _227;
if(IlvBrowserInfo.instance.isSafari&&((IlvUtil.getCS(node).position=="absolute"))&&(node.parentNode==db)){
_227=db;
}else{
_227=db.parentNode;
}
var cs=IlvUtil.getCS(node);
var n=node;
if(IlvBrowserInfo.instance.isIE){
ret.x-=document.body.scrollLeft;
ret.y-=document.body.scrollTop;
}else{
ret.x-=window.pageXOffset;
ret.y-=window.pageYOffset;
}
var _229=node;
do{
var n=_229.offsetLeft;
if(n>0){
ret.x+=isNaN(n)?0:n;
}
var t=_229.offsetTop;
ret.y+=isNaN(t)?0:t;
var cs=IlvUtil.getCS(_229);
if(_229!=node){
if(IlvBrowserInfo.instance.isSafari){
ret.x+=IlvUtil._toPixelValue(_229,cs.borderLeftWidth);
ret.y+=IlvUtil._toPixelValue(_229,cs.borderTopWidth);
}else{
if(d.isFF){
ret.x+=2*IlvUtil._toPixelValue(_229,cs.borderLeftWidth);
ret.y+=2*IlvUtil._toPixelValue(_229,cs.borderTopWidth);
}
}
}
if(IlvBrowserInfo.instance.moz17up&&cs.position=="static"){
var _22b=_229.parentNode;
while(_22b!=_229.offsetParent){
var pcs=IlvUtil.getCS(_22b);
if(pcs.position=="static"){
ret.x+=IlvUtil._toPixelValue(_229,pcs.borderLeftWidth);
ret.y+=IlvUtil._toPixelValue(_229,pcs.borderTopWidth);
}
_22b=_22b.parentNode;
}
}
_229=_229.offsetParent;
}while((_229!=_227)&&_229);
}else{
if(node.x&&node.y){
ret.x+=isNaN(node.x)?0:node.x;
ret.y+=isNaN(node.y)?0:node.y;
}
}
}
if(node.offsetParent){
var _22d=IlvUtil._docScroll();
ret.x+=_22d.x;
ret.y+=_22d.y;
}
return ret;
};
IlvGlassView.prototype.enhanceEvent=function(e,_22f){
var _230;
var _231;
if(e){
_230=e.pageX;
_231=e.pageY;
if(_22f){
e=this.cloneEvent(e);
}
}else{
if(_22f){
e=this.cloneEvent(event);
}else{
e=event;
}
if(e.pageX==null&&e.clientX!=null){
var doc=document.documentElement,body=document.body;
e.pageX=event.clientX+(doc&&doc.scrollLeft||body&&body.scrollLeft||0)-(doc&&doc.clientLeft||body&&body.clientLeft||0);
e.pageY=event.clientY+(doc&&doc.scrollTop||body&&body.scrollTop||0)-(doc&&doc.clientTop||body&&body.clientTop||0);
}
_230=e.pageX;
_231=e.pageY;
}
_230-=this.getEventOriginLeft();
_231-=this.getEventOriginTop();
if(this.relativePosition){
var pos=this.getNodeCoords(this.refNode);
_230-=parseInt(pos.x);
_231-=parseInt(pos.y);
}
e.mouseX=_230;
e.mouseY=_231;
return e;
};
IlvGlassView.prototype.cloneEvent=function(e){
var _236=new Object();
_236.altKey=e.altKey;
_236.ctrlKey=e.ctrlKey;
_236.shiftKey=e.shiftKey;
_236.type=e.type;
_236.screenX=e.screenX;
_236.screenY=e.screenY;
_236.button=e.button;
_236.keyCode=e.keyCode;
_236.clientX=e.clientX;
_236.clientY=e.clientY;
return _236;
};
IlvGlassView.prototype._enhanceKeyEvent=function(e){
if(e){
if(typeof (e.keyCode)=="undefined"){
e.keyCode=e.which;
}else{
if(e.keyCode==0){
var _238={altKey:e.altKey,ctrlKey:e.ctrlKey,metaKey:e.metaKey,shiftKey:e.shiftKey,keyCode:e.charCode};
e=_238;
}
}
}else{
e=window.event;
}
return e;
};
IlvGlassView.prototype._keyPress=function(e){
var view=this._view;
if(view==null||!view.enabled){
return false;
}
var _23b=view.getEventHandler();
if(_23b==null){
return false;
}
var _23c=_23b.keyPress;
if(_23c&&typeof (_23c)=="function"){
e=view._enhanceKeyEvent(e);
_23b.keyPress(e);
}
if(e.keyCode==9){
if(IlvBrowserInfo.instance.ie){
return true;
}
}else{
if(e.preventDefault){
e.preventDefault();
}
}
return false;
};
IlvGlassView.prototype._keyUp=function(e){
var view=this._view;
if(view==null||!view.enabled){
return false;
}
var _23f=view.getEventHandler();
if(_23f==null){
return false;
}
var _240=_23f.keyUp;
if(_240&&typeof (_240)=="function"){
e=view._enhanceKeyEvent(e);
_23f.keyUp(e);
}
if(e.keyCode==9){
if(IlvBrowserInfo.instance.ie){
return true;
}
}else{
if(e.preventDefault){
e.preventDefault();
}
}
return false;
};
IlvGlassView.prototype._keyDown=function(e){
var view=this._view;
if(view==null||!view.enabled){
return false;
}
var _243=view.getEventHandler();
if(_243==null){
return false;
}
var _244=_243.keyDown;
if(_244&&typeof (_244)=="function"){
e=view._enhanceKeyEvent(e);
_243.keyDown(e);
}
if(e.keyCode==9){
if(IlvBrowserInfo.instance.ie){
return true;
}
}else{
if(e.preventDefault){
e.preventDefault();
}
}
return false;
};
IlvGlassView.prototype._dragStart=function(e){
var _246=IlvBrowserInfo.instance;
if((_246.moz19up||_246.ff4||_246.chrome||(_246.ie9up&&!_246.isQuirks)||_246.ie10up)&&e.preventDefault){
e.preventDefault();
}
};
IlvGlassView.prototype._mouseDown=function(e){
var view=this._view;
if(view==null||!view.enabled){
return false;
}
if(IlvBrowserInfo.instance.android&&!e.android_){
view._stopEvent(e);
return false;
}
view._dragging=true;
view._draggingButton=e?e.button:event.button;
document.IlvTmpView=view;
if(document.addEventListener){
document.addEventListener("mouseup",IlvGlassView.prototype._mouseUp,true);
document.addEventListener("mousemove",IlvGlassView.prototype._mouseMove,true);
}else{
if(document.onmouseup!=null){
view._oldmouseup=document.onmouseup;
}
if(document.onmousemove!=null){
view._oldmousemove=document.onmousemove;
}
document.onmouseup=IlvGlassView.prototype._mouseUp;
document.onmousemove=IlvGlassView.prototype._mouseMove;
}
var _249=view.getEventHandler();
if(_249==null){
return false;
}
var _24a=_249.mouseDown;
if(_24a&&typeof (_24a)=="function"){
_249.mouseDown(view.enhanceEvent(e));
}
return false;
};
IlvGlassView.prototype._mouseMove=function(e){
var view=this.IlvTmpView;
if(view==null){
view=this._view;
}
if(IlvBrowserInfo.instance.android&&!e.android_){
view._stopEvent(e);
return false;
}
if(view==null||!view.enabled){
return true;
}
var _24d=view.getEventHandler();
if(_24d==null){
return !view._dragging;
}
if(view._dragging){
var _24e=_24d.mouseDrag;
if(_24e&&typeof (_24e)=="function"){
var _24f=view.enhanceEvent(e,true);
_24f.button=view._draggingButton;
_24d.mouseDrag(_24f);
}
}else{
var _24e=_24d.mouseMove;
if(_24e&&typeof (_24e)=="function"){
_24d.mouseMove(view.enhanceEvent(e));
}
}
return !view._dragging;
};
IlvGlassView.prototype._mouseUp=function(e){
var view=this.IlvTmpView;
if(view==null){
return true;
}
if(IlvBrowserInfo.instance.android&&!e.android_){
view._stopEvent(e);
return false;
}
view._dragging=false;
if(this.addEventListener){
this.removeEventListener("mouseup",IlvGlassView.prototype._mouseUp,true);
this.removeEventListener("mousemove",IlvGlassView.prototype._mouseMove,true);
}else{
if(view._oldmouseup){
this.onmouseup=view._oldmouseup;
}
if(view._oldmousemove){
this.onmousemove=view._oldmousemove;
}
}
document.IlvTmpView=null;
if(!view.enabled){
return false;
}
var _252=view.getEventHandler();
if(_252==null){
return false;
}
var _253=_252.mouseUp;
if(_253&&typeof (_253)=="function"){
_252.mouseUp(view.enhanceEvent(e));
}
return false;
};
IlvGlassView.prototype._mouseOver=function(e){
var view=this._view;
if(view==null||!view.enabled){
return;
}
if(IlvBrowserInfo.instance.android&&!e.android_){
view._stopEvent(e);
return false;
}
var _256=view.getEventHandler();
if(_256==null){
return;
}
var _257=_256.mouseOver;
if(_257&&typeof (_257)=="function"){
_256.mouseOver(view.enhanceEvent(e));
}
return false;
};
IlvGlassView.prototype._mouseOut=function(e){
var view=this._view;
if(view==null||!view.enabled){
return;
}
if(IlvBrowserInfo.instance.android&&!e.android_){
view._stopEvent(e);
return false;
}
var _25a=view.getEventHandler();
if(_25a==null){
return false;
}
var _25b=_25a.mouseOut;
if(_25b&&typeof (_25b)=="function"){
_25a.mouseOut(view.enhanceEvent(e));
}
return false;
};
IlvGlassView.prototype._mouseWheel=function(e){
var view=this._view;
if(view==null||!view.enabled){
return;
}
var _25e=view.getEventHandler();
if(_25e==null){
return false;
}
if(!e){
e=window.event;
}
if(e.wheelDelta){
delta=e.wheelDelta/120;
}else{
if(e.detail){
delta=-e.detail;
}
}
if(delta){
var _25f={wheelDelta:delta};
var _260=_25e.mouseWheel;
if(_260&&typeof (_260)=="function"){
_25e.mouseWheel(_25f);
if(e.preventDefault){
e.preventDefault();
}
}
}
return false;
};
IlvGlassView.prototype._stopEvent=function(e){
e.preventDefault&&e.preventDefault();
e.stopPropagation&&e.stopPropagation();
e.cancelBubble=true;
e.returnValue=false;
};
IlvGlassView.prototype._touchStart=function(e){
var view=this._view;
if(null==view||!view.enabled){
return false;
}
e=e||window.event;
view._stopEvent(e);
view.storeTouchContext(e);
if(1==view.touchctx.touchCount){
if(this.addEventListener){
this.addEventListener("touchend",IlvGlassView.prototype._touchEnd,true);
this.addEventListener("touchmove",IlvGlassView.prototype._touchMove,true);
}else{
if(document.onmouseup!=null){
view._oldmouseup=document.onmouseup;
}
if(document.onmousemove!=null){
view._oldmousemove=document.onmousemove;
}
document.ontouchend=IlvGlassView.prototype._touchEnd;
document.ontouchmove=IlvGlassView.prototype._touchMove;
}
view.convertTouchEvent(e,"mouseover");
view.convertTouchEvent(e,"mousedown");
}
return false;
};
IlvGlassView.prototype._touchMove=function(e){
var view=this._view;
if(null==view||!view.enabled){
return false;
}
e=e||window.event;
view._stopEvent(e);
view.recordTouchMove(e);
if(!view.touchctx.isGesture&&view.hasMoved()){
view.convertTouchEvent(e,"mousemove");
}
return false;
};
IlvGlassView.prototype._touchEnd=function(e){
var view=this._view;
if(null==view||!view.enabled){
return false;
}
e=e||window.event;
view._stopEvent(e);
view.touchctx.touchCount-=Math.min(view.touchctx.touchCount,e.changedTouches.length);
if(0==view.touchctx.touchCount){
if(view.touchctx.isGesture){
view.touchctx.isGesture=false;
var _268=view.getEventHandler().JSFRef;
if(view.touchctx.interactor&&_268&&_268.setInteractor){
_268.setInteractor(view.touchctx.interactor);
view.touchctx.interactor=null;
}
}else{
if(this.addEventListener){
this.removeEventListener("touchend",IlvGlassView.prototype._touchEnd,true);
this.removeEventListener("touchmove",IlvGlassView.prototype._touchMove,true);
}else{
if(view._oldmouseup){
this.onmouseup=view._oldmouseup;
}
if(view._oldmousemove){
this.onmousemove=view._oldmousemove;
}
}
view.convertTouchEvent(e,"mouseup");
view.convertTouchEvent(e,"click");
view.convertTouchEvent(e,"mouseout");
}
view.clearTouchStart();
}
return false;
};
IlvGlassView.prototype._touchCancel=function(e){
var view=this._view;
if(null==view||!view.enabled){
return false;
}
e=e||window.event;
view._stopEvent(e);
if(view.touchctx.isGesture){
view._gestureEnd(e);
}
if(view.touchctx.touchCount){
view.convertTouchEvent(e,"mouseup");
view.convertTouchEvent(e,"mouseout");
}
view.convertTouchEvent(e,"abort");
view.clearTouchStart();
return false;
};
IlvGlassView.prototype._gestureStart=function(e){
var view=this._view;
if(null==view||!view.enabled){
return false;
}
e=e||window.event;
view._stopEvent(e);
if(view.touchctx){
if(view.touchctx.touchCount){
view.convertTouchEvent(e,"mouseup");
}
view.touchctx.isGesture=true;
var _26d=view.getEventHandler().JSFRef;
if(_26d&&_26d.getInteractor){
view.touchctx.interactor=_26d.getInteractor();
_26d.setInteractor(null);
}
if(this.addEventListener){
this.addEventListener("gestureend",IlvGlassView.prototype._gestureEnd,true);
this.addEventListener("gesturechange",IlvGlassView.prototype._gestureChange,true);
}
}
return false;
};
IlvGlassView.prototype._gestureEnd=function(e){
var view=this._view;
if(null==view||!view.enabled){
return false;
}
e=e||window.event;
view._stopEvent(e);
var _270=view.getEventHandler().JSFRef;
if(view.touchctx.isGesture&&_270&&view.isScale(e,_270)){
_270.zoomBy(e.scale);
_270.setInteractor(view.touchctx.interactor);
view.touchctx.interactor=null;
}
if(this.addEventListener){
this.removeEventListener("gestureend",IlvGlassView.prototype._gestureEnd,true);
this.removeEventListener("gesturechange",IlvGlassView.prototype._gestureChange,true);
}
return false;
};
IlvGlassView.prototype._gestureChange=function(e){
var view=this._view;
if(null==view||!view.enabled){
return false;
}
view._stopEvent(e);
var _273=view.getEventHandler().JSFRef;
if(view.touchctx.isGesture&&_273&&view.isScale(e,_273)){
_273.getPlaceHolder().style["-webkit-transform"]="scale("+e.scale+")";
}
};
IlvGlassView.prototype.convertTouchEvent=function(e,et){
var me=document.createEvent("MouseEvent"),ft=null;
if(e.changedTouches){
ft=e.changedTouches[0];
}else{
ft=e;
}
me.initMouseEvent(et,true,true,window,1,ft.screenX,ft.screenY,ft.clientX,ft.clientY,false,false,false,false,0,null);
me.android_=IlvBrowserInfo.instance.android;
switch(et){
case "mouseover":
this._mouseOver.call(this.eventPanel.getMouseEventSource(),me);
break;
case "mousedown":
this._mouseDown.call(this.eventPanel.getMouseEventSource(),me);
break;
case "mousemove":
this._mouseMove.call(document,me);
break;
case "mouseup":
this._mouseUp.call(document,me);
break;
case "mouseout":
this._mouseOut.call(this.eventPanel.getMouseEventSource(),me);
break;
default:
ft.target.dispatchEvent(me);
}
};
IlvGlassView.prototype.storeTouchContext=function(e){
if(!this.touchctx){
this.touchctx={startX:e.changedTouches[0].screenX,startY:e.changedTouches[0].screenY,lastX:e.changedTouches[0].screenX,lastY:e.changedTouches[0].screenY,isGesture:false,interactor:null,touchCount:1};
}else{
this.touchctx.touchCount+=1;
}
};
IlvGlassView.prototype.recordTouchMove=function(e){
this.touchctx.lastX=e.changedTouches[0].screenX;
this.touchctx.lastY=e.changedTouches[0].screenY;
};
IlvGlassView.prototype.clearTouchStart=function(){
delete this.touchctx.startX;
delete this.touchctx.startY;
delete this.touchctx.lastX;
delete this.touchctx.lastY;
delete this.touchctx.isGesture;
delete this.touchctx.touchcont;
delete this.touchctx.interactor;
delete this.touchctx;
};
IlvGlassView.prototype.hasMoved=function(){
return this.touchctx&&(Math.abs(this.touchctx.startX-this.touchctx.lastX)>5||Math.abs(this.touchctx.startY-this.touchctx.lastY)>5);
};
IlvGlassView.prototype.isScale=function(e,c){
return Math.abs(1-e.scale)>0.05&&c.getMaxZoomLevel&&c.getZoomFactor&&(e.scale<c.getMaxZoomLevel()||e.scale<1&&c.getZoomFactor()>1);
};
IlvResizableView=function(left,top,_27e,_27f,_280){
if(!window.IlvEmptyView){
alert(jviews.messages.IlvResizableView.requiresIlvEmptyView);
}
this.superConstructor(left,top,_27e,_27f,_280);
this.minimumHeight=100;
this.minimumWidth=100;
this.maximumWidth=4096;
this.maximumHeight=3072;
this.resizable=false;
this.accessible=false;
};
IlvResizableView.prototype=new IlvEmptyView();
IlvResizableView.prototype.setClassName("IlvResizableView");
IlvResizableView.prototype.dispose=function(){
this.superInvoke("dispose");
if(this.resizeTool){
this.resizeTool.dispose();
this.resizeTool=null;
}
};
IlvResizableView.prototype.removeHTML=function(){
this.superInvoke("removeHTML");
if(this.resizeTool){
this.resizeTool.removeHTML();
}
};
IlvResizableView.prototype.updateVisibility=function(){
this.superInvoke("updateVisibility");
if(this.resizeTool){
this.resizeTool.updateVisibility();
}
};
IlvResizableView.prototype.setChildrenBounds=function(left,top,_283,_284){
this.superInvoke("setChildrenBounds",left,top,_283,_284);
if(this.resizeTool){
this.resizeTool.setBounds(left,top,_283,_284);
}
};
IlvResizableView.prototype.setResizable=function(set){
this.resizable=set;
if(this.resizeTool){
this.resizeTool.setVisible(set);
}
};
IlvResizableView.prototype.isResizable=function(set){
return this.resizable;
};
IlvResizableView.prototype.isResizeable=IlvResizableView.prototype.isResizable;
IlvResizableView.prototype.setResizeable=IlvResizableView.prototype.setResizable;
IlvResizableView.prototype.setMaximumSize=function(_287,_288){
this.maximumWidth=_287;
this.maximumHeight=_288;
};
IlvResizableView.prototype.getMaximumSize=function(){
return {width:this.maximumWidth,height:this.maximumHeight};
};
IlvResizableView.prototype.setMinimumSize=function(_289,_28a){
this.minimumWidth=_289;
this.minimumHeight=_28a;
};
IlvResizableView.prototype.getMinimumSize=function(){
return {width:this.minimumWidth,height:this.minimumHeight};
};
IlvResizableView.prototype.setHotkeys=function(_28b){
if(_28b){
if(_28b.length>0){
try{
var _28b=eval("("+_28b+")");
}
catch(err){
return;
}
}
if(typeof (_28b)=="object"){
var _28c=this.hotkeys;
for(p in _28c){
for(q in _28b){
if(p==q){
if(_28b[q].hotkey){
_28c[p].hotkey=_28b[q].hotkey;
}
if(_28b[q].filter){
for(w in _28b[q].filter){
if(_28b[q].filter[w]!=_28c[p].filter[w]){
_28c[p].filter[w]=_28b[q].filter[w];
}
}
}
break;
}
}
}
}
}
};
IlvResizableView.prototype.setDefaultHotkeys=function(){
this.hotkeys={up:{hotkey:IlvUtil.keys.UP_ARROW,filter:{ctrl:false,alt:false,shift:false}},down:{hotkey:IlvUtil.keys.DOWN_ARROW,filter:{ctrl:false,alt:false,shift:false}},left:{hotkey:IlvUtil.keys.LEFT_ARROW,filter:{ctrl:false,alt:false,shift:false}},right:{hotkey:IlvUtil.keys.RIGHT_ARROW,filter:{ctrl:false,alt:false,shift:false}},singleSelect:{hotkey:IlvUtil.keys.ENTER,filter:{ctrl:false,alt:false,shift:false}},zoomIn:{hotkey:[IlvUtil.keys.NUMPAD_PLUS,IlvUtil.keys.EQUALS],filter:{ctrl:true,alt:false,shift:false}},zoomOut:{hotkey:[IlvUtil.keys.NUMPAD_MINUS,IlvUtil.keys.DASH],filter:{ctrl:true,alt:false,shift:false}},panUp:{hotkey:IlvUtil.keys.UP_ARROW,filter:{ctrl:true,alt:false,shift:false}},panDown:{hotkey:IlvUtil.keys.DOWN_ARROW,filter:{ctrl:true,alt:false,shift:false}},panLeft:{hotkey:IlvUtil.keys.LEFT_ARROW,filter:{ctrl:true,alt:false,shift:false}},panRight:{hotkey:IlvUtil.keys.RIGHT_ARROW,filter:{ctrl:true,alt:false,shift:false}},moveNodeUp:{hotkey:IlvUtil.keys.UP_ARROW,filter:{ctrl:false,alt:false,shift:true}},moveNodeDown:{hotkey:IlvUtil.keys.DOWN_ARROW,filter:{ctrl:false,alt:false,shift:true}},moveNodeLeft:{hotkey:IlvUtil.keys.LEFT_ARROW,filter:{ctrl:false,alt:false,shift:true}},moveNodeRight:{hotkey:IlvUtil.keys.RIGHT_ARROW,filter:{ctrl:false,alt:false,shift:true}},collapseExpand:{hotkey:IlvUtil.keys.SPACE,filter:{ctrl:false,alt:false,shift:false}}};
};
IlvResizableView.prototype.getHotkeys=function(){
return this.hotkeys;
};
IlvResizableView.prototype.toHTML=function(_28d){
this.superInvoke("toHTML",_28d);
this.resizeTool=new IlvResizeTool(this);
this.resizeTool.toHTML(_28d);
this.resizeTool.setVisible(this.resizable);
};
IlvResizeTool=function(view){
this.superConstructor();
this.view=view;
this.color="#808080";
this.lineWidth=2;
this.inHTML=false;
this.registerDispose();
};
IlvResizeTool.prototype=new IlvObject();
IlvResizeTool.prototype.setClassName("IlvResizeTool");
IlvResizeTool.prototype.removeHTML=function(){
this.superInvoke("removeHTML");
if(this.corner){
this.corner.removeHTML();
}
if(this.rect){
this.rect.removeHTML();
}
};
IlvResizeTool.prototype.updateVisibility=function(){
this.superInvoke("updateVisibility");
if(this.corner){
this.corner.updateVisibility();
}
if(this.rect){
this.rect.updateVisibility();
}
};
IlvResizeTool.prototype.dispose=function(){
this.superInvoke("dispose");
if(this.corner){
this.corner.resizeTool=null;
this.corner.dispose();
}
if(this.rect){
this.rect.dispose();
}
this.view=null;
};
IlvResizeTool.prototype.setVisible=function(_28f){
if(this.corner){
this.corner.setVisible(_28f);
}
};
IlvResizeTool.prototype.toHTML=function(_290){
if(this.inHTML){
return;
}
var view=this.view;
var x=view.left;
var y=view.top;
var w=view.width;
var h=view.height;
this.rect=new IlvRectangle(null,_290);
this.rect.setColor(this.color);
this.rect.setThickness(this.lineWidth);
this.corner=new IlvGlassView(x+w-16,y+h-16,16,16);
if(view.accessible){
this.corner.setTabIndex(0);
}
var _296=this.corner;
_296.resizeTool=this;
_296.setContent("<img style=\"-webkit-user-drag:none\" width=\""+_296.getWidth()+"\" height=\""+_296.getHeight()+"\" src=\""+IlvConstants.ilvImagePath+jviews.messages.IlvResizeTool.resizeCornerIcon+"\"/>");
_296.getEventOriginLeft=function(){
return this.resizeTool.view.getLeft();
};
_296.getEventOriginTop=function(){
return this.resizeTool.view.getTop();
};
_296.setEventHandler(this);
_296.setCursor("se-resize");
_296.toHTML(_290);
this.inHTML=true;
};
IlvResizeTool.prototype.setBounds=function(x,y,w,h){
var view=this.view;
var _29c=view.vScrollBar&&view.vScrollBar.isVisible()?w+view.vScrollBar.getWidth():w;
var _29d=view.hScrollBar&&view.hScrollBar.isVisible()?h+view.hScrollBar.getHeight():h;
this.corner.setBounds(x+_29c-16,y+_29d-16,16,16);
};
IlvResizeTool.prototype.startResize=function(e){
this.dragging=true;
var view=this.view;
this.offsetX=view.getWidth()-e.mouseX;
this.offsetY=view.getHeight()-e.mouseY;
this.duringResize(e);
this.rect.setVisible(true);
};
IlvResizeTool.prototype.duringResize=function(e){
if(!this.dragging){
return;
}
var view=this.view;
var _2a2=e.mouseX+this.offsetX;
var _2a3=e.mouseY+this.offsetY;
var mini=view.getMinimumSize();
var maxi=view.getMaximumSize();
_2a2=Math.max(mini.width,_2a2);
_2a3=Math.max(mini.height,_2a3);
_2a2=Math.min(_2a2,maxi.width);
_2a3=Math.min(_2a3,maxi.height);
this.rect.setBounds(view.left,view.top,_2a2,_2a3);
var _2a6=this.corner;
_2a6.setLocation(_2a2+view.left-_2a6.getWidth(),_2a3+view.top-_2a6.getHeight());
};
IlvResizeTool.prototype.stopResize=function(e){
var view=this.view;
var _2a9=e.mouseX+this.offsetX;
var _2aa=e.mouseY+this.offsetY;
var mini=view.getMinimumSize();
var maxi=view.getMaximumSize();
_2a9=Math.max(mini.width,_2a9);
_2aa=Math.max(mini.height,_2aa);
_2a9=Math.min(_2a9,maxi.width);
_2aa=Math.min(_2aa,maxi.height);
view.resizeTool=null;
view.setBounds(view.left,view.top,_2a9,_2aa);
view.resizeTool=this;
this.rect.setVisible(false);
var _2ad=this.corner;
_2ad.setLocation(_2a9+view.left-_2ad.getWidth(),_2aa+view.top-_2ad.getHeight());
this.dragging=false;
};
IlvResizeTool.prototype.mouseDown=function(e){
if(this.dragging){
this.stopResize(e);
}else{
this.startResize(e);
}
};
IlvResizeTool.prototype.mouseDrag=function(e){
this.duringResize(e);
};
IlvResizeTool.prototype.mouseUp=function(e){
if(this.dragging){
this.stopResize(e);
}
};
IlvResizeTool.prototype.startResizeAccessible=function(e){
this.dragging=true;
this.keyPressed=true;
this.offsetX=0;
this.offsetY=0;
e.mouseX=this.mouseX;
e.mouseY=this.mouseY;
this.duringResize(e);
this.rect.setVisible(true);
};
IlvResizeTool.prototype.keyDown=function(e){
if(this.view.accessible&&e.ctrlKey){
if(!this.dragging){
this.mouseX=this.view.width;
this.mouseY=this.view.height;
}
if(e.keyCode==37){
this.mouseX-=5;
}else{
if(e.keyCode==38){
this.mouseY-=5;
}else{
if(e.keyCode==39){
this.mouseX+=5;
}else{
if(e.keyCode==40){
this.mouseY+=5;
}
}
}
}
if(e.keyCode!=17){
this.startResizeAccessible(e);
}
}
};
IlvResizeTool.prototype.keyUp=function(e){
if(this.view.accessible&&this.keyPressed){
e.mouseX=this.mouseX;
e.mouseY=this.mouseY;
this.stopResize(e);
this.keyPressed=false;
}
};
IlvAbstractView=function(left,top,_2b6,_2b7,_2b8){
if(!window.IlvResizableView){
alert(jviews.messages.IlvAbstractView.requiresIlvResizableView);
}
if(!window.IlvGlassView){
alert(jviews.messages.IlvAbstractView.requiresIlvGlassView);
}
this.additionalParams=[];
this.hitInfoTypes=[];
this.scrollState=0;
this.superConstructor(left,top,_2b6,_2b7,_2b8);
this.eventPanel=new IlvGlassView(left,top,_2b6,_2b7);
this.eventPanel.setEventHandler(this);
this.eventPanel.setTabIndex(0);
};
IlvAbstractView.prototype=new IlvResizableView();
IlvAbstractView.prototype.setClassName("IlvAbstractView");
IlvAbstractView.prototype.setReferenceNode=function(node){
this.eventPanel.setReferenceNode(node);
};
IlvAbstractView.prototype.removeHTML=function(){
this.superInvoke("removeHTML");
if(this.eventPanel){
this.eventPanel.removeHTML();
}
if(this.hScrollBar){
this.hScrollBar.removeHTML();
}
if(this.vScrollBar){
this.vScrollBar.removeHTML();
}
};
IlvAbstractView.prototype.putHitInfoType=function(_2ba){
var _2bb=this.hitInfoTypes.join(" ");
if(_2bb.indexOf(_2ba)<0){
this.hitInfoTypes.push(_2ba);
}
};
IlvAbstractView.prototype.getHitInfoTypes=function(){
var _2bc="&hitInfo=";
var _2bd=this.hitInfoTypes.join(" ");
return _2bc+_2bd;
};
IlvAbstractView.prototype.dispose=function(){
this.superInvoke("dispose");
if(this.eventPanel){
this.eventPanel.dispose();
}
if(this.hScrollBar){
this.hScrollBar.dispose();
}
if(this.vScrollBar){
this.vScrollBar.dispose();
}
if(this.hitmap){
this.hitmap.dispose();
this.hitmap=null;
}
};
IlvAbstractView.prototype.setAdditionalParameters=function(key,_2bf){
IlvRequestParameters.setParameter(this.additionalParams,key,_2bf);
};
IlvAbstractView.prototype.getAdditionalParameters=function(){
return IlvRequestParameters.getRequestParameters(this.additionalParams);
};
IlvAbstractView.prototype.updateVisibility=function(){
this.superInvoke("updateVisibility");
if(this.eventPanel){
this.eventPanel.updateVisibility();
}
if(this.hScrollBar){
this.hScrollBar.updateVisibility();
}
if(this.vScrollBar){
this.vScrollBar.updateVisibility();
}
};
IlvAbstractView.prototype.setScrollBarState=function(_2c0){
this.scrollState=_2c0;
if(this.scrollState>0){
if(typeof (IlvHScrollbar)!="undefined"&&!this.hScrollBar){
this.hScrollBar=new IlvHScrollbar(0,0,0);
if(this.accessible){
this.hScrollBar.setTabIndex(0);
}
}
if(typeof (IlvVScrollbar)!="undefined"&&!this.vScrollBar){
this.vScrollBar=new IlvVScrollbar(0,0,0);
if(this.accessible){
this.vScrollBar.setTabIndex(0);
}
}
if(this.vScrollBar&&this.hScrollBar){
this.addImageOnLoadListener(IlvAbstractView.updateScrollBarValues);
this.addCapabilitiesOnLoadListener(IlvAbstractView.installScrollBarsHandler);
}
}
if(this.scrollState==2){
this.hScrollBar.setVisible(true);
this.vScrollBar.setVisible(true);
}else{
this.hScrollBar.setVisible(false);
this.vScrollBar.setVisible(false);
}
};
IlvAbstractView.prototype.setScrollBarSize=function(_2c1){
if(_2c1>16){
this.hScrollBar&&this.hScrollBar.setButtonSize(_2c1);
this.vScrollBar&&this.vScrollBar.setButtonSize(_2c1);
}
};
IlvAbstractView.installScrollBarsHandler=function(view){
if(!view.scrollBarHandlersExist){
view.scrollBarHandlersExist=true;
view.createhScrollBarHandler();
view.createvScrollBarHandler();
}
};
IlvAbstractView.prototype.createhScrollBarHandler=function(){
var _2c3=this.hScrollBar;
var view=this;
function hScroll(dx){
view.moveTo(view.qbboxx+dx,view.qbboxy);
view.scrollhScrollBar=true;
}
function updateValue(dx){
hScroll(dx);
var _2c7=_2c3.getValue();
_2c3.setValue(_2c7+dx);
}
_2c3.thumbHandler.mouseDown=function(e){
this.startValue=_2c3.getValue();
this.mouseDownX=e.mouseX-this.scrollbar.thumb.left;
this.mouseDownY=e.mouseY-this.scrollbar.thumb.top;
};
_2c3.thumbHandler.mouseUp=function(e){
var dx=_2c3.getValue()-this.startValue;
hScroll(dx);
};
_2c3.thumbHandler.keyDown=function(e){
if(!this.dx){
this.dx=0;
}
if(view.accessible&&e.ctrlKey){
if(e.keyCode==37){
this.dx-=5;
}else{
if(e.keyCode==39){
this.dx+=5;
}
}
if(this.dx==5||this.dx==-5){
this.startValue=_2c3.getValue();
}
if(this.dx!=0){
this.scrollbar.doThumbDrag(this.dx+this.scrollbar.thumb.left,0);
}
}
};
_2c3.thumbHandler.keyUp=function(e){
if(view.accessible&&typeof (this.dx)!="undefined"&&this.dx!=0){
var _2cd=_2c3.getValue()-this.startValue;
hScroll(_2cd);
this.dx=0;
this.scrollbar.keyPressed=true;
view.scrollhScrollBar=false;
}
};
var _2ce=null;
_2c3.leftTopHandler.mouseDown=function(e){
var _2d0=this.scrollbar;
_2d0.barLeftTop.setImage(_2d0.barLeftTopDownImage.src);
updateValue(-10);
_2ce=setInterval(function(){
updateValue(-10);
},200);
};
_2c3.leftTopHandler.mouseUp=function(e){
var _2d2=this.scrollbar;
_2d2.barLeftTop.setImage(_2d2.barLeftTopUpImage.src);
if(_2ce){
clearInterval(_2ce);
_2ce=null;
}
};
_2c3.rightBottomHandler.mouseDown=function(e){
var _2d4=this.scrollbar;
_2d4.barRightBottom.setImage(_2d4.barRightBottomDownImage.src);
updateValue(10);
_2ce=setInterval(function(){
updateValue(10);
},200);
};
_2c3.rightBottomHandler.mouseUp=function(e){
var _2d6=this.scrollbar;
_2d6.barRightBottom.setImage(_2d6.barRightBottomUpImage.src);
if(_2ce){
clearInterval(_2ce);
_2ce=null;
}
};
};
IlvAbstractView.prototype.createvScrollBarHandler=function(){
var _2d7=this.vScrollBar;
var view=this;
function vScroll(dy){
view.moveTo(view.qbboxx,view.qbboxy+dy);
view.scrollvScrollBar=true;
}
function updateValue(dx){
vScroll(dx);
var _2db=_2d7.getValue();
_2d7.setValue(_2db+dx);
}
_2d7.thumbHandler.mouseDown=function(e){
this.startValue=_2d7.getValue();
this.mouseDownX=e.mouseX-this.scrollbar.thumb.left;
this.mouseDownY=e.mouseY-this.scrollbar.thumb.top;
};
_2d7.thumbHandler.mouseUp=function(e){
var dy=_2d7.getValue()-this.startValue;
vScroll(dy);
};
_2d7.thumbHandler.keyDown=function(e){
if(!this.dy){
this.dy=0;
}
if(view.accessible&&e.ctrlKey){
if(e.keyCode==38){
this.dy-=5;
}else{
if(e.keyCode==40){
this.dy+=5;
}
}
if(this.dy==5||this.dy==-5){
this.startValue=_2d7.getValue();
}
if(this.dy!=0){
this.scrollbar.doThumbDrag(0,this.dy+this.scrollbar.thumb.top);
}
}
};
_2d7.thumbHandler.keyUp=function(e){
if(view.accessible&&typeof (this.dy)!="undefined"&&this.dy!=0){
var _2e1=_2d7.getValue()-this.startValue;
vScroll(_2e1);
this.dy=0;
this.scrollbar.keyPressed=true;
view.scrollvScrollBar=false;
}
};
var _2e2=null;
_2d7.leftTopHandler.mouseDown=function(e){
var _2e4=this.scrollbar;
_2e4.barLeftTop.setImage(_2e4.barLeftTopDownImage.src);
updateValue(-10);
_2e2=setInterval(function(){
updateValue(-10);
},200);
};
_2d7.leftTopHandler.mouseUp=function(e){
var _2e6=this.scrollbar;
_2e6.barLeftTop.setImage(_2e6.barLeftTopUpImage.src);
if(_2e2){
clearInterval(_2e2);
_2e2=null;
}
};
_2d7.rightBottomHandler.mouseDown=function(e){
var _2e8=this.scrollbar;
_2e8.barRightBottom.setImage(_2e8.barRightBottomDownImage.src);
updateValue(10);
_2e2=setInterval(function(){
updateValue(10);
},200);
};
_2d7.rightBottomHandler.mouseUp=function(e){
var _2ea=this.scrollbar;
_2ea.barRightBottom.setImage(_2ea.barRightBottomUpImage.src);
if(_2e2){
clearInterval(_2e2);
_2e2=null;
}
};
};
IlvAbstractView.updateScrollBarValues=function(view){
if(view.scrollState==0){
return;
}
var _2ec=view.hScrollBar;
var _2ed=view.vScrollBar;
if(_2ec&&_2ec.keyPressed){
_2ec.keyPressed=false;
return;
}
if(_2ed&&_2ed.keyPressed){
_2ed.keyPressed=false;
return;
}
if(view.scrollhScrollBar){
view.scrollhScrollBar=false;
return;
}
if(view.scrollvScrollBar){
view.scrollvScrollBar=false;
return;
}
var _2ee=function(num1,num2,_2f1){
var _2f2=num1*_2f1;
var _2f3=num2*_2f1;
return Math.floor(_2f2)-Math.floor(_2f3);
};
if(!view.isTiled()){
var _2f4=view.getViewBBox();
view.getAllVBBox();
var _2f5=(_2ee(_2f4.left,view.allVbbox.left,100)>0||_2ee(_2f4.width+_2f4.left,view.allVbbox.width+view.allVbbox.left,100)<0);
var _2f6=(_2ee(_2f4.top,view.allVbbox.top,100)>0||_2ee(_2f4.height+_2f4.top,view.allVbbox.height+view.allVbbox.top,100)<0);
if(_2f5){
_2ec.setVisible(true);
var _2f7=_2f4.left-view.allVbbox.left;
var _2f8=_2f4.width;
if(_2f7<0){
_2f8=_2f4.width+_2f7;
_2f7=0;
}
var _2f9=_2f6?16:0;
_2ec.setValues(_2f7,_2f8,0,view.allVbbox.width+_2f9);
}else{
if(view.scrollState===1){
_2ec.setVisible(false);
}else{
if(view.scrollState===2){
_2ec.setValues(0,view.allVbbox.width,0,view.allVbbox.width);
}
}
}
if(_2f6){
_2ed.setVisible(true);
var _2fa=_2f4.top-view.allVbbox.top;
var _2fb=_2f4.height;
if(_2fa<0){
_2fb=_2f4.height+_2fa;
_2fa=0;
}
_2f9=_2f6?16:0;
_2ed.setValues(_2fa,_2fb,0,view.allVbbox.height+_2f9);
}else{
if(view.scrollState==1){
_2ed.setVisible(false);
}else{
if(view.scrollState==2){
_2ed.setValues(0,view.allVbbox.height,0,view.allVbbox.height);
}
}
}
}else{
return;
}
view.setBounds(view.left,view.top,view.getWidth(),view.getHeight());
};
IlvAbstractView.prototype.setChildrenBounds=function(left,top,_2fe,_2ff){
if(this.inHTML){
var now=new Date();
now.setTime(now.getTime()+365*24*60*60*1000);
if(this.isStateInCookie()){
this.saveSizeToCookie(now);
}else{
this.saveState(this);
}
if(this.hScrollBar){
this.hScrollBar.setBounds(left,top+_2ff,_2fe);
}
if(this.vScrollBar){
this.vScrollBar.setBounds(left+_2fe,top,_2ff);
}
}
this.superInvoke("setChildrenBounds",left,top,_2fe,_2ff);
this.eventPanel.setBounds(left,top,_2fe,_2ff);
};
IlvAbstractView.prototype.setAccessible=function(_301){
this.accessible=_301;
if(this.accessible){
this.accessibilityInteractor=new IlvAccessibilityInteractor();
this.setInteractor(this.accessibilityInteractor);
this.setDefaultHotkeys();
}
};
IlvAbstractView.prototype.isAccessible=function(_302){
return this.accessible;
};
IlvAbstractView.prototype.setInteractor=function(_303){
if(this.interactor==_303){
return;
}
var old=this.interactor;
if(this.interactor!=null){
this.interactor.setViewInternal(null);
this.hitmap=null;
}
if(_303&&this.accessibilityInteractor&&this.interactor){
var _305=new IlvInteractorGroup();
_305.isMultiInteractor=_303.isMultiInteractor;
if(_303.getClassName()==="IlvAccessibilityInteractor"){
_305.addInteractor(this.interactor);
}else{
_305.addInteractor(_303);
}
_305.addInteractor(this.accessibilityInteractor);
_303=_305;
}
this.interactor=_303;
if(_303!=null){
this.isMultiInteractor=_303.isMultiInteractor;
_303.setViewInternal(this);
}
this.interactorListeners.notify(this,old,_303);
};
IlvAbstractView.prototype.getInteractor=function(){
return this.interactor;
};
IlvAbstractView.prototype.setCursor=function(_306){
this.eventPanel.setCursor(_306);
};
IlvAbstractView.prototype.getCursor=function(){
return this.eventPanel.getCursor();
};
IlvAbstractView.prototype.childrenToHTML=function(_307){
if(typeof _307=="undefined"){
_307=document.body;
}
this.superInvoke("childrenToHTML",_307);
this.eventPanel.toHTML(_307);
if(this.hScrollBar){
this.hScrollBar.toHTML(_307);
}
if(this.vScrollBar){
this.vScrollBar.toHTML(_307);
}
if(this._toHTML&&typeof (this._toHTML)=="function"){
this._toHTML();
}
};
IlvAbstractView.prototype.getGlassView=function(){
return this.eventPanel;
};
IlvAbstractView.prototype.mouseDown=function(e){
};
IlvAbstractView.prototype.mouseOver=function(e){
};
IlvAbstractView.prototype.mouseOut=function(e){
};
IlvAbstractView.prototype.mouseMove=function(e){
};
IlvAbstractView.prototype.mouseDrag=function(e){
};
IlvAbstractView.prototype.mouseUp=function(e){
};
IlvAbstractView.prototype.keyPress=function(e){
};
IlvAbstractView.prototype.updateHitmap=function(_30f){
if(!this.hitmap){
return;
}
if(this.drawPanel){
this.drawPanel.clear();
}
this.hitmap.clear();
if(!this.hitmapRequest){
this.hitmapRequest=new IlvAjax.HTMLRequest(this,this.hitmapUpdated);
}
if(!_30f){
if(!this.hitmapLayers){
this.hitmapLayers=IlvUtil.getEncodedVisibleLayers(this,this.allLayers);
}
_30f=this.createHitmapRequestURL(this.qbboxx,this.qbboxy,this.qbboxw,this.qbboxh,this.getWidth(),this.getHeight(),this.hitmapLayers);
}
if(_30f){
this.hitmapRequest.send(_30f);
}
};
IlvAbstractView.prototype.hitmapUpdated=function(_310){
try{
eval(_310);
if(!this.hitmap){
this.hitmap=new IlvHitmap();
}
this.hitmap.setData(jviews_hitdata);
this.hitmap.tooltips=typeof (jviews_tooltips)!="undefined"?jviews_tooltips:"";
this.hitmap.extensions=typeof (jviews_extensions)!="undefined"?jviews_extensions:"";
this.hitmap.hitInfos=typeof (jviews_hitInfos)!="undefined"?jviews_hitInfos:null;
if(this.hitmap.hitInfos){
this.hitmap.tooltips=this.hitmap.hitInfos.tooltip;
this.hitmap.extensions=this.hitmap.hitInfos.jviews_extensions;
}
if(this.waitPanel){
this.waitPanel.setVisible(false);
}
}
catch(err){
alert("hitmap updated error: "+err.toString());
}
};
IlvAbstractView.prototype.createHitmapRequestURL=function(qx,qy,qw,qh,_315,_316,_317){
var _318=[];
var temp=unescape(_317).split(",");
for(var j=0;j<temp.length;j++){
for(var i=0;i<this.allLayers.length;i++){
if(IlvUtil.trim(temp[j])==IlvUtil.trim(this.allLayers[i])&&this.visibleLayers[i]){
_318.push(temp[j]);
break;
}
}
}
if(_318.length>0){
var _31c=[this.requestURL,"?request=hitmap","&layer=",_318.join(","),"&bbox=",escape([qx,qy,qw,qh].join(",")),"&width=",_315,"&height=",_316,"&again=",this.againString(),this.getHitInfoTypes(),this.getAdditionalParameters()];
return _31c.join("");
}else{
return null;
}
};
IlvAbstractView.prototype.getDrawPanel=function(){
if(!this.drawPanel){
var _31d=this.parentNode;
this.drawPanel=new IlvDrawView(_31d,this.left,this.top,this.width,this.height);
}
this.drawPanel.setBounds(this.left,this.top,this.width,this.height);
return this.drawPanel;
};
IlvAbstractView.prototype.setHitmapLayers=function(_31e){
if(!_31e){
return;
}
var _31f=_31e.split(" ");
this.hitmapLayers=IlvUtil.encodeStringAttribute(_31f.join(","));
};
IlvAbstractView.prototype.getHitInfos=function(){
return this.hitmap.hitInfos;
};
IlvDrawView=function(_320,x,y,w,h){
this.superConstructor(x,y,w,h);
this.container=_320;
this.scene=null;
this.cannotHighlight=false;
if(!IlvBrowserInfo.instance.svg&&!IlvBrowserInfo.instance.vml){
IlvBrowserInfo.noVectorialAlert();
this.cannotHighlight=true;
}
};
IlvDrawView.prototype=new IlvPanel();
IlvDrawView.prototype.setClassName("IlvDrawView");
IlvDrawView.prototype.createScene=function(_325,id){
var x=this._bounds.left,y=this._bounds.top;
var w=this._bounds.width,h=this._bounds.height;
var _32b="position:absolute; visibility:visible; z-index:3;";
_32b+=" left:"+x+"px; top:"+y+"px; width:"+w+"px; height:"+h+"px;";
this._div=document.createElement("div");
this._div.id=id;
this._div.style.cssText=_32b;
this.setClipImpl(0,0,w,h);
if(_325){
_325.appendChild(this._div);
}else{
document.body.appendChild(this._div);
}
if(IlvBrowserInfo.instance.svg){
var svg=document.createElementNS("http://www.w3.org/2000/svg","svg");
svg.style.width="100%";
svg.style.height="100%";
this._div.appendChild(svg);
this.scene=svg;
}else{
this.scene=this._div;
}
};
IlvDrawView.prototype.getScene=function(){
if(!this.scene){
this.createScene(this.container,this.toString());
}
return this.scene;
};
IlvDrawView.prototype.clear=function(){
if(!this.scene){
return;
}
while(this.scene.hasChildNodes()){
this.scene.removeChild(this.scene.firstChild);
}
};
IlvDrawView.prototype.addGroup=function(_32d){
this.scene.appendChild(_32d);
};
IlvDrawView.createLine=function(x1,y1,x2,y2,_332,_333){
if(IlvBrowserInfo.instance.svg){
return IlvDrawView.createSVGLine(x1,y1,x2,y2,_332,_333);
}else{
if(IlvBrowserInfo.instance.vml){
return IlvDrawView.createVMLLine(x1,y1,x2,y2,_332,_333);
}
}
};
IlvDrawView.createGroup=function(){
if(IlvBrowserInfo.instance.svg){
return IlvDrawView.createSVGGroup();
}else{
if(IlvBrowserInfo.instance.vml){
return IlvDrawView.createVMLGroup();
}
}
};
IlvDrawView.createSVGGroup=function(){
return document.createElementNS("http://www.w3.org/2000/svg","g");
};
IlvDrawView.createSVGLine=function(x1,y1,x2,y2,_338,_339){
var impl=document.createElementNS("http://www.w3.org/2000/svg","line");
impl.setAttributeNS(null,"x1",x1);
impl.setAttributeNS(null,"y1",y1);
impl.setAttributeNS(null,"x2",x2);
impl.setAttributeNS(null,"y2",y2);
impl.setAttributeNS(null,"stroke",_339);
impl.setAttributeNS(null,"stroke-width",_338);
return impl;
};
IlvDrawView.prototype.addShape=function(_33b,_33c,_33d){
if(IlvBrowserInfo.instance.svg){
this.addSVGShape(_33b,_33c,_33d);
}else{
if(IlvBrowserInfo.instance.vml){
this.addVMLShape(_33b,_33c,_33d);
}
}
};
IlvDrawView.prototype.addSVGShape=function(_33e,_33f,_340){
var path=IlvDrawView.toPath(_33e," ");
var _342=document.createElementNS("http://www.w3.org/2000/svg","path");
this.getScene().appendChild(_342);
_342.setAttributeNS(null,"d",path);
_342.setAttributeNS(null,"stroke",_33f);
_342.setAttributeNS(null,"stroke-opacity",_340);
_342.setAttributeNS(null,"stroke-width",1);
return _342;
};
IlvDrawView.prototype.addVMLShape=function(_343,_344,_345){
var path=IlvDrawView.toPath(_343,",");
var _347=document.createElement("shape");
_347.style.behavior="url(#default#VML)";
this.getScene().appendChild(_347);
_347.strokeweight=1;
_347.strokecolor=_344;
_347.coordsize.x=this.getWidth();
_347.coordsize.y=this.getHeight();
_347.style.position="absolute";
_347.style.width=this.getWidth()+"px";
_347.style.height=this.getHeight()+"px";
_347.path=path;
_347.style.filter="alpha(opacity="+(_345*100)+")";
return _347;
};
IlvDrawView.createVMLGroup=function(){
return document.createElement("group");
};
IlvDrawView.createVMLLine=function(x1,y1,x2,y2,_34c,_34d){
var impl=document.createElement("line");
impl.style.behavior="url(#default#VML)";
var d=document.documentElement.clientWidth?document.documentElement:document.body;
var _350=d.scrollLeft;
var _351=d.scrollTop;
if(document.body.clientLeft){
_350-=document.body.clientLeft;
}
if(document.body.clientTop){
_351-=document.body.clientTop;
}
impl.from=(x1+_350)+","+(y1+_351);
impl.to=(x2+_350)+","+(y2+_351);
impl.strokeweight=_34c;
impl.strokecolor=_34d;
return impl;
};
IlvDrawView.toPath=function(_352,sep){
var path="";
var y;
for(var i=0;i<_352.length;i+=3){
y=_352[i+2];
path+="M"+_352[i]+sep+y+"L"+_352[i+1]+sep+y;
}
return path;
};
IlvButton=function(left,top,_359,_35a,_35b,_35c){
if(!window.IlvImageView){
alert(jviews.messages.IlvButton.requiresIlvImageView);
}
this.superConstructor(left,top,_359,_35a);
this.imageView=new IlvImageEventView(left,top,_359,_35a,_35b);
this.imageView.setTabIndex(0);
this.imageView.setBlendTransform(false);
this.imageView.setEventHandler(this);
this.selected=false;
this.rollover=false;
this.imageSrc=_35b;
if(_35b){
this.image=new Image();
this.image.src=_35b;
}
this.rolloverImageSrc=null;
this.selectedImageSrc=null;
this.setAction(_35c);
this.infoPanel=IlvButton.defaultMessagePanel;
this.message="";
this.baseTextDirection="";
this.isToggle=false;
this.registerDispose();
this.enabled=true;
};
if(!window.IlvEmptyView){
alert(jviews.messages.IlvButton.requiresIlvEmptyView);
}
IlvButton.prototype=new IlvEmptyView();
IlvButton.prototype.setClassName("IlvButton");
IlvButton.defaultMessagePanel=null;
IlvButton.prototype.getWidth=function(){
return this.imageView.getWidth();
};
IlvButton.prototype.getHeight=function(){
return this.imageView.getHeight();
};
IlvButton.prototype.dispose=function(){
this.superInvoke("dispose");
this.selected=null;
this.enabled=null;
this.action=null;
if(this.infoPanel){
this.infoPanel.dispose();
}
if(this.image){
IlvUtil.disposeImageSource(this.image);
this.image=null;
}
if(this.rolloverImage){
IlvUtil.disposeImageSource(this.rolloverImage);
this.rolloverImage=null;
}
if(this.selectedImage){
IlvUtil.disposeImageSource(this.selectedImage);
this.selectedImage=null;
}
if(this.imageView){
this.imageView.setEventHandler(null);
this.imageView.dispose();
}
};
IlvButton.prototype.removeHTML=function(){
this.imageView.removeHTML();
};
IlvButton.prototype.updateVisibility=function(){
this.imageView.updateVisibility();
};
IlvButton.prototype.getAction=function(){
return this.action;
};
IlvButton.prototype.setAction=function(_35d){
if(typeof (_35d)=="function"||typeof (_35d)=="string"){
this.action=_35d;
}else{
if(typeof (_35d)!="undefined"){
alert(jviews.messages.IlvButton.actionParamMustBeFunction);
}
}
};
IlvButton.prototype.getMessagePanel=function(){
return this.infoPanel;
};
IlvButton.prototype.setMessagePanel=function(_35e){
this.infoPanel=_35e;
};
IlvButton.prototype.getMessage=function(){
return this.message;
};
IlvButton.prototype.setMessage=function(_35f){
this.message=_35f;
};
IlvButton.prototype.getToolTipText=function(){
return IlvUtil.removeMessageUCCDirection(this.imageView.getToolTipText());
};
IlvButton.prototype.setToolTipText=function(_360){
this.imageView.setToolTipText(IlvUtil.setMessageUCCDirection(_360,this.baseTextDirection));
};
IlvButton.prototype.setBaseTextDirection=function(_361){
if(typeof (_361)=="string"){
this.baseTextDirection=_361;
this.imageView.setToolTipText(IlvUtil.setMessageUCCDirection(this.imageView.getToolTipText(),this.baseTextDirection));
}
};
IlvButton.prototype.getBaseTextDirection=function(){
return this.baseTextDirection;
};
IlvButton.prototype.getCursor=function(){
return this.imageView.getCursor();
};
IlvButton.prototype.setCursor=function(_362){
this.imageView.setCursor(_362);
};
IlvButton.prototype.isEnabled=function(){
return this.enabled;
};
IlvButton.prototype.setEnabled=function(_363){
if(this.selected&&!_363){
this.setSelected(false);
}
this.enabled=_363;
this.updateCurrentImage();
};
IlvButton.prototype.isSelected=function(){
return this.selected;
};
IlvButton.prototype.setSelected=function(_364){
if(this.enabled){
this.selected=_364;
this.updateCurrentImage();
}
};
IlvButton.prototype.isToggleButton=function(){
return this.isToggle;
};
IlvButton.prototype.setToggleButton=function(set){
this.isToggle=set;
};
IlvButton.prototype.getImage=function(){
return this.imageSrc;
};
IlvButton.prototype.setImage=function(_366){
if(this.image){
IlvUtil.disposeImageSource(this.image);
this.image=null;
}
this.imageSrc=_366;
if(_366){
this.image=new Image();
this.image.src=_366;
}
this.updateCurrentImage();
};
IlvButton.prototype.getRolloverImage=function(){
return this.rolloverImageSrc;
};
IlvButton.prototype.setRolloverImage=function(_367){
if(this.rolloverImage){
IlvUtil.disposeImageSource(this.rolloverImage);
this.rolloverImage=null;
}
this.rolloverImageSrc=_367;
if(_367){
this.rolloverImage=new Image();
this.rolloverImage.src=_367;
}
this.updateCurrentImage();
};
IlvButton.prototype.getSelectedImage=function(){
return this.selectedImageSrc;
};
IlvButton.prototype.setSelectedImage=function(_368){
if(this.selectedImage){
IlvUtil.disposeImageSource(this.selectedImage);
this.selectedImage=null;
}
this.selectedImageSrc=_368;
if(_368){
this.selectedImage=new Image();
this.selectedImage.src=_368;
}
this.updateCurrentImage();
};
IlvButton.prototype.updateCurrentImage=function(){
var _369=this.imageSrc;
if(this.selected&&this.selectedImageSrc){
_369=this.selectedImageSrc;
}else{
if(this.rollover&&this.rolloverImageSrc){
_369=this.rolloverImageSrc;
}
}
this.imageView.setImage(_369);
if(this.imageView.inHTML){
if(this.enabled){
this.imageView.imagePanel.setOpacity(1);
}else{
this.imageView.imagePanel.setOpacity(0.4);
}
}
};
IlvButton.prototype.setChildrenBounds=function(left,top,_36c,_36d){
this.imageView.setBounds(left,top,_36c,_36d);
};
IlvButton.prototype.childrenToHTML=function(_36e){
this.imageView.toHTML(_36e);
if(this.enabled){
this.imageView.imagePanel.setOpacity(1);
}else{
this.imageView.imagePanel.setOpacity(0.4);
}
};
IlvButton.prototype.doAction=function(){
if(this.enabled){
if(typeof (this.action)=="function"){
this.action();
}else{
eval(this.action);
}
}
};
IlvButton.prototype.doClick=function(){
if(this.enabled){
var _36f=this.isToggleButton();
if(_36f){
this.setSelected(!this.isSelected());
}else{
this.setSelected(true);
}
this.doAction();
if(!_36f){
this.setSelected(false);
}
}
};
IlvButton.prototype.mouseDown=function(e){
if(this.enabled&&e.button!=2){
var _371=this.isToggleButton();
if(_371){
this.setSelected(!this.isSelected());
}else{
this.setSelected(true);
}
this.doAction();
}
};
IlvButton.prototype.mouseUp=function(e){
if(this.enabled){
if(!this.isToggleButton()){
this.setSelected(false);
}
}
};
IlvButton.prototype.mouseOver=function(e){
this.rollover=true;
if(this.enabled){
this.updateCurrentImage();
}
if(this.message!=""){
window.status=this.message;
}else{
window.status="";
}
if(this.infoPanel){
if(IlvBrowserInfo.instance.ie&&document.readyState!="complete"){
return;
}
this.infoPanel.setContent(IlvUtil.setMessageDirection(this.message,(this.infoPanel.getBaseTextDirection()!="")?this.infoPanel.getBaseTextDirection():this.baseTextDirection));
}
};
IlvButton.prototype.mouseOut=function(e){
this.rollover=false;
if(this.enabled){
this.updateCurrentImage();
}
window.status="";
if(this.infoPanel){
if(IlvBrowserInfo.instance.ie&&document.readyState!="complete"){
return true;
}
this.infoPanel.setContent("");
}
};
IlvButton.prototype.keyDown=function(e){
if(e.keyCode==13||e.keyCode==32){
this.mouseDown(e);
}
};
IlvButton.prototype.keyUp=function(e){
if(e.keyCode==13||e.keyCode==32){
this.mouseUp(e);
}
};
IlvScrollbar=function(left,top,_379){
if(!window.IlvImageView){
alert(jviews.messages.IlvScrollbar.requiresIlvImageView);
}
this.superConstructor();
this.buttonSize=16;
this.value=0;
this.extent=10;
this.minValue=0;
this.maxValue=100;
this.unitIncrement=1;
this.setBounds(left,top,_379);
this.visible=true;
this.enabled=true;
this.valueListeners=new IlvListenerList();
this.barBackground=new IlvGlassView();
this.barBackground.setBackgroundColor("#E4E4E4");
this.updateBarBackgroundBounds();
this.barLeftTop=new IlvImageEventView(this.left,this.top,this.buttonSize,this.buttonSize,this.barLeftTopUpImage.src);
this.barLeftTop.setBlendTransform(false);
this.updateBarLeftTopBounds();
this.leftTopHandler={scrollbar:this,mouseDown:function(e){
var _37b=this.scrollbar;
_37b.barLeftTop.setImage(_37b.barLeftTopDownImage.src);
_37b.setValue(_37b.getValue()-_37b.getUnitIncrement());
},mouseUp:function(e){
var _37d=this.scrollbar;
_37d.barLeftTop.setImage(_37d.barLeftTopUpImage.src);
}};
this.barLeftTop.setEventHandler(this.leftTopHandler);
this.barRightBottom=new IlvImageEventView(0,0,this.buttonSize,this.buttonSize,this.barRightBottomUpImage.src);
this.barRightBottom.setBlendTransform(false);
if(this.updateBarRightBottomBounds){
this.updateBarRightBottomBounds();
}
this.rightBottomHandler={scrollbar:this,mouseDown:function(e){
var _37f=this.scrollbar;
_37f.barRightBottom.setImage(_37f.barRightBottomDownImage.src);
_37f.setValue(_37f.getValue()+_37f.getUnitIncrement());
},mouseUp:function(e){
var _381=this.scrollbar;
_381.barRightBottom.setImage(_381.barRightBottomUpImage.src);
}};
this.barRightBottom.setEventHandler(this.rightBottomHandler);
this.thumb=new IlvGlassView();
if(this.updateThumbBounds){
this.updateThumbBounds();
}
this.thumb.scrollbar=this;
this.thumb.getEventOriginLeft=function(){
return this.scrollbar.left;
};
this.thumb.getEventOriginTop=function(){
return this.scrollbar.top;
};
this.thumbHandler={scrollbar:this,mouseDown:function(e){
this.mouseDownX=e.mouseX-this.scrollbar.thumb.left;
this.mouseDownY=e.mouseY-this.scrollbar.thumb.top;
},mouseDrag:function(e){
var _384=e.mouseX-this.mouseDownX;
var _385=e.mouseY-this.mouseDownY;
this.scrollbar.doThumbDrag(_384,_385);
},keyDown:function(e){
if(!this.dx){
this.dx=0;
}
if(e.ctrlKey){
if(e.keyCode==37){
this.dx-=10;
this.scrollbar.doThumbDrag(this.dx+this.scrollbar.thumb.left,0);
}else{
if(e.keyCode==39){
this.dx+=10;
this.scrollbar.doThumbDrag(this.dx+this.scrollbar.thumb.left,0);
}
}
}
},keyUp:function(e){
if(this.dx!=0){
this.dx=0;
}
}};
this.thumb.setEventHandler(this.thumbHandler);
};
IlvScrollbar.prototype=new IlvObject();
IlvScrollbar.prototype.setClassName("IlvScrollbar");
IlvScrollbar.prototype.barLeftTopUpImage=new Image();
IlvScrollbar.prototype.barLeftTopDownImage=new Image();
IlvScrollbar.prototype.barRightBottomUpImage=new Image();
IlvScrollbar.prototype.barRightBottomDownImage=new Image();
IlvScrollbar.prototype.setButtonSize=function(_388){
this.buttonSize=_388;
};
IlvScrollbar.prototype.removeHTML=function(){
this.barBackground.removeHTML();
this.barLeftTop.removeHTML();
this.barRightBottom.removeHTML();
this.thumb.removeHTML();
};
IlvScrollbar.prototype.dispose=function(){
this.valueListeners.dispose();
this.superInvoke("dispose");
this.barBackground.dispose();
this.barLeftTop.dispose();
this.barRightBottom.dispose();
this.thumb.dispose();
};
IlvScrollbar.prototype.updateVisibility=function(){
this.barBackground.updateVisibility();
this.barLeftTop.updateVisibility();
this.barRightBottom.updateVisibility();
this.thumb.updateVisibility();
};
IlvScrollbar.prototype.updateBounds=function(){
this.width=0;
this.height=0;
};
IlvScrollbar.prototype.computeRanges=function(){
this.valueRange=this.maxValue-this.minValue;
this.pixelRange=this.length-(2*this.buttonSize);
this.pixelValueRatio=this.pixelRange/this.valueRange;
};
IlvScrollbar.prototype.updateBarBackgroundBounds=function(){
if(!this.barBackground){
return;
}
this.barBackground.setBounds(this.left,this.top,this.width,this.height);
this.barBackground.setContent("<img style=\"display:block;-webkit-user-drag:none\" width=\""+this.width+"\" height=\""+this.height+"\" src=\""+IlvConstants.ilvImagePath+jviews.messages.IlvScrollbar.scrollBarBackIcon+"\"/>");
};
IlvScrollbar.prototype.updateBarLeftTopBounds=function(){
if(!this.barLeftTop){
return;
}
var _389=this.buttonSize;
this.barLeftTop.setBounds(this.left,this.top,_389,_389);
};
IlvScrollbar.prototype.setBounds=function(left,top,_38c){
this.left=left||0;
this.top=top||0;
this.length=_38c||0;
this.length=Math.max(this.length,3*this.buttonSize);
this.updateBounds();
this.computeRanges();
this.updateBarBackgroundBounds();
this.updateBarLeftTopBounds();
if(this.updateBarRightBottomBounds){
this.updateBarRightBottomBounds();
}
if(this.updateThumbBounds){
this.updateThumbBounds();
}
};
IlvScrollbar.prototype.setTabIndex=function(_38d){
if(this.thumb){
this.thumb.setTabIndex(_38d);
}
};
IlvScrollbar.prototype.getLeft=function(){
return this.left;
};
IlvScrollbar.prototype.getTop=function(){
return this.top;
};
IlvScrollbar.prototype.getWidth=function(){
return this.width;
};
IlvScrollbar.prototype.getHeight=function(){
return this.height;
};
IlvScrollbar.prototype.setLocation=function(left,top){
this.setBounds(left,top,this.length);
};
IlvScrollbar.prototype.isVisible=function(){
return this.visible;
};
IlvScrollbar.prototype.setVisible=function(_390){
this.visible=_390;
this.barBackground.setVisible(_390);
this.barLeftTop.setVisible(_390);
this.barRightBottom.setVisible(_390);
this.thumb.setVisible(_390);
};
IlvScrollbar.prototype.isEnabled=function(){
return this.enabled;
};
IlvScrollbar.prototype.setEnabled=function(_391){
this.enabled=_391;
this.barBackground.setEnabled(_391);
this.barLeftTop.setEnabled(_391);
this.barRightBottom.setEnabled(_391);
this.thumb.setEnabled(_391);
};
IlvScrollbar.prototype.getUnitIncrement=function(){
return this.unitIncrement;
};
IlvScrollbar.prototype.setUnitIncrement=function(_392){
_392=Math.round(Math.max(1,_392));
this.unitIncrement=_392;
};
IlvScrollbar.prototype.getValue=function(){
return this.value;
};
IlvScrollbar.prototype.getExtent=function(){
return this.extent;
};
IlvScrollbar.prototype.getMinValue=function(){
return this.minValue;
};
IlvScrollbar.prototype.getMaxValue=function(){
return this.maxValue;
};
IlvScrollbar.prototype.setValue=function(_393){
var _394=this.value;
_393=Math.min(_393,this.maxValue-this.extent);
_393=Math.max(_393,this.minValue);
this.value=Math.round(_393);
this.updateThumbLocation();
if(this.value!=_394){
this.fireValueChanged();
}
};
IlvScrollbar.prototype.setValues=function(_395,_396,min,max){
var _399=this.value;
this.extent=Math.max(Math.round(_396),0);
this.maxValue=Math.round(max);
this.minValue=Math.min(Math.round(min),this.maxValue);
this.value=Math.round(_395);
if(this.value<this.minValue){
this.minValue=this.value;
}
this.maxValue=Math.max(this.maxValue,this.value+this.extent);
this.computeRanges();
this.updateThumbBounds();
if(this.value!=_399){
this.fireValueChanged();
}
};
IlvScrollbar.prototype.fireValueChanged=function(){
this.valueListeners.notify(this);
};
IlvScrollbar.prototype.addValueListener=function(_39a){
this.valueListeners.addListener(_39a);
};
IlvScrollbar.prototype.removeValueListener=function(_39b){
this.valueListeners.removeListener(_39b);
};
IlvScrollbar.prototype.toHTML=function(_39c){
if(this.inHTML){
return;
}
this.barBackground.toHTML(_39c);
this.barBackground.setZIndex(1);
this.barLeftTop.toHTML(_39c);
this.barRightBottom.toHTML(_39c);
this.thumb.toHTML(_39c);
this.inHTML=true;
};
IlvVScrollbar=function(left,top,_39f){
if(IlvVScrollbar.prototype.barLeftTopUpImage.src!=IlvConstants.ilvImagePath+jviews.messages.IlvVScrollbar.scrollBarTopupIcon){
IlvVScrollbar.prototype.barLeftTopUpImage=new Image();
IlvVScrollbar.prototype.barLeftTopUpImage.src=IlvConstants.ilvImagePath+jviews.messages.IlvVScrollbar.scrollBarTopupIcon;
IlvVScrollbar.prototype.barLeftTopDownImage=new Image();
IlvVScrollbar.prototype.barLeftTopDownImage.src=IlvConstants.ilvImagePath+jviews.messages.IlvVScrollbar.scrollBarTopdnIcon;
IlvVScrollbar.prototype.barRightBottomUpImage=new Image();
IlvVScrollbar.prototype.barRightBottomUpImage.src=IlvConstants.ilvImagePath+jviews.messages.IlvVScrollbar.scrollBarBotupIcon;
IlvVScrollbar.prototype.barRightBottomDownImage=new Image();
IlvVScrollbar.prototype.barRightBottomDownImage.src=IlvConstants.ilvImagePath+jviews.messages.IlvVScrollbar.scrollBarBotdnIcon;
}
this.superConstructor(left,top,_39f);
};
IlvVScrollbar.prototype=new IlvScrollbar();
IlvVScrollbar.prototype.setClassName("IlvVScrollbar");
IlvVScrollbar.prototype.updateBounds=function(){
this.width=this.buttonSize;
this.height=this.length;
};
IlvVScrollbar.prototype.getThumbContent=function(){
var _3a0="display:block;-webkit-user-drag:none";
return "<table border=\"0\" width=\""+this.width+"\" cellpadding=\"0\" cellspacing=\"0\">"+"<tr><td><img style=\""+_3a0+"\" src=\""+IlvConstants.ilvImagePath+jviews.messages.IlvVScrollbar.scrollBarThumbtopIcon+"\""+" width=\""+this.width+"\"/></td></tr> "+"<tr><td><img style=\""+_3a0+"\" src=\""+IlvConstants.ilvImagePath+jviews.messages.IlvVScrollbar.scrollBarVthumbIcon+"\""+" width=\""+this.width+" \" height=\""+(this.thumb.height-4)+"\"/></td></tr>"+"<tr><td><img style=\""+_3a0+"\" src=\""+IlvConstants.ilvImagePath+jviews.messages.IlvVScrollbar.scrollBarThumbbotIcon+"\""+" width=\""+this.width+"\"/></td></tr>"+"</table>";
};
IlvVScrollbar.prototype.updateBarRightBottomBounds=function(){
var _3a1=this.buttonSize;
var top=this.top+this.length-_3a1;
this.barRightBottom.setBounds(this.left,top,_3a1,_3a1);
};
IlvVScrollbar.prototype.updateThumbLocation=function(){
var _3a3=this.valueRange-this.extent;
if(Math.abs(_3a3)<1){
y=this.thumbMinY;
}else{
var _3a5=(this.thumbMaxY-this.thumbMinY)/_3a3;
var y=this.thumbMinY+(_3a5*(this.value-this.minValue));
}
this.thumb.setLocation(this.left,y);
};
IlvVScrollbar.prototype.updateThumbBounds=function(){
var _3a6=this.buttonSize;
var _3a7=this.pixelValueRatio*this.extent;
_3a7=Math.max(_3a7,_3a6);
this.thumbMinY=this.top+this.buttonSize;
this.thumbMaxY=this.top+this.length-(this.buttonSize+_3a7);
var _3a8=this.valueRange-this.extent;
if(Math.abs(_3a8)<1){
y=this.thumbMinY;
}else{
var _3aa=(this.thumbMaxY-this.thumbMinY)/_3a8;
var y=this.thumbMinY+(_3aa*(this.value-this.minValue));
}
this.thumb.setBounds(this.left,y,this.buttonSize,_3a7);
this.thumb.setContent(this.getThumbContent());
};
IlvVScrollbar.prototype.doThumbDrag=function(_3ab,_3ac){
_3ac=Math.max(_3ac,this.thumbMinY);
if(Math.abs(_3ac-this.thumbMaxY)<1){
this.value=this.maxValue;
}else{
_3ac=Math.min(_3ac,this.thumbMaxY);
var _3ad=this.valueRange-this.extent;
if(Math.abs(_3ad)<1){
this.value=Math.round(this.minValue);
}else{
var _3ae=(this.thumbMaxY-this.thumbMinY)/_3ad;
this.value=Math.round(this.minValue+((_3ac-this.thumbMinY)/_3ae));
}
}
this.updateThumbLocation();
this.fireValueChanged();
};
IlvHScrollbar=function(left,top,_3b1){
if(IlvHScrollbar.prototype.barLeftTopUpImage.src!=IlvConstants.ilvImagePath+jviews.messages.IlvHScrollbar.scrollBarLeftupIcon){
IlvHScrollbar.prototype.barLeftTopUpImage=new Image();
IlvHScrollbar.prototype.barLeftTopUpImage.src=IlvConstants.ilvImagePath+jviews.messages.IlvHScrollbar.scrollBarLeftupIcon;
IlvHScrollbar.prototype.barLeftTopDownImage=new Image();
IlvHScrollbar.prototype.barLeftTopDownImage.src=IlvConstants.ilvImagePath+jviews.messages.IlvHScrollbar.scrollBarLeftdnIcon;
IlvHScrollbar.prototype.barRightBottomUpImage=new Image();
IlvHScrollbar.prototype.barRightBottomUpImage.src=IlvConstants.ilvImagePath+jviews.messages.IlvHScrollbar.scrollBarRightupIcon;
IlvHScrollbar.prototype.barRightBottomDownImage=new Image();
IlvHScrollbar.prototype.barRightBottomDownImage.src=IlvConstants.ilvImagePath+jviews.messages.IlvHScrollbar.scrollBarRightdnIcon;
}
this.superConstructor(left,top,_3b1);
};
IlvHScrollbar.prototype=new IlvScrollbar();
IlvHScrollbar.prototype.setClassName("IlvHScrollbar");
IlvHScrollbar.prototype.updateBounds=function(){
this.width=this.length;
this.height=this.buttonSize;
};
IlvHScrollbar.prototype.getThumbContent=function(){
var _3b2="display:block;-webkit-user-drag:none";
return "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>"+"<td><img style=\""+_3b2+"\" src=\""+IlvConstants.ilvImagePath+jviews.messages.IlvHScrollbar.scrollBarThumbleftIcon+"\" height=\""+this.height+"\"/></td>"+"<td><img style=\""+_3b2+"\" src=\""+IlvConstants.ilvImagePath+jviews.messages.IlvHScrollbar.scrollBarHthumbIcon+"\" "+" width=\""+(this.thumb.width-4)+"\" height=\""+this.height+"\"/></td>"+"<td><img style=\""+_3b2+"\" src=\""+IlvConstants.ilvImagePath+jviews.messages.IlvHScrollbar.scrollBarThumbrightIcon+"\" height=\""+this.height+"\"/></td>"+"</tr></table>";
};
IlvHScrollbar.prototype.updateBarRightBottomBounds=function(){
var _3b3=this.buttonSize;
var left=this.left+this.length-_3b3;
this.barRightBottom.setBounds(left,this.top,_3b3,_3b3);
};
IlvHScrollbar.prototype.updateThumbLocation=function(){
var x=this.thumbMinX+(this.pixelValueRatio*(this.value-this.minValue));
this.thumb.setLocation(x,this.top);
};
IlvHScrollbar.prototype.updateThumbBounds=function(){
var _3b6=this.buttonSize;
var _3b7=this.pixelValueRatio*this.extent;
_3b7=Math.max(_3b7,_3b6);
this.thumbMinX=this.left+this.buttonSize;
this.thumbMaxX=this.left+this.length-(this.buttonSize+_3b7);
var x=this.thumbMinX+(this.pixelValueRatio*(this.value-this.minValue));
this.thumb.setBounds(x,this.top,_3b7,this.buttonSize);
this.thumb.setContent(this.getThumbContent());
};
IlvHScrollbar.prototype.doThumbDrag=function(_3b9,_3ba){
_3b9=Math.max(_3b9,this.thumbMinX);
_3b9=Math.min(_3b9,this.thumbMaxX);
this.value=Math.round(this.minValue+((_3b9-this.thumbMinX)/this.pixelValueRatio));
this.updateThumbLocation();
this.fireValueChanged();
};
IlvInteractor=function(){
this.superConstructor();
this.view=null;
this.message="";
};
IlvInteractor.prototype=new IlvObject();
IlvInteractor.prototype.setClassName("IlvInteractor");
IlvInteractor.prototype.setCursor=function(_3bb){
if(_3bb!=this.cursor){
this.cursor=_3bb;
if(this.view){
this.view.setCursor(this.cursor);
}
}
};
IlvInteractor.prototype.getCursor=function(){
return this.cursor;
};
IlvInteractor.prototype.setMessage=function(_3bc){
this.message=_3bc;
};
IlvInteractor.prototype.getMessage=function(){
return this.message;
};
IlvInteractor.prototype.getView=function(){
return this.view;
};
IlvInteractor.prototype.setView=function(view){
};
IlvInteractor.prototype.setViewInternal=function(view){
if(this.view!=null){
if(typeof (this.oldCursor)!="undefined"){
this.view.setCursor(this.oldCursor);
}
}
this.setView(view);
this.view=view;
if(view!=null){
if(typeof (this.getCursor())!="undefined"){
this.oldCursor=view.getCursor();
view.setCursor(this.getCursor());
}else{
view.setCursor("default");
}
}
};
IlvInteractor.prototype.setMenuModelId=function(_3bf){
this.modelId=_3bf;
};
IlvInteractor.prototype.getMenuModelId=function(){
return this.modelId;
};
IlvResizeInteractor=function(){
this.superConstructor();
this.actionName="resizeNode";
};
IlvResizeInteractor.prototype=new IlvInteractor();
IlvResizeInteractor.prototype.setClassName("IlvResizeInteractor");
IlvResizeInteractor.prototype.setViewInternal=function(view){
this.view=view;
if(this.view){
this.view.showResizeHandlers=true;
this.oldCursor=this.view.getCursor();
}
};
IlvResizeInteractor.prototype.setActionName=function(_3c1){
this.actionName=_3c1;
};
IlvResizeInteractor.prototype.mouseDown=function(e){
if(e.button!=2&&this.view!=null){
if(this.activeResizableRect){
if(!this.activeResizableRect.isVisible()){
this.activeResizableRect.setVisible(true);
}else{
if(this.activeResizableRect){
this.offsetX=0;
this.offsetY=0;
this.onStartDrag(e,this.activeResizableRect);
}
}
}
}
return false;
};
IlvResizeInteractor.prototype.mouseDrag=function(e){
if(e.button!=2&&this.view!=null){
if(this.activeResizableRect&&this.activeResizableRect.isVisible()){
this.onDuringDrag(e,this.activeResizableRect);
}
}
return false;
};
IlvResizeInteractor.prototype.mouseUp=function(e){
if(e.button!=2&&this.view!=null){
if(this.activeResizableRect&&this.activeResizableRect.isVisible()){
this.onEndDrag(e,this.activeResizableRect);
}
}
if(typeof (this.getCursor())!="undefined"){
this.view.setCursor(this.getCursor());
}else{
this.view.setCursor("default");
}
return false;
};
IlvResizeInteractor.prototype.setResizeCursor=function(view,_3c6,e){
if(_3c6&&_3c6.isVisible()){
var vBox=this.view.getBounds();
if(_3c6.inHandler(vBox,e.mouseX,e.mouseY,_3c6.eResizeHandle)){
view.setCursor("e-resize");
this.resizeEndTime=true;
return true;
}else{
if(_3c6.inHandler(vBox,e.mouseX,e.mouseY,_3c6.neResizeHandle)){
view.setCursor("ne-resize");
return true;
}else{
if(_3c6.inHandler(vBox,e.mouseX,e.mouseY,_3c6.nwResizeHandle)){
view.setCursor("nw-resize");
return true;
}else{
if(_3c6.inHandler(vBox,e.mouseX,e.mouseY,_3c6.nResizeHandle)){
view.setCursor("n-resize");
return true;
}else{
if(_3c6.inHandler(vBox,e.mouseX,e.mouseY,_3c6.seResizeHandle)){
view.setCursor("se-resize");
return true;
}else{
if(_3c6.inHandler(vBox,e.mouseX,e.mouseY,_3c6.swResizeHandle)){
view.setCursor("sw-resize");
return true;
}else{
if(_3c6.inHandler(vBox,e.mouseX,e.mouseY,_3c6.sResizeHandle)){
view.setCursor("s-resize");
return true;
}else{
if(_3c6.inHandler(vBox,e.mouseX,e.mouseY,_3c6.wResizeHandle)){
view.setCursor("w-resize");
this.resizeStartTime=true;
return true;
}
}
}
}
}
}
}
}
}
if(!this.view.oldCursor){
view.setCursor(this.oldCursor);
}
this.resizeStartTime=false;
this.resizeEndTime=false;
return false;
};
IlvResizeInteractor.prototype.mouseMove=function(e){
var mgr=this.view.getSelectionManager();
for(var i=0;i<mgr.rectangleList.length;i++){
var _3cc=mgr.rectangleList[i];
this.activeResizableRect=_3cc;
if(this.setResizeCursor(this.view,_3cc,e)){
this.activeRectIndex=i;
this.resizeCursorSet=true;
return true;
}
}
if(this.resizeCursorSet&&this.view.oldCursor){
this.view.setCursor(this.view.oldCursor);
this.resizeCursorSet=false;
}
this.activeResizableRect=null;
this.activeRectIndex=-1;
return false;
};
IlvResizeInteractor.prototype.keyDown=function(e){
return false;
};
IlvResizeInteractor.prototype.onStartDrag=function(_3ce,_3cf){
this.dragging=true;
this.startResize(_3ce,_3cf);
};
IlvResizeInteractor.prototype.onDuringDrag=function(_3d0,_3d1){
if(this.dragging){
this.duringResize(_3d0,_3d1);
}
};
IlvResizeInteractor.prototype.onEndDrag=function(_3d2,_3d3){
if(this.dragging&&this.actionName){
var _3d4=_3d3.getBounds();
var _3d5=1;
var _3d6=this.view.getContentsBounds();
var _3d7=_3d3.thickness;
var left=_3d4.left-_3d6.left+_3d7;
var top=_3d4.top-_3d6.top+_3d7;
var _3da=_3d4.width-2*_3d7;
var _3db=_3d4.height-2*_3d7;
var _3dc=[_3d5,left,top,_3da,_3db];
var x=_3d2.mouseX;
var y=_3d2.mouseY;
this.offsetX=x-this.cursorStartX;
this.offsetY=y-this.cursorStartY;
if(this.offsetX==0&&this.offsetY==0){
this.stopResize(_3d2);
return;
}
var mgr=this.view.getSelectionManager();
if(mgr){
var _3e0=mgr.getSelection();
if(_3e0.length>1){
_3d5=_3e0.length;
var _3e1=this.oldBounds.left+this.oldBounds.width/2;
var _3e2=this.oldBounds.top+this.oldBounds.height/2;
_3dc=[_3d5,left,top,_3da,_3db,_3e1,_3e2];
}
if(typeof (mgr.synchronizeSiblings)==="function"){
mgr.setOnRequestComplete(function(){
mgr.synchronizeSiblings(true,false);
});
_3dc=[this.activeRectIndex,left,top,_3da,_3db,this.resizeStartTime,this.resizeEndTime];
}
mgr.forceUpdate();
this.view.performAction(this.actionName,_3dc,"getCapabilities");
}
this.stopResize(_3d2);
}
};
IlvResizeInteractor.prototype.startResize=function(e,_3e4){
this.cursorStartX=e.mouseX;
this.cursorStartY=e.mouseY;
this.oldBounds=_3e4.getBounds();
this.duringResize(e);
};
IlvResizeInteractor.prototype.duringResize=function(e,_3e6){
if(!this.dragging||_3e6==null){
return;
}
var vb=this.view.getGlassView().getBounds();
var x=e.mouseX;
var y=e.mouseY;
this.offsetX=x-this.cursorStartX;
this.offsetY=y-this.cursorStartY;
var t=_3e6.getThickness();
var _3eb=this.view.getCursor();
var left,top,_3ee,_3ef;
left=this.oldBounds.left+t;
top=this.oldBounds.top+t;
if(_3eb=="s-resize"||_3eb=="e-resize"||_3eb=="se-resize"){
if(_3eb=="s-resize"){
_3ee=this.oldBounds.width;
}else{
_3ee=this.offsetX+this.oldBounds.width;
}
if(_3eb=="e-resize"){
_3ef=this.oldBounds.height;
}else{
_3ef=this.offsetY+this.oldBounds.height;
}
}
if(_3eb=="nw-resize"||_3eb=="n-resize"||_3eb=="w-resize"){
left=this.oldBounds.left+t+this.offsetX;
top=this.oldBounds.top+t+this.offsetY;
_3ee=this.oldBounds.width-this.offsetX;
_3ef=this.oldBounds.height-this.offsetY;
if(_3eb=="n-resize"){
left=this.oldBounds.left+t;
_3ee=this.oldBounds.width;
}
if(_3eb=="w-resize"){
top=this.oldBounds.top+t;
_3ef=this.oldBounds.height;
}
}
if(_3eb=="ne-resize"){
left=this.oldBounds.left+t;
top=this.oldBounds.top+t+this.offsetY;
_3ee=this.oldBounds.width+this.offsetX;
_3ef=this.oldBounds.height-this.offsetY;
}
if(_3eb=="sw-resize"){
left=this.oldBounds.left+t+this.offsetX;
top=this.oldBounds.top+t;
_3ee=this.oldBounds.width-this.offsetX;
_3ef=this.oldBounds.height+this.offsetY;
}
var dt=t+t;
_3ee-=dt;
_3ef-=dt;
if(_3ee<0){
_3ee=0-_3ee;
left-=_3ee;
}
if(_3ef<0){
_3ef=0-_3ef;
top-=_3ef;
}
var _3f1=_3e6.thickness;
_3e6.setBounds(left+_3f1,top+_3f1,_3ee-2*_3f1,_3ef-2*_3f1);
};
IlvResizeInteractor.prototype.stopResize=function(e){
this.dragging=false;
};
IlvAnchor=function(_3f3,_3f4,_3f5,_3f6){
this.superConstructor();
this.centerX=Math.floor(_3f3);
this.centerY=Math.floor(_3f4);
this.thick=_3f5?_3f5:2;
this.color=_3f6?_3f6:"blue";
};
IlvAnchor.prototype=new IlvObject();
IlvAnchor.prototype.setClassName("IlvAnchor");
IlvAnchor.prototype.setCenter=function(x,y){
this.centerX=Math.floor(x);
this.centerY=Math.floor(y);
};
IlvAnchor.prototype.draw=function(_3f9){
this.parentNode=_3f9;
var _3fa=[];
this.anchor=document.createElement("div");
_3fa[0]=[this.centerX-this.thick,this.centerY-this.thick];
_3fa[1]=[this.centerX+this.thick,this.centerY-this.thick];
_3fa[2]=[this.centerX+this.thick,this.centerY+this.thick];
_3fa[3]=[this.centerX-this.thick,this.centerY+this.thick];
var temp=[_3fa[0].join(","),_3fa[1].join(","),_3fa[2].join(","),_3fa[3].join(",")];
if(IlvBrowserInfo.instance.svg){
var svg;
this.anchor.setAttribute("style","z-index:3;position:absolute;left:0px;top:0px;width:100%;height:100%");
svg=document.createElementNS("http://www.w3.org/2000/svg","svg");
var impl=document.createElementNS("http://www.w3.org/2000/svg","polygon");
impl.setAttributeNS(null,"points",temp.join(" "));
impl.setAttributeNS(null,"style","fill:none;");
impl.setAttributeNS(null,"stroke",this.color);
impl.setAttributeNS(null,"stroke-width",this.thick);
if(!this.anchor.parentNode){
if(!svg.parentNode){
svg.appendChild(impl);
this.anchor.appendChild(svg);
}
_3f9.appendChild(this.anchor);
}
}else{
if(IlvBrowserInfo.instance.vml){
this.createRectInIE(_3f9,this.anchor,_3fa);
}
}
this.visiable=true;
};
IlvAnchor.prototype.createRectInIE=function(_3fe,_3ff,_400){
if(!_3ff){
return;
}
_3ff.style.zIndex=3;
_3ff.style.left="0";
_3ff.style.top="0";
_3ff.style.position="absolute";
_3ff.style.width="100%";
_3ff.style.height="100%";
var _401=document.createElement("line");
_401.style.behavior="url(#default#VML)";
_401.setAttribute("from",_400[0].join(","));
_401.setAttribute("to",_400[1].join(","));
_401.from=_400[0].join(",");
_401.to=_400[1].join(",");
_401.strokeweight=this.thick;
_401.strokecolor=this.color;
_3ff.appendChild(_401);
var _402=document.createElement("line");
_402.style.behavior="url(#default#VML)";
_402.from=_400[1].join(",");
_402.to=_400[2].join(",");
_402.strokeweight=this.thick;
_402.strokecolor=this.color;
_3ff.appendChild(_402);
var _403=document.createElement("line");
_403.style.behavior="url(#default#VML)";
_403.from=_400[2].join(",");
_403.to=_400[3].join(",");
_403.strokeweight=this.thick;
_403.strokecolor=this.color;
_3ff.appendChild(_403);
var _404=document.createElement("line");
_404.style.behavior="url(#default#VML)";
_404.from=_400[3].join(",");
_404.to=_400[0].join(",");
_404.strokeweight=this.thick;
_404.strokecolor=this.color;
_3ff.appendChild(_404);
_3fe.appendChild(_3ff);
};
IlvAnchor.prototype.remove=function(){
if(this.parentNode&&this.anchor){
this.parentNode.removeChild(this.anchor);
this.anchor=null;
delete (this.anchor);
}
this.visiable=false;
};
IlvAnchor.prototype.contain=function(x,y){
if(x>=this.centerX-this.thick&&x<=this.centerX+this.thick&&y>=this.centerY-this.thick&&y<=this.centerY+this.thick){
return true;
}else{
return false;
}
};
IlvSelectionLink=function(_407,_408,_409,_40a){
this.superConstructor();
this.parent=_407;
this.points=_408;
this.scrollX=0;
this.scrollY=0;
this.lines=[];
this.middles=[];
this.thickness=_409||1;
this.color=_40a||"red";
};
IlvSelectionLink.prototype=new IlvSelection();
IlvSelectionLink.prototype.setClassName("IlvSelectionLink");
IlvSelectionLink.prototype.setOffsets=function(_40b){
this.offsetX=_40b.left;
this.offsetY=_40b.top;
this.width=_40b.width;
this.height=_40b.height;
};
IlvSelectionLink.prototype.isPointInBBox=function(x,y){
if(x>0&&x<this.width&&y>0&&y<this.height){
return true;
}else{
return false;
}
};
IlvSelectionLink.prototype.intersection=function(x1,y1,x2,y2,x3,y3,x4,y4){
var d=(y2-y1)*(x4-x3)-(y4-y3)*(x2-x1);
if(d!=0){
x0=((x2-x1)*(x4-x3)*(y3-y1)+(y2-y1)*(x4-x3)*x1-(y4-y3)*(x2-x1)*x3)/d;
y0=((y2-y1)*(y4-y3)*(x3-x1)+(x2-x1)*(y4-y3)*y1-(x4-x3)*(y2-y1)*y3)/(-d);
if((x0-x1)*(x0-x2)<=0&&(x0-x3)*(x0-x4)<=0&&(y0-y1)*(y0-y2)<=0&&(y0-y3)*(y0-y4)<=0){
return [x0,y0];
}
}
};
IlvSelectionLink.prototype.drawLink=function(){
if(this.points&&this.points.length>0){
var _417=this.points.length;
for(var i=0;i<_417-1;i++){
var _419=this.points[i].x-this.scrollX;
var _41a=this.points[i].y-this.scrollY;
var endX=this.points[i+1].x-this.scrollX;
var endY=this.points[i+1].y-this.scrollY;
if(_419<=0&&endX<=0){
continue;
}
if(_419>=this.width&&endX>=this.width){
continue;
}
if(_41a<=0&&endY<=0){
continue;
}
if(_41a>=this.height&&endY>=this.height){
continue;
}
if(this.isPointInBBox(_419,_41a)&&this.isPointInBBox(endX,endY)){
}else{
if(this.isPointInBBox(_419,_41a)){
var _41d=this.intersection(_419,_41a,endX,endY,0,0,0,this.height);
if(_41d){
endX=_41d[0];
endY=_41d[1];
}else{
_41d=this.intersection(_419,_41a,endX,endY,0,0,this.width,0);
}
if(_41d){
endX=_41d[0];
endY=_41d[1];
}else{
_41d=this.intersection(_419,_41a,endX,endY,0,this.height,this.width,this.height);
}
if(_41d){
endX=_41d[0];
endY=_41d[1];
}else{
_41d=this.intersection(_419,_41a,endX,endY,this.width,0,this.width,this.height);
}
if(_41d){
endX=_41d[0];
endY=_41d[1];
}
}
if(this.isPointInBBox(endX,endY)){
var _41d=this.intersection(_419,_41a,endX,endY,0,0,0,this.height);
if(_41d){
_419=_41d[0];
_41a=_41d[1];
}else{
_41d=this.intersection(_419,_41a,endX,endY,0,0,this.width,0);
}
if(_41d){
_419=_41d[0];
_41a=_41d[1];
}else{
_41d=this.intersection(_419,_41a,endX,endY,0,this.height,this.width,this.height);
}
if(_41d){
_419=_41d[0];
_41a=_41d[1];
}else{
_41d=this.intersection(_419,_41a,endX,endY,this.width,0,this.width,this.height);
}
if(_41d){
_419=_41d[0];
_41a=_41d[1];
}
}
if(!this.isPointInBBox(_419,_41a)&&!this.isPointInBBox(endX,endY)){
var _41d=[];
_41d[0]=this.intersection(_419,_41a,endX,endY,0,0,0,this.height);
_41d[1]=this.intersection(_419,_41a,endX,endY,0,0,this.width,0);
_41d[2]=this.intersection(_419,_41a,endX,endY,0,this.height,this.width,this.height);
_41d[3]=this.intersection(_419,_41a,endX,endY,this.width,0,this.width,this.height);
if(!_41d[0]&&!_41d[1]&&!_41d[2]&&!_41d[3]){
continue;
}
var p=[];
if(_41d[0]){
p.push(_41d[0]);
}
if(_41d[1]){
p.push(_41d[1]);
}
if(_41d[2]){
p.push(_41d[2]);
}
if(_41d[3]){
p.push(_41d[3]);
}
if(p.length==2){
_419=p[0][0];
_41a=p[0][1];
endX=p[1][0];
endY=p[1][1];
}
}
}
this.lines[i]=IlvDrawUtil.drawLine(_419+this.offsetX,_41a+this.offsetY,endX+this.offsetX,endY+this.offsetY,this.thickness,this.color,this.lines[i],this.parent);
}
}
};
IlvSelectionLink.prototype.pointOnLink=function(x,y){
var x=x+this.offsetX;
var y=y+this.offsetY;
if(this.points&&this.points.length>0){
var _421=this.points.length;
for(i=0;i<_421-1;i++){
var x1=Math.floor(this.points[i].x);
var y1=Math.floor(this.points[i].y);
var x2=Math.floor(this.points[i+1].x);
var y2=Math.floor(this.points[i+1].y);
var minX=Math.min(x1,x2);
var maxX=Math.max(x1,x2);
var minY=Math.min(y1,y2);
var maxY=Math.max(y1,y2);
if((x>=minX)&&(x<=maxX)&&(y>=minY)&&(y<=maxY)){
var a=y*(x2-x1)+x1*(y2-y1);
var b=x*(y2-y1)+y1*(x2-x1);
if(Math.abs(a-b)<=150){
return i+1;
}
}
}
return -1;
}
return -1;
};
IlvSelectionLink.prototype.overMiddles=function(x,y){
var left=x+this.offsetX;
var top=y+this.offsetY;
if(this.middles.length==0){
return false;
}
for(var i=0;i<this.middles.length;i++){
if(this.middles[i]&&this.middles[i].contain(left,top)){
this.middleIndex=i;
return true;
}
}
this.middleIndex=-1;
return false;
};
IlvSelectionLink.prototype.setScrollPosition=function(_431,_432){
this.scrollX=_431;
this.scrollY=_432;
this.updateLocation();
};
IlvSelectionLink.prototype.updateLocation=function(){
this.remove();
this.draw(false);
};
IlvSelectionLink.prototype.draw=function(_433){
this.showHandles=_433;
this.drawLink();
if(this.showHandles){
this.drawHandles(this.thickness,this.color);
}
};
IlvSelectionLink.prototype.drawHandles=function(_434,_435){
this.handleThick=_434||1;
this.handleColor=_435||"red";
var psX=this.points[0].x-this.scrollX;
var psY=this.points[0].y-this.scrollY;
if(this.isPointInBBox(psX,psY)){
this.start=new IlvAnchor(psX,psY,this.handleThick,this.handleColor);
this.start.draw(this.parent);
}
if(this.points.length>2){
for(var i=1;i<this.points.length-1;i++){
var x=this.points[i].x-this.scrollX;
var y=this.points[i].y-this.scrollY;
if(this.isPointInBBox(x,y)){
this.middles[i-1]=new IlvAnchor(x,y,this.handleThick,this.handleColor);
this.middles[i-1].draw(this.parent);
}
}
}
var _43b=this.points.length-1;
var peX=this.points[_43b].x-this.scrollX;
var peY=this.points[_43b].y-this.scrollY;
if(this.isPointInBBox(peX,peY)){
this.end=new IlvAnchor(peX,peY,this.handleThick,this.handleColor);
this.end.draw(this.parent);
}
};
IlvSelectionLink.prototype.overStart=function(x,y){
var left=x+this.offsetX;
var top=y+this.offsetY;
if(this.start&&this.start.contain(left,top)){
return true;
}
return false;
};
IlvSelectionLink.prototype.overEnd=function(x,y){
var left=x+this.offsetX;
var top=y+this.offsetY;
if(this.end&&this.end.contain(left,top)){
return true;
}
return false;
};
IlvSelectionLink.prototype.removeAnchors=function(){
if(this.start){
this.start.remove();
}
for(var i=0;i<this.middles.length;i++){
if(this.middles[i]){
this.middles[i].remove();
}
}
this.middles=[];
if(this.end){
this.end.remove();
}
};
IlvSelectionLink.prototype.removeLines=function(){
if(this.lines.length>0){
for(i=0;i<this.lines.length;i++){
IlvDrawUtil.releaseLine(this.lines[i]);
this.lines[i]=null;
}
}
this.lines.length=0;
};
IlvSelectionLink.prototype.remove=function(){
this.removeLines();
this.removeAnchors();
};
IlvLinkInteractor=function(){
this.superConstructor();
this.insertIndex=-1;
this.tempPoints=null;
this.cursor="default";
this.actionName="moveLink";
this.modifier="ctrl";
this.tempAnchor=new IlvAnchor(0,0);
IlvLinkInteractor.exist=true;
};
IlvLinkInteractor.prototype=new IlvInteractor();
IlvLinkInteractor.prototype.setClassName("IlvLinkInteractor");
IlvLinkInteractor.prototype.setActionName=function(_447){
this.actionName=_447;
};
IlvLinkInteractor.prototype.setView=function(view){
this.view=view;
if(this.view){
this.view.showLinkHandlers=true;
}
};
IlvLinkInteractor.prototype.mouseDown=function(e){
if(!this.isDragging&&e.button!=2){
this.isDragging=true;
}
return false;
};
IlvLinkInteractor.prototype.mouseDrag=function(e){
if(this.isDragging){
this.clearTimer();
var _44b=this.view.getSelectionManager();
var _44c=_44b.getLineWidth();
var _44d=_44b.getLineColor();
if(this.activeLink){
var _44e=this.activeLink.parent;
var _44f=this.activeLink.offsetX-this.activeLink.scrollX;
var _450=this.activeLink.offsetY-this.activeLink.scrollY;
var _451={x:e.mouseX+_44f,y:e.mouseY+_450};
this.activeLink.removeLines();
var _452=this.activeLink.points;
if(this.moveEnd){
var _453=_452[0].x-this.activeLink.scrollX;
var _454=_452[0].y-this.activeLink.scrollY;
this.line=IlvDrawUtil.drawLine(_453,_454,e.mouseX+_44f,e.mouseY+_450,_44c,_44d,this.line,_44e);
}
if(this.moveStart){
var _455=_452[_452.length-1];
var endX=_455.x-this.activeLink.scrollX;
var endY=_455.y-this.activeLink.scrollY;
this.line=IlvDrawUtil.drawLine(e.mouseX+_44f,e.mouseY+_450,endX,endY,_44c,_44d,this.line,_44e);
}
if(this.moveMiddles){
var _458=this.activeLink.middleIndex;
if(_458>-1){
_452[_458+1]=_451;
}
this.activeLink.points=_452;
this.activeLink.drawLink();
}
if(this.tempAnchor.visiable){
this.moveMiddles=true;
if(this.tempPoints==null){
if(this.insertIndex>-1){
var _459=_452.slice(0,this.insertIndex);
var _45a=_452.slice(this.insertIndex);
_459.push(_451);
this.tempPoints=_459.concat(_45a);
}
}else{
this.tempPoints[this.insertIndex]=_451;
}
this.activeLink.points=this.tempPoints;
this.activeLink.drawLink();
}
if(this.moveEnd||this.moveStart){
var _45b=this;
this.timer=setTimeout(function(){
_45b.selectObject(e.mouseX,e.mouseY);
_45b.timer=null;
},150);
}
}
}
return false;
};
IlvLinkInteractor.prototype.mouseUp=function(e){
if(this.isDragging&&this.actionName&&this.activeLink){
if(eval("e."+this.modifier+"Key")==true&&this.activeLink.middleIndex>-1){
this.activeLink.points.splice(this.activeLink.middleIndex+1,1);
}
var _45d=[];
var _45e=this.activeLink.offsetX;
var _45f=this.activeLink.offsetY;
for(var i=0;i<this.activeLink.points.length;i++){
var x=this.activeLink.points[i].x-_45e;
var y=this.activeLink.points[i].y-_45f;
var _463=x+" "+y;
_45d.push(_463);
}
var _464=[this.index,this.moveStart,this.moveEnd,this.moveMiddles,_45d.join(":")];
var _465=this.view.getSelectionManager();
_465.forceUpdate();
if(((this.moveStart||this.moveEnd)&&this.doSelectObject===true)||(this.moveMiddles===true)){
this.view.performAction(this.actionName,_464,"getCapabilities");
}
this.reset();
}
return false;
};
IlvLinkInteractor.prototype.mouseMove=function(e){
this.moveStart=false;
this.moveEnd=false;
if(this.tempAnchor.visiable){
this.tempAnchor.remove();
}
if(this.isOverStartHandler(e)||this.isOverEndHandler(e)||this.isOverMiddlesHandler(e)){
this.view.setCursor("pointer");
return true;
}else{
var _467=this.view.getSelectionManager();
if(_467){
for(var i=0;i<_467.linkList.length;i++){
this.insertIndex=_467.linkList[i].pointOnLink(e.mouseX,e.mouseY);
if(this.insertIndex>-1){
this.view.setCursor("pointer");
this.activeLink=_467.linkList[i];
this.index=i;
var _469=this.activeLink.offsetX-this.activeLink.scrollX;
var _46a=this.activeLink.offsetY-this.activeLink.scrollY;
this.tempAnchor.setCenter(e.mouseX+_469,e.mouseY+_46a);
this.tempAnchor.draw(this.activeLink.parent,this.view);
return true;
}else{
if(!this.view.oldCursor){
this.view.setCursor(this.cursor);
}
}
}
}
}
return false;
};
IlvLinkInteractor.prototype.setAddRemovePointModifier=function(_46b){
this.modifier=_46b;
};
IlvLinkInteractor.prototype.isOverStartHandler=function(e){
var _46d=this.view.getSelectionManager();
var vBox=this.view.getBounds();
if(_46d){
this.index=_46d.overLinkStart(e.mouseX,e.mouseY);
if(this.index>-1){
this.activeLink=_46d.linkList[this.index];
this.moveStart=true;
return true;
}
}
return false;
};
IlvLinkInteractor.prototype.isOverMiddlesHandler=function(e){
var _470=this.view.getSelectionManager();
if(_470){
this.index=_470.overLinkMiddles(e.mouseX,e.mouseY);
if(this.index>-1){
this.activeLink=_470.linkList[this.index];
this.moveMiddles=true;
return true;
}
}
return false;
};
IlvLinkInteractor.prototype.isOverEndHandler=function(e){
var _472=this.view.getSelectionManager();
if(_472){
this.index=_472.overLinkEnd(e.mouseX,e.mouseY);
if(this.index>-1){
this.activeLink=_472.linkList[this.index];
this.moveEnd=true;
return true;
}
}
return false;
};
IlvLinkInteractor.prototype.reset=function(){
this.clearTimer();
if(this.line){
IlvDrawUtil.releaseLine(this.line);
}
if(IlvBrowserInfo.instance.ie6up){
this.line=null;
}
if(this.activeLink){
this.activeLink.remove();
}
if(this.tempAnchor.visiable){
this.tempAnchor.remove();
}
this.isDragging=false;
this.moveStart=false;
this.moveEnd=false;
this.moveMiddles=false;
this.tempPoints=null;
this.insertIndex=-1;
this.doSelectObject=false;
};
IlvLinkInteractor.prototype.selectObject=function(x,y){
this.view.getSelectionManager().selectOne(x,y,false);
this.doSelectObject=true;
};
IlvLinkInteractor.prototype.clearTimer=function(){
if(this.timer){
clearTimeout(this.timer);
this.timer=null;
}
};
IlvInteractorGroup=function(){
this.superConstructor();
this.interactors=[];
this.selectPan=["SelectInteractor","PanInteractor"];
this.selectZoom=["SelectInteractor","ZoomInteractor"];
this.selectScroll=["SelectInteractor","SheetScrollInteractor"];
this.hitmapGroup=[];
this.hitmapGroup.push(this.selectPan);
this.hitmapGroup.push(this.selectZoom);
this.hitmapGroup.push(this.selectScroll);
};
IlvInteractorGroup.prototype=new IlvInteractor();
IlvInteractorGroup.prototype.setClassName("IlvInteractorGroup");
IlvInteractorGroup.prototype.setViewInternal=function(view){
var _476=[];
for(var i=0;i<this.interactors.length;i++){
var _478=this.interactors[i];
if(_478&&(typeof _478.addHitInfotype==="function")){
_478.addHitInfotype(view);
}
}
for(var i=0;i<this.interactors.length;i++){
var _478=this.interactors[i];
if(_478){
_478.setViewInternal(view);
if(_478.getClassName()=="IlvInterceptInteractor"&&_478.interactor){
_476.push(_478.interactor.getClassName());
}else{
_476.push(_478.getClassName());
}
}
}
if(view==null){
return;
}
this.view=view;
var _479=_476.join("");
for(var i=0;i<this.hitmapGroup.length;i++){
this.generateHitmap(view,_479,this.hitmapGroup[i]);
}
};
IlvInteractorGroup.prototype.addHitmapGroup=function(_47a){
this.hitmapGroup.push(_47a);
};
IlvInteractorGroup.prototype.generateHitmap=function(view,_47c,_47d){
for(var i=0;i<_47d.length;i++){
if(_47c.indexOf(_47d[i])<0){
return;
}
}
if(view!=null){
if(!view.hitmap){
if(typeof IlvHitmap!="undefined"){
view.hitmap=new IlvHitmap();
if(view.capabilitiesLoaded){
view.updateHitmap();
}
}
}
this.isMultiInteractor=true;
this.view.isMultiInteractor=true;
if(this.cursor){
this.view.setCursor(this.cursor);
}else{
this.view.setCursor("default");
}
}
};
IlvInteractorGroup.prototype.addInteractor=function(_47f){
this.interactors.push(_47f);
};
IlvInteractorGroup.prototype.removeInteractor=function(_480){
for(var i=0;i<this.interactors.length;i++){
if(this.interactors[i]==_480){
this.interactors.splice(i,1);
return;
}
}
};
IlvInteractorGroup.prototype.mouseDown=function(e){
for(var i=0;i<this.interactors.length;i++){
var _484=this.interactors[i];
if(!_484){
continue;
}
if(_484.mouseDown){
_484.mouseDown(e);
}else{
if(_484.onmousedown){
_484.onmousedown(e);
}
}
}
return false;
};
IlvInteractorGroup.prototype.mouseDrag=function(e){
for(var i=0;i<this.interactors.length;i++){
var _487=this.interactors[i];
if(!_487){
continue;
}
if(_487.mouseDrag){
_487.mouseDrag(e);
}else{
if(_487.onmousemove){
_487.onmousemove(e);
}
}
}
return false;
};
IlvInteractorGroup.prototype.mouseUp=function(e){
for(var i=0;i<this.interactors.length;i++){
var _48a=this.interactors[i];
if(!_48a){
continue;
}
if(_48a.mouseUp){
_48a.mouseUp(e);
}else{
if(_48a.onmouseup){
_48a.onmouseup(e);
}
}
}
return false;
};
IlvInteractorGroup.prototype.mouseMove=function(e){
for(var i=0;i<this.interactors.length;i++){
var _48d=this.interactors[i];
if(!_48d){
continue;
}
if(_48d.mouseMove){
if(_48d.mouseMove(e)){
return true;
}
}else{
if(_48d.onmousemove){
if(_48d.onmousemove(e)){
return true;
}
}
}
}
return false;
};
IlvInteractorGroup.prototype.mouseWheel=function(e){
for(var i=0;i<this.interactors.length;i++){
var _490=this.interactors[i];
if(!_490){
continue;
}
if(_490.mouseWheel){
_490.mouseWheel(e);
}
}
};
IlvInteractorGroup.prototype.keyDown=function(e){
for(var i=0;i<this.interactors.length;i++){
var _493=this.interactors[i];
if(!_493){
continue;
}
if(_493.keyDown){
_493.keyDown(e);
}
}
return false;
};
IlvInteractorGroup.prototype.keyUp=function(e){
for(var i=0;i<this.interactors.length;i++){
var _496=this.interactors[i];
if(!_496){
continue;
}
if(_496.keyUp){
_496.keyUp(e);
}
}
return false;
};
IlvInteractorGroup.prototype.mouseOut=function(e){
for(var i=0;i<this.interactors.length;i++){
var _499=this.interactors[i];
if(!_499){
continue;
}
if(_499.mouseOut){
if(_499.mouseOut(e)){
return true;
}
}else{
if(_499.onmouseout){
if(_499.onmouseout(e)){
return true;
}
}
}
}
return false;
};
IlvAOP=function(_49a){
_49a.yield=null;
_49a.rv={};
var _49b=null;
var _49c=null;
var _49d=null;
function handleCallBack(_49e,_49f,f,_4a1){
if(typeof f!="function"){
return false;
}
return f.apply(_49f,_4a1);
}
_49a.before=function(_4a2,f){
if(_49b==null){
_49b=eval("this."+_4a2);
}
if(f!=null){
this[_4a2]=function(){
var _4a4=handleCallBack(_49a,this,f,arguments);
if(_4a4===false){
return false;
}
return _49b.apply(this,arguments);
};
}else{
this[_4a2]=function(){
return _49b.apply(this,arguments);
};
}
};
_49a.after=function(_4a5,f){
if(_49c==null){
_49c=eval("this."+_4a5);
}
if(f!=null){
this[_4a5]=function(){
this.rv[_4a5]=_49c.apply(this,arguments);
handleCallBack(_49a,this,f,arguments);
};
}else{
this[_4a5]=function(){
return _49c.apply(this,arguments);
};
}
};
_49a.override=function(_4a7,f){
if(!_49d){
_49d=eval("this."+_4a7);
}
if(f){
this[_4a7]=function(){
this.yield=_49d;
return f.apply(this,arguments);
};
}else{
this[_4a7]=function(){
return _49d.apply(this,arguments);
};
}
};
};
IlvInterceptInteractor=function(_4a9){
this.superConstructor();
this.interactor=_4a9;
IlvAOP(this.interactor);
};
IlvInterceptInteractor.prototype=new IlvInteractor();
IlvInterceptInteractor.prototype.setClassName("IlvInterceptInteractor");
IlvInterceptInteractor.prototype.setViewInternal=function(view){
this.interactor.setViewInternal(view);
};
IlvInterceptInteractor.prototype.getInteractor=function(){
return this.interactor;
};
IlvInterceptInteractor.prototype.setBeforeHandler=function(_4ab,_4ac){
this.interactor.before(_4ab,_4ac);
};
IlvInterceptInteractor.prototype.setAfterHandler=function(_4ad,_4ae){
this.interactor.after(_4ad,_4ae);
};
IlvInterceptInteractor.prototype.setOverrideHandler=function(_4af,_4b0){
this.interactor.override(_4af,_4b0);
};
IlvInterceptInteractor.prototype.mouseDown=function(e){
if(this.interactor&&this.interactor.mouseDown){
return this.interactor.mouseDown(e,this.interactor.view);
}
return false;
};
IlvInterceptInteractor.prototype.mouseDrag=function(e){
if(this.interactor&&this.interactor.mouseDrag){
return this.interactor.mouseDrag(e,this.interactor.view);
}
return false;
};
IlvInterceptInteractor.prototype.mouseUp=function(e){
if(this.interactor&&this.interactor.mouseUp){
return this.interactor.mouseUp(e,this.interactor.view);
}
return false;
};
IlvInterceptInteractor.prototype.mouseMove=function(e){
if(this.interactor&&this.interactor.mouseMove){
return this.interactor.mouseMove(e,this.interactor.view);
}
return false;
};
IlvInterceptInteractor.prototype.mouseWheel=function(e){
if(this.interactor&&this.interactor.mouseWheel){
return this.interactor.mouseWheel(e,this.interactor.view);
}
return false;
};
IlvInterceptInteractor.prototype.keyDown=function(e){
if(this.interactor&&this.interactor.keyDown){
return this.interactor.keyDown(e,this.interactor.view);
}
return false;
};
IlvInterceptInteractor.prototype.mouseOut=function(e){
if(this.interactor&&this.interactor.mouseOut){
return this.interactor.mouseOut(e,this.interactor.view);
}
return false;
};
IlvAjaxInteractor=function(){
this.superConstructor();
};
IlvAjaxInteractor.prototype=new IlvInteractor();
IlvAjaxInteractor.prototype.setClassName("IlvAjaxInteractor");
IlvAjaxInteractor.prototype.setViewInternal=function(view){
this.view=view;
};
IlvAjaxInteractor.prototype.setRender=function(_4b9){
this.render=_4b9;
};
IlvAjaxInteractor.prototype.mouseDown=function(e){
var _4bb=this.render;
jsf.ajax.request(this,"click",{render:_4bb});
return false;
};
IlvCursorChangeInteractor=function(){
this.superConstructor();
};
IlvCursorChangeInteractor.prototype=new IlvInteractor();
IlvCursorChangeInteractor.prototype.setClassName("IlvCursorChangeInteractor");
IlvCursorChangeInteractor.prototype.addHitInfotype=function(view){
view&&view.putHitInfoType("cursor");
};
IlvCursorChangeInteractor.prototype.setView=function(view){
if(view!=null){
this.addHitInfotype(view);
if(!view.hitmap){
view.hitmap=new IlvHitmap();
if(view.capabilitiesLoaded){
view.updateHitmap();
}
}
}
};
IlvCursorChangeInteractor.prototype.mouseMove=function(e){
var x=e.mouseX,y=e.mouseY;
var v=this.view;
var h=v.hitmap;
if(!h){
return;
}
var _4c3=this.tolerance?h.hittest(x,y,this.tolerance):h.hittest(x,y);
v.oldCursor=v.getCursor();
if(_4c3==0){
if(!this.defaultCursor){
this.defaultCursor=v.oldCursor;
}
v.setCursor(this.defaultCursor);
}
if(!this.cursorChanged){
if(h.hitInfos&&h.hitInfos.cursor&&h.hitInfos.cursor[_4c3]){
v.setCursor(h.hitInfos.cursor[_4c3]);
this.cursorChanged=true;
}else{
if(_4c3>0){
v.setCursor("pointer");
this.cursorChanged=true;
}
}
}else{
if(this.cursorChanged){
v.setCursor(v.oldCursor);
this.cursorChanged=false;
}
}
};
IlvPopupMenuFactory=function(){
this.superConstructor();
};
IlvPopupMenuFactory.prototype=new IlvObject();
IlvPopupMenuFactory.prototype.setClassName("IlvPopupMenuFactory");
IlvPopupMenuFactory.prototype.dispose=function(){
this.superInvoke("dispose");
this._loader=null;
this._view=null;
if(this.factory){
this.factory.dispose();
}
};
IlvPopupMenuFactory.prototype.displayPopupMenu=function(view,_4c5,_4c6){
IlvAbstractPopupMenu.prototype.showAgentContextualMenu=false;
var _4c7=this.popupMenu.createRequestURL(view,_4c5,_4c6);
if(!_4c7){
return;
}
this._view=view;
if(!this._loader){
this._loader=new IlvAjax.JSRequest(this,this.onload);
}
this._loader.send(_4c7);
return false;
};
IlvPopupMenuFactory.prototype.create=function(data){
var _4c9=data.menu;
if(!_4c9){
return null;
}
menu=this.read(_4c9);
menu.popupMenu=this.popupMenu;
menu.popupMenu._triggerLeft=data.left;
menu.popupMenu._triggerTop=data.top;
return menu;
};
IlvPopupMenuFactory.prototype.getRequestType=function(){
return this._requestType||"popupmenurequested";
};
IlvPopupMenuFactory.prototype.setRequestType=function(_4ca){
this._requestType=_4ca;
};
IlvPopupMenuFactory.prototype.read=function(_4cb){
var type=_4cb[0];
if(type=="Menu"){
var menu=this.readMenu(_4cb);
var _4ce=0,_4cf=0;
var i,imax=_4cb.length;
for(i=4;i<imax;i++){
menu.add(this.read(_4cb[i]));
}
return menu;
}else{
if(type=="MenuItem"){
var item=this.readMenuItem(_4cb);
item._view=this._view;
return item;
}else{
alert(IlvUtil.formatStr(jviews.messages.IlvPopupMenuFactory.notToRead,type));
}
}
return null;
};
IlvPopupMenuFactory.prototype.readAction=function(item,_4d4){
var type=_4d4[0];
if(type=="JS"){
item.setAction(eval(_4d4[1]));
}else{
if(type=="Servlet"){
var _4d6=_4d4[1];
var _4d7=_4d4[2];
var _4d8=_4d4.slice(3);
item.setAction(function(){
item.performServerAction(_4d6,_4d8,_4d7);
});
}
}
};
IlvPopupMenuFactory.prototype.onload=function(_4d9){
this.asyncDisplayPopupMenu(_4d9);
};
IlvPopupMenuFactory.prototype.asyncDisplayPopupMenu=function(data){
var view=this._view;
var _4dc=view.getLocation();
var res=this.popupMenu.imageToPageCoordinateSystem(view,data.left,data.top);
this.popupMenu.hidePopupMenu();
var menu=this.create(data);
this.popupMenu.onModelLoaded();
this.popupMenu.internalDisplayPopupMenu(res.x,res.y,menu);
};
IlvPopupMenuFactory.prototype.readMenu=function(_4df,path){
var menu;
if(!IlvMenu._reusable){
menu=new IlvMenu(_4df[1],_4df[2]);
menu.setBaseTextDirection(this.popupMenu.getBaseTextDirection());
}else{
menu=IlvMenu._reusable;
IlvMenu._reusable=menu._next;
menu._next=null;
menu._child=[];
menu._parent=null;
menu._isExpanded=false;
menu._isHighlighted=false;
menu._action=null;
menu.setBaseTextDirection(this.popupMenu.getBaseTextDirection());
menu.setLabel(_4df[1]);
menu.setEnabled(_4df[2]);
}
var _4e2=_4df[3];
if(_4e2!=null&&_4e2!="no"){
menu._img=_4e2;
}
return menu;
};
IlvPopupMenuFactory.prototype.readMenuItem=function(_4e3){
var item;
if(!IlvMenuItem._reusable){
item=new IlvMenuItem(_4e3[1],_4e3[3]);
item.setBaseTextDirection(this.popupMenu.getBaseTextDirection());
this.readAction(item,_4e3[2]);
if(_4e3[4]!="no"){
item._img=_4e3[4];
}
item._path=_4e3[5];
return item;
}else{
item=IlvMenuItem._reusable;
IlvMenuItem._reusable=item._next;
item._next=null;
item._isHighlighted=false;
item._img=null;
item._action=null;
item.setBaseTextDirection(this.popupMenu.getBaseTextDirection());
item.setLabel(_4e3[1]);
item.setEnabled(_4e3[3]);
if(_4e3[4]!="no"){
item._img=_4e3[4];
}
item._path=_4e3[5];
this.readAction(item,_4e3[2]);
return item;
}
};
IlvAbstractPopupMenu=function(init){
if(init){
this.superConstructor();
IlvAbstractPopupMenu.prototype.showAgentContextualMenu=true;
if(document.body.addEventListener){
document.body.addEventListener("contextmenu",IlvAbstractPopupMenu.onContextMenuHandler,false);
}else{
document.oncontextmenu=function(){
var res=IlvAbstractPopupMenu.prototype.showAgentContextualMenu;
if(!res){
window.event.cancelBubble=true;
window.event.returnValue=res;
}
IlvAbstractPopupMenu.prototype.showAgentContextualMenu=true;
return res;
};
}
this.dynamic=true;
this.factory=new IlvPopupMenuFactory();
this.factory.popupMenu=this;
this.baseTextDirection="";
}
};
IlvAbstractPopupMenu.prototype=new IlvObject();
IlvAbstractPopupMenu.prototype.setClassName("IlvAbstractPopupMenu");
IlvAbstractPopupMenu.prototype.setBaseTextDirection=function(_4e7){
this.baseTextDirection=_4e7;
};
IlvAbstractPopupMenu.prototype.getBaseTextDirection=function(){
return this.baseTextDirection;
};
IlvAbstractPopupMenu.prototype.dispose=function(){
if(this.eventPanel){
this.eventPanel.dispose();
}
this._view=null;
if(this.factory){
this.factory.dispose();
}
if(this.images){
this.imagesLoadedCount=0;
for(var i=0;i<this.images.length;i++){
this.images[i]=null;
}
this.images.length=0;
}
this.superInvoke("dispose");
};
IlvAbstractPopupMenu.onblur=function(){
var m=IlvAbstractPopupMenu._openMenu;
if(m&&m.popupMenu){
m.popupMenu.hidePopupMenu();
}
};
IlvAbstractPopupMenu.onContextMenuHandler=function(_4ea){
var res=IlvAbstractPopupMenu.prototype.showAgentContextualMenu;
if(!res){
_4ea.preventDefault();
}
IlvAbstractPopupMenu.prototype.showAgentContextualMenu=true;
return res;
};
IlvAbstractPopupMenu.onContextMenuHandler2=function(_4ec){
IlvAbstractPopupMenu.prototype.showAgentContextualMenu=false;
};
IlvAbstractPopupMenu.onModelLoaded=function(){
};
IlvAbstractPopupMenu.prototype.createIEEventPanel=function(){
if(IlvBrowserInfo.instance.ie5up&&!this.eventPanel){
this.eventPanel=new IlvDynPanel();
this.eventPanel.setLocation(0,0);
if(IlvBrowserInfo.instance.ie7up){
this.eventPanel._div.style.width="100%";
this.eventPanel._div.style.height="100%";
}else{
this.eventPanel._div.style.width=document.body.clientWidth+"px";
this.eventPanel._div.style.height=document.body.clientHeight+"px";
var eh=this.eventPanel;
window.attachEvent("onresize",function(){
eh._div.style.width=document.body.clientWidth+"px";
eh._div.style.height=document.body.clientHeight+"px";
});
}
this.eventPanel.setZIndex(9);
var p=this.eventPanel;
var _4ef=this;
this.eventPanel.getMouseEventSource().onmouseup=function(_4f0){
_4ef.hidePopupMenu();
if(IlvBrowserInfo.instance.ie5up){
var v=_4ef._view;
var _4f0=v.eventPanel.enhanceEvent();
var x=_4f0.mouseX;
var y=_4f0.mouseY;
var _4f4=(x<0||x>v.getWidth()||y<0||y>v.getHeight());
IlvAbstractPopupMenu.prototype.showAgentContextualMenu=_4f4;
}
};
}
};
IlvAbstractPopupMenu.prototype.displayPopupMenu=function(view,_4f6,_4f7){
IlvAbstractPopupMenu.prototype.showAgentContextualMenu=false;
if(_4f6.stopPropagation){
_4f6.stopPropagation();
}
this._view=view;
if(!this.isPopupTrigger(_4f6)){
return true;
}
this._triggerLeft=_4f6.mouseX;
this._triggerTop=_4f6.mouseY;
if(this.dynamic){
return this.factory.displayPopupMenu(view,_4f6,_4f7);
}else{
var x=_4f6.mouseX;
var y=_4f6.mouseY;
var res=this.imageToPageCoordinateSystem(view,x,y);
this.hidePopupMenu();
this.internalDisplayPopupMenu(res.x,res.y,this.menu);
}
};
IlvAbstractPopupMenu.prototype.internalResetEvent=function(){
IlvAbstractPopupMenu._documentOnMouseUp=document.onmouseup;
};
IlvAbstractPopupMenu.prototype.imageToPageCoordinateSystem=function(view,x,y){
var _4fe=view.getLocation();
return {x:x+_4fe.left,y:y+_4fe.top};
};
IlvAbstractPopupMenu.prototype.internalDisplayPopupMenu=function(x,y,menu){
var view=this._view;
IlvAbstractPopupMenu.prototype.showAgentContextualMenu=false;
if(menu&&menu.getChildrenCount()>0){
menu.createHTMLContainer();
menu._delegate.setZIndex(10);
this.location=[x,y];
this.menu=menu;
if(IlvBrowserInfo.instance.ie5up){
this.internalDisplayPopupMenu2(x,y,menu);
}else{
this.preloadImages(menu);
}
}
};
IlvAbstractPopupMenu.prototype.preloadImages=function(menu){
this.images=this.getImages(menu);
this.imagesLoadedCount=this.images.length;
if(this.imagesLoadedCount==0){
this.internalDisplayPopupMenu2(this.location[0],this.location[1],this.menu);
}else{
for(var i=0;i<this.images.length;i++){
var _505=new Image();
_505.view=this;
_505.onload=IlvAbstractPopupMenu.offscreenLoadListener;
_505.onabort=IlvAbstractPopupMenu.offscreenLoadListener;
_505.onerror=IlvAbstractPopupMenu.offscreenLoadListener;
_505.src=this.images[i];
}
}
};
IlvAbstractPopupMenu.prototype.loadHandler=function(){
this.imagesLoadedCount--;
if(this.imagesLoadedCount==0){
this.internalDisplayPopupMenu2(this.location[0],this.location[1],this.menu);
}
};
IlvAbstractPopupMenu.prototype.getImages=function(menu){
var arr=[];
if(menu==null){
return arr;
}
if(menu.getIcon()){
arr.push(menu.getIcon());
}
var _508=menu._child;
if(_508!=null){
for(var i=0;i<_508.length;i++){
arr=arr.concat(this.getImages(_508[i]));
}
}
return arr;
};
IlvAbstractPopupMenu.offscreenLoadListener=function(){
var view=this.view;
if(!view){
return;
}
this.onabort=null;
this.onerror=null;
this.onload=null;
view.loadHandler();
this.view=null;
};
IlvAbstractPopupMenu.prototype.internalDisplayPopupMenu2=function(x,y,menu){
menu.setLocation(x,y);
menu.setVisible(true);
IlvAbstractPopupMenu._openMenu=menu;
if(IlvBrowserInfo.instance.ie5up){
this.createIEEventPanel();
if(this.eventPanel){
this.eventPanel.setVisible(true);
}
this._onscroll=document.body.onscroll;
var _50e=this.eventPanel;
document.body.onscroll=function(){
var doc=document;
var de=doc.documentElement.clientWidth?doc.documentElement:doc.body;
_50e.setLocation(0,de.scrollTop);
};
}else{
IlvAbstractPopupMenu._documentOnMouseUp=document.onmouseup;
var _511=this;
document.onmouseup=function(_512){
_511.hidePopupMenu();
};
}
};
IlvAbstractPopupMenu.prototype.createRequestURL=function(view,_514,_515){
};
IlvAbstractPopupMenu.prototype.hidePopupMenu=function(){
if(IlvAbstractPopupMenu._openMenu){
IlvAbstractPopupMenu.prototype.showAgentContextualMenu=true;
if(IlvBrowserInfo.instance.ie5up){
if(this.eventPanel){
this.eventPanel.setVisible(false);
}
if(this._onscroll){
document.body.onscroll=this._onscroll;
this._onscroll=null;
}
}
if(IlvAbstractPopupMenu._documentOnMouseUp){
document.onmouseup=IlvAbstractPopupMenu._documentOnMouseUp;
}else{
document.onmouseup=null;
}
IlvAbstractPopupMenu._openMenu.setVisible(false);
if(this.dynamic){
IlvAbstractPopupMenu._openMenu.recycle();
}else{
this.deselectAll(IlvAbstractPopupMenu._openMenu);
}
IlvAbstractPopupMenu._openMenu=null;
return true;
}else{
return false;
}
};
IlvAbstractPopupMenu.prototype.performServerAction=function(_516,_517,_518){
var view=this.view;
if(view!=null&&_516!=null){
view.performAction(_516,_517,_518);
}
};
IlvAbstractPopupMenu.prototype.deselectAll=function(menu){
menu.setHighlighted(false);
for(var i=0;i<menu._child.length;i++){
menu._child[i].setHighlighted(false);
if(menu._child[i].setExpanded){
this.deselectAll(menu._child[i]);
}
}
};
IlvAbstractPopupMenu.prototype.setViewInternal=function(view){
var src;
if(this.view){
if(document.addEventListener){
src=this.view.eventPanel.getMouseEventSource();
if(src){
src.removeEventListener("contextmenu",IlvAbstractPopupMenu.onContextMenuHandler2,false);
}
}
}
this.view=view;
if(view){
src=view.eventPanel.getMouseEventSource();
if(document.addEventListener){
if(src){
src.addEventListener("contextmenu",IlvAbstractPopupMenu.onContextMenuHandler2,false);
}else{
var l=function(view){
var src=view.eventPanel.getMouseEventSource();
src.addEventListener("contextmenu",IlvAbstractPopupMenu.onContextMenuHandler2,false);
if(view.removeCapabilitiesOnLoadListener){
view.removeCapabilitiesOnLoadListener(l);
}else{
if(view.removeCapabilitiesLoadListener){
view.removeCapabilitiesLoadListener(l);
}
}
};
if(view.addCapabilitiesOnLoadListener){
view.addCapabilitiesOnLoadListener(l);
}else{
if(view.addCapabilitiesLoadListener){
view.addCapabilitiesLoadListener(l);
}
}
}
}
}
};
IlvAbstractPopupMenu.prototype.setMenu=function(menu){
if(this.menu!=null){
menu.popupMenu=null;
}
this.menu=menu;
if(menu!=null){
this.setDynamic(false);
menu.popupMenu=this;
}else{
this.setDynamic(true);
}
};
IlvAbstractPopupMenu.prototype.getMenu=function(){
return this.menu;
};
IlvAbstractPopupMenu.prototype.setDynamic=function(_522){
this.dynamic=_522;
};
IlvAbstractPopupMenu.prototype.isDynamic=function(){
return this.dynamic;
};
IlvAbstractPopupMenu.prototype.getItemStyleClass=function(){
return this.itemStyleClass;
};
IlvAbstractPopupMenu.prototype.setItemStyleClass=function(_523){
this.itemStyleClass=_523;
};
IlvAbstractPopupMenu.prototype.getItemHighlightedStyleClass=function(){
return this.itemHighlightedStyleClass;
};
IlvAbstractPopupMenu.prototype.setItemHighlightedStyleClass=function(_524){
this.itemHighlightedStyleClass=_524;
};
IlvAbstractPopupMenu.prototype.getItemDisabledStyleClass=function(){
return this.itemDisabledStyleClass;
};
IlvAbstractPopupMenu.prototype.setItemDisabledStyleClass=function(_525){
this.itemDisabledStyleClass=_525;
};
IlvAbstractPopupMenu.prototype.getSubMenuIcon=function(){
if(this.subMenuIcon==undefined){
this.subMenuIcon=IlvConstants.ilvImagePath+jviews.messages.IlvAbstractPopupMenu.subMenuIcon;
}
return this.subMenuIcon;
};
IlvAbstractPopupMenu.prototype.setSubmenuIcon=function(_526){
this.subMenuIcon=_526;
};
IlvAbstractPopupMenu.prototype.isPopupTrigger=function(_527){
return _527.button==2;
};
IlvMenuItem=function(_528,_529,_52a,_52b,path){
if(typeof (_528)=="undefined"){
return;
}
this.superConstructor();
if(typeof (_529)=="undefined"){
this._isEnabled=true;
}else{
this._isEnabled=_529;
}
this._label=_528;
if(_52a!=null){
this.setAction(_52a);
}
if(_52b==""){
this._img=null;
}else{
this._img=_52b;
}
if(path!=null){
this._path=path;
}
this.baseTextDirection="";
};
IlvMenuItem.prototype=new IlvPanel();
IlvMenuItem.prototype.setClassName("IlvMenuItem");
IlvMenuItem.prototype.setBaseTextDirection=function(_52d){
this.baseTextDirection=_52d;
};
IlvMenuItem.prototype.getBaseTextDirection=function(){
return this.baseTextDirection;
};
IlvMenuItem.prototype.dispose=function(){
this._div=null;
if(this._proxy){
this._proxy.dispose();
}
if(this._delegate){
this._delegate.dispose();
}
this._img=null;
this.superInvoke("dispose");
};
IlvMenuItem.prototype.createHTMLContainer=function(){
if(!this._delegate){
this._delegate=new IlvDynPanel();
this._div=this._delegate._div;
this._div.style.width="auto";
this._layer=this._delegate._layer;
this._proxy=new IlvDynPanel();
if(this.isRoot()){
this._delegate._div.style.display="none";
this._proxy._div.style.display="none";
}
if(IlvBrowserInfo.instance.ie8up){
if(IlvBrowserInfo.instance.ie10up){
this._proxy._div.style["opacity"]="0";
}else{
this._proxy._div.style["filter"]="alpha(opacity=00)";
}
this._proxy._div.style["background"]="#ff0000";
}
var item=this;
var _52f=this._proxy.getMouseEventSource();
if(_52f.addEventListener){
_52f.addEventListener("mouseover",function(){
item.onmouseover();
},false);
_52f.addEventListener("mouseup",function(){
item.mouseUpHandler();
},false);
}else{
_52f.onmouseover=function(){
item.onmouseover();
};
_52f.onmouseup=function(){
item.mouseUpHandler();
};
}
}
};
IlvMenuItem.prototype.mouseUpHandler=function(){
IlvAbstractPopupMenu.prototype.showAgentContextualMenu=false;
if(this.getLabel()==""||this.getLabel()=="-"||!this.isEnabled()||this.setExpanded){
return true;
}
var root=this.getRoot();
root.setVisible(false);
if(IlvBrowserInfo.instance.ie5up){
root.popupMenu.eventPanel.setVisible(false);
}
this.onmouseup();
};
IlvMenuItem.prototype.setAction=function(_531){
if(typeof (_531)=="function"||typeof (_531)=="string"){
this._action=_531;
}else{
if(typeof (_531)=="object"&&typeof (_531._f)=="function"){
this._action=_531._f;
}else{
if(typeof (_531)!="undefined"){
alert(jviews.messages.IlvMenuItem.actionParamMustBeFunction);
}
}
}
};
IlvMenuItem.prototype.getAction=function(){
return this._action;
};
IlvMenuItem.prototype.getIconPreferredSize=function(){
if(this._img==null){
return {width:8,height:0};
}
var span;
if(!IlvMenuItem._span){
span=document.createElement("span");
document.body.appendChild(span);
span.style.position="absolute";
span.style.visibility="hidden";
span.style.left="0px";
span.style.top="0px";
IlvMenuItem._span=span;
}
span=IlvMenuItem._span;
this.setSize(0,0);
span.innerHTML="<img style='-webkit-user-drag:none' border='0' src='"+this.getIcon()+"'/>";
return {width:span.clientWidth,height:span.clientHeight};
};
IlvMenuItem.prototype.getPreferredSize=function(){
if(this._label){
var span;
if(!IlvMenuItem._span){
span=document.createElement("span");
document.body.appendChild(span);
span.style.position="absolute";
span.style.visibility="hidden";
span.style.left="0px";
span.style.top="0px";
IlvMenuItem._span=span;
}
span=IlvMenuItem._span;
this.setSize(0,0);
span.innerHTML=this.createHTMLContent(0);
return {width:this._label=="-"?0:span.clientWidth,height:span.clientHeight};
}
if(!this._defaultSize){
this._defaultSize={width:200,height:20};
}
return this._defaultSize;
};
IlvMenuItem.prototype.setPreferredSize=function(_534,_535){
if(!this._defaultSize){
this._defaultSize={};
}
this._defaultSize.width=_534;
this._defaultSize.height=_535;
};
IlvMenuItem.prototype.setVisible=function(_536){
this.superInvoke("setVisible",_536);
this._proxy.setVisible(_536);
if(_536){
this.update();
}
};
IlvMenuItem.prototype.setLabel=function(_537){
if(this._label!=_537){
this._label=_537||"";
this.update();
}
};
IlvMenuItem.prototype.getLabel=function(){
return this._label;
};
IlvMenuItem.prototype.setIcon=function(_538){
if(this._img!=_538){
this._img=_538;
this.update();
}
};
IlvMenuItem.prototype.getIcon=function(){
return this._img;
};
IlvMenuItem.prototype.setEnabled=function(_539){
if(this._isEnabled!=_539){
this._isEnabled=_539;
this.update();
}
};
IlvMenuItem.prototype.isEnabled=function(){
return this._isEnabled;
};
IlvMenuItem.prototype.setHighlighted=function(_53a){
if(this._isHighlighted!=_53a){
this._isHighlighted=_53a;
this.update();
}
};
IlvMenuItem.prototype.isHighlighted=function(){
return this._isHighlighted;
};
IlvMenuItem.prototype.setSize=function(_53b,_53c){
this.superInvoke("setSize",_53b,_53c);
this._proxy.setSize(_53b,_53c);
this.update();
};
IlvMenuItem.prototype.setLocation=function(left,top){
this.superInvoke("setLocation",left,top);
this._proxy.setLocation(left,top);
};
IlvMenuItem.prototype.getParent=function(){
return this._parent;
};
IlvMenuItem.prototype.isRoot=function(){
return !this.getParent();
};
IlvMenuItem.prototype.getRoot=function(){
var _53f=this;
while(!_53f.isRoot()){
_53f=_53f.getParent();
}
return _53f;
};
IlvMenuItem.prototype.onmouseover=function(){
if(this.getLabel()==""||this.getLabel()=="-"){
return true;
}
if(this.getParent()){
this.getParent().setHighlightedChild(this);
}
};
IlvMenuItem.prototype.onmouseup=function(){
if(this._action){
if(typeof (this._action)=="function"){
this._action(this._view,this);
}else{
eval(this._action);
}
}
};
IlvMenuItem.prototype.performServerAction=function(_540,_541,_542){
if(this.getRoot()&&this.getRoot().popupMenu){
var _543=this.getRoot().popupMenu;
var _544=[_543._triggerLeft,_543._triggerTop,this._path];
_543.performServerAction(_540,_544.concat(_541),_542);
}
};
IlvMenuItem.prototype.getStyle=function(_545){
var root=this.getRoot();
var _547="width:"+(_545?_545+"px":"auto")+";";
var _548;
if(root.popupMenu){
if(root.popupMenu.itemStyleClass){
_548=root.popupMenu.itemStyleClass;
}else{
_547+="background:#f0eff2;color:black;font-family:sans-serif;font-size:12px;";
}
if(this._isHighlighted){
if(root.popupMenu.itemHighlightedStyleClass){
_548+=" "+root.popupMenu.itemHighlightedStyleClass;
}else{
_547+="background-color:#335ea8;color:white;";
}
}
if(!this._isEnabled){
if(root.popupMenu.itemDisabledStyleClass){
_548+=" "+root.popupMenu.itemDisabledStyleClass;
}else{
_547+="color:#a7a6aa;";
}
}
}
return [_547,_548];
};
IlvMenuItem.prototype.createHTMLContent=function(_549,_54a){
if(this._label){
var cols=(this.setExpanded?4:3);
if(this._label=="-"){
cols-=2;
}
var _54c=this.getStyle(_549);
var h="<table cols=\""+cols+"\" border=\"0\" cellpadding=\"1\" cellspacing=\"0\"";
if(_54c[0]!=null){
h+=" style=\""+_54c[0]+"\"";
}
if(_54c[1]!=null){
h+=" class=\""+_54c[1]+"\"";
}
h+=(_549?" width=\""+_549+"\"":"");
h+=(_54a?" height=\""+_54a+"\"":"");
h+=">";
h+="<tr>";
var size=8;
if(this._iconWidth!=null){
size=this._iconWidth;
}
if(this._label!="-"){
h+="<td width=\""+size+"\" valign=\"middle\">";
if(this._img!=null){
h+="<img style=\"-webkit-user-drag:none\" border=\"0\" src=\""+this._img+"\"/>";
}
h+="</td>";
}
h+="<td valign=\"middle\">";
if(this._label=="-"){
h+="<hr/>";
}else{
h+=" "+IlvUtil.setMessageDirection(this._label,this.baseTextDirection)+" ";
}
h+="</td>";
if(this._label!="-"){
if(this.setExpanded){
h+="<td width=\"20\" valign=\"middle\"><div align=\"right\">";
if(this.getRoot().popupMenu.getSubMenuIcon()!=null){
h+="<img style=\"-webkit-user-drag:none\" border=\"0\" src=\""+this.getRoot().popupMenu.getSubMenuIcon()+"\"/>";
}else{
h+="&gt;";
}
h+="</div></td>";
}else{
h+="<td width=\"10\"></td>";
}
}
h+="</tr></table>";
return h;
}
return "";
};
IlvMenuItem.prototype.update=function(){
if(this._label==""){
return;
}else{
if(!this.isVisible()){
this._needUpdate=true;
return;
}
}
this._needUpdate=false;
var _54f=this.createHTMLContent(this.getWidth(),this.getHeight());
this._delegate.setContent(_54f);
};
IlvMenuItem.prototype.recycle=function(){
this._next=IlvMenuItem._reusable;
IlvMenuItem._reusable=this;
};
IlvMenu=function(_550,_551,_552,path){
this.superConstructor(_550,_551,null,_552,path);
};
IlvMenu.prototype=new IlvMenuItem();
IlvMenu.prototype.setClassName("IlvMenu");
IlvMenu.prototype.dispose=function(){
this.superInvoke("dispose");
if(this._border){
for(var i=0;i<this._border.length;i++){
this._border[i].dispose();
}
this._border.length=0;
}
if(this._child){
for(var i=0;i<this._child.length;i++){
this._child[i].dispose();
}
this._child.length=0;
}
};
IlvMenu.prototype.createHTMLContainer=function(){
this.superInvoke("createHTMLContainer");
this.createBorders();
var _555=this._child;
var i,imax=(_555?_555.length:0);
for(i=0;i<imax;i++){
_555[i].createHTMLContainer();
}
};
IlvMenu.prototype.createBorders=function(){
if(!this._border){
this._border=[];
for(var i=0;i<4;i++){
this._border[i]=new IlvDynPanel();
}
this._border[0].setBackgroundColor("#C0C0C0");
this._border[1].setBackgroundColor("#000000");
this._border[2].setBackgroundColor("#FFFFFF");
this._border[3].setBackgroundColor("#808080");
}
};
IlvMenu.prototype.add=function(_559){
if(!this._child){
this._child=[];
}
this._child[this._child.length]=_559;
_559._parent=this;
};
IlvMenu.prototype.getChildrenCount=function(){
return this._child?this._child.length:0;
};
IlvMenu.prototype.setVisible=function(_55a){
if(this.isRoot()){
this._rootVisibility=_55a;
}
var _55b=this.isExpanded();
var _55c=this._child;
var i,imax=(_55c?_55c.length:0);
for(i=0;i<imax;i++){
_55c[i].setVisible(_55a&&_55b);
}
if(this.isRoot()){
this.superInvoke("setVisible",false);
}else{
this.superInvoke("setVisible",_55a);
}
for(i=0;i<4;i++){
this._border[i].setVisible(_55b&&_55a);
}
};
IlvMenu.prototype.isVisible=function(){
if(this.isRoot()){
return this._rootVisibility;
}else{
return this.superInvoke("isVisible");
}
};
IlvMenu.prototype.setLocation=function(left,top){
this.superInvoke("setLocation",left,top);
var _561=(this.isRoot()?0:this.getWidth());
var _562=(this.isRoot()?0:this.getHeight());
var b=document.body;
var _564=window.pageXOffset||(b?b.scrollLeft:0);
var _565=window.innerWidth||(b?b.clientWidth:0);
_565-=_564;
var _566=window.pageYOffset||(b?b.scrollTop:0);
var _567=window.innerHeight||(b?b.clientHeight:0);
_567-=_566;
var _568=this.getChildrenWidth();
var _569=this.getChildrenHeight();
if(left+_561+_568>_565&&left-_568>_564){
left-=_568;
}else{
left+=_561;
}
if(top+_569>_567&&top+_562-_569>_566){
top-=_569-_562;
}
var _56a=this._delegate.getZIndex();
var _56b=this._child;
var i,itop=top,imax=(_56b?_56b.length:0);
for(i=0;i<imax;i++){
_56b[i]._delegate.setZIndex(_56a+2);
_56b[i]._proxy.setZIndex(_56a+3);
_56b[i].setLocation(left,itop);
itop+=_56b[i].getHeight();
}
for(i=0;i<4;i++){
this._border[i].setZIndex(_56a+1);
}
this._border[0].setBounds(left-2,top-2,_568+4,_569+4);
this._border[1].setBounds(left-1,top-1,_568+3,_569+3);
this._border[2].setBounds(left-1,top-1,_568+2,_569+2);
this._border[3].setBounds(left,top,_568+1,_569+1);
};
IlvMenu.prototype.getChildren=function(){
var _56f=[];
var _570=this.getChildrenCount();
for(var i=0;i<_570;i++){
_56f[i]=this._child[i];
}
return _56f;
};
IlvMenu.prototype.getChild=function(_572){
return this._child.length>_572?this._child[_572]:null;
};
IlvMenu.prototype.getChildrenWidth=function(){
this.computeChildrenSize();
var _573=0;
var _574=this._child;
var i,imax=(_574?_574.length:0);
for(i=0;i<imax;i++){
var _577=_574[i].getWidth();
if(_573<_577){
_573=_577;
}
}
return _573;
};
IlvMenu.prototype.getChildrenHeight=function(){
this.computeChildrenSize();
var _578=0;
var _579=this._child;
var i,imax=(_579?_579.length:0);
for(i=0;i<imax;i++){
_578+=_579[i].getHeight()||0;
}
return _578;
};
IlvMenu.prototype.setHighlighted=function(_57c){
this.superInvoke("setHighlighted",_57c);
this.setExpanded(_57c);
};
IlvMenu.prototype.isExpanded=function(){
if(this.isRoot()){
return true;
}
return this._isExpanded;
};
IlvMenu.prototype.setExpanded=function(_57d){
if(_57d==this._isExpanded){
return;
}
if(_57d){
var _57e=this;
while(_57e){
_57e._isExpanded=true;
_57e=_57e.getParent();
}
var root=this.getRoot();
root.setVisible(root.isVisible());
}else{
this.collapse();
this.setVisible(this.isVisible());
}
};
IlvMenu.prototype.onmouseover=function(){
this.superInvoke("onmouseover");
this.setHighlightedChild(null);
};
IlvMenu.prototype.computeChildrenSize=function(){
if(this._child._sizeComputed){
return;
}
var s;
var _581=0;
var _582=[];
var _583=null;
var _584=this._child;
var i,itop=top,imax=(_584?_584.length:0);
for(i=0;i<imax;i++){
s=this._child[i].getIconPreferredSize();
if(_583<s.width){
_583=s.width;
}
}
for(i=0;i<imax;i++){
this._child[i]._iconWidth=_583;
s=this._child[i].getPreferredSize();
if(_581<s.width){
_581=s.width;
}
_582[i]=s.height;
}
for(i=0;i<imax;i++){
this._child[i].setSize(_581,_582[i]);
}
this._child._sizeComputed=true;
};
IlvMenu.prototype.setHighlightedChild=function(_588){
var _589=this._child;
var i,imax=(_589?_589.length:0);
for(i=0;i<imax;i++){
_589[i].setHighlighted(_588==_589[i]);
}
};
IlvMenu.prototype.collapse=function(){
if(!this._isExpanded){
return;
}
this._isExpanded=false;
var _58c=this._child;
var i,imax=(_58c?_58c.length:0);
for(i=0;i<imax;i++){
var menu=_58c[i];
if(menu._isExpanded){
menu.collapse();
}
}
};
IlvMenu.prototype.recycle=function(){
var _590=this._child;
var i,imax=(_590?_590.length:0);
for(i=0;i<imax;i++){
_590[i].recycle();
}
this._next=IlvMenu._reusable;
IlvMenu._reusable=this;
};
IlvSelectionRectangle=function(init,_594,_595){
this.superConstructor(init,_594,_595);
this.resizable=false;
this.handles=["e-Resize","ne-Resize","nw-Resize","n-Resize","se-Resize","sw-Resize","s-Resize","w-Resize"];
};
IlvSelectionRectangle.prototype=new IlvDynRectangle("init");
IlvSelectionRectangle.prototype.setClassName("IlvSelectionRectangle");
IlvSelectionRectangle.prototype.setResizable=function(_596){
this.resizable=_596;
if(this.resizable==true){
this.createHandles(this.parentNode,this.handles);
}
};
IlvSelectionRectangle.prototype.setHandles=function(_597){
if(_597){
this.handles=_597;
}
};
IlvSelectionRectangle.prototype.dispose=function(){
this.superInvoke("dispose");
if(this.eResizeHandle){
this.eResizeHandle.dispose();
}
if(this.neResizeHandle){
this.neResizeHandle.dispose();
}
if(this.nwResizeHandle){
this.nwResizeHandle.dispose();
}
if(this.nResizeHandle){
this.nResizeHandle.dispose();
}
if(this.seResizeHandle){
this.seResizeHandle.dispose();
}
if(this.swResizeHandle){
this.swResizeHandle.dispose();
}
if(this.sResizeHandle){
this.sResizeHandle.dispose();
}
if(this.wResizeHandle){
this.wResizeHandle.dispose();
}
};
IlvSelectionRectangle.prototype.inHandler=function(vBox,_599,_59a,_59b){
if(!_59b){
return false;
}
var left=_599+vBox.left;
var top=_59a+vBox.top;
var _59e=_59b.getBounds();
if(left>=_59e.left&&left<=_59e.left+_59e.width&&top>=_59e.top&&top<=_59e.top+_59e.height){
return true;
}else{
return false;
}
};
IlvSelectionRectangle.prototype.overHandlers=function(vBox,x,y){
if(this.inHandler(vBox,x,y,this.eResizeHandle)){
return true;
}else{
if(this.inHandler(vBox,x,y,this.neResizeHandle)){
return true;
}else{
if(this.inHandler(vBox,x,y,this.nwResizeHandle)){
return true;
}else{
if(this.inHandler(vBox,x,y,this.nResizeHandle)){
return true;
}else{
if(this.inHandler(vBox,x,y,this.seResizeHandle)){
return true;
}else{
if(this.inHandler(vBox,x,y,this.swResizeHandle)){
return true;
}else{
if(this.inHandler(vBox,x,y,this.sResizeHandle)){
return true;
}else{
if(this.inHandler(vBox,x,y,this.wResizeHandle)){
return true;
}
}
}
}
}
}
}
}
return false;
};
IlvSelectionRectangle.prototype.setBounds=function(left,top,_5a4,_5a5){
var t=this.getThickness();
this.superInvoke("setBounds",left-t,top-t,_5a4+2*t,_5a5+2*t);
};
IlvSelectionRectangle.prototype.setThickness=function(_5a7){
if(this.thickness==_5a7){
return;
}
var old=this.thickness;
this.thickness=_5a7||0;
var b=this.getBounds();
this.setBounds(b.left+old,b.top+old,b.width-2*old,b.height-2*old);
if(this.visible==true){
this.recompute();
}
};
IlvSelectionRectangle.prototype.recompute=function(){
this.superInvoke("recompute");
if(this.resizable==true){
this.drawHandles();
}
};
IlvSelectionRectangle.prototype.drawHandles=function(){
var b=this.bounds;
if(b){
var t=2;
var rw=rh=2*t;
this.draw(this.eResizeHandle,b.left+b.width-this.scrollX,b.top-this.scrollY+b.height/2-t,rw,rh);
this.draw(this.neResizeHandle,b.left+b.width-this.scrollX,b.top-this.scrollY-rh,rw,rh);
this.draw(this.nwResizeHandle,b.left-rw-this.scrollX,b.top-this.scrollY-rh,rw,rh);
this.draw(this.nResizeHandle,b.left-this.scrollX+b.width/2-t,b.top-this.scrollY-rh,rw,rh);
this.draw(this.seResizeHandle,b.left-this.scrollX+b.width,b.top-this.scrollY+b.height,rw,rh);
this.draw(this.swResizeHandle,b.left-this.scrollX-rw,b.top-this.scrollY+b.height,rw,rh);
this.draw(this.sResizeHandle,b.left-this.scrollX+b.width/2-t,b.top-this.scrollY+b.height,rw,rh);
this.draw(this.wResizeHandle,b.left-this.scrollX-rw,b.top-this.scrollY+b.height/2-t,rw,rh);
}
};
IlvSelectionRectangle.prototype.setVisible=function(_5ad){
if(this.visible!=_5ad){
this.visible=_5ad;
this.top.setVisible(_5ad);
this.left.setVisible(_5ad);
this.right.setVisible(_5ad);
this.bottom.setVisible(_5ad);
if(this.resizable){
this.setHandlesVisible(_5ad);
}
if(this.fill){
this.fill.setVisible(_5ad&&this.fillOn);
}
if(this.visible){
this.recompute();
}
}
};
IlvSelectionRectangle.prototype.setHandlesVisible=function(_5ae){
if(this.eResizeHandle){
this.eResizeHandle.setVisible(_5ae);
}
if(this.neResizeHandle){
this.neResizeHandle.setVisible(_5ae);
}
if(this.nwResizeHandle){
this.nwResizeHandle.setVisible(_5ae);
}
if(this.nResizeHandle){
this.nResizeHandle.setVisible(_5ae);
}
if(this.seResizeHandle){
this.seResizeHandle.setVisible(_5ae);
}
if(this.swResizeHandle){
this.swResizeHandle.setVisible(_5ae);
}
if(this.sResizeHandle){
this.sResizeHandle.setVisible(_5ae);
}
if(this.wResizeHandle){
this.wResizeHandle.setVisible(_5ae);
}
};
IlvSelectionRectangle.prototype.createHandle=function(){
var _5af=new IlvHTMLPanel("",this.parentNode);
_5af.setBackgroundColor(this.color);
return _5af;
};
IlvSelectionRectangle.prototype.createHandles=function(){
if(!this.eResizeHandle&&this.handles[0]=="e-Resize"){
this.eResizeHandle=this.createHandle();
}
if(!this.neResizeHandle&&this.handles[1]=="ne-Resize"){
this.neResizeHandle=this.createHandle();
}
if(!this.nwResizeHandle&&this.handles[2]=="nw-Resize"){
this.nwResizeHandle=this.createHandle();
}
if(!this.nResizeHandle&&this.handles[3]=="n-Resize"){
this.nResizeHandle=this.createHandle();
}
if(!this.seResizeHandle&&this.handles[4]=="se-Resize"){
this.seResizeHandle=this.createHandle();
}
if(!this.swResizeHandle&&this.handles[5]=="sw-Resize"){
this.swResizeHandle=this.createHandle();
}
if(!this.sResizeHandle&&this.handles[6]=="s-Resize"){
this.sResizeHandle=this.createHandle();
}
if(!this.wResizeHandle&&this.handles[7]=="w-Resize"){
this.wResizeHandle=this.createHandle();
}
};
IlvAbstractSelectionManager=function(init,_5b1,_5b2,_5b3){
if(typeof (init)=="undefined"){
return;
}
this.recycledList=[];
this.rectangleList=[];
this.linkList=[];
this.additionalParams=[];
this.multiSelectKey="ctrl";
this.lineWidth=1;
this.lineColor="black";
this.fillOn=false;
this.listeners=new IlvListenerList();
this.isMovableValue=false;
this.moveAllowed=true;
this.dragging=false;
this.imageMode=true;
this.moveActionName=_5b1?_5b1:"moveNode";
this.selectionActionName=_5b2?_5b2:"selectNode";
this.deleteActionName=_5b3?_5b3:"deleteObject";
this.onRequestComplete=null;
};
IlvAbstractSelectionManager.prototype=new IlvObject();
IlvAbstractSelectionManager.prototype.setClassName("IlvAbstractSelectionManager");
IlvAbstractSelectionManager.prototype.dispose=function(){
this.superInvoke("dispose");
if(this.recycledList&&this.recycledList.length>0){
for(var i in this.recycledList){
if(this.recycledList[i] instanceof IlvSelectionRectangle){
this.recycledList[i].dispose();
}
}
this.recycledList=[];
}
if(this.rectangleList&&this.rectangleList.length>0){
for(var i in this.rectangleList){
if(this.rectangleList[i] instanceof IlvSelectionRectangle){
this.rectangleList[i].dispose();
}
}
this.rectangleList=[];
}
this.additionalParams=[];
if(this.listeners){
this.listeners.dispose();
this.listeners=null;
}
this.setOnRequestComplete(null);
this.xhr=null;
this.view=null;
this.parentNode=null;
};
IlvAbstractSelectionManager.prototype.setParentNode=function(node){
this.parentNode=node;
};
IlvAbstractSelectionManager.prototype.addSelectionChangedListener=function(_5b6){
this.listeners.addListener(_5b6);
};
IlvAbstractSelectionManager.prototype.removeSelectionChangedListener=function(_5b7){
this.listeners.removeListener(_5b7);
};
IlvAbstractSelectionManager.prototype.setImageMode=function(_5b8){
if(this.imageMode!=_5b8){
if(_5b8){
this.hideAll();
}
this.imageMode=_5b8;
this.performUpdateImageMode();
}
};
IlvAbstractSelectionManager.prototype.isImageMode=function(){
return this.imageMode;
};
IlvAbstractSelectionManager.prototype.setLineColor=function(_5b9){
if(this.lineColor!=_5b9){
this.lineColor=_5b9;
this.applyToAll(function(mgr,r){
r.setColor(_5b9);
});
}
};
IlvAbstractSelectionManager.prototype.getLineColor=function(){
return this.lineColor;
};
IlvAbstractSelectionManager.prototype.setFillOn=function(_5bc){
if(this.fillOn!=_5bc){
this.fillOn=_5bc;
this.applyToAll(function(mgr,r){
r.setFillOn(_5bc);
});
}
};
IlvAbstractSelectionManager.prototype.isFillOn=function(){
return this.fillOn;
};
IlvAbstractSelectionManager.prototype.setLineWidth=function(_5bf){
if(this.lineWidth!=_5bf){
this.lineWidth=_5bf;
this.applyToAll(function(mgr,r){
r.setThickness(_5bf);
});
}
};
IlvAbstractSelectionManager.prototype.getLineWidth=function(){
return this.lineWidth;
};
IlvAbstractSelectionManager.prototype.setMoveAllowed=function(_5c2){
this.moveAllowed=_5c2;
};
IlvAbstractSelectionManager.prototype.isMoveAllowed=function(){
return this.moveAllowed;
};
IlvAbstractSelectionManager.prototype.setMultipleSelectionKey=function(key){
this.multiSelectKey=key;
};
IlvAbstractSelectionManager.prototype.getMultipleSelectionKey=function(){
return this.multiSelectKey;
};
IlvAbstractSelectionManager.prototype.setForceUpdateProperties=function(_5c4){
this.forceUpdateProperties=_5c4;
};
IlvAbstractSelectionManager.prototype.isForceUpdateProperties=function(){
return this.forceUpdateProperties;
};
IlvAbstractSelectionManager.prototype.setOnRequestComplete=function(_5c5){
this.onRequestComplete=_5c5;
};
IlvAbstractSelectionManager.prototype.getSelection=function(){
return this.rectangleList.concat(this.linkList);
};
IlvAbstractSelectionManager.prototype.setViewInternal=function(view){
this.view=view;
};
IlvAbstractSelectionManager.prototype.applyToAll=function(f){
if(this.rectangleList==null){
return;
}
var _5c8=this.rectangleList.length;
for(var i=0;i<_5c8;i++){
f(this,this.rectangleList[i]);
}
};
IlvAbstractSelectionManager.prototype.applyToAllLink=function(f){
var _5cb=this.linkList.length;
for(var i=0;i<_5cb;i++){
f(this,this.linkList[i]);
}
};
IlvAbstractSelectionManager.prototype.isMultipleSelection=function(e){
return this.multiSelectKey=="ctrl"?e.ctrlKey:e.shiftKey;
};
IlvAbstractSelectionManager.prototype.getViewPosition=function(){
return this.view.getBounds();
};
IlvAbstractSelectionManager.prototype.createSelectionRectangle=function(left,top,_5d0,_5d1,_5d2){
if(!this.view){
return;
}
var r=this.createRectangle();
this.setSelectionProperties(r,_5d2);
var _5d4=this.view.getContentsBounds();
var _5d5={left:_5d4.left+left,top:_5d4.top+top,width:_5d0,height:_5d1};
r.setBounds(_5d4.left+left,_5d4.top+top,_5d0,_5d1);
r.setClip(_5d4.left,_5d4.top,_5d4.width,_5d4.height);
r.recompute();
if(!IlvUtil.isIntersect(_5d4,_5d5)){
r.setDisplayed(false);
}
this.rectangleList[this.rectangleList.length]=r;
};
IlvAbstractSelectionManager.prototype.createSelectionLink=function(_5d6,_5d7){
if(_5d6==null){
return;
}
if(this.view==null){
return;
}
var _5d8=this.view.getContentsBounds();
var _5d9=new Array();
var _5da=_5d6.length;
for(var i=0;i<_5da;i++){
var _5dc=new Object();
var _5dd=_5d6[i].split(" ");
_5dc.x=parseFloat(_5dd[0]);
_5dc.y=parseFloat(_5dd[1]);
_5d9.push(_5dc);
}
var _5de=new IlvSelectionLink(this.view.parentNode,_5d9,this.lineWidth,this.lineColor);
this.setSelectionProperties(_5de,_5d7);
if(!this.imageMode){
_5de.setOffsets(_5d8);
_5de.draw(this.view.showLinkHandlers||false);
}
this.linkList[this.linkList.length]=_5de;
};
IlvAbstractSelectionManager.prototype.createRectangle=function(){
var r;
if(!this.view){
return;
}
if(this.recycledList.length==0){
if(!this.parentNode){
this.parentNode=this.view.parentNode;
}
r=new IlvSelectionRectangle(null,this.parentNode,this.fillOn);
if(!this.view.showResizeHandlers){
this.handles=[];
}
r.setHandles(this.handles);
r.setZIndex(2);
r.setColor(this.lineColor);
r.setThickness(this.lineWidth);
return r;
}
r=this.recycledList[this.recycledList.length-1];
r.setColor(this.lineColor);
r.setThickness(this.lineWidth);
r.setFillOn(this.fillOn);
r.setDisplayed(true);
this.recycledList.length=this.recycledList.length-1;
return r;
};
IlvAbstractSelectionManager.prototype.setSelectionProperties=function(_5e0,_5e1){
if(!_5e0){
return;
}
_5e0.id=_5e1[0];
_5e0.isMovable=_5e1[1];
_5e0.type=_5e1[2];
if(_5e1.length>=5){
_5e0.setResizable(_5e1[4]);
}
};
IlvAbstractSelectionManager.prototype.recycleAll=function(){
this.applyToAll(function(mgr,r){
r.setVisible(false);
r.setScrollPosition(0,0);
mgr.recycledList[mgr.recycledList.length]=r;
});
this.rectangleList.length=0;
for(var i=0;i<this.linkList.length;i++){
this.linkList[i].remove();
}
this.linkList.length=0;
};
IlvAbstractSelectionManager.prototype.findById=function(id){
var _5e6=this.rectangleList.length;
for(var i=0;i<_5e6;i++){
if(this.rectangleList[i].id==id){
return {id:id,rectangle:this.rectangleList[i],index:i};
}
}
return null;
};
IlvAbstractSelectionManager.prototype.recycle=function(id){
var res=this.findById(id);
if(res!=null){
res.rectangle.setScrollPosition(0,0);
var l=this.recycledList.length;
this.recycledList[l]=res.rectangle;
this.rectangleList.splice(res.index,1);
res.rectangle.setVisible(false);
}
};
IlvAbstractSelectionManager.prototype.removeHTML=function(){
this.applyToAll(function(mgr,r){
r.removeHTML();
});
};
IlvAbstractSelectionManager.prototype.clipAll=function(){
var bbox=this.view.getContentsBounds();
this.applyToAll(function(mgr,r){
r.setClip(bbox.left,bbox.top,bbox.width,bbox.height);
});
};
IlvAbstractSelectionManager.prototype.isMovable=function(r){
return r.isMovable;
};
IlvAbstractSelectionManager.prototype.isHiddenWhenDragging=function(r){
return false;
};
IlvAbstractSelectionManager.prototype.isSelectionMovable=function(){
return this.isMovableValue;
};
IlvAbstractSelectionManager.prototype.computeSelectionMovable=function(){
var _5f2=false;
for(var i=0;i<this.rectangleList.length&&!_5f2;i++){
_5f2=this.isMovable(this.rectangleList[i]);
}
this.isMovableComputed=true;
this.isMovableValue=_5f2;
};
IlvAbstractSelectionManager.prototype.setScrollPosition=function(x,y){
this.scrollX=x;
this.scrollY=y;
this.applyToAll(function(mgr,r){
if(mgr.isMovable(r)){
r.setScrollPosition(x,y);
}
});
};
IlvAbstractSelectionManager.prototype.getScrollPosition=function(){
return {x:this.scrollX,y:this.scrollY};
};
IlvAbstractSelectionManager.prototype.onViewScrolled=function(x,y){
this.scrollX=x;
this.scrollY=y;
if(x==0&&y==0){
return;
}
this.applyToAll(function(mgr,r){
r.setScrollPosition(x,y);
});
this.applyToAllLink(function(mgr,l){
l.setScrollPosition(x,y);
});
};
IlvAbstractSelectionManager.prototype.isDragging=function(){
return this.dragging;
};
IlvAbstractSelectionManager.prototype.startDragging=function(e){
this.selectionLoaded=false;
this.selectionRequested=false;
this.hasMoved=false;
this.multiKeyPressed=this.isMultipleSelection(e);
this.startx=e.mouseX;
this.starty=e.mouseY;
this.resizing=false;
if(this.isOverHandlers(e)){
this.resizing=true;
return;
}
this.dragging=true;
if(this.multiKeyPressed){
this.selectMulti(e.mouseX,e.mouseY);
}else{
this.selectOne(e.mouseX,e.mouseY,true);
}
};
IlvAbstractSelectionManager.prototype.isOverHandlers=function(e){
var x=e.mouseX;
var y=e.mouseY;
var vBox=this.view.getBounds();
return this.overLinkStart(x,y)>-1||this.overLinkEnd(x,y)>-1||this.overLinkMiddles(x,y)>-1||this.overResizeHandlers(vBox,x,y);
};
IlvAbstractSelectionManager.prototype.overLinkStart=function(x,y){
if(this.linkList){
for(var i=0;i<this.linkList.length;i++){
var link=this.linkList[i];
if(link.overStart(x,y)){
return i;
}
}
}
return -1;
};
IlvAbstractSelectionManager.prototype.overLinkMiddles=function(x,y){
if(this.linkList){
for(var i=0;i<this.linkList.length;i++){
var link=this.linkList[i];
if(link.overMiddles(x,y)){
return i;
}
}
}
return -1;
};
IlvAbstractSelectionManager.prototype.overLinkEnd=function(x,y){
if(this.linkList){
for(var i=0;i<this.linkList.length;i++){
var link=this.linkList[i];
if(link.overEnd(x,y)){
return i;
}
}
}
return -1;
};
IlvAbstractSelectionManager.prototype.overResizeHandlers=function(vBox,x,y){
if(this.rectangleList){
for(var i=0;i<this.rectangleList.length;i++){
var _613=this.rectangleList[i];
if(typeof (_613)=="undefined"){
return false;
}
if(_613.overHandlers(vBox,x,y)){
return true;
}
}
}
return false;
};
IlvAbstractSelectionManager.prototype.whileDragging=function(e){
if(this.resizing){
return;
}
var dx=e.mouseX-this.startx;
var dy=e.mouseY-this.starty;
if(!this.hasMoved&&((Math.abs(dx)>3)||(Math.abs(dy)>3))){
this.hasMoved=true;
}
if(this.hasMoved&&this.imageMode&&!this.resizing&&!this.selectionLoaded&&!this.selectionRequested&&!this.selectionImageRequested){
this.updateAll();
}else{
if(this.hasMoved&&this.selectionLoaded&&!this.selectionRequested){
if(this.getSelection().length==1){
this.showAll();
}else{
this.showMovable();
}
if(this.noSelection){
this.setScrollPosition(0,0);
}else{
this.setScrollPosition(-dx,-dy);
}
}
}
};
IlvAbstractSelectionManager.prototype.stopDragging=function(e){
if(this.resizing){
return;
}
this.dragging=false;
if(!this.hasMoved&&!this.multiKeyPressed&&((this.selectionLoaded&&this.rectangleList.length>1)||!this.selectionLoaded)){
}else{
if(this.hasMoved&&!this.noSelection&&this.isSelectionMovable()){
this.startx=this.startx?this.startx:e.mouseX;
this.starty=this.starty?this.starty:e.mouseY;
var dx=e.mouseX-this.startx;
var dy=e.mouseY-this.starty;
if(dx!=0||dy!=0){
this.forceUpdate();
this.view.performAction(this.moveActionName,[dx,dy],"getCapabilites");
}else{
this.hideAll();
}
}else{
if(this.hasMoved&&!this.noSelection){
this.showAll();
}
}
}
};
IlvAbstractSelectionManager.prototype.abortDragging=function(e){
this.dragging=false;
this.startx=0;
this.starty=0;
this.setScrollPosition(0,0);
if(this.imageMode){
this.hideAll();
}else{
this.showAll();
}
};
IlvAbstractSelectionManager.prototype.hideNotMovable=function(){
if(!this.notMovableHidden){
this.notMovableHidden=true;
this.applyToAll(function(mgr,r){
if(!mgr.isMovable(r)){
r.setVisible(false);
}
});
}
};
IlvAbstractSelectionManager.prototype.showMovable=function(){
if(!this.notMovableHidden){
this.notMovableHidden=true;
this.allHidden=false;
this.applyToAll(function(mgr,r){
r.setVisible(mgr.isMovable(r)||!mgr.isHiddenWhenDragging(r));
});
}
};
IlvAbstractSelectionManager.prototype.hideAll=function(){
if(!this.allHidden){
this.allHidden=true;
this.notMovableHidden=false;
this.applyToAll(function(mgr,r){
r.setVisible(false);
});
}
};
IlvAbstractSelectionManager.prototype.showAll=function(){
this.allHidden=false;
this.notMovableHidden=false;
this.applyToAll(function(mgr,r){
r.setVisible(true);
});
};
IlvAbstractSelectionManager.prototype.createRequestURL=function(){
};
IlvAbstractSelectionManager.prototype.getAdditionalParameters=function(){
return IlvRequestParameters.getRequestParameters(this.additionalParams);
};
IlvAbstractSelectionManager.prototype.setAdditionalParameters=function(key,_624){
IlvRequestParameters.setParameter(this.additionalParams,key,_624);
};
IlvAbstractSelectionManager.prototype.removeAdditionalParameter=function(key){
IlvRequestParameters.removeParameter(this.additionalParams,key);
};
IlvAbstractSelectionManager.prototype.sendRequest=function(_626){
this.selectionRequested=true;
if(!this._loader){
this._loader=new IlvAjax.JSRequest(this,this.onSelectionLoadedImpl);
}
this._loader.send(_626);
return false;
};
IlvAbstractSelectionManager.prototype.performServerAction=function(_627,_628,_629){
};
IlvAbstractSelectionManager.prototype.invokeOnRequestComplete=function(){
var _62a=this.onRequestComplete;
if(_62a){
this.onRequestComplete=null;
_62a();
}
};
IlvAbstractSelectionManager.prototype.selectOne=function(x,y,_62d){
this.doingSelect=true;
if(this.imageMode&&!this.hasMoved){
if(this.view){
this.performServerAction(this.selectionActionName,[x,y,false,_62d],this.getSelectionImageRequestListener());
}else{
alert(jviews.messages.IlvAbstractSelectionManager.noViewAttached);
}
}else{
var _62e=[this.createRequestURL(),"&selectionType=selectOne","&x=",x,"&y=",y,"&mouseUp=",_62d];
this.sendRequest(_62e.join(""));
}
};
IlvAbstractSelectionManager.prototype.selectById=function(id,_630){
if(!id){
return;
}
this.doingSelect=true;
if(!_630){
_630=false;
}
if(this.imageMode&&!this.hasMoved){
if(this.view){
this.performServerAction(this.selectionActionName,[-1,-1,_630,id],this.getSelectionImageRequestListener());
}else{
alert(jviews.messages.IlvAbstractSelectionManager.noViewAttached);
}
}else{
var _631=[this.createRequestURL(),"&selectionType=",(_630?"selectMultiId":"selectOneId"),"&id=",id];
this.sendRequest(_631.join(""));
}
};
IlvAbstractSelectionManager.prototype.selectMulti=function(x,y){
this.doingSelect=true;
if(this.imageMode){
if(this.view){
this.performServerAction(this.selectionActionName,[x,y,true,false],this.getSelectionImageRequestListener());
}else{
alert(jviews.messages.IlvAbstractSelectionManager.noViewAttached);
}
}else{
var _634=[this.createRequestURL(),"&selectionType=selectMulti","&x=",x,"&y=",y];
this.sendRequest(_634.join(""));
}
};
IlvAbstractSelectionManager.prototype.selectAll=function(){
this.doingSelect=true;
if(this.imageMode&&!this.hasMoved){
if(this.view){
this.performServerAction(this.selectionActionName,[-2,-2,false,false],this.getSelectionImageRequestListener());
}else{
alert(jviews.messages.IlvAbstractSelectionManager.noViewAttached);
}
}else{
var _635=[this.createRequestURL(),"&selectionType=selectAll"];
this.sendRequest(_635.join(""));
}
};
IlvAbstractSelectionManager.prototype.deselectAll=function(){
this.doingSelect=true;
if(this.imageMode&&!this.hasMoved){
if(this.view){
this.performServerAction(this.selectionActionName,[-3,-3,false,false],this.getSelectionImageRequestListener());
}else{
alert(jviews.messages.IlvAbstractSelectionManager.noViewAttached);
}
}else{
var _636=[this.createRequestURL(),"&selectionType=deselectAll"];
this.sendRequest(_636.join(""));
}
};
IlvAbstractSelectionManager.prototype.getSelectionImageRequestListener=function(){
this.selectionImageRequested=true;
if(!this.imageListener){
this.imageListener=function(v){
this.selectionImageRequested=false;
};
}
return this.imageListener;
};
IlvAbstractSelectionManager.prototype.updateAll=function(){
this.doingSelect=false;
this._doUpdateAll();
};
IlvAbstractSelectionManager.prototype._doUpdateAll=function(){
var _638=this.createRequestURL();
_638+="&selectionType=updateAll";
this.sendRequest(_638);
};
IlvAbstractSelectionManager.prototype.updateSelectionProperties=function(){
this.updateAll();
};
IlvAbstractSelectionManager.prototype.doSelect=function(e){
var x=e.mouseX;
var y=e.mouseY;
var _63c=this.isMultipleSelection(e);
if(_63c){
this.selectMulti(x,y);
}else{
this.selectOne(x,y);
}
};
IlvAbstractSelectionManager.prototype.onSelectionLoadedImpl=function(_63d){
this.onSelectionLoaded(_63d);
this.invokeOnRequestComplete();
};
IlvAbstractSelectionManager.prototype.onSelectionLoaded=function(_63e){
if(_63e.refreshImage){
this.hideAll();
this.performUpdateImage();
}else{
var i,_640,r,r0;
if(_63e.removeAll){
this.recycleAll();
}
if(_63e.removeList){
_640=_63e.removeList.length;
for(i=0;i<_640;i++){
this.recycle(_63e.removeList[i][4][0]);
}
}
if(_63e.addList){
_640=_63e.addList.length;
for(i=0;i<_640;i++){
r=_63e.addList[i];
var _643=r[2];
if(_643){
this.createSelectionLink(_643,r[1]);
}else{
r0=r[0];
this.createSelectionRectangle(r0.x,r0.y,r0.width,r0.height,r[1]);
}
}
}
this.noSelection=_63e.noSelection;
var _644=this.rectangleList[this.rectangleList.length-1];
this.computeSelectionMovable();
if(!this.imageMode||(_644&&_644.resizable==true)){
this.showAll();
}else{
if(this.imageMode&&this.hasMoved&&this.dragging&&this.isSelectionMovable()){
this.showMovable();
}
}
this.updateCapabilities(_63e,this.view);
if(this.doingSelect||(this.imageMode&&this.forceUpdateProperties)){
this.listeners.notify(this.getSelection());
}
}
this.selectionRequested=false;
this.selectionLoaded=true;
};
IlvAbstractSelectionManager.prototype.updateCapabilities=function(_645,view){
};
IlvAbstractSelectionManager.prototype.performUpdateImageMode=function(){
};
IlvAbstractSelectionManager.prototype.performUpdateImage=function(){
};
IlvAbstractSelectionManager.prototype.deleteSelection=function(){
this.forceUpdate();
this.view.performAction(this.deleteActionName,null,"getCapabilites");
};
IlvAbstractSelectionManager.prototype.forceUpdate=function(){
if(this.isForceUpdateProperties()){
if(!this.forceListener){
this.forceListener=function(v){
if(typeof (v.removeImageOnLoadListener)=="function"){
v.removeImageOnLoadListener(v.getSelectionManager().forceListener);
}
if(typeof (v.removeImageLoadListener)=="function"){
v.removeImageLoadListener(v.getSelectionManager().forceListener);
}
v.getSelectionManager().updateSelectionProperties();
};
}
if(typeof (this.view.addImageLoadListener)=="function"){
this.view.addImageLoadListener(this.forceListener);
}
if(typeof (this.view.addImageOnLoadListener)=="function"){
this.view.addImageOnLoadListener(this.forceListener);
}
}
};
IlvAbstractSelectionManager.prototype.commitSelectionProperties=function(_648,_649,_64a){
var _64b=this.createRequestURL();
_64b+="&selectionType=setProperties";
var _64c=this.getSelection();
var _64d=[];
var _64e=_64c.length;
var _64f=[];
for(var i=0;i<_64e;i++){
if(_64c[i].invalidated){
_64d.push(_64c[i]);
_64f.push([_64c[i].id].concat(_64c[i].getInvalidatedProperties()));
}
}
_64f=IlvJSONUtil.arrayToJSON(_64f);
var _651=this;
var _652=function(xhr){
var _654=_64d.length;
for(var i=0;i<_654;i++){
_64d[i].invalidated=false;
}
var _656=eval(xhr.responseText);
if(_656&&_656.length>0){
var _657=new Array(_656.length);
for(var i=0;i<_656.length;i++){
_657[i]=new IlvSelectionPropertiesError(_656[i]);
}
_656=_657;
}
if(_649){
_649.call(_651,_656,xhr);
}
if(_648){
_651.performUpdateImage();
}
};
var _658=function(xhr){
if(_64a){
_64a.call(_651,xhr);
}
};
this.xhr=IlvAjax.Util.post(_64b,_64f,this.xhr,_652,_658);
};
IlvSelectionPropertiesError=function(info){
this.info=info;
};
IlvSelectionPropertiesError.ACCEPT_ERROR=1;
IlvSelectionPropertiesError.CONVERSION_ERROR=2;
IlvSelectionPropertiesError.SET_ERROR=3;
IlvSelectionPropertiesError.prototype.getObjectID=function(){
return this.info[0];
};
IlvSelectionPropertiesError.prototype.getObjectErroneousProperty=function(_65b){
return this.info[1][_65b].errorValue;
};
IlvSelectionPropertiesError.prototype.getObjectProperty=function(_65c){
return this.info[1][_65c].value;
};
IlvSelectionPropertiesError.prototype.getType=function(_65d){
return this.info[1][_65d].type;
};
IlvSelectionPropertiesError.prototype.getObjectPropertyNames=function(){
var _65e=[];
var _65f=0;
for(var i in this.info[1]){
_65e[_65f++]=i;
}
return _65e;
};
IlvHitmap=function(_661){
if(_661){
this.setData(_661);
}
this.highlighted=0;
};
IlvHitmap.prototype=new IlvObject();
IlvHitmap.prototype.width=function(){
if(this.hitdata){
return this.hitdata[0].length;
}else{
return -1;
}
};
IlvHitmap.prototype.height=function(){
if(this.hitdata){
return this.hitdata.length;
}else{
return -1;
}
};
IlvHitmap.prototype.setData=function(_662){
if(_662.width){
this.hitdata=new Array(_662.data.length);
for(var row=0;row<_662.data.length;row++){
this.hitdata[row]=new Array(_662.width);
for(var c=0;c<_662.width;c++){
this.hitdata[row][c]=0;
}
}
var _665=_662.width.toString(36).length;
var _666=_662.span.toString(36).length;
var _667=_662.depth.toString(36).length;
var _668=_662.count.toString(36).length;
var step=_665+_666+_667+_668;
for(var row=0;row<_662.data.length;row++){
var line=_662.data[row];
if(line!=null){
for(var c=0;c<line.length;c+=step){
var _66b=c;
var _66c=_66b+_665;
var _66d=_66c+_666;
var _66e=_66d+_667;
var left=parseInt(line.substr(_66b,_665),36);
var _670=parseInt(line.substr(_66c,_666),36);
var _671=parseInt(line.substr(_66d,_667),36);
var _672=parseInt(line.substr(_66e,_668),36);
for(var _673=row;_673<row+_671;_673++){
for(var x=left;x<left+_670;x++){
this.hitdata[_673][x]=_672;
}
}
}
}
}
}else{
this.hitdata=_662.data;
}
};
IlvHitmap.prototype.hittest=function(x,y,_677){
if(!this.hitdata){
return 0;
}
if(y>=this.hitdata.length||y<0){
return 0;
}
if(x>=this.hitdata[0].length||x<0){
return 0;
}
var _678=this.hitdata[y][x];
if(_678!=0){
return _678;
}
var t=_677?_677:3;
for(var i=1;i<=t;i++){
for(var j=1;j<=t;j++){
for(var k=-1;k<=1;k=k+2){
var x1=x+i*k;
var y1=y+j*k;
if(x1>=0&&x1<this.width()&&y1>=0&&y1<this.height()){
_678=this.hitdata[y1][x1];
if(_678!=0){
return _678;
}
}
}
}
}
return 0;
};
IlvHitmap.prototype.getShape=function(_67f){
var _680=new Array();
var _681=this.width(),_682=this.height();
for(var y=0;y<_682;y++){
var from=-1;
var to=-1;
for(var x=0;x<_681;x++){
if(this.hitdata[y][x]==_67f){
if(from<0){
from=x;
}
if(from>=0){
to=x;
}
}
if(from>=0&&to>=0&&(this.hitdata[y][x]!=_67f||x==_681-1)){
var left=from==0?0:from-1;
var _688=to==_681-1?_681-1:to+1;
_680.push(left);
_680.push(_688);
_680.push(y);
from=-1;
to=-1;
}
}
}
return _680;
};
IlvHitmap.prototype.getGroupIndexes=function(_689){
var _68a=this.hitInfos?this.hitInfos.group:null;
if(_68a&&_68a[_689]){
var _68b=_68a[_689];
return [].concat(_68b);
}
return _689;
};
IlvHitmap.prototype.clear=function(){
for(var p in this){
var t=typeof (this[p]);
if(t=="number"){
this[p]=0;
}else{
if(t=="string"||t=="object"){
this[p]=null;
}
}
}
};
IlvAccessibilityInteractor=function(_68e,_68f){
this.superConstructor();
this.handlers={};
this.isMultiInteractor=true;
};
IlvAccessibilityInteractor.prototype=new IlvInteractor();
IlvAccessibilityInteractor.prototype.setClassName("IlvAccessibilityInteractor");
IlvAccessibilityInteractor.instances={};
IlvAccessibilityInteractor.prototype.addHitInfotype=function(view){
view&&view.putHitInfoType("navigation");
};
IlvAccessibilityInteractor.prototype.setView=function(view){
if(view!=null){
this.addHitInfotype(view);
if(!view.hitmap){
view.hitmap=new IlvHitmap();
if(view.capabilitiesLoaded){
view.updateHitmap();
}
}
view.accessibleParams={};
view.accessibleParams.dx=0;
view.accessibleParams.dy=0;
}
};
IlvAccessibilityInteractor.prototype.keyDown=function(e){
this.tempHandler=this.createKeyboardActionHandler(e);
if(this.tempHandler){
this.tempHandler.downAction(e);
}
return true;
};
IlvAccessibilityInteractor.prototype.keyUp=function(e){
if(this.tempHandler){
this.tempHandler.upAction(e);
this.tempHandler=null;
}
return true;
};
IlvAccessibilityInteractor.prototype.mouseDown=function(e){
if(e.button!=2&&this.view!=null){
var _695=this.view.hitmap;
if(_695){
var x=e.mouseX,y=e.mouseY;
var _698=_695.hittest(x,y);
if(_698>0){
this.view.accessibleParams.focusIndex=_698;
}
}
}
return true;
};
IlvAccessibilityInteractor.prototype.createKeyboardActionHandler=function(e){
var _69a=this.view.hotkeys;
for(p in _69a){
if(_69a[p]){
var _69b=this.view.hotkeys[p].hotkey;
var _69c=this.view.hotkeys[p].filter;
if(e.ctrlKey==_69c.ctrl&&e.altKey==_69c.alt&&e.shiftKey==_69c.shift){
var _69d=false;
var _69e=typeof (_69b);
if(_69e=="object"){
for(var i=0;i<_69b.length;i++){
if(_69b[i]==e.keyCode+""){
_69d=true;
break;
}
}
}else{
if(_69e=="number"){
if(_69b==e.keyCode){
_69d=true;
}
}
}
if(_69d){
var _6a0=this.handlers[p];
if(!_6a0){
_6a0=eval("new Ilv"+p.substr(0,1).toUpperCase()+p.substr(1,p.length-1)+"KeyboardActionHandler(this.view)");
this.handlers[p]=_6a0;
}
return _6a0;
}
}
}
}
return null;
};
IlvBaseKeyboardActionHandler=function(view){
if(view){
this.view=view;
this.accessibleParams=view.accessibleParams;
}
};
IlvBaseKeyboardActionHandler.prototype=new IlvObject();
IlvBaseKeyboardActionHandler.prototype.setClassName("IlvBaseKeyboardActionHandler");
IlvBaseKeyboardActionHandler.prototype.downAction=function(e){
};
IlvBaseKeyboardActionHandler.prototype.upAction=function(e){
};
IlvNavigationKeyboardActionHandler=function(view){
this.superConstructor(view);
this.color="#FF7F50";
this.opacity=0.5;
this.dx=0;
this.dy=0;
};
IlvNavigationKeyboardActionHandler.prototype=new IlvBaseKeyboardActionHandler();
IlvNavigationKeyboardActionHandler.prototype.setClassName("IlvNavigationKeyboardActionHandler");
IlvNavigationKeyboardActionHandler.prototype.downAction=function(){
var view=this.view;
var _6a6=view.hitmap;
if(!_6a6){
return true;
}
var _6a7=_6a6.hitInfos?_6a6.hitInfos.navigation:null;
if(!_6a7){
this.accessibleParams=null;
return true;
}
if(_6a7!==this.accessibleParams.tempAccessibleInfo){
this.accessibleParams.tempAccessibleInfo=_6a7;
if(typeof (view.getSelectionManager)!="function"||(view.getSelectionManager()&&view.getSelectionManager().imageMode)){
if(_6a7[0]){
this.accessibleParams.focusIndex=_6a7[0];
}
}
this.accessibleParams.indexes=null;
}
if(!this.accessibleParams.indexes){
for(var i=1;i<_6a7.length;i++){
if(_6a7[i][0]==0&&_6a7[i][1]>0){
this.startIndex=i;
}
if(_6a7[i][0]>0&&_6a7[i][1]==0){
this.endIndex=i;
}
}
if(!this.startIndex){
this.startIndex=1;
this.endIndex=_6a7.length-1;
}
if(!this.accessibleParams.focusIndex||this.accessibleParams.focusIndex>=_6a7.length){
this.accessibleParams.indexes=[this.startIndex,this.startIndex,this.startIndex,this.startIndex];
return true;
}
this.accessibleParams.indexes=_6a7[this.accessibleParams.focusIndex];
}else{
this.accessibleParams.indexes=_6a7[this.accessibleParams.focusIndex];
}
};
IlvNavigationKeyboardActionHandler.prototype.setFocus=function(_6a9){
var _6aa=this.view.hitmap;
var _6ab=_6aa.getGroupIndexes(_6a9);
var _6ac=this.view.getDrawPanel();
_6ac.clear();
if(IlvUtil.isArray(_6ab)){
_6ab.push(_6a9);
for(var i=0;i<_6ab.length;i++){
_6ac.addShape(_6aa.getShape(_6ab[i]),this.color,this.opacity);
}
}else{
_6ac.addShape(_6aa.getShape(_6ab),this.color,this.opacity);
}
};
IlvUpKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvUpKeyboardActionHandler.prototype=new IlvNavigationKeyboardActionHandler();
IlvUpKeyboardActionHandler.prototype.setClassName("IlvUpKeyboardActionHandler");
IlvUpKeyboardActionHandler.prototype.downAction=function(){
this.superInvoke("downAction");
if(this.accessibleParams&&this.accessibleParams.indexes[0]>0){
this.setFocus(this.accessibleParams.indexes[0]);
this.accessibleParams.focusIndex=this.accessibleParams.indexes[0];
}
};
IlvDownKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvDownKeyboardActionHandler.prototype=new IlvNavigationKeyboardActionHandler();
IlvDownKeyboardActionHandler.prototype.setClassName("IlvDownKeyboardActionHandler");
IlvDownKeyboardActionHandler.prototype.downAction=function(){
this.superInvoke("downAction");
if(this.accessibleParams&&this.accessibleParams.indexes[1]>0){
this.setFocus(this.accessibleParams.indexes[1]);
this.accessibleParams.focusIndex=this.accessibleParams.indexes[1];
}
};
IlvLeftKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvLeftKeyboardActionHandler.prototype=new IlvNavigationKeyboardActionHandler();
IlvLeftKeyboardActionHandler.prototype.setClassName("IlvLeftKeyboardActionHandler");
IlvLeftKeyboardActionHandler.prototype.downAction=function(){
this.superInvoke("downAction");
if(this.accessibleParams&&this.accessibleParams.indexes[2]>0){
this.setFocus(this.accessibleParams.indexes[2]);
this.accessibleParams.focusIndex=this.accessibleParams.indexes[2];
}
};
IlvRightKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvRightKeyboardActionHandler.prototype=new IlvNavigationKeyboardActionHandler();
IlvRightKeyboardActionHandler.prototype.setClassName("IlvRightKeyboardActionHandler");
IlvRightKeyboardActionHandler.prototype.downAction=function(){
this.superInvoke("downAction");
if(this.accessibleParams&&this.accessibleParams.indexes[3]>0){
this.setFocus(this.accessibleParams.indexes[3]);
this.accessibleParams.focusIndex=this.accessibleParams.indexes[3];
}
};
IlvSingleSelectKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvSingleSelectKeyboardActionHandler.prototype=new IlvNavigationKeyboardActionHandler();
IlvSingleSelectKeyboardActionHandler.prototype.setClassName("IlvSingleSelectKeyboardActionHandler");
IlvSingleSelectKeyboardActionHandler.prototype.downAction=function(e){
var _6b4=this.view.hitmap.hitdata;
if(!_6b4){
return;
}
var _6b5=this.accessibleParams.focusIndex;
var _6b6=_6b4[0].length;
var _6b7=_6b4.length;
var _6b8=false;
for(var y=0;y<_6b7;y++){
for(var x=0;x<_6b6;x++){
if(_6b4[y][x]==_6b5){
e.mouseX=this.accessibleParams.mouseX=x+2;
e.mouseY=this.accessibleParams.mouseY=y+2;
this.view.forceSelect=true;
this.view.mouseDown(e);
_6b8=true;
break;
}
}
if(_6b8){
break;
}
}
};
IlvSingleSelectKeyboardActionHandler.prototype.upAction=function(e){
e.mouseX=this.accessibleParams.mouseX;
e.mouseY=this.accessibleParams.mouseY;
this.view.mouseUp(e);
this.view.forceSelect=false;
};
IlvZoomInKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvZoomInKeyboardActionHandler.prototype=new IlvBaseKeyboardActionHandler();
IlvZoomInKeyboardActionHandler.prototype.setClassName("IlvZoomInKeyboardActionHandler");
IlvZoomInKeyboardActionHandler.prototype.downAction=function(){
if(typeof (this.view.zoomIn)=="function"){
this.view.zoomIn(true,true);
}
};
IlvZoomOutKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvZoomOutKeyboardActionHandler.prototype=new IlvBaseKeyboardActionHandler();
IlvZoomOutKeyboardActionHandler.prototype.setClassName("IlvZoomOutKeyboardActionHandler");
IlvZoomOutKeyboardActionHandler.prototype.downAction=function(){
if(typeof (this.view.zoomOut)=="function"){
this.view.zoomOut(true,true);
}
};
IlvZoomInByXKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvZoomInByXKeyboardActionHandler.prototype=new IlvZoomInKeyboardActionHandler();
IlvZoomInByXKeyboardActionHandler.prototype.setClassName("IlvZoomInByXKeyboardActionHandler");
IlvZoomInByXKeyboardActionHandler.prototype.downAction=function(){
if(typeof (this.view.zoomInX)=="function"){
this.view.zoomInX();
}
};
IlvZoomOutByXKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvZoomOutByXKeyboardActionHandler.prototype=new IlvZoomOutKeyboardActionHandler();
IlvZoomOutByXKeyboardActionHandler.prototype.setClassName("IlvZoomOutByXKeyboardActionHandler");
IlvZoomOutByXKeyboardActionHandler.prototype.downAction=function(){
if(typeof (this.view.zoomOutX)=="function"){
this.view.zoomOutX();
}
};
IlvZoomInByYKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvZoomInByYKeyboardActionHandler.prototype=new IlvZoomInKeyboardActionHandler();
IlvZoomInByYKeyboardActionHandler.prototype.setClassName("IlvZoomInByYKeyboardActionHandler");
IlvZoomInByYKeyboardActionHandler.prototype.downAction=function(){
if(typeof (this.view.zoomInY)=="function"){
this.view.zoomInY();
}
};
IlvZoomOutByYKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvZoomOutByYKeyboardActionHandler.prototype=new IlvZoomOutKeyboardActionHandler();
IlvZoomOutByYKeyboardActionHandler.prototype.setClassName("IlvZoomOutByYKeyboardActionHandler");
IlvZoomOutByYKeyboardActionHandler.prototype.downAction=function(){
if(typeof (this.view.zoomOutY)=="function"){
this.view.zoomOutY();
}
};
IlvPanKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvPanKeyboardActionHandler.prototype=new IlvBaseKeyboardActionHandler();
IlvPanKeyboardActionHandler.prototype.setClassName("IlvPanKeyboardActionHandler");
IlvPanKeyboardActionHandler.prototype.downAction=function(e){
var view=this.view;
var _6c5=this.accessibleParams;
if(!_6c5.keyPressed&&(_6c5.dx!=0||_6c5.dy!=0)){
e.mouseX=_6c5.mouseX=view.width/2;
e.mouseY=_6c5.mouseY=view.height/2;
view.forcePan=true;
view.mouseDown(e);
_6c5.keyPressed=true;
}
e.mouseX=_6c5.mouseX+_6c5.dx;
e.mouseY=_6c5.mouseY+_6c5.dy;
view.mouseDrag(e);
};
IlvPanKeyboardActionHandler.prototype.upAction=function(e){
var view=this.view;
var _6c8=this.accessibleParams;
if(_6c8.keyPressed){
e.mouseX=_6c8.mouseX+_6c8.dx;
e.mouseY=_6c8.mouseY+_6c8.dy;
view.mouseUp(e);
_6c8.dx=0;
_6c8.dy=0;
_6c8.keyPressed=false;
view.forcePan=false;
}
};
IlvPanUpKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvPanUpKeyboardActionHandler.prototype=new IlvPanKeyboardActionHandler();
IlvPanUpKeyboardActionHandler.prototype.setClassName("IlvPanUpKeyboardActionHandler");
IlvPanUpKeyboardActionHandler.prototype.downAction=function(e){
this.accessibleParams.dy-=10;
this.superInvoke("downAction",e);
};
IlvPanDownKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvPanDownKeyboardActionHandler.prototype=new IlvPanKeyboardActionHandler();
IlvPanDownKeyboardActionHandler.prototype.setClassName("IlvPanDownKeyboardActionHandler");
IlvPanDownKeyboardActionHandler.prototype.downAction=function(e){
this.accessibleParams.dy+=10;
this.superInvoke("downAction",e);
};
IlvPanLeftKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvPanLeftKeyboardActionHandler.prototype=new IlvPanKeyboardActionHandler();
IlvPanLeftKeyboardActionHandler.prototype.setClassName("IlvPanLeftKeyboardActionHandler");
IlvPanLeftKeyboardActionHandler.prototype.downAction=function(e){
this.accessibleParams.dx-=10;
this.superInvoke("downAction",e);
};
IlvPanRightKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvPanRightKeyboardActionHandler.prototype=new IlvPanKeyboardActionHandler();
IlvPanRightKeyboardActionHandler.prototype.setClassName("IlvPanRightKeyboardActionHandler");
IlvPanRightKeyboardActionHandler.prototype.downAction=function(e){
this.accessibleParams.dx+=10;
this.superInvoke("downAction",e);
};
IlvMoveNodeKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvMoveNodeKeyboardActionHandler.prototype=new IlvSingleSelectKeyboardActionHandler();
IlvMoveNodeKeyboardActionHandler.prototype.setClassName("IlvMoveNodeKeyboardActionHandler");
IlvMoveNodeKeyboardActionHandler.prototype.downAction=function(e){
var view=this.view;
var _6d4=view.accessibleParams;
if(!_6d4.keyPressed&&(_6d4.dx!=0||_6d4.dy!=0)){
this.superInvoke("downAction",e);
_6d4.keyPressed=true;
}
e.mouseX=_6d4.mouseX=_6d4.mouseX+_6d4.dx;
e.mouseY=_6d4.mouseY=_6d4.mouseY+_6d4.dy;
view.mouseDrag(e);
};
IlvMoveNodeKeyboardActionHandler.prototype.upAction=function(e){
var _6d6=this.view.accessibleParams;
if(_6d6.keyPressed){
this.superInvoke("upAction",e);
this.accessibleParams.dx=0;
this.accessibleParams.dy=0;
_6d6.keyPressed=false;
}
};
IlvMoveNodeUpKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvMoveNodeUpKeyboardActionHandler.prototype=new IlvMoveNodeKeyboardActionHandler();
IlvMoveNodeUpKeyboardActionHandler.prototype.setClassName("IlvMoveNodeUpKeyboardActionHandler");
IlvMoveNodeUpKeyboardActionHandler.prototype.downAction=function(e){
this.accessibleParams.dy-=5;
this.superInvoke("downAction",e);
};
IlvMoveNodeDownKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvMoveNodeDownKeyboardActionHandler.prototype=new IlvMoveNodeKeyboardActionHandler();
IlvMoveNodeDownKeyboardActionHandler.prototype.setClassName("IlvMoveNodeDownKeyboardActionHandler");
IlvMoveNodeDownKeyboardActionHandler.prototype.downAction=function(e){
this.accessibleParams.dy+=5;
this.superInvoke("downAction",e);
};
IlvMoveNodeLeftKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvMoveNodeLeftKeyboardActionHandler.prototype=new IlvMoveNodeKeyboardActionHandler();
IlvMoveNodeLeftKeyboardActionHandler.prototype.setClassName("IlvMoveNodeLeftKeyboardActionHandler");
IlvMoveNodeLeftKeyboardActionHandler.prototype.downAction=function(e){
this.accessibleParams.dx-=5;
this.superInvoke("downAction",e);
};
IlvMoveNodeRightKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvMoveNodeRightKeyboardActionHandler.prototype=new IlvMoveNodeKeyboardActionHandler();
IlvMoveNodeRightKeyboardActionHandler.prototype.setClassName("IlvMoveNodeRightKeyboardActionHandler");
IlvMoveNodeRightKeyboardActionHandler.prototype.downAction=function(e){
this.accessibleParams.dx+=5;
this.superInvoke("downAction",e);
};
IlvCollapseExpandKeyboardActionHandler=function(view){
this.superConstructor(view);
};
IlvCollapseExpandKeyboardActionHandler.prototype=new IlvSingleSelectKeyboardActionHandler();
IlvCollapseExpandKeyboardActionHandler.prototype.setClassName("IlvCollapseExpandKeyboardActionHandler");
if(typeof (IlvBodyEventManager)=="undefined"){
IlvBodyEventManager={listeners:[],addOnEvent:function(type,func){
var list=IlvBodyEventManager.listeners[type];
if(!list){
list=[];
this.listeners[type]=list;
}
var _6e3=false;
var l=list.length;
for(var i=0;i<l&&!_6e3;i++){
if(list[i]==func){
_6e3=true;
}
}
if(!_6e3){
list.push(func);
}
},onResize:function(){
IlvBodyEventManager.callListeners("resize");
},callListeners:function(type){
var _6e7=IlvBodyEventManager.listeners[type];
if(_6e7){
var l=_6e7.length;
for(var i=0;i<l;i++){
try{
eval(_6e7[i]);
}
catch(e){
}
}
}
}};
IlvUtil.addOnEvt("resize",IlvBodyEventManager.onResize);
}
IlvUtil.addOnEvt("unload",IlvObject.callDispose);
IlvPropertyStateManager=function(_6ea){
if(_6ea){
this.superConstructor();
this.egalityChar=":";
this.separatorChar=";";
this.clientId=_6ea;
this.stateId=_6ea+"_state";
this.stateObject=document.getElementById(this.stateId);
this.stateObject.value=";";
if(!this.stateObject){
alert(IlvUtil.formatStr(jviews.messages.IlvPropertyStateManager.stateContainerNotFound,this.stateId));
}
this.propertyList=[];
this.propertyMap=[];
this.debug=true;
}
};
IlvPropertyStateManager.prototype=new IlvObject();
IlvPropertyStateManager.prototype.setClassName("IlvPropertyStateManager");
IlvPropertyStateManager.lockNotify=true;
IlvPropertyStateManager.prototype.trace=function(msg){
if(this.debug){
alert(msg);
}
};
IlvPropertyStateManager.prototype.getClientId=function(){
return this.clientId;
};
IlvPropertyStateManager.prototype.notify=function(_6ec){
if(!IlvPropertyStateManager.lockNotify){
if(!this.propertyMap[_6ec]){
this.propertyMap[_6ec]="1";
this.propertyList[this.propertyList.length]=_6ec;
}
this.saveState(_6ec);
}
};
IlvPropertyStateManager.prototype.saveState=function(_6ed){
this.saveStateImpl1(_6ed);
};
IlvPropertyStateManager.prototype.clearState=function(){
this.stateObject.value=null;
};
IlvPropertyStateManager.prototype.saveStateImpl1=function(_6ee){
var _6ef="";
if(this.stateObject){
_6ef=this.stateObject.value;
}else{
this.stateObject=document.getElementById(this.stateId);
}
var _6f0;
var _6f1="get"+_6ee;
if(typeof (this[_6f1])!="function"){
_6f1=_6f1="is"+_6ee;
if(typeof (this[_6f1])!="function"){
this.trace(IlvUtil.formatStr(jviews.messages.IlvPropertyStateManager.noGetterMethodForProperty,_6ee,this.clientId));
return;
}
}
_6f0=this[_6f1]();
if(_6f0||_6f0==0||_6f0==null){
var _6f2;
if(_6f0==0||_6f0==null){
_6f2=_6f0;
}else{
_6f2=_6f0.getClientId?_6f0.getClientId():_6f0;
}
if(_6f2 instanceof Array){
_6f2=_6f2.join(",");
}else{
if(typeof (_6f2)=="object"){
var buf=[];
for(var _6f4 in _6f2){
buf.push(_6f4);
buf.push(_6f2[_6f4]);
}
_6f2=buf.join(",");
}
}
var s=_6ef.indexOf(";"+_6ee+":");
if(s==-1){
if(typeof (_6f2)!="undefined"){
_6ef+=_6ee+":"+_6f2+";";
}
}else{
s++;
var e=_6ef.substring(s,_6ef.length).indexOf(";")+s;
if(typeof (_6f2)!="undefined"){
_6ef=_6ef.substring(0,s)+_6ee+":"+_6f2+_6ef.substring(e,_6ef.length);
}else{
_6ef=_6ef.substring(0,s)+_6ef.substring(e+1,_6ef.length);
}
}
this.stateObject.value=_6ef;
}
};
IlvFacesProxy=function(_6f7){
this.superConstructor(_6f7);
this.phNode=null;
IlvPanel.visibilityLock=true;
IlvPropertyStateManager.lockNotify=true;
if(_6f7){
this.registerDisposeByClientId(_6f7);
}
};
IlvFacesProxy.prototype=new IlvPropertyStateManager();
IlvFacesProxy.prototype.setClassName("IlvFacesProxy");
IlvFacesProxy.prototype.dispose=function(){
this.superInvoke("dispose");
this.jviewsObject.dispose();
this.stateObject=null;
this.phNode=null;
this.refNode=null;
};
IlvFacesProxy.prototype.setJViewsDHTMLObject=function(_6f8){
this.setObject(_6f8);
};
IlvFacesProxy.prototype.setObject=function(_6f9){
this.jviewsObject=_6f9;
_6f9.JSFRef=this;
if(this.refNode&&_6f9&&_6f9.setReferenceNode){
_6f9.setReferenceNode(this.refNode);
}
this.setPageIdSupport();
};
IlvFacesProxy.prototype.setReferenceNode=function(_6fa){
this.refNode=_6fa;
this.phNode=this.getPlaceHolder();
if(this.refNode&&this.jviewsObject&&this.jviewsObject.setReferenceNode){
this.jviewsObject.setReferenceNode(_6fa);
}
};
IlvFacesProxy.prototype.getReferenceNode=function(){
return this.refNode;
};
IlvFacesProxy.prototype.getNodeCoords=function(){
var _6fb=this.refNode;
var _6fc=0;
var _6fd=0;
while(_6fb.tagName!="body"&&_6fb.tagName!="html"&&_6fb.tagName!="BODY"&&_6fb.tagName!="HTML"){
_6fc+=_6fb.offsetLeft;
_6fd+=_6fb.offsetTop;
_6fb=_6fb.offsetParent;
}
if(this.refNode.dir=="rtl"){
_6fc+=obj.text.offsetWidth-obj.div.offsetWidth;
}
return {left:_6fc,top:_6fd};
};
IlvFacesProxy.prototype.getJViewsDHTMLObject=function(){
return this.getObject();
};
IlvFacesProxy.prototype.getObject=function(){
return this.jviewsObject;
};
IlvFacesProxy.prototype.toHTML=function(){
if(this.phNode==null){
this.phNode=this.getPlaceHolder();
}
this.jviewsObject.toHTML(this.phNode);
};
IlvFacesProxy.prototype.resize=function(_6fe,_6ff){
if(this.refNode){
this.refNode.style.width=_6fe+"px";
this.refNode.style.height=_6ff+"px";
}
if(this.phNode){
this.phNode.style.width=_6fe+"px";
this.phNode.style.height=_6ff+"px";
}
};
IlvFacesProxy.prototype.getPlaceHolder=function(){
if(this.refNode){
var id=this.refNode.id;
var pos=id.lastIndexOf("_");
var idph=id.substring(0,pos)+"_ph";
return document.getElementById(idph);
}
};
IlvFacesProxy.prototype.setAbsoluteId=function(_703){
this.absId=_703;
};
IlvFacesProxy.prototype.getAbsoluteId=function(){
return this.absId;
};
IlvFacesProxy.onload=function(_704){
IlvPropertyStateManager.lockNotify=false;
IlvUtil.pageLoaded=true;
};
IlvFacesProxy.prototype.setPageIdSupport=function(){
if(typeof (this.jviewsObject.setAdditionalParameters)!="undefined"){
this.jviewsObject.setAdditionalParameters(IlvPageId.pageIdKey,IlvPageId.instance.getPageId());
}
};
IlvSizedViewProxy=function(_705){
this.superConstructor(_705);
this.minWidth=100;
this.minHeight=100;
};
IlvSizedViewProxy.prototype=new IlvFacesProxy();
IlvSizedViewProxy.prototype.setClassName("IlvSizedViewProxy");
IlvSizedViewProxy.prototype.setMinimumSize=function(_706,_707){
this.minWidth=_706;
this.minHeight=_707;
};
IlvSizedViewProxy.prototype.getMinimumSize=function(){
return {minWidth:this.minWidth,minHeight:this.minHeight};
};
IlvSizedViewProxy.prototype.getCreationSize=function(_708,_709,_70a){
var _70b=document.getElementById(_708);
this.setReferenceNode(_70b);
var w=_709;
var h=_70a;
if(_709&&_709>=this.minWidth){
this.widthSet=true;
}else{
w=_70b.offsetWidth;
if(w<=this.minWidth){
w=this.minWidth;
}
}
if(_70a&&_70a>=this.minHeight){
this.heightSet=true;
}else{
h=_70b.offsetHeight;
if(h<=this.minHeight){
h=this.minHeight;
}
}
if(!_70b.style.position||_70b.style.position=="static"){
_70b.style.position="relative";
}
return {width:w,height:h};
};
IlvSizedViewProxy.prototype.positionAfterLayout=function(_70e,_70f){
return {x:0,y:0};
};
IlvSizedViewProxy.prototype.resizeAfterLayout=function(init){
var w=0;
var h=0;
if(this.refNode){
w=this.refNode.offsetWidth;
h=this.refNode.offsetHeight;
}
if(w==0||!init){
this.oldStyleWidth=this.oldStyleWidth||this.refNode.style.width;
if(this.oldStyleWidth.lastIndexOf("%")>-1){
var pw=this.refNode.parentNode.offsetWidth;
if(pw<this.minWidth||!init){
pw=document.body.offsetWidth;
}
w=Math.round(pw*parseInt(this.oldStyleWidth)/100);
this.refNode.style.width=w+"px";
this.phNode.style.width=w+"px";
}
}
if(h==0||!init){
this.oldStyleHeight=this.oldStyleHeight||this.refNode.style.height;
if(this.oldStyleHeight.lastIndexOf("%")>-1){
var ph=this.refNode.parentNode.offsetHeight;
if(ph<this.minHeight||!init){
ph=document.body.offsetHeight;
}
h=Math.round(document.body.offsetHeight*parseInt(this.oldStyleHeight)/100);
this.refNode.style.height=h+"px";
this.phNode.style.height=h+"px";
}
}
if(w==0||h==0){
return;
}
var _715=false;
if(w<this.minWidth&&w!=0){
w=this.minWidth;
this.refNode.style.width=this.minWidth+"px";
_715=true;
}
if(h<this.minHeight&&h!=0){
h=this.minHeight;
this.refNode.style.height=this.minHeight+"px";
_715=true;
}
if(_715||!this.widthSet||!this.heightSet){
var pos=this.positionAfterLayout(w,h);
this.getObject().updateOnResizeLock=true;
var b=this.getObject().getBounds();
this.getObject().setBounds(pos.x,pos.y,w,h);
_715=b.left!=pos.x||b.top!=pos.y||b.width!=w||b.height!=h;
this.getObject().updateOnResizeLock=false;
}else{
this.getObject().setAdditionalParameters("componentWidth",w);
this.getObject().setAdditionalParameters("componentHeight",h);
}
this.getObject().updateOnResizeLock=true;
this.afterLayoutHandler(_715);
this.getObject().updateOnResizeLock=false;
this.layoutDone=true;
IlvPanel.visibilityLock=false;
this.getObject().updateVisibility();
if(init||_715){
this.init();
}
};
IlvSizedViewProxy.prototype.afterLayoutHandler=function(_718){
};
IlvSizedViewProxy.prototype.init=function(){
if(this.getObject().init){
this.getObject().init();
}
};
IlvSizedViewProxy.prototype.getAbsoluteBounds=function(){
var r=this.refNode;
return {left:r.offsetLeft,top:r.offsetTop,width:r.offsetWidth,height:r.offsetHeight};
};
IlvSizedViewProxy.prototype.getBounds=function(){
return this.getObject().getBounds();
};
IlvSizedViewProxy.prototype.getWidth=function(){
return this.getObject().getWidth();
};
IlvSizedViewProxy.prototype.getHeight=function(){
return this.getObject().getHeight();
};
IlvSizedViewProxy.prototype.registerResizeListener=function(_71a){
_71a.addSizeListener(IlvSizedViewProxy.onResize);
};
IlvSizedViewProxy.onResize=function(view){
if(!view.updateOnResizeLock){
var _71c=view.JSFRef;
_71c.resize(view.getWidth(),view.getHeight());
_71c.notify("Width");
_71c.notify("Height");
}
};
IlvSizedViewProxy.prototype.startResizeTimer=function(view){
if(this.resizeTimer){
clearTimeout(this.resizeTimer);
}
if(!this.callLater){
var _71e=this;
this.callLater=function(){
_71e.resizeAfterLayout(false);
};
}
this.resizeTimer=setTimeout(this.callLater,100);
};
IlvSizedViewProxy.onload=function(_71f){
IlvPropertyStateManager.lockNotify=false;
_71f.resizeAfterLayout(true);
};
IlvSizedViewProxy.onresize=function(_720){
_720.startResizeTimer();
};
IlvBasicViewProxy=function(_721){
if(_721){
this.superConstructor(_721);
}
};
IlvBasicViewProxy.prototype=new IlvSizedViewProxy();
IlvBasicViewProxy.prototype.setClassName("IlvBasicViewProxy");
IlvBasicViewProxy.prototype.dispose=function(){
this.superInvoke("dispose");
if(this.messageBox){
this.messageBox.dispose();
}
};
IlvBasicViewProxy.prototype.init=function(){
var o=this.getObject();
if(o.init){
o.init();
}
};
IlvBasicViewProxy.prototype.setResizable=function(_723){
this.getObject().setResizable(_723);
};
IlvBasicViewProxy.prototype.setProgressiveZoom=function(_724){
this.getObject().setProgressiveZoom(_724);
};
IlvBasicViewProxy.prototype.setMessageBox=function(_725){
this.messageBox=_725;
this.getObject().setMessagePanel(_725.getObject());
this.notify("MessageBoxId");
};
IlvBasicViewProxy.prototype.getMessageBoxId=function(){
return this.messageBox.getAbsoluteId();
};
IlvBasicViewProxy.prototype.setWaitingImage=function(_726){
this.getObject().setWaitingImage(_726);
this.notify("WaitingImage");
};
IlvBasicViewProxy.prototype.setImageFormat=function(_727){
this.getObject().setImageFormat(_727);
this.notify("ImageFormat");
};
IlvBasicViewProxy.prototype.getMessageBox=function(_728){
return this.messageBox;
};
IlvBasicViewProxy.prototype.getWaitingImage=function(_729){
return this.getObject().getWaitingImage();
};
IlvBasicViewProxy.prototype.getImageFormat=function(_72a){
return this.getObject().getImageFormat();
};
IlvBasicViewProxy.prototype.getServletClass=function(){
return this.servletClass;
};
IlvBasicViewProxy.prototype.setServletClass=function(_72b){
this.servletClass=_72b;
this.getObject().setAdditionalParameters("facesData",this.servletClass);
};
IlvBasicViewProxy.prototype.setServletURL=function(_72c){
this.getObject().setServletURL(_72c);
this.notify("ServletURL");
};
IlvBasicViewProxy.prototype.getServletURL=function(){
return this.getObject().getServletURL();
};
IlvBasicViewProxy.prototype.addRequestParameters=function(){
this.getObject().setAdditionalParameters("facesService","forward");
this.getObject().setAdditionalParameters("facesData",this.getServletClass());
};
IlvBasicViewHelperProxy=function(_72d,_72e,_72f,_730){
this.superConstructor(_72d);
};
IlvBasicViewHelperProxy.prototype=new IlvSizedViewProxy();
IlvBasicViewHelperProxy.prototype.setClassName("IlvBasicViewHelperProxy");
IlvBasicViewHelperProxy.prototype.setViewInternal=function(view){
this.view=view;
this.getObject().setViewInternal(view.getObject());
this.notify("ViewId");
};
IlvBasicViewHelperProxy.prototype.setView=function(view){
this.setViewInternal(view);
};
IlvBasicViewHelperProxy.prototype.getView=function(view){
return this.getViewInternal();
};
IlvBasicViewHelperProxy.prototype.getViewInternal=function(){
return this.view;
};
IlvBasicViewHelperProxy.prototype.getViewId=function(){
return this.view.getAbsoluteId();
};
IlvBasicViewHelperProxy.prototype.setMessageBox=function(_734){
this.messageBox=_734;
this.getObject().setMessagePanel(_734.getObject());
this.notify("MessageBoxId");
};
IlvBasicViewHelperProxy.prototype.getMessageBox=function(){
return this.messageBox;
};
IlvBasicViewHelperProxy.prototype.getMessageBoxId=function(){
return this.messageBox.getAbsoluteId();
};
IlvMessageBoxProxy=function(_735,_736){
this.superConstructor(_735);
this.setMinimumSize(50,5);
this.getCreationSize(_736);
this.phNode=this.getPlaceHolder();
this.messageBox=new IlvHTMLPanel("",this.phNode);
this.setObject(this.messageBox);
this.getObject().setVisible(true);
this.baseTextDirection="";
};
IlvMessageBoxProxy.prototype=new IlvSizedViewProxy();
IlvMessageBoxProxy.prototype.setClassName("IlvMessageBoxProxy");
IlvMessageBoxProxy.prototype.dispose=function(){
this.superInvoke("dispose");
this.messageBox.dispose();
this.phNode=null;
};
IlvMessageBoxProxy.prototype.displayMessage=function(_737){
this.getObject().setContent(IlvUtil.setMessageDirection(_737,this.baseTextDirection));
};
IlvMessageBoxProxy.prototype.setBaseTextDirection=function(_738){
this.baseTextDirection=_738;
this.getObject().setBaseTextDirection(_738);
};
IlvMessageBoxProxy.prototype.getBaseTextDirection=function(){
if(this.getObject().getBaseTextDirection()==""){
return this.baseTextDirection;
}
return this.getObject().getBaseTextDirection();
};
IlvInteractorProxy=function(_739){
if(typeof (_739)=="undefined"){
return;
}
this.superConstructor(_739);
};
IlvInteractorProxy.prototype=new IlvFacesProxy();
IlvInteractorProxy.prototype.setClassName("IlvInteractorProxy");
IlvInteractorProxy.prototype.setCursor=function(_73a){
this.getObject().setCursor(_73a);
this.notify("Cursor");
};
IlvInteractorProxy.prototype.getCursor=function(){
return this.getObject().getCursor();
};
IlvInteractorProxy.prototype.setMessage=function(_73b){
this.getObject().setMessage(_73b);
this.notify("Message");
};
IlvInteractorProxy.prototype.getMessage=function(){
return this.getObject().getMessage();
};
IlvInteractorProxy.prototype.setMenuModelId=function(_73c){
this.getObject().setMenuModelId(_73c);
this.notify("MenuModelId");
};
IlvInteractorProxy.prototype.getMenuModelId=function(){
return this.getObject().getMenuModelId();
};
IlvDragRectInteractorProxy=function(_73d){
this.superConstructor(_73d);
};
IlvDragRectInteractorProxy.prototype=new IlvInteractorProxy();
IlvDragRectInteractorProxy.prototype.setClassName("IlvDragRectInteractorProxy");
IlvDragRectInteractorProxy.prototype.setLineWidth=function(_73e){
this.getObject().setLineWidth(_73e);
this.notify("LineWidth");
};
IlvDragRectInteractorProxy.prototype.getLineWidth=function(){
return this.getObject().getLineWidth();
};
IlvDragRectInteractorProxy.prototype.setLineColor=function(_73f){
this.getObject().setColor(_73f);
this.notify("LineColor");
};
IlvDragRectInteractorProxy.prototype.getLineColor=function(){
return this.getObject().getColor();
};
IlvFacesSelectionManagerProxy=function(_740,_741,_742){
if(typeof (_740)=="undefined"){
return;
}
this.superConstructor(_740);
this.setObject(_741);
if(_742){
_741.setAdditionalParameters("infoProviderMB",_742);
}
};
IlvFacesSelectionManagerProxy.prototype=new IlvFacesProxy();
IlvFacesSelectionManagerProxy.prototype.setClassName("IlvFacesSelectionManagerProxy");
IlvFacesSelectionManagerProxy.prototype.getLineColor=function(){
return this.getObject().getLineColor();
};
IlvFacesSelectionManagerProxy.prototype.setLineColor=function(_743){
this.getObject().setLineColor(_743);
this.notify("LineColor");
};
IlvFacesSelectionManagerProxy.prototype.getLineWidth=function(){
return this.getObject().getLineWidth();
};
IlvFacesSelectionManagerProxy.prototype.setLineWidth=function(_744){
this.getObject().setLineWidth(_744);
this.notify("LineWidth");
};
IlvFacesSelectionManagerProxy.prototype.isImageMode=function(){
return this.getObject().isImageMode();
};
IlvFacesSelectionManagerProxy.prototype.setImageMode=function(_745){
this.getObject().setImageMode(_745);
this.notify("ImageMode");
};
IlvFacesSelectionManagerProxy.prototype.isFillOn=function(){
return this.getObject().isFillOn();
};
IlvFacesSelectionManagerProxy.prototype.setFillOn=function(_746){
this.getObject().setFillOn(_746);
this.notify("FillOn");
};
IlvFacesSelectionManagerProxy.prototype.getForceUpdateProperties=function(){
return this.getObject().getForceUpdateProperties();
};
IlvFacesSelectionManagerProxy.prototype.setForceUpdateProperties=function(_747){
this.getObject().setForceUpdateProperties(_747);
this.notify("ForceUpdateProperties");
};
IlvFacesSelectionManagerProxy.prototype.getInfoProviderMethodBinding=function(){
return this.getObject().getInfoProviderMethodBinding();
};
IlvFacesSelectionManagerProxy.prototype.getOnSelectionChanged=function(){
return this.onSelectionChanged;
};
IlvFacesSelectionManagerProxy.prototype.setOnSelectionChanged=function(_748){
if(this.onSelectionChanged){
this.getObject().removeSelectionChangedListener(this.onSelectionChanged);
}
this.onSelectionChanged=_748;
if(this.onSelectionChanged){
this.getObject().addSelectionChangedListener(this.onSelectionChanged);
}
this.notify("OnSelectionChanged");
};
IlvFacesSelectionManagerProxy.prototype.commitSelectionProperties=function(_749,_74a,_74b){
this.getObject().commitSelectionProperties(_749,_74a,_74b);
};
IlvButton.prototype.mouseDown=function(e){
if(this.enabled&&e.button!=2){
var _74d=this.isToggleButton();
if(_74d){
this.setSelected(!this.isSelected());
}else{
this.setSelected(true);
}
this.doAction(e);
}
};
IlvButton.prototype.doAction=function(_74e){
if(this.enabled){
if(typeof (this.action)=="function"){
return this.action(this.imageView.imagePanel._div,_74e);
}else{
eval(this.action);
}
}
};
IlvButton.prototype.doClick=function(){
if(this.enabled){
var _74f=this.isToggleButton();
if(_74f){
this.setSelected(!this.isSelected());
}else{
this.setSelected(true);
}
this.doAction();
if(!_74f){
this.setSelected(false);
}
}
};
IlvButton.prototype.getDoActionOnBGDeselect=function(){
return this.doActionOnBGDeselect;
};
IlvButton.prototype.setDoActionOnBGDeselect=function(_750){
this.doActionOnBGDeselect=_750;
};
IlvGroupedButton=function(left,top,_753,_754,_755,_756){
this.superConstructor(left,top,_753,_754,_755,_756);
this.group=null;
this.registerDispose();
};
IlvGroupedButton.prototype=new IlvButton();
IlvGroupedButton.prototype.setClassName("IlvGroupedButton");
IlvGroupedButton.prototype.dispose=function(){
this.superInvoke("dispose");
this.group=null;
};
IlvGroupedButton.prototype.setSelected=function(_757){
if(this.group&&_757&&this.enabled){
this.group.select(this);
}
this.superInvoke("setSelected",_757);
this.JSFRef.notify("Selected");
};
IlvGroupedButton.prototype.mouseDown=function(e){
if(this.isSelected()){
return false;
}
return this.superInvoke("mouseDown",e);
};
IlvToggleButton=function(left,top,_75b,_75c,_75d,_75e){
this.superConstructor(left,top,_75b,_75c,_75d,_75e);
this.registerDispose();
};
IlvToggleButton.prototype=new IlvButton();
IlvToggleButton.prototype.setClassName("IlvToggleButton");
IlvToggleButton.prototype.setSelected=function(_75f){
this.superInvoke("setSelected",_75f);
this.JSFRef.notify("Selected");
};
IlvButtonGroup=function(){
this.superConstructor();
this.selection=null;
this.registerDispose();
};
IlvButtonGroup.prototype=new IlvObject();
IlvButtonGroup.prototype.setClassName("IlvButtonGroup");
IlvButtonGroup.prototype.dispose=function(){
this.superInvoke("dispose");
this.selection=null;
};
IlvButtonGroup.prototype.select=function(_760){
if(this.selection){
var _761=this.selection.isEnabled();
this.selection.setEnabled(true);
this.selection.setSelected(false);
if(this.selection.getDoActionOnBGDeselect()){
this.selection.doAction();
}
this.selection.setEnabled(_761);
}
this.selection=_760;
};
IlvButtonGroup.prototype.add=function(_762){
_762.group=this;
if(_762.isSelected()&&!this.selection){
this.selection=_762;
}
};
IlvImageButtonProxy=function(_763,_764,_765){
if(_763){
this.superConstructor(_763);
this.setMinimumSize(10,10);
var size=this.getCreationSize(_764);
var _767=_765?new IlvGroupedButton(0,0,size.width,size.height):new IlvToggleButton(0,0,size.width,size.height);
this.setObject(_767);
this.baseTextDirection="";
}
};
IlvImageButtonProxy.prototype=new IlvSizedViewProxy();
IlvImageButtonProxy.prototype.setClassName("IlvImageButtonProxy");
IlvImageButtonProxy.prototype.setImage=function(_768){
this.getObject().setImage(_768);
this.notify("Image");
};
IlvImageButtonProxy.prototype.getImage=function(){
return this.getObject().getImage();
};
IlvImageButtonProxy.prototype.setRolloverImage=function(_769){
this.getObject().setRolloverImage(_769);
this.notify("RolloverImage");
};
IlvImageButtonProxy.prototype.getRolloverImage=function(){
return this.getObject().getRolloverImage();
};
IlvImageButtonProxy.prototype.setSelectedImage=function(_76a){
this.getObject().setSelectedImage(_76a);
this.notify("SelectedImage");
};
IlvImageButtonProxy.prototype.getSelectedImage=function(){
return this.getObject().getSelectedImage();
};
IlvImageButtonProxy.prototype.setCursor=function(_76b){
this.getObject().setCursor(_76b);
this.notify("Cursor");
};
IlvImageButtonProxy.prototype.getCursor=function(){
return this.getObject().getCursor();
};
IlvImageButtonProxy.prototype.setToggle=function(_76c){
this.getObject().setToggleButton(_76c);
this.notify("Toggle");
};
IlvImageButtonProxy.prototype.isToggle=function(){
return this.getObject().isToggleButton();
};
IlvImageButtonProxy.prototype.setMessage=function(_76d){
this.getObject().setMessage(_76d);
this.notify("Message");
};
IlvImageButtonProxy.prototype.getMessage=function(){
return this.getObject().getMessage();
};
IlvImageButtonProxy.prototype.setMessageBox=function(_76e){
this.messageBox=_76e;
this.getObject().setMessagePanel(_76e.getObject());
this.notify("MessageBoxId");
};
IlvImageButtonProxy.prototype.getMessageBox=function(){
return this.messageBox;
};
IlvImageButtonProxy.prototype.getMessageBoxId=function(){
return this.messageBox.getAbsoluteId();
};
IlvImageButtonProxy.prototype.setTitle=function(_76f){
this.getObject().setToolTipText(_76f);
this.notify("Title");
};
IlvImageButtonProxy.prototype.getTitle=function(){
return this.getObject().getTitle();
};
IlvImageButtonProxy.prototype.setOnclick=function(_770){
this.getObject().setAction(_770);
this.notify("onClick");
};
IlvImageButtonProxy.prototype.getOnclick=function(){
return this.getObject().getOnClick();
};
IlvImageButtonProxy.prototype.setEnabled=function(_771){
this.getObject().setEnabled(_771);
this.notify("Enabled");
};
IlvImageButtonProxy.prototype.isEnabled=function(){
return this.getObject().isEnabled();
};
IlvImageButtonProxy.prototype.setSelected=function(_772){
this.getObject().setSelected(_772);
this.notify("Selected");
};
IlvImageButtonProxy.prototype.isSelected=function(){
return this.getObject().isSelected();
};
IlvImageButtonProxy.prototype.setCommitted=function(_773){
this.committed=_773;
this.notify("Committed");
};
IlvImageButtonProxy.prototype.isCommitted=function(){
return this.committed;
};
IlvImageButtonProxy.prototype.getDoActionOnBGDeselect=function(){
return this.getObject().getDoActionOnBGDeselect();
};
IlvImageButtonProxy.prototype.setDoActionOnBGDeselect=function(_774){
this.getObject().setDoActionOnBGDeselect(_774);
this.notify("DoActionOnBGDeselect");
};
IlvImageButtonProxy.prototype.doClick=function(){
this.getObject().doClick();
};
IlvImageButtonProxy.prototype.doAction=function(){
this.getObject().doAction();
};
IlvImageButtonProxy.prototype.setBaseTextDirection=function(_775){
if(_775){
this.getObject().setBaseTextDirection(_775);
}
};
IlvImageButtonProxy.prototype.getBaseTextDirection=function(){
return this.getObject().getBaseTextDirection();
};
IlvObjectSelectInteractorProxy=function(_776,_777){
if(_776){
this.superConstructor(_776);
this.formId=_777;
this.autoSubmit=true;
this.partialSubmit=false;
this.invocationContext="JSF_CONTEXT";
this.finder="none";
this.methodRef="none";
}
};
IlvObjectSelectInteractorProxy.prototype=new IlvInteractorProxy();
IlvObjectSelectInteractorProxy.prototype.setClassName("IlvObjectSelectInteractorProxy");
IlvObjectSelectInteractorProxy.prototype.getAutoSubmit=function(){
return this.autoSubmit;
};
IlvObjectSelectInteractorProxy.prototype.setAutoSubmit=function(_778){
this.autoSubmit=_778;
this.notify("AutoSubmit");
};
IlvObjectSelectInteractorProxy.prototype.getPartialSubmit=function(){
return this.partialSubmit;
};
IlvObjectSelectInteractorProxy.prototype.setPartialSubmit=function(_779){
this.partialSubmit=_779;
this.notify("PartialSubmit");
};
IlvObjectSelectInteractorProxy.prototype.performSelect=function(_77a){
this.setSubmittedValue(_77a.join("|"));
if(this.autoSubmit){
var form=document.getElementById(this.formId);
if(form){
IlvUtil.submitForm(form,this.clientId,this.partialSubmit);
}
}
};
IlvObjectSelectInteractorProxy.prototype.setSubmittedValue=function(_77c){
this.params=_77c;
this.notify("SubmittedValue");
};
IlvObjectSelectInteractorProxy.prototype.getSubmittedValue=function(){
return this.params;
};
IlvObjectSelectInteractorProxy.prototype.setViewId=function(vId){
this.vId=vId;
var _77e=IlvPropertyStateManager.lockNotify;
IlvPropertyStateManager.lockNotify=false;
this.notify("ViewId");
IlvPropertyStateManager.lockNotify=_77e;
};
IlvObjectSelectInteractorProxy.prototype.getViewId=function(){
return this.vId;
};
IlvObjectSelectInteractorProxy.prototype.getInvocationContext=function(){
return this.invocationContext;
};
IlvObjectSelectInteractorProxy.prototype.setInvocationContext=function(_77f){
this.invocationContext=_77f;
this.notify("InvocationContext");
};
IlvObjectSelectInteractorProxy.prototype.getValueChangeListener=function(){
return this.methodRef;
};
IlvObjectSelectInteractorProxy.prototype.setValueChangeListener=function(_780){
this.methodRef=_780;
this.notify("ValueChangeListener");
};
IlvObjectSelectInteractorProxy.prototype.getValueChangeListeners=function(){
return this.listenersRef;
};
IlvObjectSelectInteractorProxy.prototype.setValueChangeListeners=function(_781){
this.listenersRef=_781;
};
IlvObjectSelectInteractorProxy.prototype.getObjectSelectedFinder=function(){
return this.finder;
};
IlvObjectSelectInteractorProxy.prototype.setObjectSelectedFinder=function(_782){
this.finder=_782;
this.notify("ObjectSelectedFinder");
};
IlvObjectSelectRectInteractorProxy=function(_783,_784){
if(_783){
this.superConstructor(_783,_784);
}
};
IlvObjectSelectRectInteractorProxy.prototype=new IlvObjectSelectInteractorProxy();
IlvObjectSelectRectInteractorProxy.prototype.setClassName("IlvObjectSelectRectInteractorProxy");
IlvObjectSelectRectInteractorProxy.prototype.performSelectRect=function(_785){
this.performSelect(_785);
};
IlvObjectSelectRectInteractorProxy.prototype.setLineWidth=function(_786){
this.getObject().setLineWidth(_786);
this.notify("LineWidth");
};
IlvObjectSelectRectInteractorProxy.prototype.getLineWidth=function(){
return this.getObject().getLineWidth();
};
IlvObjectSelectRectInteractorProxy.prototype.setLineColor=function(_787){
this.getObject().setColor(_787);
this.notify("LineColor");
};
IlvObjectSelectRectInteractorProxy.prototype.getLineColor=function(){
return this.getObject().getColor();
};
IlvFacesSelectInteractorProxy=function(_788,_789){
if(typeof (_788)=="undefined"){
return;
}
this.superConstructor(_788);
this.infoProviderMB=_789;
};
IlvFacesSelectInteractorProxy.prototype=new IlvInteractorProxy();
IlvFacesSelectInteractorProxy.prototype.setClassName("IlvFacesSelectInteractorProxy");
IlvFacesSelectInteractorProxy.prototype.desinstallInteractor=function(mgr){
if(this.onSelectionChanged!=null&&this.listenerAdded){
mgr.removeSelectionChangedListener(this.onSelectionChanged);
}
};
IlvFacesSelectInteractorProxy.prototype.setupSelectionManager=function(mgr){
if(this.imageMode!=null){
mgr.setImageMode(this.imageMode);
}
if(this.lineWidth!=null){
mgr.setLineWidth(this.lineWidth);
}
if(this.color!=null){
mgr.setLineColor(this.color);
}
if(this.forceUpdateProperties!=null){
mgr.setForceUpdateProperties(this.forceUpdateProperties);
}
if(typeof (this.infoProviderMB)!="undefined"){
if(this.infoProviderMB!=null){
mgr.setAdditionalParameters("infoProviderMB",this.infoProviderMB);
}else{
mgr.removeAdditionalParameter("infoProviderMB");
}
}
if(this.onSelectionChanged!=null&&!this.listenerAdded){
mgr.addSelectionChangedListener(this.onSelectionChanged);
}
if(this.moveAllowed!=null){
mgr.setMoveAllowed(this.moveAllowed);
}
};
IlvFacesSelectInteractorProxy.prototype.getLineColor=function(){
return this.color;
};
IlvFacesSelectInteractorProxy.prototype.setLineColor=function(_78c){
this.color=_78c;
this.notify("LineColor");
var v=this.getObject().view;
if(v!=null){
v.getSelectionManager().setLineColor(_78c);
}
};
IlvFacesSelectInteractorProxy.prototype.getLineWidth=function(){
return this.lineWidth;
};
IlvFacesSelectInteractorProxy.prototype.setLineWidth=function(_78e){
this.lineWidth=_78e;
this.notify("LineWidth");
var v=this.getObject().view;
if(v!=null){
v.getSelectionManager().setLineWidth(_78e);
}
};
IlvFacesSelectInteractorProxy.prototype.isMoveAllowed=function(){
return this.moveAllowed;
};
IlvFacesSelectInteractorProxy.prototype.setMoveAllowed=function(_790){
this.moveAllowed=_790;
this.notify("MoveAllowed");
var v=this.getObject().view;
if(v!=null){
v.getSelectionManager().setMoveAllowed(_790);
}
};
IlvFacesSelectInteractorProxy.prototype.isImageMode=function(){
return this.imageMode;
};
IlvFacesSelectInteractorProxy.prototype.setImageMode=function(_792){
this.imageMode=_792;
this.notify("ImageMode");
var v=this.getObject().view;
if(v!=null){
v.getSelectionManager().setImageMode(_792);
}
};
IlvFacesSelectInteractorProxy.prototype.isForceUpdateProperties=function(){
return this.forceUpdateProperties;
};
IlvFacesSelectInteractorProxy.prototype.setForceUpdateProperties=function(_794){
this.forceUpdateProperties=_794;
this.notify("ForceUpdateProperties");
var v=this.getObject().view;
if(v!=null){
v.getSelectionManager().setForceUpdateProperties(_794);
}
};
IlvFacesSelectInteractorProxy.prototype.getOnSelectionChanged=function(){
return this.onSelectionChanged;
};
IlvFacesSelectInteractorProxy.prototype.setOnSelectionChanged=function(_796){
this.onSelectionChanged=_796;
var v=this.getObject().view;
if(v!=null){
v.getSelectionManager().addSelectionChangedListener(_796);
this.listenerAdded=true;
}
this.notify("OnSelectionChanged");
};
IlvAbstractPopupMenu.prototype.imageToPageCoordinateSystem=function(view,x,y){
var _79b=view.JSFRef.getNodeCoords();
return {x:x+_79b.left,y:y+_79b.top};
};
IlvPopupMenuFactory.prototype.readAction=function(item,_79d){
var type=_79d[0];
if(type=="JS"){
item.setAction(eval(_79d[1]));
}else{
if(type=="Servlet"){
var _79f=_79d[1];
var _7a0=_79d[2];
var _7a1=_79d.slice(3);
item.setAction(function(){
item.performServerAction(_79f,_7a1,_7a0);
});
}else{
if(type=="JSF"){
item.setAction(function(){
item.performJSFAction();
});
}
}
}
};
IlvMenuItem.prototype.performJSFAction=function(){
this.getRoot().popupMenu.performJSFAction(this._path);
};
IlvAbstractPopupMenu.prototype.performJSFAction=function(path){
this.JSFRef.performJSFAction(this._triggerLeft,this._triggerTop,path);
};
IlvAbstractPopupMenu.prototype.performServerAction=function(_7a3,_7a4,_7a5){
this.JSFRef.performServerAction(_7a3,_7a4,_7a5);
};
IlvAbstractPopupMenuProxy=function(_7a6,_7a7){
if(_7a6!=null){
this.superConstructor(_7a6);
this.formId=_7a7;
}
this.partialSubmit=false;
this.baseTextDirection="";
};
IlvAbstractPopupMenuProxy.prototype=new IlvFacesProxy();
IlvAbstractPopupMenuProxy.prototype.setClassName("IlvAbstractPopupMenuProxy");
IlvAbstractPopupMenuProxy.prototype.getPartialSubmit=function(){
return this.partialSubmit;
};
IlvAbstractPopupMenuProxy.prototype.setPartialSubmit=function(_7a8){
this.partialSubmit=_7a8;
this.notify("PartialSubmit");
};
IlvAbstractPopupMenuProxy.prototype.setFactory=function(_7a9){
this.factory=_7a9;
this.notify("Factory");
};
IlvAbstractPopupMenuProxy.prototype.getFactory=function(){
return this.factory;
};
IlvAbstractPopupMenuProxy.prototype.setBaseTextDirection=function(_7aa){
this.baseTextDirection=_7aa;
this.getObject().setBaseTextDirection(_7aa);
};
IlvAbstractPopupMenuProxy.prototype.getBaseTextDirection=function(){
return this.baseTextDirection;
};
IlvAbstractPopupMenuProxy.prototype.readMenu=function(_7ab){
var _7ac=this.getObject().factory;
var menu=_7ac.read(_7ab);
this.getObject().setMenu(menu);
};
IlvAbstractPopupMenuProxy.prototype.setMenu=function(menu){
this.getObject().setMenu(menu);
};
IlvAbstractPopupMenuProxy.prototype.performJSFAction=function(x,y,path){
var _7b2=this.getActionParameters(x,y);
var _7b3=_7b2[0]+","+_7b2[1];
var _7b4=_7b2.length;
for(var i=2;i<_7b4;i++){
_7b3+=","+_7b2[i];
}
this.action=_7b3;
this.path=path;
this.notify("JSFAction");
this.notify("Path");
if(document.forms[this.formId]){
IlvUtil.submitForm(document.forms[this.formId],this.clientId,this.partialSubmit);
}else{
alert(jviews.messages.IlvAbstractPopupMenuProxy.popupMenuNotJSFForm);
}
};
IlvAbstractPopupMenuProxy.prototype.performServerAction=function(_7b6,_7b7,_7b8){
var view=this.getObject().view;
if(view!=null&&_7b6!=null){
view.performAction(_7b6,this.adaptParameters(_7b7),_7b8);
}
};
IlvAbstractPopupMenuProxy.prototype.adaptParameters=function(_7ba){
};
IlvAbstractPopupMenuProxy.prototype.getActionParameters=function(x,y){
};
IlvAbstractPopupMenuProxy.prototype.getJSFAction=function(){
return this.action;
};
IlvAbstractPopupMenuProxy.prototype.getPath=function(){
return this.path;
};
IlvAbstractPopupMenuProxy.prototype.setObjectSelectedFinder=function(_7bd){
this.finder=_7bd;
};
IlvAbstractPopupMenuProxy.prototype.getObjectSelectedFinder=function(){
return this.finder;
};
IlvAbstractPopupMenuProxy.prototype.getItemStyleClass=function(){
return this.getObject().getItemStyleClass();
};
IlvAbstractPopupMenuProxy.prototype.setItemStyleClass=function(_7be){
this.getObject().setItemStyleClass(_7be);
};
IlvAbstractPopupMenuProxy.prototype.getItemHighlightedStyleClass=function(){
return this.getObject().getItemHighlightedStyleClass();
};
IlvAbstractPopupMenuProxy.prototype.setItemHighlightedStyleClass=function(_7bf){
this.getObject().setItemHighlightedStyleClass(_7bf);
};
IlvAbstractPopupMenuProxy.prototype.getItemDisabledStyleClass=function(){
return this.getObject().getItemDisabledStyleClass();
};
IlvAbstractPopupMenuProxy.prototype.setItemDisabledStyleClass=function(_7c0){
this.getObject().setItemDisabledStyleClass(_7c0);
};
IlvInteractorGroupProxy=function(_7c1){
this.superConstructor(_7c1);
this.setObject(new IlvInteractorGroup());
};
IlvInteractorGroupProxy.prototype=new IlvInteractorProxy();
IlvInteractorGroupProxy.prototype.setClassName("IlvInteractorGroupProxy");
IlvInteractorGroupProxy.prototype.setInteractors=function(_7c2){
if(typeof (_7c2)!="undefined"){
var _7c3=_7c2.split(" ");
for(var i=0;i<_7c3.length;i++){
if(_7c3[i]!==""){
this.getObject().addInteractor(IlvObject.disposeProxyInstances[_7c3[i]].getObject());
}
}
}
};
IlvAjaxInteractorProxy=function(_7c5){
this.superConstructor(_7c5);
this.setObject(new IlvAjaxInteractor());
};
IlvAjaxInteractorProxy.prototype=new IlvInteractorProxy();
IlvAjaxInteractorProxy.prototype.setClassName("IlvAjaxInteractorProxy");
IlvAjaxInteractorProxy.prototype.setRender=function(_7c6){
this.getObject().setRender(_7c6);
};
IlvCursorChangeInteractorProxy=function(_7c7){
this.superConstructor(_7c7);
this.setObject(new IlvCursorChangeInteractor());
};
IlvCursorChangeInteractorProxy.prototype=new IlvInteractorProxy();
IlvCursorChangeInteractorProxy.prototype.setClassName("IlvCursorChangeInteractorProxy");
IlvResizeInteractorProxy=function(_7c8){
this.superConstructor(_7c8);
this.setObject(new IlvResizeInteractor());
};
IlvResizeInteractorProxy.prototype=new IlvFacesSelectInteractorProxy();
IlvResizeInteractorProxy.prototype.setClassName("IlvResizeInteractorProxy");
IlvResizeInteractorProxy.prototype.setActionName=function(_7c9){
this.getObject().setActionName(_7c9);
};
IlvLinkInteractorProxy=function(_7ca){
this.superConstructor(_7ca);
this.setObject(new IlvLinkInteractor());
};
IlvLinkInteractorProxy.prototype=new IlvFacesSelectInteractorProxy();
IlvLinkInteractorProxy.prototype.setClassName("IlvLinkInteractorProxy");
IlvLinkInteractorProxy.prototype.setActionName=function(_7cb){
this.getObject().setActionName(_7cb);
};
IlvLinkInteractorProxy.prototype.setAddRemovePointModifier=function(_7cc){
this.getObject().setAddRemovePointModifier(_7cc);
};
IlvInterceptInteractorProxy=function(_7cd){
this.superConstructor(_7cd);
this.eventType=null;
};
IlvInterceptInteractorProxy.prototype=new IlvInteractorProxy();
IlvInterceptInteractorProxy.prototype.setClassName("IlvInterceptInteractorProxy");
IlvInterceptInteractorProxy.prototype.setInteractor=function(_7ce){
this.setObject(new IlvInterceptInteractor(_7ce.getObject()));
};
IlvInterceptInteractorProxy.prototype.setBeforeHandler=function(_7cf){
if(this.eventType!==null){
this.getObject().setBeforeHandler(this.eventType,_7cf);
}
};
IlvInterceptInteractorProxy.prototype.setAfterHandler=function(_7d0){
if(this.eventType!==null){
this.getObject().setAfterHandler(this.eventType,_7d0);
}
};
IlvInterceptInteractorProxy.prototype.setOverrideHandler=function(_7d1){
if(this.eventType!==null){
this.getObject().setOverrideHandler(this.eventType,_7d1);
}
};
IlvInterceptInteractorProxy.prototype.setEventType=function(_7d2){
this.eventType=_7d2;
};
}
