package com.jang.addrbook;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import com.jang.addrbook.AddrBook;

@Controller
public class AddrControler {

	@RequestMapping("/addrbook_list.do")
	public ModelAndView addrbookList(AddrBook ab, AddrBean abdao, ModelAndView mav) throws Exception{
		mav.addObject("addrBookList",abdao.getDBList()); //addrBookList에 담고 
		mav.setViewName("addrbook_list"); //addrbook_list 로 보냈다.
		return mav;
	}

	//신규회원 등록 화면
	@RequestMapping("/addrbook_form.do")
	public String addrbookForm() throws Exception{
		return "addrbook_form";
	}

	//신규회원 insert
	@RequestMapping("/addrbook_insert.do")
	public String addrbookInsert(AddrBook ab, AddrBean abdao, ModelAndView mav) throws Exception{
		abdao.insertDB(ab); 
		return "redirect:addrbook_list.do";
	}



	@RequestMapping("/addrbook_edit_form.do")
	public ModelAndView addrbookOne(AddrBook ab, AddrBean abdao, ModelAndView mav) throws Exception{
		mav.addObject("addrBookOne",abdao.getDB(ab.getAb_num())); //addrBookList에 담고 
		mav.setViewName("addrbook_edit_form"); //addrbook_list 로 보냈다.
		return mav;
	}


	//회원 정보 수정 update
	@RequestMapping("/addrbook_update.do")
	public String addrbookUpdate(AddrBook ab, AddrBean abdao) throws Exception{
		abdao.updateDB(ab); 
		return "redirect:addrbook_list.do";
	}

	//회원 삭제 Delete
	@RequestMapping("addrbook_delete.do")
	public String addrbookDelete(AddrBook ab, AddrBean abdao) throws Exception{
		abdao.deleteDB(ab.getAb_num()); 
		return "redirect:addrbook_list.do";
	}





}
