/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.handlers;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.AbstractFlightRecordingEditor;
import com.jrockit.mc.ui.MCPathEditorInput;
import com.jrockit.mc.ui.idesupport.IDESupportUIToolkit;
import com.jrockit.mc.ui.misc.ErrorDialog;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.internal.handlers.SaveAsHandler;

public class SaveAsJFRHandler
extends SaveAsHandler {
    public Object execute(ExecutionEvent event) {
        ISaveablePart saveablePart = this.getSaveablePart(event);
        if (saveablePart != null && saveablePart instanceof AbstractFlightRecordingEditor) {
            AbstractFlightRecordingEditor editor = (AbstractFlightRecordingEditor)saveablePart;
            File srcFile = MCPathEditorInput.getFile((IEditorInput)editor.getEditorInput());
            if (srcFile != null) {
                File saveAsFile;
                do {
                    if ((saveAsFile = ControlPanel.openSaveAsFileBrowser(srcFile)) != null) continue;
                    return null;
                } while (IDESupportUIToolkit.checkAlreadyExists((File)saveAsFile));
                try {
                    IOToolkit.copyFile((File)srcFile, (File)saveAsFile);
                    editor.setActiveFile(saveAsFile);
                }
                catch (IOException e) {
                    ErrorDialog.showException((Shell)editor.getActiveEditor().getSite().getShell(), (String)Messages.SAVE_AS_ERROR_MSG, (Throwable)e);
                }
            } else {
                ErrorDialog.showError((Shell)editor.getActiveEditor().getSite().getShell(), (String)Messages.SAVE_AS_ERROR_MSG, (String)Messages.SAVE_AS_NO_SRC_ERROR_MSG);
            }
        }
        return null;
    }
}

