/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import oracle.core.lmx.CoreException;
import oracle.sql.Datum;
import oracle.sql.LnxLib;
import oracle.sql.LnxLibServer;
import oracle.sql.LnxLibThin;

public class NUMBER
extends Datum {
    static byte[] MAX_LONG = NUMBER.toBytes(Long.MAX_VALUE);
    static byte[] MIN_LONG = NUMBER.toBytes(Long.MIN_VALUE);
    private static final int CHARACTER_ZERO = 48;
    private static final BigDecimal BIGDEC_NEGZERO = new BigDecimal("-0");
    private static final BigDecimal BIGDEC_ZERO = BigDecimal.valueOf(0L);
    private static final BigDecimal BIGDEC_ONE = BigDecimal.valueOf(1L);
    private static final BigInteger BIGINT_ZERO = BigInteger.valueOf(0L);
    private static final BigInteger BIGINT_HUND = BigInteger.valueOf(100L);
    private static final byte DIGEND = 21;
    private static final byte ODIGEND = 9;
    private static final int HUNDIGMAX = 66;
    private static final int BIGINTARRAYMAX = 54;
    private static final double BIGRATIO = 0.1505149978319906;
    private static final int BIGLENMAX = 22;
    static final byte LNXM_NUM = 22;
    static final int LNXSGNBT = 128;
    static final byte LNXDIGS = 20;
    static final byte LNXEXPBS = 64;
    static final double ORANUM_FBASE = 100.0;
    static final int LNXBASE = 100;
    static final byte IEEE_DBL_DIG = 15;
    private static final byte IEEE_FLT_DIG = 6;
    static final int LNXEXPMX = 127;
    static final int LNXEXPMN = 0;
    static final int LNXMXOUT = 40;
    static final int LNXMXFMT = 64;
    private static final byte BYTE_MAX_VALUE = 127;
    private static final byte BYTE_MIN_VALUE = -128;
    private static final short SHORT_MAX_VALUE = Short.MAX_VALUE;
    private static final short SHORT_MIN_VALUE = Short.MIN_VALUE;
    private static final byte[] PI = new byte[]{-63, 4, 15, 16, 93, 66, 36, 90, 80, 33, 39, 47, 27, 44, 39, 33, 80, 51, 29, 85, 21};
    private static final byte[] E = new byte[]{-63, 3, 72, 83, 82, 83, 85, 60, 5, 53, 36, 37, 3, 88, 48, 14, 53, 67, 25, 98, 77};
    private static final byte[] LN10 = new byte[]{-63, 3, 31, 26, 86, 10, 30, 95, 5, 57, 85, 2, 80, 92, 46, 47, 85, 37, 43, 8, 61};
    private static LnxLib _slnxlib;
    private static LnxLib _thinlib;
    private static int DBL_MAX;
    private static int INT_MAX;
    private static float FLOAT_MAX_INT;
    private static float FLOAT_MIN_INT;
    private static double DOUBLE_MAX_INT;
    private static double DOUBLE_MIN_INT;
    private static double DOUBLE_MAX_INT_2;
    private static double DOUBLE_MIN_INT_2;
    private static Object drvType;
    private static String LANGID;

    public NUMBER() {
        super(NUMBER._makeZero());
    }

    public NUMBER(byte[] byArray) {
        super(byArray);
    }

    public NUMBER(byte by) {
        super(NUMBER.toBytes(by));
    }

    public NUMBER(int n) {
        super(NUMBER.toBytes(n));
    }

    public NUMBER(long l) {
        super(NUMBER.toBytes(l));
    }

    public NUMBER(short s) {
        super(NUMBER.toBytes(s));
    }

    public NUMBER(float f) {
        super(NUMBER.toBytes(f));
    }

    public NUMBER(double d) throws SQLException {
        super(NUMBER.toBytes(d));
    }

    public NUMBER(BigDecimal bigDecimal) throws SQLException {
        super(NUMBER.toBytes(bigDecimal));
    }

    public NUMBER(BigInteger bigInteger) throws SQLException {
        super(NUMBER.toBytes(bigInteger));
    }

    public NUMBER(String string, int n) throws SQLException {
        super(NUMBER.toBytes(string, n));
    }

    public NUMBER(boolean bl) {
        super(NUMBER.toBytes(bl));
    }

    public NUMBER(Object object) throws SQLException {
        if (object instanceof Integer) {
            this.setShareBytes(NUMBER.toBytes((Integer)object));
        } else if (object instanceof Long) {
            this.setShareBytes(NUMBER.toBytes((Long)object));
        } else if (object instanceof Float) {
            this.setShareBytes(NUMBER.toBytes(((Float)object).floatValue()));
        } else if (object instanceof Double) {
            this.setShareBytes(NUMBER.toBytes((Double)object));
        } else if (object instanceof BigInteger) {
            this.setShareBytes(NUMBER.toBytes((BigInteger)object));
        } else if (object instanceof BigDecimal) {
            this.setShareBytes(NUMBER.toBytes((BigDecimal)object));
        } else if (object instanceof Boolean) {
            this.setShareBytes(NUMBER.toBytes((Boolean)object));
        } else if (object instanceof String) {
            this.setShareBytes(this.stringToBytes((String)object));
        } else {
            throw new SQLException("Initialization failed");
        }
    }

    public static double toDouble(byte[] byArray) {
        if (NUMBER._isZero(byArray)) {
            return 0.0;
        }
        if (NUMBER._isPosInf(byArray)) {
            return Double.POSITIVE_INFINITY;
        }
        if (NUMBER._isNegInf(byArray)) {
            return Double.NEGATIVE_INFINITY;
        }
        String string = null;
        try {
            string = drvType == null ? _slnxlib.lnxnuc(byArray, DBL_MAX, null) : _slnxlib.lnxnuc(byArray, DBL_MAX, LANGID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        double d = Double.valueOf(string);
        return d;
    }

    public static float toFloat(byte[] byArray) {
        return (float)NUMBER.toDouble(byArray);
    }

    public static long toLong(byte[] byArray) throws SQLException {
        if (NUMBER._isZero(byArray)) {
            return 0L;
        }
        if (NUMBER._isInf(byArray) || NUMBER.compareBytes(byArray, MAX_LONG) > 0 || NUMBER.compareBytes(byArray, MIN_LONG) < 0) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        return NUMBER._getLnxLib().lnxsni(byArray);
    }

    public static int toInt(byte[] byArray) throws SQLException {
        if (NUMBER._isInf(byArray)) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        String string = drvType == null ? _slnxlib.lnxnuc(byArray, INT_MAX, null) : _slnxlib.lnxnuc(byArray, INT_MAX, LANGID);
        double d = Double.valueOf(string);
        if ((float)d > FLOAT_MAX_INT || (float)d < FLOAT_MIN_INT) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        if (d > DOUBLE_MAX_INT && d <= DOUBLE_MAX_INT_2) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        if (d < DOUBLE_MIN_INT && d >= DOUBLE_MIN_INT_2) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        int n = (int)d;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short toShort(byte[] byArray) throws SQLException {
        long l = 0L;
        l = NUMBER.toLong(byArray);
        if (l > 32767L || l < -32768L) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        return (short)l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte toByte(byte[] byArray) throws SQLException {
        long l = 0L;
        l = NUMBER.toLong(byArray);
        if (l > 127L || l < -128L) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        return (byte)l;
    }

    public static BigInteger toBigInteger(byte[] byArray) throws SQLException {
        int n;
        long[] lArray = new long[10];
        int n2 = 9;
        int n3 = 1;
        int n4 = 0;
        if (NUMBER._isZero(byArray)) {
            return BIGINT_ZERO;
        }
        if (NUMBER._isInf(byArray)) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        boolean bl = NUMBER._isPositive(byArray);
        byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
        if (byArray2[0] < 0) {
            return BIGINT_ZERO;
        }
        int n5 = n = Math.min(byArray2[0] + 1, byArray2.length - 1);
        if ((n & 1) == 1) {
            lArray[n2] = byArray2[n3];
            n3 = (byte)(n3 + 1);
            --n5;
        } else {
            lArray[n2] = byArray2[n3] * 100 + byArray2[n3 + 1];
            n3 = (byte)(n3 + 2);
            n5 -= 2;
        }
        int n6 = n2;
        while (n5 != 0) {
            long l = byArray2[n3] * 100 + byArray2[n3 + 1];
            for (n2 = 9; n2 >= n6; n2 = (int)((byte)(n2 - 1))) {
                lArray[n2] = (l += lArray[n2] * 10000L) & 0xFFFFL;
                l >>= 16;
            }
            if (l != 0L) {
                // empty if block
            }
            n6 = (byte)(n6 - 1);
            lArray[n6] = l;
            n3 = (byte)(n3 + 2);
            n5 -= 2;
        }
        int n7 = lArray[n6] >> 8 != 0L ? 2 * (9 - n6) + 2 : 2 * (9 - n6) + 1;
        byte[] byArray3 = new byte[n7];
        if ((n7 & 1) == 1) {
            byArray3[n4] = (byte)lArray[n6];
            ++n4;
        } else {
            byArray3[n4] = (byte)(lArray[n6] >> 8);
            byArray3[++n4] = (byte)(lArray[n6] & 0xFFL);
            ++n4;
        }
        for (n6 = (int)((byte)(n6 + 1)); n6 <= 9; n6 = (int)((byte)(n6 + 1))) {
            byArray3[n4] = (byte)(lArray[n6] >> 8);
            byArray3[n4 + 1] = (byte)(lArray[n6] & 0xFFL);
            n4 += 2;
        }
        BigInteger bigInteger = new BigInteger(bl ? 1 : -1, byArray3);
        int n8 = byArray2[0] - (n - 1);
        return bigInteger.multiply(BIGINT_HUND.pow(n8));
    }

    public static BigDecimal toBigDecimal(byte[] byArray) throws SQLException {
        int n;
        long[] lArray = new long[10];
        int n2 = 9;
        int n3 = 1;
        int n4 = 0;
        if (NUMBER._isZero(byArray)) {
            return BIGDEC_ZERO;
        }
        if (NUMBER._isInf(byArray)) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        boolean bl = NUMBER._isPositive(byArray);
        byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
        int n5 = n = byArray2.length - 1;
        if ((n & 1) == 1) {
            lArray[n2] = byArray2[n3];
            n3 = (byte)(n3 + 1);
            --n5;
        } else {
            lArray[n2] = byArray2[n3] * 100 + byArray2[n3 + 1];
            n3 = (byte)(n3 + 2);
            n5 -= 2;
        }
        int n6 = n2;
        while (n5 != 0) {
            long l = byArray2[n3] * 100 + byArray2[n3 + 1];
            for (n2 = 9; n2 >= n6; n2 = (int)((byte)(n2 - 1))) {
                lArray[n2] = (l += lArray[n2] * 10000L) & 0xFFFFL;
                l >>= 16;
            }
            if (l != 0L) {
                // empty if block
            }
            n6 = (byte)(n6 - 1);
            lArray[n6] = l;
            n3 = (byte)(n3 + 2);
            n5 -= 2;
        }
        int n7 = lArray[n6] >> 8 != 0L ? 2 * (9 - n6) + 2 : 2 * (9 - n6) + 1;
        byte[] byArray3 = new byte[n7];
        if ((n7 & 1) == 1) {
            byArray3[n4] = (byte)lArray[n6];
            ++n4;
        } else {
            byArray3[n4] = (byte)(lArray[n6] >> 8);
            byArray3[++n4] = (byte)(lArray[n6] & 0xFFL);
            ++n4;
        }
        for (n6 = (int)((byte)(n6 + 1)); n6 <= 9; n6 = (int)((byte)(n6 + 1))) {
            byArray3[n4] = (byte)(lArray[n6] >> 8);
            byArray3[n4 + 1] = (byte)(lArray[n6] & 0xFFL);
            n4 += 2;
        }
        BigInteger bigInteger = new BigInteger(bl ? 1 : -1, byArray3);
        BigDecimal bigDecimal = new BigDecimal(bigInteger);
        int n8 = byArray2[0] - n + 1;
        bigDecimal = bigDecimal.movePointRight(n8 * 2);
        if (n8 < 0 && byArray2[n] % 10 == 0) {
            bigDecimal = bigDecimal.setScale(-(n8 * 2 + 1));
        }
        return bigDecimal;
    }

    public static String toString(byte[] byArray) {
        int n;
        int n2 = 0;
        if (NUMBER._isZero(byArray)) {
            return new String("0");
        }
        if (NUMBER._isPosInf(byArray)) {
            return new Double(Double.POSITIVE_INFINITY).toString();
        }
        if (NUMBER._isNegInf(byArray)) {
            return new Double(Double.NEGATIVE_INFINITY).toString();
        }
        byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
        int n3 = byArray2[0];
        int n4 = n3 - ((n = byArray2.length - 1) - 1);
        int n5 = n4 >= 0 ? 2 * (n3 + 1) + 1 : (n3 >= 0 ? 2 * (n + 1) : 2 * (n - n3) + 3);
        char[] cArray = new char[n5];
        if (!NUMBER._isPositive(byArray)) {
            cArray[n2++] = 45;
        }
        if (n4 >= 0) {
            n2 += NUMBER._byteToChars(byArray2[1], cArray, n2);
            int n6 = 2;
            while (n6 <= n) {
                NUMBER._byteTo2Chars(byArray2[n6], cArray, n2);
                n2 += 2;
                ++n6;
                --n3;
            }
            if (n3 > 0) {
                while (n3 > 0) {
                    cArray[n2++] = 48;
                    cArray[n2++] = 48;
                    --n3;
                }
            }
        } else {
            int n7 = n + n4;
            if (n7 > 0) {
                int n8;
                n2 += NUMBER._byteToChars(byArray2[1], cArray, n2);
                if (n7 == 1) {
                    cArray[n2++] = 46;
                }
                for (n8 = 2; n8 < n; ++n8) {
                    NUMBER._byteTo2Chars(byArray2[n8], cArray, n2);
                    n2 += 2;
                    if (n7 != n8) continue;
                    cArray[n2++] = 46;
                }
                if (byArray2[n8] % 10 == 0) {
                    n2 += NUMBER._byteToChars((byte)(byArray2[n8] / 10), cArray, n2);
                } else {
                    NUMBER._byteTo2Chars(byArray2[n8], cArray, n2);
                    n2 += 2;
                }
            } else {
                int n9;
                cArray[n2++] = 48;
                cArray[n2++] = 46;
                while (n7 < 0) {
                    cArray[n2++] = 48;
                    cArray[n2++] = 48;
                    ++n7;
                }
                for (n9 = 1; n9 < n; ++n9) {
                    NUMBER._byteTo2Chars(byArray2[n9], cArray, n2);
                    n2 += 2;
                }
                if (byArray2[n9] % 10 == 0) {
                    n2 += NUMBER._byteToChars((byte)(byArray2[n9] / 10), cArray, n2);
                } else {
                    NUMBER._byteTo2Chars(byArray2[n9], cArray, n2);
                    n2 += 2;
                }
            }
        }
        return new String(cArray, 0, n2);
    }

    public static boolean toBoolean(byte[] byArray) {
        return !NUMBER._isZero(byArray);
    }

    public static byte[] toBytes(double d) throws SQLException {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException(CoreException.getMessage((byte)11));
        }
        if (d == 0.0 || d == -0.0) {
            return NUMBER._makeZero();
        }
        if (d == Double.POSITIVE_INFINITY) {
            return NUMBER._makePosInf();
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return NUMBER._makeNegInf();
        }
        return NUMBER._getThinLib().lnxren(d);
    }

    public static byte[] toBytes(float f) {
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException(CoreException.getMessage((byte)11));
        }
        if (f == 0.0f || f == -0.0f) {
            return NUMBER._makeZero();
        }
        if (f == Float.POSITIVE_INFINITY) {
            return NUMBER._makePosInf();
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return NUMBER._makeNegInf();
        }
        String string = Float.toString(f);
        try {
            return NUMBER._getLnxLib().lnxcpn(string, false, 0, false, 0, "AMERICAN_AMERICA");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] toBytes(long l) {
        return NUMBER._getLnxLib().lnxmin(l);
    }

    public static byte[] toBytes(int n) {
        return NUMBER.toBytes((long)n);
    }

    public static byte[] toBytes(short s) {
        return NUMBER.toBytes((long)s);
    }

    public static byte[] toBytes(byte by) {
        return NUMBER.toBytes((long)by);
    }

    public static byte[] toBytes(BigInteger bigInteger) throws SQLException {
        int n;
        long l;
        int n2;
        int n3;
        byte[] byArray;
        Object object;
        byte[] byArray2 = new byte[66];
        long[] lArray = new long[54];
        long[] lArray2 = new long[22];
        int n4 = 21;
        int n5 = 0;
        int n6 = 21;
        boolean bl = false;
        int n7 = 0;
        boolean bl2 = true;
        if (bigInteger.signum() == 0) {
            return NUMBER._makeZero();
        }
        if (bigInteger.signum() == -1) {
            object = bigInteger.abs();
            bl2 = false;
            byArray = ((BigInteger)object).toByteArray();
            n3 = (int)Math.floor((double)((BigInteger)object).bitLength() * 0.1505149978319906);
        } else {
            byArray = bigInteger.toByteArray();
            n3 = (int)Math.floor((double)bigInteger.bitLength() * 0.1505149978319906);
        }
        if (bigInteger.compareTo(BIGINT_HUND.pow(n3)) < 0) {
            --n3;
        }
        if (byArray.length > 54) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        for (n2 = 0; n2 < byArray.length; ++n2) {
            lArray[n2] = byArray[n2] < 0 ? (long)(byArray[n2] + 256) : (long)byArray[n2];
        }
        int n8 = byArray.length;
        switch (n8 % 3) {
            case 2: {
                lArray2[n4] = (lArray[n5] << 8) + lArray[n5 + 1];
                n5 = (byte)(n5 + 2);
                n8 -= 2;
                break;
            }
            case 1: {
                lArray2[n4] = lArray[n5];
                n5 = (byte)(n5 + 1);
                --n8;
                break;
            }
            default: {
                l = (lArray[n5] << 16) + (lArray[n5 + 1] << 8) + lArray[n5 + 2];
                lArray2[n4] = l % 1000000L;
                lArray2[n4 - 1] = l / 1000000L;
                n6 = (byte)(n6 - (lArray2[n4 - 1] != 0L ? 1 : 0));
                n5 = (byte)(n5 + 3);
                n8 -= 3;
            }
        }
        while (n8 != 0) {
            l = (lArray[n5] << 4) + (lArray[n5 + 1] >> 4);
            for (n4 = 21; n4 >= n6; n4 = (int)((byte)(n4 - 1))) {
                lArray2[n4] = (l += lArray2[n4] << 12) % 1000000L;
                l /= 1000000L;
            }
            if (l != 0L) {
                n6 = (byte)(n6 - 1);
                lArray2[n6] = l;
            }
            l = ((lArray[n5 + 1] & 0xFL) << 8) + lArray[n5 + 2];
            for (n4 = 21; n4 >= n6; n4 = (int)((byte)(n4 - 1))) {
                lArray2[n4] = (l += lArray2[n4] << 12) % 1000000L;
                l /= 1000000L;
            }
            if (l != 0L) {
                n6 = (byte)(n6 - 1);
                lArray2[n6] = l;
            }
            n5 = (byte)(n5 + 3);
            n8 -= 3;
        }
        byArray2[n7] = (byte)(lArray2[n6] / 10000L);
        if (byArray2[n7] != 0) {
            n = 3 * (21 - n6) + 3;
            byArray2[n7 + 1] = (byte)(lArray2[n6] % 10000L / 100L);
            byArray2[n7 + 2] = (byte)(lArray2[n6] % 100L);
            n7 += 3;
        } else {
            byArray2[n7] = (byte)(lArray2[n6] % 10000L / 100L);
            if (byArray2[n7] != 0) {
                n = 3 * (21 - n6) + 2;
                byArray2[n7 + 1] = (byte)(lArray2[n6] % 100L);
                n7 += 2;
            } else {
                byArray2[n7] = (byte)lArray2[n6];
                n = 3 * (21 - n6) + 1;
                ++n7;
            }
        }
        for (n4 = (int)((byte)(n6 + 1)); n4 <= 21; n4 = (int)((byte)(n4 + 1))) {
            byArray2[n7] = (byte)(lArray2[n4] / 10000L);
            byArray2[n7 + 1] = (byte)(lArray2[n4] % 10000L / 100L);
            byArray2[n7 + 2] = (byte)(lArray2[n4] % 100L);
            n7 += 3;
        }
        for (n2 = n7 - 1; n2 >= 0 && byArray2[n2] == 0; --n2) {
            --n;
        }
        if (n > 19) {
            n2 = 20;
            n = 19;
            if (byArray2[n2] >= 50) {
                int n9 = --n2;
                byArray2[n9] = (byte)(byArray2[n9] + 1);
                while (byArray2[n2] == 100) {
                    if (n2 == 0) {
                        ++n3;
                        byArray2[n2] = 1;
                        break;
                    }
                    byArray2[n2] = 0;
                    int n10 = --n2;
                    byArray2[n10] = (byte)(byArray2[n10] + 1);
                }
                for (n2 = n - 1; n2 >= 0 && byArray2[n2] == 0; --n2) {
                    --n;
                }
            }
        }
        if (n3 > 62) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        object = new byte[n + 1];
        object[0] = (byte)n3;
        System.arraycopy(byArray2, 0, object, 1, n);
        return NUMBER._toLnxFmt((byte[])object, bl2);
    }

    public static byte[] toBytes(BigDecimal bigDecimal) throws SQLException {
        int n;
        long l;
        int n2;
        BigDecimal bigDecimal2;
        byte[] byArray = new byte[66];
        long[] lArray = new long[54];
        long[] lArray2 = new long[22];
        int n3 = 21;
        int n4 = 0;
        int n5 = 21;
        int n6 = 0;
        int n7 = 0;
        BigDecimal bigDecimal3 = bigDecimal.abs();
        int n8 = 0;
        if (bigDecimal.signum() == 0) {
            return NUMBER._makeZero();
        }
        boolean bl = bigDecimal.signum() != -1;
        int n9 = bigDecimal.scale();
        if (n9 < 0) {
            bigDecimal = bigDecimal.setScale(0);
            n9 = 0;
        }
        int n10 = bigDecimal3.compareTo(BIGDEC_ONE);
        int n11 = 0;
        if (n10 == -1) {
            while ((bigDecimal2 = bigDecimal3.movePointRight(++n11)).compareTo(BIGDEC_ONE) < 0) {
            }
            n8 = -n11;
        } else {
            while ((bigDecimal2 = bigDecimal3.movePointLeft(++n11)).compareTo(BIGDEC_ONE) >= 0) {
            }
            n8 = n11;
        }
        byte[] byArray2 = bigDecimal3.movePointRight(n9).toBigInteger().toByteArray();
        if (byArray2.length > 54) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            lArray[n2] = byArray2[n2] < 0 ? (long)(byArray2[n2] + 256) : (long)byArray2[n2];
        }
        int n12 = byArray2.length;
        switch (n12 % 3) {
            case 2: {
                lArray2[n3] = (lArray[n4] << 8) + lArray[n4 + 1];
                n4 = (byte)(n4 + 2);
                n12 -= 2;
                break;
            }
            case 1: {
                lArray2[n3] = lArray[n4];
                n4 = (byte)(n4 + 1);
                --n12;
                break;
            }
            default: {
                l = (lArray[n4] << 16) + (lArray[n4 + 1] << 8) + lArray[n4 + 2];
                lArray2[n3] = l % 1000000L;
                lArray2[n3 - 1] = l / 1000000L;
                n5 = (byte)(n5 - (lArray2[n3 - 1] != 0L ? 1 : 0));
                n4 = (byte)(n4 + 3);
                n12 -= 3;
            }
        }
        while (n12 != 0) {
            l = (lArray[n4] << 4) + (lArray[n4 + 1] >> 4);
            for (n3 = 21; n3 >= n5; n3 = (int)((byte)(n3 - 1))) {
                lArray2[n3] = (l += lArray2[n3] << 12) % 1000000L;
                l /= 1000000L;
            }
            if (l != 0L) {
                n5 = (byte)(n5 - 1);
                lArray2[n5] = l;
            }
            l = ((lArray[n4 + 1] & 0xFL) << 8) + lArray[n4 + 2];
            for (n3 = 21; n3 >= n5; n3 = (int)((byte)(n3 - 1))) {
                lArray2[n3] = (l += lArray2[n3] << 12) % 1000000L;
                l /= 1000000L;
            }
            if (l != 0L) {
                n5 = (byte)(n5 - 1);
                lArray2[n5] = l;
            }
            n4 = (byte)(n4 + 3);
            n12 -= 3;
        }
        byArray[n6] = (byte)(lArray2[n5] / 10000L);
        if (byArray[n6] != 0) {
            n = 3 * (21 - n5) + 3;
            byArray[n6 + 1] = (byte)(lArray2[n5] % 10000L / 100L);
            byArray[n6 + 2] = (byte)(lArray2[n5] % 100L);
            n6 += 3;
        } else {
            byArray[n6] = (byte)(lArray2[n5] % 10000L / 100L);
            if (byArray[n6] != 0) {
                n = 3 * (21 - n5) + 2;
                byArray[n6 + 1] = (byte)(lArray2[n5] % 100L);
                n6 += 2;
            } else {
                byArray[n6] = (byte)lArray2[n5];
                n = 3 * (21 - n5) + 1;
                ++n6;
            }
        }
        for (n3 = (int)((byte)(n5 + 1)); n3 <= 21; n3 = (int)((byte)(n3 + 1))) {
            byArray[n6] = (byte)(lArray2[n3] / 10000L);
            byArray[n6 + 1] = (byte)(lArray2[n3] % 10000L / 100L);
            byArray[n6 + 2] = (byte)(lArray2[n3] % 100L);
            n6 += 3;
        }
        for (n2 = n6 - 1; n2 >= 0 && byArray[n2] == 0; --n2) {
            --n;
        }
        if (n9 > 0 && (n9 & 1) != 0) {
            int n13 = n;
            byte[] byArray3 = new byte[n13 + 1];
            if (byArray[0] <= 9) {
                for (n2 = 0; n2 < n13 - 1; ++n2) {
                    byArray3[n2] = (byte)(byArray[n2] % 10 * 10 + byArray[n2 + 1] / 10);
                }
                byArray3[n2] = (byte)(byArray[n2] % 10 * 10);
                if (byArray3[n13 - 1] == 0) {
                    --n;
                }
            } else {
                byArray3[n13] = (byte)(byArray[n13 - 1] % 10 * 10);
                for (n2 = n13 - 1; n2 > 0; --n2) {
                    byArray3[n2] = (byte)(byArray[n2] / 10 + byArray[n2 - 1] % 10 * 10);
                }
                byArray3[n2] = (byte)(byArray[n2] / 10);
                if (byArray3[n13] > 0) {
                    ++n;
                }
            }
            System.arraycopy(byArray3, 0, byArray, 0, n);
        }
        if (n > 20) {
            n2 = 20;
            n = 20;
            if (byArray[n2] >= 50) {
                int n14 = --n2;
                byArray[n14] = (byte)(byArray[n14] + 1);
                while (byArray[n2] == 100) {
                    if (n2 == 0) {
                        ++n8;
                        byArray[n2] = 1;
                        break;
                    }
                    byArray[n2] = 0;
                    int n15 = --n2;
                    byArray[n15] = (byte)(byArray[n15] + 1);
                }
            }
            for (n2 = n - 1; n2 >= 0 && byArray[n2] == 0; --n2) {
                --n;
            }
        }
        n7 = n8 <= 0 ? (byArray[0] < 10 ? -(2 - n8) / 2 + 1 : -(2 - n8) / 2) : (n8 - 1) / 2;
        if (n7 > 62) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        if (n7 <= -65) {
            throw new SQLException(CoreException.getMessage((byte)2));
        }
        byte[] byArray4 = new byte[n + 1];
        byArray4[0] = (byte)n7;
        System.arraycopy(byArray, 0, byArray4, 1, n);
        return NUMBER._toLnxFmt(byArray4, bl);
    }

    public static byte[] toBytes(String string, int n) throws SQLException {
        int n2;
        int n3;
        int n4;
        Object object;
        int n5 = 0;
        int n6 = 0;
        byte[] byArray = new byte[22];
        int n7 = 0;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 40;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = string.indexOf("E");
        if (n16 != -1 || (n16 = string.indexOf("e")) != -1) {
            int n17;
            object = new StringBuffer(string.length() + 5);
            n4 = 0;
            BigDecimal bigDecimal = null;
            boolean bl4 = string.charAt(0) == '-';
            String string2 = string.substring(n16 + 1);
            String string3 = string.substring(bl4 ? 1 : 0, n16);
            bigDecimal = new BigDecimal(string3);
            boolean bl5 = string2.charAt(0) == '-';
            string2 = string2.substring(1);
            n4 = Integer.parseInt(string2);
            String string4 = bigDecimal.toString();
            int n18 = string4.indexOf(".");
            int n19 = string4.length();
            int n20 = n19--;
            if (n18 != -1) {
                string4 = string4.substring(0, n18) + string4.substring(n18 + 1);
                if (bl5) {
                    n4 -= n18;
                } else {
                    n20 = ++n4;
                }
            } else if (bl5) {
                n4 -= n19;
            } else {
                n20 = ++n4;
            }
            if (bl4) {
                ((StringBuffer)object).append("-");
            }
            if (bl5) {
                ((StringBuffer)object).append("0.");
                for (n17 = 0; n17 < n4; ++n17) {
                    ((StringBuffer)object).append("0");
                }
                ((StringBuffer)object).append(string4);
            } else {
                n17 = n4 > n19 ? n4 : n19;
                for (int i = 0; i < n17; ++i) {
                    if (n20 == i) {
                        ((StringBuffer)object).append(".");
                    }
                    ((StringBuffer)object).append(n19 > i ? string4.charAt(i) : (char)'0');
                }
            }
            string = ((StringBuffer)object).toString();
        }
        string = string.trim();
        int n21 = string.length();
        if (string.charAt(0) == '-') {
            --n21;
            bl = false;
            n14 = 1;
        }
        n5 = n21;
        object = new char[n21];
        string.getChars(n14, n21 + n14, (char[])object, 0);
        for (n3 = 0; n3 < n21; ++n3) {
            if (object[n3] != 46) continue;
            bl3 = true;
            break;
        }
        if (!bl3) {
            n = 0;
        }
        while (n6 < n5 && object[n6] == 48) {
            ++n6;
            if (!bl3) continue;
            ++n15;
        }
        if (n6 == n5) {
            return NUMBER._makeZero();
        }
        if (n21 >= 2 && object[n6] == 46) {
            while (n5 > 0 && object[n5 - 1] == 48) {
                --n5;
            }
            if (++n6 == n5) {
                return NUMBER._makeZero();
            }
            --n8;
            while (n6 < n5 - 1 && object[n6] == 48 && object[n6 + 1] == 48) {
                --n8;
                n10 += 2;
                n6 += 2;
            }
            if (n8 <= -65) {
                throw new SQLException(CoreException.getMessage((byte)2));
            }
            if (n5 - n6 > n11) {
                n2 = 2 + n11;
                if (n10 > 0) {
                    n2 += n10;
                }
                if (n2 <= n5) {
                    n5 = n2;
                }
                n12 = n5;
                bl2 = true;
            }
            n7 = n5 - n6 >> 1;
            if ((n5 - n6) % 2 != 0) {
                byArray[n7] = (byte)(Integer.parseInt(new String((char[])object, n5 - 1, 1)) * 10);
                ++n9;
                --n5;
            }
            while (n5 > n6) {
                byArray[--n7] = (byte)Integer.parseInt(new String((char[])object, n5 - 2, 2));
                n5 -= 2;
                ++n9;
            }
        } else {
            int n22;
            while (n > 0 && n5 > 0 && object[n5 - 1] == 48) {
                --n5;
                --n;
            }
            if (n == 0 && n5 > 1) {
                if (object[n5 - 1] == 46) {
                    --n5;
                }
                if (n6 == n5) {
                    return NUMBER._makeZero();
                }
                while (n5 > 1 && object[n5 - 2] == 48 && object[n5 - 1] == 48) {
                    n5 -= 2;
                    ++n8;
                }
            }
            if (n8 > 62) {
                throw new SQLException(CoreException.getMessage((byte)3));
            }
            if (n5 - n6 - (bl3 ? 1 : 0) > n11) {
                n2 = n11 + (bl3 ? 1 : 0);
                n4 = n5 - n2;
                n5 = n2;
                if ((n -= n4) < 0) {
                    n = 0;
                }
                bl2 = true;
                n12 = n5;
            }
            int n23 = n22 = n == 0 ? n5 - n6 : n5 - n - 1;
            if (n15 > 0) {
                n22 -= n15;
            }
            if (n22 % 2 != 0) {
                n13 = Integer.parseInt(new String((char[])object, n6, 1));
                ++n6;
                --n22;
                if (n5 - 1 == n11) {
                    --n;
                    bl2 = true;
                    n12 = --n5;
                }
            } else {
                n13 = Integer.parseInt(new String((char[])object, n6, 2));
                n6 += 2;
                n22 -= 2;
            }
            byArray[n7] = (byte)n13;
            ++n7;
            ++n9;
            while (n22 > 0) {
                byArray[n7] = (byte)Integer.parseInt(new String((char[])object, n6, 2));
                ++n7;
                n6 += 2;
                ++n8;
                n22 -= 2;
                ++n9;
            }
            if (n6 < n5) {
                if (n % 2 != 0) {
                    byArray[n7 += n / 2] = (byte)(Integer.parseInt(new String((char[])object, n5 - 1, 1)) * 10);
                    --n5;
                    --n;
                } else {
                    byArray[n7 += n / 2 - 1] = (byte)Integer.parseInt(new String((char[])object, n5 - 2, 2));
                    n5 -= 2;
                    n -= 2;
                }
                ++n9;
                --n7;
            }
            while (n > 0) {
                byArray[n7] = (byte)Integer.parseInt(new String((char[])object, n5 - 2, 2));
                --n7;
                n5 -= 2;
                n -= 2;
                ++n9;
            }
        }
        if (bl2) {
            n4 = n9;
            n13 = Integer.parseInt(new String((char[])object, n12, 1));
            if (n13 >= 5) {
                int n24 = --n4;
                byArray[n24] = (byte)(byArray[n24] + 1);
                while (byArray[n4] == 100) {
                    if (n4 == 0) {
                        ++n8;
                        byArray[n4] = 1;
                        break;
                    }
                    byArray[n4] = 0;
                    int n25 = --n4;
                    byArray[n25] = (byte)(byArray[n25] + 1);
                }
                for (n3 = n9 - 1; n3 >= 0 && byArray[n3] == 0; --n3) {
                    --n9;
                }
            }
        }
        byte[] byArray2 = new byte[n9 + 1];
        byArray2[0] = (byte)n8;
        System.arraycopy(byArray, 0, byArray2, 1, n9);
        return NUMBER._toLnxFmt(byArray2, bl);
    }

    public static byte[] toBytes(boolean bl) {
        if (bl) {
            return NUMBER.toBytes(1L);
        }
        return NUMBER.toBytes(0L);
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public double doubleValue() {
        return NUMBER.toDouble(this.shareBytes());
    }

    public float floatValue() {
        return NUMBER.toFloat(this.shareBytes());
    }

    public long longValue() throws SQLException {
        return NUMBER.toLong(this.shareBytes());
    }

    public int intValue() throws SQLException {
        return NUMBER.toInt(this.shareBytes());
    }

    public short shortValue() throws SQLException {
        return NUMBER.toShort(this.shareBytes());
    }

    public byte byteValue() throws SQLException {
        return NUMBER.toByte(this.shareBytes());
    }

    public BigInteger bigIntegerValue() throws SQLException {
        return NUMBER.toBigInteger(this.shareBytes());
    }

    public BigDecimal bigDecimalValue() throws SQLException {
        return NUMBER.toBigDecimal(this.shareBytes());
    }

    public String stringValue() {
        return NUMBER.toString(this.shareBytes());
    }

    public boolean booleanValue() {
        return NUMBER.toBoolean(this.shareBytes());
    }

    public Object toJdbc() throws SQLException {
        try {
            return this.bigDecimalValue();
        }
        catch (SQLException sQLException) {
            return new SQLException(sQLException.getMessage());
        }
    }

    public Object makeJdbcArray(int n) {
        BigDecimal[] bigDecimalArray = new BigDecimal[n];
        return bigDecimalArray;
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.Integer") == 0 || string.compareTo("java.lang.Long") == 0 || string.compareTo("java.lang.Float") == 0 || string.compareTo("java.lang.Double") == 0 || string.compareTo("java.math.BigInteger") == 0 || string.compareTo("java.math.BigDecimal") == 0 || string.compareTo("java.lang.String") == 0 || string.compareTo("java.lang.Boolean") == 0;
    }

    public NUMBER abs() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxabs(this.shareBytes()));
    }

    public NUMBER acos() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxacos(this.shareBytes()));
    }

    public NUMBER add(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxadd(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER asin() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxasin(this.shareBytes()));
    }

    public NUMBER atan() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxatan(this.shareBytes()));
    }

    public NUMBER atan2(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxatan2(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER ceil() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxceil(this.shareBytes()));
    }

    public NUMBER cos() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxcos(this.shareBytes()));
    }

    public NUMBER cosh() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxcsh(this.shareBytes()));
    }

    public NUMBER decrement() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxdec(this.shareBytes()));
    }

    public NUMBER div(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxdiv(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER exp() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxexp(this.shareBytes()));
    }

    public NUMBER floatingPointRound(int n) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxfpr(this.shareBytes(), n));
    }

    public NUMBER floor() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxflo(this.shareBytes()));
    }

    public NUMBER increment() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxinc(this.shareBytes()));
    }

    public NUMBER ln() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxln(this.shareBytes()));
    }

    public NUMBER log(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxlog(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER mod(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxmod(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER mul(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxmul(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER negate() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxneg(this.shareBytes()));
    }

    public NUMBER pow(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxbex(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER pow(int n) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxpow(this.shareBytes(), n));
    }

    public NUMBER round(int n) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxrou(this.shareBytes(), n));
    }

    public NUMBER scale(int n, int n2, boolean[] blArray) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsca(this.shareBytes(), n, n2, blArray));
    }

    public NUMBER shift(int n) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxshift(this.shareBytes(), n));
    }

    public NUMBER sin() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsin(this.shareBytes()));
    }

    public NUMBER sinh() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsnh(this.shareBytes()));
    }

    public NUMBER sqroot() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsqr(this.shareBytes()));
    }

    public NUMBER sub(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsub(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER tan() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxtan(this.shareBytes()));
    }

    public NUMBER tanh() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxtnh(this.shareBytes()));
    }

    public NUMBER truncate(int n) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxtru(this.shareBytes(), n));
    }

    public static NUMBER formattedTextToNumber(String string, String string2, String string3) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxfcn(string, string2, string3));
    }

    public static NUMBER textToPrecisionNumber(String string, boolean bl, int n, boolean bl2, int n2, String string2) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxcpn(string, bl, n, bl2, n2, string2));
    }

    public String toFormattedText(String string, String string2) throws SQLException {
        return NUMBER._getLnxLib().lnxnfn(this.shareBytes(), string, string2);
    }

    public String toText(int n, String string) throws SQLException {
        return NUMBER._getLnxLib().lnxnuc(this.shareBytes(), n, string);
    }

    public int compareTo(NUMBER nUMBER) {
        return NUMBER.compareBytes(this.shareBytes(), nUMBER.shareBytes());
    }

    public boolean isInf() {
        return NUMBER._isInf(this.shareBytes());
    }

    public boolean isNegInf() {
        return NUMBER._isNegInf(this.shareBytes());
    }

    public boolean isPosInf() {
        return NUMBER._isPosInf(this.shareBytes());
    }

    public boolean isInt() {
        return NUMBER._isInt(this.shareBytes());
    }

    public static boolean isValid(byte[] byArray) {
        int n = byArray.length;
        if (NUMBER._isPositive(byArray)) {
            if (n == 1) {
                return NUMBER._isZero(byArray);
            }
            if (byArray[0] == -1 && byArray[1] == 101) {
                return n == 2;
            }
            if (n > 21) {
                return false;
            }
            if (byArray[1] < 2 || byArray[n - 1] < 2) {
                return false;
            }
            for (int i = 1; i < n; ++i) {
                byte by = byArray[i];
                if (by >= 1 && by <= 100) continue;
                return false;
            }
            return true;
        }
        if (n < 3) {
            return NUMBER._isNegInf(byArray);
        }
        if (n > 21) {
            return false;
        }
        if (byArray[n - 1] != 102) {
            if (n <= 20) {
                return false;
            }
        } else {
            n = (byte)(n - 1);
        }
        if (byArray[1] > 100 || byArray[n - 1] > 100) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            byte by = byArray[i];
            if (by >= 2 && by <= 101) continue;
            return false;
        }
        return true;
    }

    public boolean isZero() {
        return NUMBER._isZero(this.shareBytes());
    }

    public static NUMBER e() {
        return new NUMBER(E);
    }

    public static NUMBER ln10() {
        return new NUMBER(LN10);
    }

    public static NUMBER negInf() {
        return new NUMBER(NUMBER._makeNegInf());
    }

    public static NUMBER pi() {
        return new NUMBER(PI);
    }

    public static NUMBER posInf() {
        return new NUMBER(NUMBER._makePosInf());
    }

    public static NUMBER zero() {
        return new NUMBER(NUMBER._makeZero());
    }

    public int sign() {
        if (NUMBER._isZero(this.shareBytes())) {
            return 0;
        }
        return NUMBER._isPositive(this.shareBytes()) ? 1 : -1;
    }

    static boolean _isInf(byte[] byArray) {
        return byArray.length == 2 && byArray[0] == -1 && byArray[1] == 101 || byArray[0] == 0 && byArray.length == 1;
    }

    private static boolean _isInt(byte[] byArray) {
        byte by;
        if (NUMBER._isZero(byArray)) {
            return true;
        }
        if (NUMBER._isInf(byArray)) {
            return false;
        }
        byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
        byte by2 = (byte)(byArray2.length - 1);
        return by2 <= (by = byArray2[0]) + 1;
    }

    static boolean _isNegInf(byte[] byArray) {
        return byArray[0] == 0 && byArray.length == 1;
    }

    static boolean _isPosInf(byte[] byArray) {
        return byArray.length == 2 && byArray[0] == -1 && byArray[1] == 101;
    }

    static boolean _isPositive(byte[] byArray) {
        return (byArray[0] & 0xFFFFFF80) != 0;
    }

    static boolean _isZero(byte[] byArray) {
        return byArray[0] == -128 && byArray.length == 1;
    }

    static byte[] _makePosInf() {
        byte[] byArray = new byte[]{-1, 101};
        return byArray;
    }

    static byte[] _makeNegInf() {
        byte[] byArray = new byte[]{0};
        return byArray;
    }

    static byte[] _makeZero() {
        byte[] byArray = new byte[]{-128};
        return byArray;
    }

    static byte[] _fromLnxFmt(byte[] byArray) {
        byte[] byArray2;
        int n = byArray.length;
        if (NUMBER._isPositive(byArray)) {
            byArray2 = new byte[n];
            byArray2[0] = (byte)((byArray[0] & 0xFFFFFF7F) - 65);
            for (int i = 1; i < n; ++i) {
                byArray2[i] = (byte)(byArray[i] - 1);
            }
        } else {
            byArray2 = n - 1 == 20 && byArray[n - 1] != 102 ? new byte[n] : new byte[n - 1];
            byArray2[0] = (byte)((~byArray[0] & 0xFFFFFF7F) - 65);
            for (int i = 1; i < byArray2.length; ++i) {
                byArray2[i] = (byte)(101 - byArray[i]);
            }
        }
        return byArray2;
    }

    static byte[] _toLnxFmt(byte[] byArray, boolean bl) {
        byte[] byArray2;
        int n = byArray.length;
        if (bl) {
            byArray2 = new byte[n];
            byArray2[0] = (byte)(byArray[0] + 128 + 64 + 1);
            for (int i = 1; i < n; ++i) {
                byArray2[i] = (byte)(byArray[i] + 1);
            }
        } else {
            int n2;
            byArray2 = n - 1 < 20 ? new byte[n + 1] : new byte[n];
            byArray2[0] = (byte)(~(byArray[0] + 128 + 64 + 1));
            for (n2 = 1; n2 < n; ++n2) {
                byArray2[n2] = (byte)(101 - byArray[n2]);
            }
            if (n2 <= 20) {
                byArray2[n2] = 102;
            }
        }
        return byArray2;
    }

    private static LnxLib _getLnxLib() {
        if (_slnxlib == null) {
            try {
                _slnxlib = System.getProperty("oracle.jserver.version") != null ? new LnxLibServer() : new LnxLibThin();
            }
            catch (SecurityException securityException) {
                _slnxlib = new LnxLibThin();
            }
        }
        return _slnxlib;
    }

    private static LnxLib _getThinLib() {
        if (_thinlib == null) {
            _thinlib = new LnxLibThin();
        }
        return _thinlib;
    }

    private static int _byteToChars(byte by, char[] cArray, int n) {
        if (by < 0) {
            return 0;
        }
        if (by < 10) {
            cArray[n] = (char)(48 + by);
            return 1;
        }
        if (by < 100) {
            cArray[n] = (char)(48 + by / 10);
            cArray[n + 1] = (char)(48 + by % 10);
            return 2;
        }
        cArray[n] = 49;
        cArray[n + 1] = (char)(48 + by / 10 - 10);
        cArray[n + 2] = (char)(48 + by % 10);
        return 3;
    }

    private static void _byteTo2Chars(byte by, char[] cArray, int n) {
        if (by < 0) {
            cArray[n] = 48;
            cArray[n + 1] = 48;
        } else if (by < 10) {
            cArray[n] = 48;
            cArray[n + 1] = (char)(48 + by);
        } else if (by < 100) {
            cArray[n] = (char)(48 + by / 10);
            cArray[n + 1] = (char)(48 + by % 10);
        } else {
            cArray[n] = 48;
            cArray[n + 1] = 48;
        }
    }

    private static void _printBytes(byte[] byArray) {
        int n = byArray.length;
        System.out.print(n + ": ");
        for (int i = 0; i < n; ++i) {
            System.out.print(byArray[i] + " ");
        }
        System.out.println();
    }

    private byte[] stringToBytes(String string) throws SQLException {
        int n = 0;
        if ((string = string.trim()).indexOf(46) >= 0) {
            n = string.length() - 1 - string.indexOf(46);
        }
        return NUMBER.toBytes(string, n);
    }

    static {
        _thinlib = null;
        DBL_MAX = 40;
        INT_MAX = 15;
        FLOAT_MAX_INT = 2.1474836E9f;
        FLOAT_MIN_INT = -2.1474836E9f;
        DOUBLE_MAX_INT = 2.147483647E9;
        DOUBLE_MIN_INT = -2.147483648E9;
        DOUBLE_MAX_INT_2 = 2.147483649E9;
        DOUBLE_MIN_INT_2 = -2.147483649E9;
        drvType = null;
        try {
            drvType = System.getProperty("oracle.jserver.version");
        }
        catch (SecurityException securityException) {
            drvType = null;
        }
        LANGID = "AMERICAN";
    }
}

