/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.telephony.TelephonyManager;
import com.skt.Tmap.MapUtils;
import com.skt.Tmap.TMapData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TMapTapi {
    private Context Tcontext;
    private String mPackageName = null;
    private String MnoInfo = "";
    private boolean isInstalledTmap = false;
    private static final int GO_HOME = 1;
    private static final int GO_COMPANY = 2;
    public OnAuthenticationListenerCallback onAuthenticationListener;

    public TMapTapi(Context context) {
        this.Tcontext = context;
        MapUtils.setInitMap(context);
        try {
            this.onAuthenticationListener = (OnAuthenticationListenerCallback)context;
        }
        catch (Exception exception) {
            // empty catch block
        }
        String skPackageName = "com.skt.skaf.l001mtm091";
        String kuPackageName = "com.skt.tmap.ku";
        boolean isInstalledSK = false;
        boolean isInstalledKU = false;
        PackageManager packageManager = this.Tcontext.getPackageManager();
        List installedPkgList = packageManager.getInstalledApplications(8192);
        for (ApplicationInfo appFmc : installedPkgList) {
            if (appFmc.packageName.equals(skPackageName)) {
                isInstalledSK = true;
                continue;
            }
            if (!appFmc.packageName.equals(kuPackageName)) continue;
            isInstalledKU = true;
        }
        try {
            this.MnoInfo = this.getMnoInfoString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.MnoInfo.equals("SKT")) {
            if (isInstalledSK || isInstalledKU) {
                this.isInstalledTmap = true;
            }
            if (isInstalledSK) {
                this.mPackageName = skPackageName;
            } else if (isInstalledKU) {
                this.mPackageName = kuPackageName;
            }
        } else {
            if (isInstalledKU) {
                this.isInstalledTmap = true;
            }
            if (isInstalledKU) {
                this.mPackageName = kuPackageName;
            }
        }
    }

    public void setOnAuthenticationListener(OnAuthenticationListenerCallback listener) {
        this.onAuthenticationListener = listener;
    }

    public void setSKTMapAuthentication(String apiKey) {
        if (!MapUtils.isVerifyApiKey) {
            MapUtils.mApiKey = apiKey;
            TMapData.checkApiKey("anCertifi", new TMapData.CheckKeyResultListenerCallback(){

                @Override
                public void onCheckKeyResult(String strResult) {
                    if (strResult.equals("OK")) {
                        if (TMapTapi.this.onAuthenticationListener != null) {
                            TMapTapi.this.onAuthenticationListener.SKTMapApikeySucceed();
                        }
                    } else if (TMapTapi.this.onAuthenticationListener != null) {
                        TMapTapi.this.onAuthenticationListener.SKTMapApikeyFailed(strResult);
                    }
                }
            });
        }
    }

    public boolean isTmapApplicationInstalled() {
        if (!MapUtils.isVerifyApiKey || this.mPackageName == null) {
            return false;
        }
        return this.isInstalledTmap;
    }

    private boolean checkTmapApplicationInstalled() {
        if (this.mPackageName == null) {
            return false;
        }
        boolean bResult = false;
        PackageManager pm = this.Tcontext.getPackageManager();
        List installedPkgList = pm.getInstalledApplications(8192);
        for (ApplicationInfo appFmc : installedPkgList) {
            if (!appFmc.packageName.equals(this.mPackageName)) continue;
            bResult = true;
        }
        return bResult;
    }

    public ArrayList<String> getTMapDownUrl() {
        String strURL = "";
        ArrayList<String> arURL = null;
        if (!MapUtils.isVerifyApiKey) {
            return null;
        }
        if (this.MnoInfo.equals("SKT")) {
            arURL = new ArrayList<String>();
            strURL = "http://onesto.re/0000163382 ";
            arURL.add(strURL);
            strURL = "http://onesto.re/0000703533 ";
            arURL.add(strURL);
        } else {
            arURL = new ArrayList();
            strURL = "https://play.google.com/store/apps/details?id=com.skt.tmap.ku";
            arURL.add(strURL);
            strURL = "http://onesto.re/0000703533 ";
            arURL.add(strURL);
        }
        return arURL;
    }

    public boolean invokeTmap() {
        boolean bResult = false;
        if (TMapData.invokeStatistics("Z0", true)) {
            if (!MapUtils.isVerifyApiKey || this.mPackageName == null) {
                return false;
            }
            if (!this.checkTmapApplicationInstalled()) {
                bResult = false;
            } else {
                try {
                    Intent intent = new Intent("android.intent.action.MAIN");
                    intent.setClassName(this.mPackageName, String.valueOf(this.mPackageName) + ".IntroActivity");
                    intent.setFlags(0x10000000);
                    this.Tcontext.startActivity(intent);
                    bResult = true;
                }
                catch (Exception e) {
                    bResult = false;
                }
            }
        }
        return bResult;
    }

    public boolean invokeSearchPortal(String szDestName) {
        PackageInfo info = null;
        boolean bResult = false;
        if (TMapData.invokeStatistics("C0", true)) {
            if (!MapUtils.isVerifyApiKey || this.mPackageName == null) {
                return false;
            }
            if (!this.checkTmapApplicationInstalled()) {
                bResult = false;
            } else {
                try {
                    info = this.Tcontext.getPackageManager().getPackageInfo(this.mPackageName, 0);
                    String[] version = info.versionName.split("\\.");
                    if (Integer.parseInt(version[0]) == 3) {
                        bResult = this.invokeSearchPortal30(szDestName);
                    } else if (Integer.parseInt(version[0]) >= 4) {
                        try {
                            String szInvokeMessage = "tmap://search?name=" + szDestName;
                            Intent intent = new Intent("android.intent.action.MAIN");
                            intent.setClassName(this.mPackageName, String.valueOf(this.mPackageName) + ".IntroActivity");
                            intent.putExtra("url", szInvokeMessage);
                            intent.setFlags(0x10000000);
                            this.Tcontext.startActivity(intent);
                            bResult = true;
                        }
                        catch (Exception e) {
                            bResult = false;
                        }
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    bResult = false;
                }
            }
        }
        return bResult;
    }

    public boolean invokeSafeDrive() {
        PackageInfo info = null;
        boolean bResult = false;
        if (TMapData.invokeStatistics("E0", true)) {
            if (!MapUtils.isVerifyApiKey || this.mPackageName == null) {
                return false;
            }
            if (!this.checkTmapApplicationInstalled()) {
                bResult = false;
            } else {
                try {
                    info = this.Tcontext.getPackageManager().getPackageInfo(this.mPackageName, 0);
                    String[] version = info.versionName.split("\\.");
                    if (Integer.parseInt(version[0]) == 3) {
                        bResult = this.invokeSafeDrive30();
                    } else if (Integer.parseInt(version[0]) >= 4) {
                        try {
                            String szInvokeMessage = "tmap://ando";
                            Intent intent = new Intent("android.intent.action.MAIN");
                            intent.setClassName(this.mPackageName, String.valueOf(this.mPackageName) + ".IntroActivity");
                            intent.putExtra("url", szInvokeMessage);
                            intent.setFlags(0x10000000);
                            this.Tcontext.startActivity(intent);
                            bResult = true;
                        }
                        catch (Exception e) {
                            bResult = false;
                        }
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    bResult = false;
                }
            }
        }
        return bResult;
    }

    public boolean invokeSetLocation(String szDestName, float fX, float fY) {
        PackageInfo info = null;
        boolean bResult = false;
        if (TMapData.invokeStatistics("B0", true)) {
            if (!MapUtils.isVerifyApiKey || this.mPackageName == null) {
                return false;
            }
            if (!this.checkTmapApplicationInstalled()) {
                bResult = false;
            } else {
                try {
                    info = this.Tcontext.getPackageManager().getPackageInfo(this.mPackageName, 0);
                    String[] version = info.versionName.split("\\.");
                    if (Integer.parseInt(version[0]) == 3) {
                        bResult = this.invokeSetLocation30(szDestName, fX, fY);
                    } else if (Integer.parseInt(version[0]) >= 4) {
                        try {
                            String szInvokeMessage = "tmap://viewmap?x=" + Float.toString(fX) + "&y=" + Float.toString(fY) + "&name=" + szDestName;
                            Intent intent = new Intent("android.intent.action.MAIN");
                            intent.setClassName(this.mPackageName, String.valueOf(this.mPackageName) + ".IntroActivity");
                            intent.putExtra("url", szInvokeMessage);
                            intent.setFlags(0x10000000);
                            this.Tcontext.startActivity(intent);
                            bResult = true;
                        }
                        catch (Exception e) {
                            bResult = false;
                        }
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    bResult = false;
                }
            }
        }
        return bResult;
    }

    public boolean invokeRoute(String szDestName, float fX, float fY) {
        PackageInfo info = null;
        boolean bResult = false;
        if (TMapData.invokeStatistics("A0", true)) {
            if (!MapUtils.isVerifyApiKey || this.mPackageName == null) {
                return false;
            }
            if (!this.checkTmapApplicationInstalled()) {
                bResult = false;
            } else {
                try {
                    info = this.Tcontext.getPackageManager().getPackageInfo(this.mPackageName, 0);
                    String[] version = info.versionName.split("\\.");
                    if (Integer.parseInt(version[0]) == 3) {
                        bResult = this.invokeRoute30(szDestName, fX, fY);
                    } else if (Integer.parseInt(version[0]) >= 4) {
                        try {
                            String szInvokeMessage = "tmap://route?goalx=" + Float.toString(fX) + "&goaly=" + Float.toString(fY) + "&goalname=" + szDestName;
                            Intent intent = new Intent("android.intent.action.MAIN");
                            intent.setClassName(this.mPackageName, String.valueOf(this.mPackageName) + ".IntroActivity");
                            intent.putExtra("url", szInvokeMessage);
                            intent.setFlags(0x10000000);
                            this.Tcontext.startActivity(intent);
                            bResult = true;
                        }
                        catch (Exception e) {
                            bResult = false;
                        }
                    } else {
                        bResult = false;
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    bResult = false;
                }
            }
        }
        return bResult;
    }

    public boolean invokeGoHome() {
        return this.invokeGo("D0", 1);
    }

    public boolean invokeGoCompany() {
        return this.invokeGo("D1", 2);
    }

    private boolean invokeGo(String invokeCate, int nParam) {
        PackageInfo info = null;
        boolean bResult = false;
        if (TMapData.invokeStatistics(invokeCate, true)) {
            if (!MapUtils.isVerifyApiKey || this.mPackageName == null) {
                return false;
            }
            if (!this.checkTmapApplicationInstalled()) {
                bResult = false;
            } else {
                String[] version;
                block11: {
                    info = this.Tcontext.getPackageManager().getPackageInfo(this.mPackageName, 0);
                    version = info.versionName.split("\\.");
                    if (Integer.parseInt(version[0]) != 3) break block11;
                    return false;
                }
                try {
                    if (Integer.parseInt(version[0]) >= 4) {
                        try {
                            String szInvokeMessage = "tmap://goto?code=" + nParam;
                            Intent intent = new Intent("android.intent.action.MAIN");
                            intent.setClassName(this.mPackageName, String.valueOf(this.mPackageName) + ".IntroActivity");
                            intent.putExtra("url", szInvokeMessage);
                            intent.setFlags(0x10000000);
                            this.Tcontext.startActivity(intent);
                            bResult = true;
                        }
                        catch (Exception e) {
                            bResult = false;
                        }
                    } else {
                        bResult = false;
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    bResult = false;
                }
            }
        }
        return bResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean invokeRoute(HashMap<String, String> routeInfo) {
        PackageInfo info = null;
        boolean bResult = false;
        if (!TMapData.invokeStatistics("A1", true)) return bResult;
        if (!MapUtils.isVerifyApiKey) return false;
        if (this.mPackageName == null) {
            return false;
        }
        if (!this.checkTmapApplicationInstalled()) {
            return false;
        }
        try {
            info = this.Tcontext.getPackageManager().getPackageInfo(this.mPackageName, 0);
            String[] version = info.versionName.split("\\.");
            if (Integer.parseInt(version[0]) == 3) {
                return false;
            }
            if (Integer.parseInt(version[0]) < 4) {
                return false;
            }
            try {
                String strGoX = null;
                String strGoY = null;
                String strGoName = null;
                String strStName = null;
                String strStX = null;
                String strStY = null;
                String strV1Name = null;
                String strV1X = null;
                String strV1Y = null;
                String strV2Name = null;
                String strV2X = null;
                String strV2Y = null;
                Iterator<Map.Entry<String, String>> iterator = routeInfo.entrySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        if (strGoName == null) return false;
                        if (strGoX == null) return false;
                        if (strGoY != null) break;
                        return false;
                    }
                    Map.Entry<String, String> e = iterator.next();
                    if (e.getKey().contains("rGoName")) {
                        strGoName = e.getValue();
                        continue;
                    }
                    if (e.getKey().contains("rGoX")) {
                        strGoX = e.getValue();
                        continue;
                    }
                    if (e.getKey().contains("rGoY")) {
                        strGoY = e.getValue();
                        continue;
                    }
                    if (e.getKey().contains("rStName")) {
                        strStName = e.getValue();
                        continue;
                    }
                    if (e.getKey().contains("rStX")) {
                        strStX = e.getValue();
                        continue;
                    }
                    if (e.getKey().contains("rStY")) {
                        strStY = e.getValue();
                        continue;
                    }
                    if (e.getKey().contains("rV1Name")) {
                        strV1Name = e.getValue();
                        continue;
                    }
                    if (e.getKey().contains("rV1X")) {
                        strV1X = e.getValue();
                        continue;
                    }
                    if (e.getKey().contains("rV1Y")) {
                        strV1Y = e.getValue();
                        continue;
                    }
                    if (e.getKey().contains("rV2Name")) {
                        strV2Name = e.getValue();
                        continue;
                    }
                    if (e.getKey().contains("rV2X")) {
                        strV2X = e.getValue();
                        continue;
                    }
                    if (!e.getKey().contains("rV2Y")) continue;
                    strV2Y = e.getValue();
                }
                String szInvokeMessage = "tmap://route?goalx=" + strGoX + "&goaly=" + strGoY + "&goalname=" + strGoName;
                if (strStX != null) {
                    szInvokeMessage = String.valueOf(szInvokeMessage) + "&startx=" + strStX;
                }
                if (strStY != null) {
                    szInvokeMessage = String.valueOf(szInvokeMessage) + "&starty= " + strStY;
                }
                if (strStName != null) {
                    szInvokeMessage = String.valueOf(szInvokeMessage) + "&startname=" + strStName;
                }
                if (strV1X != null) {
                    szInvokeMessage = String.valueOf(szInvokeMessage) + "&via1x=" + strV1X;
                }
                if (strV1Y != null) {
                    szInvokeMessage = String.valueOf(szInvokeMessage) + "&via1y= " + strV1Y;
                }
                if (strV1Name != null) {
                    szInvokeMessage = String.valueOf(szInvokeMessage) + "&via1name=" + strV1Name;
                }
                if (strV2X != null) {
                    szInvokeMessage = String.valueOf(szInvokeMessage) + "&via2x=" + strV2X;
                }
                if (strV2Y != null) {
                    szInvokeMessage = String.valueOf(szInvokeMessage) + "&via2y= " + strV2Y;
                }
                if (strV2Name != null) {
                    szInvokeMessage = String.valueOf(szInvokeMessage) + "&via2name=" + strV2Name;
                }
                Intent intent = new Intent("android.intent.action.MAIN");
                intent.setClassName(this.mPackageName, String.valueOf(this.mPackageName) + ".IntroActivity");
                intent.putExtra("url", szInvokeMessage);
                intent.setFlags(0x10000000);
                this.Tcontext.startActivity(intent);
                return true;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                return false;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    private boolean invokeSetLocation30(String szDestName, float fX, float fY) {
        boolean blcheck = false;
        try {
            String szInvokeMessage = "A2,+" + Float.toString(fX) + ",+" + Float.toString(fY) + "," + szDestName;
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setClassName(this.mPackageName, String.valueOf(this.mPackageName) + ".IntroActivity");
            intent.putExtra("url", szInvokeMessage);
            intent.setFlags(0x10000000);
            this.Tcontext.startActivity(intent);
            blcheck = true;
        }
        catch (Exception e) {
            blcheck = false;
        }
        return blcheck;
    }

    private boolean invokeSafeDrive30() {
        boolean blcheck = false;
        try {
            String szInvokeMessage = "A3";
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setClassName(this.mPackageName, String.valueOf(this.mPackageName) + ".IntroActivity");
            intent.putExtra("url", szInvokeMessage);
            intent.setFlags(0x10000000);
            this.Tcontext.startActivity(intent);
            blcheck = true;
        }
        catch (Exception e) {
            blcheck = false;
        }
        return blcheck;
    }

    private boolean invokeSearchPortal30(String szDestName) {
        boolean blcheck = false;
        try {
            String szInvokeMessage = "A4," + szDestName;
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setClassName(this.mPackageName, String.valueOf(this.mPackageName) + ".IntroActivity");
            intent.putExtra("url", szInvokeMessage);
            intent.setFlags(0x10000000);
            this.Tcontext.startActivity(intent);
            blcheck = true;
        }
        catch (Exception e) {
            blcheck = false;
        }
        return blcheck;
    }

    private boolean invokeRoute30(String szDestName, float fX, float fY) {
        boolean blcheck = false;
        try {
            String szInvokeMessage = "A1,+" + Float.toString(fX) + ",+" + Float.toString(fY) + "," + szDestName;
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setClassName(this.mPackageName, String.valueOf(this.mPackageName) + ".IntroActivity");
            intent.putExtra("url", szInvokeMessage);
            intent.setFlags(0x10000000);
            this.Tcontext.startActivity(intent);
            blcheck = true;
        }
        catch (Exception e) {
            blcheck = false;
        }
        return blcheck;
    }

    public String getMnoInfoString() {
        TelephonyManager tm = (TelephonyManager)this.Tcontext.getSystemService("phone");
        String mno = tm.getNetworkOperatorName();
        String operator = tm.getNetworkOperator();
        if ((mno = mno.toUpperCase()).contains("SKT")) {
            return "SKT";
        }
        if (mno.contains("KT") || mno.contains("OLLEH")) {
            return "KTF";
        }
        if (mno.contains("LG")) {
            return "LGT";
        }
        if ("45005".equals(operator)) {
            return "SKT";
        }
        if ("45008".equals(operator)) {
            return "KTF";
        }
        if ("45006".equals(operator)) {
            return "LGT";
        }
        return "Other";
    }

    public static interface OnAuthenticationListenerCallback {
        public void SKTMapApikeySucceed();

        public void SKTMapApikeyFailed(String var1);
    }
}

