import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;

public class WebInPut {

	public int inData=0;
	public int outData=0;
	public URL url;
	public boolean isInit = false;
	public OutputStream out = null;
	
	public void init(URL _url, OutputStream _out) {
		this.isInit=true;
		this.url = _url;
		this.out = _out;
	}
	public void sendData( String reqData)throws MalformedURLException{
		
		try {
			if(!isInit)
			{
				return;
			}
			
			URLConnection urlConn = null;
			OutputStreamWriter osw = null;
			BufferedReader br = null;
			String resData = null;
			
			urlConn = url.openConnection();
			urlConn.setDoOutput(true);
			
			osw = new OutputStreamWriter(urlConn.getOutputStream());
			System.out.println("indata-"+reqData);
			reqData = URLEncoder.encode("msg","UTF-8") + "="
					+ URLEncoder.encode(reqData,"UTF-8");
			osw.write(reqData);
			osw.flush();
			String result ="";
			br = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
			while((resData=br.readLine())!=null) {
				result+=resData;
			}
			
			System.out.println("web_output:"+result);
			
			osw.close();
			br.close();
			
			out.write(Integer.parseInt(result));
		}catch(IOException e) {
			e.printStackTrace();
		}
	}
	
}
