import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;

public class Serial {
		WebInPut client = null;
		public Serial() {
			super();
		}
		
		void connect(String portName) throws Exception{
			CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier(portName);
			if(portIdentifier.isCurrentlyOwned()) {
				System.out.println("Error: Port is currently in use");
			}else {
				CommPort commport = portIdentifier.open(this.getClass().getName(),2000);
				
				if(commport instanceof SerialPort) {
					SerialPort serialPort = (SerialPort) commport;
					serialPort.setSerialPortParams(9600, SerialPort.DATABITS_8,SerialPort.STOPBITS_1,
							SerialPort.PARITY_NONE);
					
					InputStream in = serialPort.getInputStream();
					OutputStream out = serialPort.getOutputStream();
					
					client = new WebInPut();
					URL url = new URL("http://168.126.146.39:8080/20182229/server.jsp");
					client.init(url,out);
					
					(new Thread(new SerialReader(in, client))).start();
				
				}else {
					System.out.println("Error: Only serial ports are handled by this example.");
				}
			}
		}
	}


