package com.example.s20202020_11_01;

import androidx.appcompat.app.AppCompatActivity;

import android.annotation.SuppressLint;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import org.w3c.dom.Text;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;

public class MainActivity extends AppCompatActivity {
    private EditText sendMessage;
    private TextView receiveMessage;
    private ProgressBar loadingBar;

    @SuppressLint("WrongViewCast")
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        sendMessage = findViewById(R.id.et_message);
        receiveMessage = findViewById(R.id.tv_receive);
        loadingBar = findViewById(R.id.progessBar);

        HttpConnection connection;

        Button send = findViewById(R.id.btn_sendData);

        send.setOnClickListener(new Button.OnClickListener() {
            @Override
            public void onClick(View view) {

                if (sendMessage.getText().toString().length() == 0) {
                    Toast.makeText(getApplicationContext(),
                            getResources().getString(R.string.send_message_empty),
                            Toast.LENGTH_SHORT).show();
                    return;
                }
                URL url = null;
                try {
                    String path = getResources().getString(R.string.server_url) + "?msg=";
                    String query = URLEncoder.encode(sendMessage.getText().toString(), "UTF-8");
                    url = new URL(path + query);
                } catch (MalformedURLException | UnsupportedEncodingException e) {
                    e.printStackTrace();
                    Toast.makeText(getApplicationContext(),
                            e.getMessage(), Toast.LENGTH_SHORT).show();
                }
                new HttpConnection().execute(url);
            }
        });
    }

    private class HttpConnection extends AsyncTask<URL, Integer, String> {

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            loadingBar.setVisibility(View.VISIBLE);
        }

        @Override
        protected String doInBackground(URL... urls) {
            String data = "";
            if (urls.length == 0) {
                return "URL is empty.";
            }
            try {
                RequestHttpURLConnection connection = new RequestHttpURLConnection();
                data = connection.request(urls[0]);
            } catch (Exception e) {
                data = e.getMessage();
            }
            return data;
        }

        @Override
        protected void onPostExecute(String data) {
            super.onPostExecute(data);

            loadingBar.setVisibility(View.INVISIBLE);
            receiveMessage.setText(data);
        }
    }
}