/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import org.springframework.transaction.NestedTransactionNotSupportedException;
import org.springframework.transaction.SavepointManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionUsageException;
import org.springframework.transaction.support.SmartTransactionObject;

public class DefaultTransactionStatus
implements TransactionStatus {
    private final Object transaction;
    private final boolean newTransaction;
    private final boolean newSynchronization;
    private final boolean readOnly;
    private final boolean debug;
    private final Object suspendedResources;
    private boolean rollbackOnly = false;
    private boolean completed = false;
    private Object savepoint;

    public DefaultTransactionStatus(Object transaction, boolean newTransaction, boolean newSynchronization, boolean readOnly, boolean debug, Object suspendedResources) {
        this.transaction = transaction;
        this.newTransaction = newTransaction;
        this.newSynchronization = newSynchronization;
        this.readOnly = readOnly;
        this.debug = debug;
        this.suspendedResources = suspendedResources;
    }

    public Object getTransaction() {
        return this.transaction;
    }

    public boolean hasTransaction() {
        return this.transaction != null;
    }

    public boolean isNewTransaction() {
        return this.hasTransaction() && this.newTransaction;
    }

    public boolean isNewSynchronization() {
        return this.newSynchronization;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Object getSuspendedResources() {
        return this.suspendedResources;
    }

    protected void setSavepoint(Object savepoint) {
        this.savepoint = savepoint;
    }

    public Object getSavepoint() {
        return this.savepoint;
    }

    public boolean hasSavepoint() {
        return this.savepoint != null;
    }

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    public boolean isRollbackOnly() {
        return this.isLocalRollbackOnly() || this.isGlobalRollbackOnly();
    }

    public boolean isLocalRollbackOnly() {
        return this.rollbackOnly;
    }

    public boolean isGlobalRollbackOnly() {
        return this.transaction instanceof SmartTransactionObject && ((SmartTransactionObject)this.transaction).isRollbackOnly();
    }

    public void setCompleted() {
        this.completed = true;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public Object createSavepoint() throws TransactionException {
        return this.getSavepointManager().createSavepoint();
    }

    public void rollbackToSavepoint(Object savepoint) throws TransactionException {
        this.getSavepointManager().rollbackToSavepoint(savepoint);
    }

    public void releaseSavepoint(Object savepoint) throws TransactionException {
        this.getSavepointManager().releaseSavepoint(savepoint);
    }

    public void createAndHoldSavepoint() throws TransactionException {
        this.setSavepoint(this.getSavepointManager().createSavepoint());
    }

    public void rollbackToHeldSavepoint() throws TransactionException {
        if (!this.hasSavepoint()) {
            throw new TransactionUsageException("No savepoint associated with current transaction");
        }
        this.getSavepointManager().rollbackToSavepoint(this.getSavepoint());
    }

    public void releaseHeldSavepoint() throws TransactionException {
        if (!this.hasSavepoint()) {
            throw new TransactionUsageException("No savepoint associated with current transaction");
        }
        this.getSavepointManager().releaseSavepoint(this.getSavepoint());
    }

    protected SavepointManager getSavepointManager() {
        if (!this.isTransactionSavepointManager()) {
            throw new NestedTransactionNotSupportedException("Transaction object [" + this.getTransaction() + "] does not support savepoints");
        }
        return (SavepointManager)this.getTransaction();
    }

    public boolean isTransactionSavepointManager() {
        return this.getTransaction() instanceof SavepointManager;
    }
}

