/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Entity;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.item.ExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExecution
extends Entity {
    private JobInstance jobInstance;
    private volatile Collection<StepExecution> stepExecutions = new CopyOnWriteArraySet<StepExecution>();
    private volatile BatchStatus status = BatchStatus.STARTING;
    private volatile Date startTime = null;
    private volatile Date createTime = new Date(System.currentTimeMillis());
    private volatile Date endTime = null;
    private volatile Date lastUpdated = null;
    private volatile ExitStatus exitStatus = ExitStatus.UNKNOWN;
    private volatile ExecutionContext executionContext = new ExecutionContext();
    private volatile transient List<Throwable> failureExceptions = new CopyOnWriteArrayList<Throwable>();

    public JobExecution(JobInstance job, Long id) {
        super(id);
        this.jobInstance = job;
    }

    public JobExecution(JobInstance job) {
        this(job, null);
    }

    public JobExecution(Long id) {
        super(id);
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setJobInstance(JobInstance jobInstance) {
        this.jobInstance = jobInstance;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public BatchStatus getStatus() {
        return this.status;
    }

    public void setStatus(BatchStatus status) {
        this.status = status;
    }

    public void upgradeStatus(BatchStatus status) {
        this.status = this.status.upgradeTo(status);
    }

    public Long getJobId() {
        if (this.jobInstance != null) {
            return this.jobInstance.getId();
        }
        return null;
    }

    public void setExitStatus(ExitStatus exitStatus) {
        this.exitStatus = exitStatus;
    }

    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    public JobInstance getJobInstance() {
        return this.jobInstance;
    }

    public Collection<StepExecution> getStepExecutions() {
        return Collections.unmodifiableList(new ArrayList<StepExecution>(this.stepExecutions));
    }

    public StepExecution createStepExecution(String stepName) {
        StepExecution stepExecution = new StepExecution(stepName, this);
        this.stepExecutions.add(stepExecution);
        return stepExecution;
    }

    public boolean isRunning() {
        return this.endTime == null;
    }

    public boolean isStopping() {
        return this.status == BatchStatus.STOPPING;
    }

    public void stop() {
        for (StepExecution stepExecution : this.stepExecutions) {
            stepExecution.setTerminateOnly();
        }
        this.status = BatchStatus.STOPPING;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    void addStepExecution(StepExecution stepExecution) {
        this.stepExecutions.add(stepExecution);
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public List<Throwable> getFailureExceptions() {
        return this.failureExceptions;
    }

    public synchronized void addFailureException(Throwable t) {
        this.failureExceptions.add(t);
    }

    public synchronized List<Throwable> getAllFailureExceptions() {
        HashSet<Throwable> allExceptions = new HashSet<Throwable>(this.failureExceptions);
        for (StepExecution stepExecution : this.stepExecutions) {
            allExceptions.addAll(stepExecution.getFailureExceptions());
        }
        return new ArrayList<Throwable>(allExceptions);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.failureExceptions = new ArrayList<Throwable>();
    }

    @Override
    public String toString() {
        return super.toString() + String.format(", startTime=%s, endTime=%s, lastUpdated=%s, status=%s, exitStatus=%s, job=[%s]", new Object[]{this.startTime, this.endTime, this.lastUpdated, this.status, this.exitStatus, this.jobInstance});
    }

    public void addStepExecutions(List<StepExecution> stepExecutions) {
        if (stepExecutions != null) {
            this.stepExecutions.addAll(stepExecutions);
        }
    }
}

