/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Entity;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepExecution
extends Entity {
    private final JobExecution jobExecution;
    private final String stepName;
    private volatile BatchStatus status = BatchStatus.STARTING;
    private volatile int readCount = 0;
    private volatile int writeCount = 0;
    private volatile int commitCount = 0;
    private volatile int rollbackCount = 0;
    private volatile int readSkipCount = 0;
    private volatile int processSkipCount = 0;
    private volatile int writeSkipCount = 0;
    private volatile Date startTime = new Date(System.currentTimeMillis());
    private volatile Date endTime = null;
    private volatile Date lastUpdated = null;
    private volatile ExecutionContext executionContext = new ExecutionContext();
    private volatile ExitStatus exitStatus = ExitStatus.EXECUTING;
    private volatile boolean terminateOnly;
    private volatile int filterCount;
    private volatile transient List<Throwable> failureExceptions = new CopyOnWriteArrayList<Throwable>();

    public StepExecution(String stepName, JobExecution jobExecution, Long id) {
        this(stepName, jobExecution);
        Assert.notNull((Object)jobExecution, (String)"JobExecution must be provided to re-hydrate an existing StepExecution");
        Assert.notNull((Object)id, (String)"The entity Id must be provided to re-hydrate an existing StepExecution");
        this.setId(id);
        jobExecution.addStepExecution(this);
    }

    public StepExecution(String stepName, JobExecution jobExecution) {
        Assert.hasLength((String)stepName);
        this.stepName = stepName;
        this.jobExecution = jobExecution;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public int getCommitCount() {
        return this.commitCount;
    }

    public void setCommitCount(int commitCount) {
        this.commitCount = commitCount;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public int getReadCount() {
        return this.readCount;
    }

    public void setReadCount(int readCount) {
        this.readCount = readCount;
    }

    public int getWriteCount() {
        return this.writeCount;
    }

    public void setWriteCount(int writeCount) {
        this.writeCount = writeCount;
    }

    public int getRollbackCount() {
        return this.rollbackCount;
    }

    public int getFilterCount() {
        return this.filterCount;
    }

    public void setFilterCount(int filterCount) {
        this.filterCount = filterCount;
    }

    public void setRollbackCount(int rollbackCount) {
        this.rollbackCount = rollbackCount;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public BatchStatus getStatus() {
        return this.status;
    }

    public void setStatus(BatchStatus status) {
        this.status = status;
    }

    public void upgradeStatus(BatchStatus status) {
        this.status = this.status.upgradeTo(status);
    }

    public String getStepName() {
        return this.stepName;
    }

    public Long getJobExecutionId() {
        if (this.jobExecution != null) {
            return this.jobExecution.getId();
        }
        return null;
    }

    public void setExitStatus(ExitStatus exitStatus) {
        this.exitStatus = exitStatus;
    }

    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    public JobExecution getJobExecution() {
        return this.jobExecution;
    }

    public StepContribution createStepContribution() {
        return new StepContribution(this);
    }

    public synchronized void apply(StepContribution contribution) {
        this.readSkipCount += contribution.getReadSkipCount();
        this.writeSkipCount += contribution.getWriteSkipCount();
        this.processSkipCount += contribution.getProcessSkipCount();
        this.filterCount += contribution.getFilterCount();
        this.readCount += contribution.getReadCount();
        this.writeCount += contribution.getWriteCount();
        this.exitStatus = this.exitStatus.and(contribution.getExitStatus());
    }

    public synchronized void incrementRollbackCount() {
        ++this.rollbackCount;
    }

    public boolean isTerminateOnly() {
        return this.terminateOnly;
    }

    public void setTerminateOnly() {
        this.terminateOnly = true;
    }

    public int getSkipCount() {
        return this.readSkipCount + this.processSkipCount + this.writeSkipCount;
    }

    public void incrementCommitCount() {
        ++this.commitCount;
    }

    public JobParameters getJobParameters() {
        if (this.jobExecution == null || this.jobExecution.getJobInstance() == null) {
            return new JobParameters();
        }
        return this.jobExecution.getJobInstance().getJobParameters();
    }

    public int getReadSkipCount() {
        return this.readSkipCount;
    }

    public int getWriteSkipCount() {
        return this.writeSkipCount;
    }

    public void setReadSkipCount(int readSkipCount) {
        this.readSkipCount = readSkipCount;
    }

    public void setWriteSkipCount(int writeSkipCount) {
        this.writeSkipCount = writeSkipCount;
    }

    public int getProcessSkipCount() {
        return this.processSkipCount;
    }

    public void setProcessSkipCount(int processSkipCount) {
        this.processSkipCount = processSkipCount;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public List<Throwable> getFailureExceptions() {
        return this.failureExceptions;
    }

    public void addFailureException(Throwable throwable) {
        this.failureExceptions.add(throwable);
    }

    @Override
    public boolean equals(Object obj) {
        Long jobExecutionId = this.getJobExecutionId();
        if (jobExecutionId == null || !(obj instanceof StepExecution) || this.getId() == null) {
            return super.equals(obj);
        }
        StepExecution other = (StepExecution)obj;
        return this.stepName.equals(other.getStepName()) && ((Object)jobExecutionId).equals(other.getJobExecutionId());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.failureExceptions = new ArrayList<Throwable>();
    }

    @Override
    public int hashCode() {
        Long jobExecutionId = this.getJobExecutionId();
        return super.hashCode() + 31 * (this.stepName != null ? this.stepName.hashCode() : 0) + 91 * (jobExecutionId != null ? ((Object)jobExecutionId).hashCode() : 0);
    }

    @Override
    public String toString() {
        return String.format(this.getSummary() + ", exitDescription=%s", this.exitStatus.getExitDescription());
    }

    public String getSummary() {
        return super.toString() + String.format(", name=%s, status=%s, exitStatus=%s, readCount=%d, filterCount=%d, writeCount=%d readSkipCount=%d, writeSkipCount=%d, processSkipCount=%d, commitCount=%d, rollbackCount=%d", new Object[]{this.stepName, this.status, this.exitStatus.getExitCode(), this.readCount, this.filterCount, this.writeCount, this.readSkipCount, this.writeSkipCount, this.processSkipCount, this.commitCount, this.rollbackCount});
    }
}

