/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.launch.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobExecutionNotFailedException;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.JobExecutionNotStoppedException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.JobParametersNotFoundException;
import org.springframework.batch.core.launch.support.ExitCodeMapper;
import org.springframework.batch.core.launch.support.JvmSystemExiter;
import org.springframework.batch.core.launch.support.SimpleJvmExitCodeMapper;
import org.springframework.batch.core.launch.support.SystemExiter;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineJobRunner {
    protected static final Log logger = LogFactory.getLog(CommandLineJobRunner.class);
    private ExitCodeMapper exitCodeMapper = new SimpleJvmExitCodeMapper();
    private JobLauncher launcher;
    private JobLocator jobLocator;
    private static SystemExiter systemExiter = new JvmSystemExiter();
    private static String message = "";
    private JobParametersConverter jobParametersConverter = new DefaultJobParametersConverter();
    private JobExplorer jobExplorer;
    private JobRepository jobRepository;

    public void setLauncher(JobLauncher launcher) {
        this.launcher = launcher;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setJobExplorer(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
    }

    public void setExitCodeMapper(ExitCodeMapper exitCodeMapper) {
        this.exitCodeMapper = exitCodeMapper;
    }

    public static void presetSystemExiter(SystemExiter systemExiter) {
        CommandLineJobRunner.systemExiter = systemExiter;
    }

    public static String getErrorMessage() {
        return message;
    }

    public void setSystemExiter(SystemExiter systemExiter) {
        CommandLineJobRunner.systemExiter = systemExiter;
    }

    public void setJobParametersConverter(JobParametersConverter jobParametersConverter) {
        this.jobParametersConverter = jobParametersConverter;
    }

    public void exit(int status) {
        systemExiter.exit(status);
    }

    public void setJobLocator(JobLocator jobLocator) {
        this.jobLocator = jobLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int start(String jobPath, String jobIdentifier, String[] parameters, Set<String> opts) {
        int n;
        block18: {
            JobParameters jobParameters;
            String jobName;
            ClassPathXmlApplicationContext context;
            block16: {
                int i$;
                block17: {
                    block14: {
                        int i$2;
                        block15: {
                            context = null;
                            context = new ClassPathXmlApplicationContext(jobPath);
                            context.getAutowireCapableBeanFactory().autowireBeanProperties((Object)this, 2, false);
                            Assert.state((this.launcher != null ? 1 : 0) != 0, (String)"A JobLauncher must be provided.  Please add one to the configuration.");
                            if (opts.contains("-restart") || opts.contains("-next")) {
                                Assert.state((this.jobExplorer != null ? 1 : 0) != 0, (String)"A JobExplorer must be provided for a restart or start next operation.  Please add one to the configuration.");
                            }
                            jobName = jobIdentifier;
                            jobParameters = this.jobParametersConverter.getJobParameters(StringUtils.splitArrayElementsIntoProperties((String[])parameters, (String)"="));
                            Assert.isTrue((parameters == null || parameters.length == 0 || !jobParameters.isEmpty() ? 1 : 0) != 0, (String)("Invalid JobParameters " + Arrays.asList(parameters) + ". If parameters are provided they should be in the form name=value (no whitespace)."));
                            if (!opts.contains("-stop")) break block14;
                            List<JobExecution> jobExecutions = this.getRunningJobExecutions(jobIdentifier);
                            if (jobExecutions == null) {
                                throw new JobExecutionNotRunningException("No running execution found for job=" + jobIdentifier);
                            }
                            for (JobExecution jobExecution : jobExecutions) {
                                jobExecution.setStatus(BatchStatus.STOPPING);
                                this.jobRepository.update(jobExecution);
                            }
                            i$2 = this.exitCodeMapper.intValue(ExitStatus.COMPLETED.getExitCode());
                            Object var12_22 = null;
                            if (context == null) break block15;
                            context.close();
                        }
                        return i$2;
                    }
                    if (!opts.contains("-abandon")) break block16;
                    List<JobExecution> jobExecutions = this.getStoppedJobExecutions(jobIdentifier);
                    if (jobExecutions == null) {
                        throw new JobExecutionNotStoppedException("No stopped execution found for job=" + jobIdentifier);
                    }
                    for (JobExecution jobExecution : jobExecutions) {
                        jobExecution.setStatus(BatchStatus.ABANDONED);
                        this.jobRepository.update(jobExecution);
                    }
                    i$ = this.exitCodeMapper.intValue(ExitStatus.COMPLETED.getExitCode());
                    Object var12_23 = null;
                    if (context == null) break block17;
                    context.close();
                }
                return i$;
            }
            try {
                if (opts.contains("-restart")) {
                    JobExecution jobExecution = this.getLastFailedJobExecution(jobIdentifier);
                    if (jobExecution == null) {
                        throw new JobExecutionNotFailedException("No failed or stopped execution found for job=" + jobIdentifier);
                    }
                    jobParameters = jobExecution.getJobInstance().getJobParameters();
                    jobName = jobExecution.getJobInstance().getJobName();
                }
                Job job = this.jobLocator != null ? this.jobLocator.getJob(jobName) : (Job)context.getBean(jobName);
                if (opts.contains("-next")) {
                    JobParameters nextParameters = this.getNextJobParameters(job);
                    HashMap<String, JobParameter> map = new HashMap<String, JobParameter>(nextParameters.getParameters());
                    map.putAll(jobParameters.getParameters());
                    jobParameters = new JobParameters(map);
                }
                JobExecution jobExecution = this.launcher.run(job, jobParameters);
                n = this.exitCodeMapper.intValue(jobExecution.getExitStatus().getExitCode());
                Object var12_24 = null;
                if (context == null) break block18;
            }
            catch (Throwable e) {
                int n2;
                block19: {
                    try {
                        String message = "Job Terminated in error: " + e.getMessage();
                        logger.error((Object)message, e);
                        CommandLineJobRunner.message = message;
                        n2 = this.exitCodeMapper.intValue(ExitStatus.FAILED.getExitCode());
                        Object var12_25 = null;
                        if (context == null) break block19;
                    }
                    catch (Throwable throwable) {
                        block20: {
                            Object var12_26 = null;
                            if (context == null) break block20;
                            context.close();
                        }
                        throw throwable;
                    }
                    context.close();
                }
                return n2;
            }
            context.close();
        }
        return n;
    }

    private List<JobExecution> getJobExecutionsWithStatusGreaterThan(String jobIdentifier, BatchStatus minStatus) {
        JobExecution jobExecution;
        Long executionId = this.getLongIdentifier(jobIdentifier);
        if (executionId != null && (jobExecution = this.jobExplorer.getJobExecution(executionId)).getStatus().isGreaterThan(minStatus)) {
            return Arrays.asList(jobExecution);
        }
        int start = 0;
        int count = 100;
        ArrayList<JobExecution> executions = new ArrayList<JobExecution>();
        List<JobInstance> lastInstances = this.jobExplorer.getJobInstances(jobIdentifier, start, count);
        while (!lastInstances.isEmpty()) {
            for (JobInstance jobInstance : lastInstances) {
                JobExecution jobExecution2;
                List<JobExecution> jobExecutions = this.jobExplorer.getJobExecutions(jobInstance);
                if (jobExecutions == null || jobExecutions.isEmpty() || !(jobExecution2 = jobExecutions.get(jobExecutions.size() - 1)).getStatus().isGreaterThan(minStatus)) continue;
                executions.add(jobExecution2);
            }
            lastInstances = this.jobExplorer.getJobInstances(jobIdentifier, start += count, count);
        }
        return executions;
    }

    private JobExecution getLastFailedJobExecution(String jobIdentifier) {
        List<JobExecution> jobExecutions = this.getJobExecutionsWithStatusGreaterThan(jobIdentifier, BatchStatus.STOPPING);
        if (jobExecutions.isEmpty()) {
            return null;
        }
        return jobExecutions.get(0);
    }

    private List<JobExecution> getStoppedJobExecutions(String jobIdentifier) {
        List<JobExecution> jobExecutions = this.getJobExecutionsWithStatusGreaterThan(jobIdentifier, BatchStatus.STARTED);
        if (jobExecutions.isEmpty()) {
            return null;
        }
        ArrayList<JobExecution> result = new ArrayList<JobExecution>();
        for (JobExecution jobExecution : jobExecutions) {
            if (jobExecution.getStatus() == BatchStatus.ABANDONED) continue;
            result.add(jobExecution);
        }
        return result.isEmpty() ? null : result;
    }

    private List<JobExecution> getRunningJobExecutions(String jobIdentifier) {
        List<JobExecution> jobExecutions = this.getJobExecutionsWithStatusGreaterThan(jobIdentifier, BatchStatus.COMPLETED);
        if (jobExecutions.isEmpty()) {
            return null;
        }
        ArrayList<JobExecution> result = new ArrayList<JobExecution>();
        for (JobExecution jobExecution : jobExecutions) {
            if (!jobExecution.isRunning()) continue;
            result.add(jobExecution);
        }
        return result.isEmpty() ? null : result;
    }

    private Long getLongIdentifier(String jobIdentifier) {
        try {
            return new Long(jobIdentifier);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private JobParameters getNextJobParameters(Job job) throws JobParametersNotFoundException {
        JobParameters jobParameters;
        String jobIdentifier = job.getName();
        List<JobInstance> lastInstances = this.jobExplorer.getJobInstances(jobIdentifier, 0, 1);
        JobParametersIncrementer incrementer = job.getJobParametersIncrementer();
        if (incrementer == null) {
            throw new JobParametersNotFoundException("No job parameters incrementer found for job=" + jobIdentifier);
        }
        if (lastInstances.isEmpty()) {
            jobParameters = incrementer.getNext(new JobParameters());
            if (jobParameters == null) {
                throw new JobParametersNotFoundException("No bootstrap parameters found from incrementer for job=" + jobIdentifier);
            }
        } else {
            jobParameters = incrementer.getNext(lastInstances.get(0).getJobParameters());
        }
        return jobParameters;
    }

    public static void main(String[] args) {
        CommandLineJobRunner command = new CommandLineJobRunner();
        HashSet<String> opts = new HashSet<String>();
        ArrayList<String> params = new ArrayList<String>();
        int count = 0;
        String jobPath = null;
        String jobIdentifier = null;
        for (String arg : args) {
            if (arg.startsWith("-")) {
                opts.add(arg);
                continue;
            }
            switch (count) {
                case 0: {
                    jobPath = arg;
                    break;
                }
                case 1: {
                    jobIdentifier = arg;
                    break;
                }
                default: {
                    params.add(arg);
                }
            }
            ++count;
        }
        if (jobPath == null || jobIdentifier == null) {
            String message = "At least 2 arguments are required: JobPath and jobIdentifier.";
            logger.error((Object)message);
            CommandLineJobRunner.message = message;
            command.exit(1);
        }
        String[] parameters = params.toArray(new String[params.size()]);
        int result = command.start(jobPath, jobIdentifier, parameters, opts);
        command.exit(result);
    }
}

