/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope.context;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.scope.context.StepContext;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.util.ObjectUtils;

public abstract class StepContextRepeatCallback
implements RepeatCallback {
    private final Queue<ChunkContext> attributeQueue = new LinkedBlockingQueue<ChunkContext>();
    private final StepExecution stepExecution;
    private final Log logger = LogFactory.getLog(StepContextRepeatCallback.class);

    public StepContextRepeatCallback(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepeatStatus doInIteration(RepeatContext context) throws Exception {
        RepeatStatus repeatStatus;
        block4: {
            StepContext stepContext = StepSynchronizationManager.register(this.stepExecution);
            this.logger.debug((Object)("Preparing chunk execution for StepContext: " + ObjectUtils.identityToString((Object)((Object)stepContext))));
            ChunkContext chunkContext = this.attributeQueue.poll();
            if (chunkContext == null) {
                chunkContext = new ChunkContext(stepContext);
            }
            try {
                this.logger.debug((Object)("Chunk execution starting: queue size=" + this.attributeQueue.size()));
                repeatStatus = this.doInChunkContext(context, chunkContext);
                Object var6_5 = null;
                if (chunkContext.isComplete()) break block4;
                this.attributeQueue.add(chunkContext);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (!chunkContext.isComplete()) {
                    this.attributeQueue.add(chunkContext);
                }
                StepSynchronizationManager.close();
                throw throwable;
            }
        }
        StepSynchronizationManager.close();
        return repeatStatus;
    }

    public abstract RepeatStatus doInChunkContext(RepeatContext var1, ChunkContext var2) throws Exception;
}

