/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.List;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.listener.MulticasterBatchListener;
import org.springframework.batch.core.step.item.Chunk;
import org.springframework.batch.core.step.item.ChunkProcessor;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleChunkProcessor<I, O>
implements ChunkProcessor<I>,
InitializingBean {
    private ItemProcessor<? super I, ? extends O> itemProcessor;
    private ItemWriter<? super O> itemWriter;
    private final MulticasterBatchListener<I, O> listener = new MulticasterBatchListener();

    private SimpleChunkProcessor() {
        this(null, null);
    }

    public SimpleChunkProcessor(ItemProcessor<? super I, ? extends O> itemProcessor, ItemWriter<? super O> itemWriter) {
        this.itemProcessor = itemProcessor;
        this.itemWriter = itemWriter;
    }

    public void setItemProcessor(ItemProcessor<? super I, ? extends O> itemProcessor) {
        this.itemProcessor = itemProcessor;
    }

    public void setItemWriter(ItemWriter<? super O> itemWriter) {
        this.itemWriter = itemWriter;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.itemWriter, (String)"ItemWriter must be set");
        Assert.notNull(this.itemProcessor, (String)"ItemProcessor must be set");
    }

    public void setListeners(List<? extends StepListener> listeners) {
        for (StepListener stepListener : listeners) {
            this.registerListener(stepListener);
        }
    }

    public void registerListener(StepListener listener) {
        this.listener.register(listener);
    }

    protected MulticasterBatchListener<I, O> getListener() {
        return this.listener;
    }

    protected final O doProcess(I item) throws Exception {
        if (this.itemProcessor == null) {
            I result = item;
            return (O)result;
        }
        try {
            this.listener.beforeProcess(item);
            Object result = this.itemProcessor.process(item);
            this.listener.afterProcess(item, result);
            return (O)result;
        }
        catch (Exception e) {
            this.listener.onProcessError(item, e);
            throw e;
        }
    }

    protected final void doWrite(List<O> items) throws Exception {
        if (this.itemWriter == null) {
            return;
        }
        try {
            this.listener.beforeWrite(items);
            this.writeItems(items);
            this.doAfterWrite(items);
        }
        catch (Exception e) {
            this.listener.onWriteError(e, items);
            throw e;
        }
    }

    protected final void doAfterWrite(List<O> items) {
        this.listener.afterWrite(items);
    }

    protected void writeItems(List<O> items) throws Exception {
        if (this.itemWriter != null) {
            this.itemWriter.write(items);
        }
    }

    @Override
    public final void process(StepContribution contribution, Chunk<I> inputs) throws Exception {
        this.initializeUserData(inputs);
        if (this.isComplete(inputs)) {
            return;
        }
        Chunk<O> outputs = this.transform(contribution, inputs);
        contribution.incrementFilterCount(this.getFilterCount(inputs, outputs));
        this.write(contribution, inputs, this.getAdjustedOutputs(inputs, outputs));
    }

    protected void initializeUserData(Chunk<I> inputs) {
        inputs.setUserData(inputs.size());
    }

    protected int getFilterCount(Chunk<I> inputs, Chunk<O> outputs) {
        return (Integer)inputs.getUserData() - outputs.size();
    }

    protected boolean isComplete(Chunk<I> inputs) {
        return inputs.isEmpty();
    }

    protected Chunk<O> getAdjustedOutputs(Chunk<I> inputs, Chunk<O> outputs) {
        return outputs;
    }

    protected void write(StepContribution contribution, Chunk<I> inputs, Chunk<O> outputs) throws Exception {
        this.doWrite(outputs.getItems());
        contribution.incrementWriteCount(outputs.size());
    }

    protected Chunk<O> transform(StepContribution contribution, Chunk<I> inputs) throws Exception {
        Chunk<O> outputs = new Chunk<O>();
        Chunk.ChunkIterator iterator = inputs.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            O output = this.doProcess(item);
            if (output != null) {
                outputs.add(output);
                continue;
            }
            iterator.remove();
        }
        return outputs;
    }
}

