/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.SkipListener;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.listener.StepListenerFactoryBean;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.item.BatchListenerFactoryHelper;
import org.springframework.batch.core.step.item.ChunkOrientedTasklet;
import org.springframework.batch.core.step.item.SimpleChunkProcessor;
import org.springframework.batch.core.step.item.SimpleChunkProvider;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.exception.DefaultExceptionHandler;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.repeat.policy.SimpleCompletionPolicy;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.batch.repeat.support.TaskExecutorRepeatTemplate;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStepFactoryBean<T, S>
implements FactoryBean,
BeanNameAware {
    private static final int DEFAULT_COMMIT_INTERVAL = 1;
    private String name;
    private int startLimit = Integer.MAX_VALUE;
    private boolean allowStartIfComplete;
    private ItemReader<? extends T> itemReader;
    private ItemProcessor<? super T, ? extends S> itemProcessor;
    private ItemWriter<? super S> itemWriter;
    private PlatformTransactionManager transactionManager;
    private Propagation propagation = Propagation.REQUIRED;
    private Isolation isolation = Isolation.DEFAULT;
    private int transactionTimeout = -1;
    private JobRepository jobRepository;
    private boolean singleton = true;
    private ItemStream[] streams = new ItemStream[0];
    private StepListener[] listeners = new StepListener[0];
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int commitInterval = 0;
    private TaskExecutor taskExecutor;
    private RepeatOperations stepOperations;
    private RepeatOperations chunkOperations;
    private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();
    private CompletionPolicy chunkCompletionPolicy;
    private int throttleLimit = 4;
    private boolean isReaderTransactionalQueue = false;

    public void setIsReaderTransactionalQueue(boolean isReaderTransactionalQueue) {
        this.isReaderTransactionalQueue = isReaderTransactionalQueue;
    }

    protected boolean isReaderTransactionalQueue() {
        return this.isReaderTransactionalQueue;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public void setPropagation(Propagation propagation) {
        this.propagation = propagation;
    }

    public void setIsolation(Isolation isolation) {
        this.isolation = isolation;
    }

    public void setStartLimit(int startLimit) {
        this.startLimit = startLimit;
    }

    public void setAllowStartIfComplete(boolean allowStartIfComplete) {
        this.allowStartIfComplete = allowStartIfComplete;
    }

    public void setItemReader(ItemReader<? extends T> itemReader) {
        this.itemReader = itemReader;
    }

    public void setItemWriter(ItemWriter<? super S> itemWriter) {
        this.itemWriter = itemWriter;
    }

    public void setItemProcessor(ItemProcessor<? super T, ? extends S> itemProcessor) {
        this.itemProcessor = itemProcessor;
    }

    public void setStreams(ItemStream[] streams) {
        this.streams = streams;
    }

    public void setListeners(StepListener[] listeners) {
        this.listeners = listeners;
    }

    protected StepListener[] getListeners() {
        return this.listeners;
    }

    protected ItemReader<? extends T> getItemReader() {
        return this.itemReader;
    }

    protected ItemWriter<? super S> getItemWriter() {
        return this.itemWriter;
    }

    protected ItemProcessor<? super T, ? extends S> getItemProcessor() {
        return this.itemProcessor;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    protected TransactionAttribute getTransactionAttribute() {
        DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
        attribute.setPropagationBehavior(this.propagation.value());
        attribute.setIsolationLevel(this.isolation.value());
        attribute.setTimeout(this.transactionTimeout);
        return new DefaultTransactionAttribute((TransactionAttribute)attribute){

            public boolean rollbackOn(Throwable ex) {
                return true;
            }
        };
    }

    public final Object getObject() throws Exception {
        TaskletStep step = new TaskletStep(this.getName());
        this.applyConfiguration(step);
        step.afterPropertiesSet();
        return step;
    }

    public Class<TaskletStep> getObjectType() {
        return TaskletStep.class;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public void setCommitInterval(int commitInterval) {
        this.commitInterval = commitInterval;
    }

    public void setChunkCompletionPolicy(CompletionPolicy chunkCompletionPolicy) {
        this.chunkCompletionPolicy = chunkCompletionPolicy;
    }

    protected RepeatOperations getStepOperations() {
        return this.stepOperations;
    }

    public void setStepOperations(RepeatOperations stepOperations) {
        this.stepOperations = stepOperations;
    }

    public void setChunkOperations(RepeatOperations chunkOperations) {
        this.chunkOperations = chunkOperations;
    }

    protected RepeatOperations getChunkOperations() {
        return this.chunkOperations;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    protected TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setThrottleLimit(int throttleLimit) {
        this.throttleLimit = throttleLimit;
    }

    protected void applyConfiguration(TaskletStep step) {
        RepeatTemplate repeatTemplate;
        Assert.state((this.getItemReader() != null ? 1 : 0) != 0, (String)"ItemReader must be provided");
        Assert.state((this.getItemWriter() != null || this.getItemProcessor() != null ? 1 : 0) != 0, (String)"ItemWriter or ItemProcessor must be provided");
        Assert.state((this.transactionManager != null ? 1 : 0) != 0, (String)"TransactionManager must be provided");
        step.setTransactionManager(this.transactionManager);
        step.setTransactionAttribute(this.getTransactionAttribute());
        step.setJobRepository(this.jobRepository);
        step.setStartLimit(this.startLimit);
        step.setAllowStartIfComplete(this.allowStartIfComplete);
        this.registerStreams(step, this.streams);
        if (this.chunkOperations == null) {
            repeatTemplate = new RepeatTemplate();
            repeatTemplate.setCompletionPolicy(this.getChunkCompletionPolicy());
            this.chunkOperations = repeatTemplate;
        }
        if (this.stepOperations == null) {
            this.stepOperations = new RepeatTemplate();
            if (this.taskExecutor != null) {
                repeatTemplate = new TaskExecutorRepeatTemplate();
                repeatTemplate.setTaskExecutor(this.taskExecutor);
                repeatTemplate.setThrottleLimit(this.throttleLimit);
                this.stepOperations = repeatTemplate;
            }
            ((RepeatTemplate)this.stepOperations).setExceptionHandler(this.exceptionHandler);
        }
        step.setStepOperations(this.stepOperations);
        SimpleChunkProvider<T> chunkProvider = this.configureChunkProvider();
        SimpleChunkProcessor<T, S> chunkProcessor = this.configureChunkProcessor();
        this.registerItemListeners(chunkProvider, chunkProcessor);
        this.registerStepListeners(step, this.chunkOperations);
        this.registerStreams(step, this.itemReader, this.itemProcessor, this.itemWriter);
        ChunkOrientedTasklet<T> tasklet = new ChunkOrientedTasklet<T>(chunkProvider, chunkProcessor);
        tasklet.setBuffering(!this.isReaderTransactionalQueue());
        step.setTasklet(tasklet);
    }

    protected void registerStreams(TaskletStep step, ItemStream[] streams) {
        step.setStreams(streams);
    }

    protected SimpleChunkProvider<T> configureChunkProvider() {
        return new SimpleChunkProvider<T>(this.itemReader, this.chunkOperations);
    }

    protected SimpleChunkProcessor<T, S> configureChunkProcessor() {
        return new SimpleChunkProcessor<T, S>(this.itemProcessor, this.itemWriter);
    }

    private CompletionPolicy getChunkCompletionPolicy() {
        Assert.state((this.chunkCompletionPolicy == null || this.commitInterval == 0 ? 1 : 0) != 0, (String)"You must specify either a chunkCompletionPolicy or a commitInterval but not both.");
        Assert.state((this.commitInterval >= 0 ? 1 : 0) != 0, (String)"The commitInterval must be positive or zero (for default value).");
        if (this.chunkCompletionPolicy != null) {
            return this.chunkCompletionPolicy;
        }
        if (this.commitInterval == 0) {
            this.logger.info((Object)"Setting commit interval to default value (1)");
            this.commitInterval = 1;
        }
        return new SimpleCompletionPolicy(this.commitInterval);
    }

    private void registerStreams(TaskletStep step, ItemReader<? extends T> itemReader, ItemProcessor<? super T, ? extends S> itemProcessor, ItemWriter<? super S> itemWriter) {
        for (Object itemHandler : new Object[]{itemReader, itemWriter, itemProcessor}) {
            if (!(itemHandler instanceof ItemStream)) continue;
            this.registerStreams(step, new ItemStream[]{(ItemStream)itemHandler});
        }
    }

    private void registerStepListeners(TaskletStep step, RepeatOperations chunkOperations) {
        for (Object itemHandler : new Object[]{this.getItemReader(), this.itemWriter, this.itemProcessor}) {
            if (!StepListenerFactoryBean.isListener(itemHandler)) continue;
            StepListener listener = StepListenerFactoryBean.getListener(itemHandler);
            if (listener instanceof StepExecutionListener) {
                step.registerStepExecutionListener((StepExecutionListener)listener);
            }
            if (!(listener instanceof ChunkListener)) continue;
            step.registerChunkListener((ChunkListener)listener);
        }
        step.setStepExecutionListeners(BatchListenerFactoryHelper.getListeners(this.listeners, StepExecutionListener.class).toArray(new StepExecutionListener[0]));
        step.setChunkListeners(BatchListenerFactoryHelper.getListeners(this.listeners, ChunkListener.class).toArray(new ChunkListener[0]));
    }

    private void registerItemListeners(SimpleChunkProvider<T> chunkProvider, SimpleChunkProcessor<T, S> chunkProcessor) {
        StepListener[] listeners = this.getListeners();
        chunkProvider.setListeners(BatchListenerFactoryHelper.getListeners(listeners, ItemReadListener.class));
        chunkProvider.setListeners(BatchListenerFactoryHelper.getListeners(listeners, SkipListener.class));
        chunkProcessor.setListeners(BatchListenerFactoryHelper.getListeners(listeners, ItemProcessListener.class));
        chunkProcessor.setListeners(BatchListenerFactoryHelper.getListeners(listeners, ItemWriteListener.class));
        chunkProcessor.setListeners(BatchListenerFactoryHelper.getListeners(listeners, SkipListener.class));
        List<StepListener> listofListeners = Arrays.asList(listeners);
        for (Object itemHandler : new Object[]{this.getItemReader(), this.getItemWriter(), this.getItemProcessor()}) {
            if (listofListeners.contains(itemHandler) || !StepListenerFactoryBean.isListener(itemHandler)) continue;
            StepListener listener = StepListenerFactoryBean.getListener(itemHandler);
            if (listener instanceof SkipListener) {
                chunkProvider.registerListener(listener);
                chunkProcessor.registerListener(listener);
                continue;
            }
            if (listener instanceof ItemReadListener) {
                chunkProvider.registerListener(listener);
            }
            if (!(listener instanceof ItemProcessListener) && !(listener instanceof ItemWriteListener)) continue;
            chunkProcessor.registerListener(listener);
        }
    }
}

