/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.intercept.aspectj;

import org.aspectj.lang.JoinPoint;
import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.access.intercept.InterceptorStatusToken;
import org.springframework.security.access.intercept.aspectj.AspectJAnnotationCallback;
import org.springframework.security.access.method.MethodSecurityMetadataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectJAnnotationSecurityInterceptor
extends AbstractSecurityInterceptor {
    private MethodSecurityMetadataSource securityMetadataSource;

    public MethodSecurityMetadataSource getSecurityMetadataSource() {
        return this.securityMetadataSource;
    }

    @Override
    public Class<? extends Object> getSecureObjectClass() {
        return JoinPoint.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(JoinPoint jp, AspectJAnnotationCallback advisorProceed) throws Throwable {
        Object result = null;
        InterceptorStatusToken token = super.beforeInvocation(jp);
        try {
            result = advisorProceed.proceedWithObject();
        }
        finally {
            result = super.afterInvocation(token, result);
        }
        return result;
    }

    @Override
    public SecurityMetadataSource obtainSecurityMetadataSource() {
        return this.securityMetadataSource;
    }

    public void setSecurityMetadataSource(MethodSecurityMetadataSource newSource) {
        this.securityMetadataSource = newSource;
    }
}

