/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UserDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthenticationToken
implements Authentication {
    private Object details;
    private final Collection<GrantedAuthority> authorities;
    private boolean authenticated = false;

    public AbstractAuthenticationToken(Collection<GrantedAuthority> authorities) {
        if (authorities == null) {
            this.authorities = AuthorityUtils.NO_AUTHORITIES;
            return;
        }
        for (GrantedAuthority a : authorities) {
            if (a != null) continue;
            throw new IllegalArgumentException("Authorities collection cannot contain any null elements");
        }
        ArrayList<GrantedAuthority> temp = new ArrayList<GrantedAuthority>(authorities.size());
        temp.addAll(authorities);
        this.authorities = Collections.unmodifiableList(temp);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractAuthenticationToken)) {
            return false;
        }
        AbstractAuthenticationToken test = (AbstractAuthenticationToken)obj;
        if (!((Object)this.authorities).equals(test.authorities)) {
            return false;
        }
        if (this.details == null && test.getDetails() != null) {
            return false;
        }
        if (this.details != null && test.getDetails() == null) {
            return false;
        }
        if (this.details != null && !this.details.equals(test.getDetails())) {
            return false;
        }
        if (this.getCredentials() == null && test.getCredentials() != null) {
            return false;
        }
        if (this.getCredentials() != null && !this.getCredentials().equals(test.getCredentials())) {
            return false;
        }
        if (this.getPrincipal() == null && test.getPrincipal() != null) {
            return false;
        }
        if (this.getPrincipal() != null && !this.getPrincipal().equals(test.getPrincipal())) {
            return false;
        }
        return this.isAuthenticated() == test.isAuthenticated();
    }

    @Override
    public Collection<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    @Override
    public Object getDetails() {
        return this.details;
    }

    @Override
    public String getName() {
        if (this.getPrincipal() instanceof UserDetails) {
            return ((UserDetails)this.getPrincipal()).getUsername();
        }
        if (this.getPrincipal() instanceof Principal) {
            return ((Principal)this.getPrincipal()).getName();
        }
        return this.getPrincipal() == null ? "" : this.getPrincipal().toString();
    }

    @Override
    public int hashCode() {
        int code = 31;
        for (GrantedAuthority authority : this.authorities) {
            code ^= authority.hashCode();
        }
        if (this.getPrincipal() != null) {
            code ^= this.getPrincipal().hashCode();
        }
        if (this.getCredentials() != null) {
            code ^= this.getCredentials().hashCode();
        }
        if (this.getDetails() != null) {
            code ^= this.getDetails().hashCode();
        }
        if (this.isAuthenticated()) {
            code ^= 0xFFFFFFDB;
        }
        return code;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public void setDetails(Object details) {
        this.details = details;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(": ");
        sb.append("Principal: ").append(this.getPrincipal()).append("; ");
        sb.append("Password: [PROTECTED]; ");
        sb.append("Authenticated: ").append(this.isAuthenticated()).append("; ");
        sb.append("Details: ").append(this.getDetails()).append("; ");
        if (!this.authorities.isEmpty()) {
            sb.append("Granted Authorities: ");
            int i = 0;
            for (GrantedAuthority authority : this.authorities) {
                if (i++ > 0) {
                    sb.append(", ");
                }
                sb.append(authority);
            }
        } else {
            sb.append("Not granted any authorities");
        }
        return sb.toString();
    }
}

