/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.create;

import java.lang.reflect.Method;
import org.directwebremoting.create.AbstractCreator;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Messages;

public class SingletonCreator
extends AbstractCreator
implements Creator {
    private String factoryMethod = "getInstance";
    private Class clazz;

    public void setClass(String classname) {
        try {
            this.clazz = LocalUtil.classForName(classname);
            System.out.println(this.clazz.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(Messages.getString("Creator.ClassNotFound", classname));
        }
    }

    public Object getInstance() throws InstantiationException {
        try {
            Method method = this.clazz.getMethod(this.factoryMethod, null);
            return method.invoke((Object)new SingletonCreator(), null);
        }
        catch (Exception ex) {
            throw new InstantiationException(Messages.getString("Creator.IllegalAccess"));
        }
    }

    public Class getType() {
        return this.clazz;
    }

    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    public void setFactoryMethod(String functionToCall) {
        this.factoryMethod = functionToCall;
    }
}

