/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormHttpMessageConverter
extends AbstractHttpMessageConverter<MultiValueMap<String, String>> {
    public static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");

    public FormHttpMessageConverter() {
        super(new MediaType("application", "x-www-form-urlencoded"));
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return MultiValueMap.class.isAssignableFrom(clazz);
    }

    @Override
    public MultiValueMap<String, String> readInternal(Class clazz, HttpInputMessage inputMessage) throws IOException {
        MediaType contentType = inputMessage.getHeaders().getContentType();
        Charset charset = contentType.getCharSet() != null ? contentType.getCharSet() : DEFAULT_CHARSET;
        String body = FileCopyUtils.copyToString((Reader)new InputStreamReader(inputMessage.getBody(), charset));
        String[] pairs = StringUtils.tokenizeToStringArray((String)body, (String)"&");
        LinkedMultiValueMap result = new LinkedMultiValueMap(pairs.length);
        String[] stringArray = pairs;
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            int idx = pair.indexOf(61);
            if (idx == -1) {
                result.add((Object)URLDecoder.decode(pair, charset.name()), null);
            } else {
                String name = URLDecoder.decode(pair.substring(0, idx), charset.name());
                String value = URLDecoder.decode(pair.substring(idx + 1), charset.name());
                result.add((Object)name, (Object)value);
            }
            ++n2;
        }
        return result;
    }

    @Override
    protected void writeInternal(MultiValueMap<String, String> form, HttpOutputMessage outputMessage) throws IOException {
        MediaType contentType = this.getDefaultContentType(form);
        Charset charset = contentType.getCharSet() != null ? contentType.getCharSet() : DEFAULT_CHARSET;
        StringBuilder builder = new StringBuilder();
        Iterator entryIterator = form.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)entryIterator.next();
            String name = (String)entry.getKey();
            Iterator valueIterator = ((List)entry.getValue()).iterator();
            while (valueIterator.hasNext()) {
                String value = (String)valueIterator.next();
                builder.append(URLEncoder.encode(name, charset.name()));
                if (value == null) continue;
                builder.append('=');
                builder.append(URLEncoder.encode(value, charset.name()));
                if (!valueIterator.hasNext()) continue;
                builder.append('&');
            }
            if (!entryIterator.hasNext()) continue;
            builder.append('&');
        }
        FileCopyUtils.copy((String)builder.toString(), (Writer)new OutputStreamWriter(outputMessage.getBody(), charset));
    }
}

