/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.context;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.awareness.TilesRequestContextFactoryAware;
import org.apache.tiles.context.TilesContextFactory;
import org.apache.tiles.context.TilesRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedTilesContextFactory
implements TilesContextFactory {
    @Deprecated
    public static final String FACTORY_CLASS_NAMES = "org.apache.tiles.context.ChainedTilesContextFactory.FACTORY_CLASS_NAMES";
    @Deprecated
    public static final String[] DEFAULT_FACTORY_CLASS_NAMES = new String[]{"org.apache.tiles.servlet.context.ServletTilesContextFactory", "org.apache.tiles.portlet.context.PortletTilesContextFactory", "org.apache.tiles.jsp.context.JspTilesContextFactory"};
    private final Log log = LogFactory.getLog(ChainedTilesContextFactory.class);
    private List<TilesContextFactory> factories;

    @Deprecated
    public void setFactories(List<TilesContextFactory> factories) {
        this.factories = factories;
    }

    public void init(Map<String, String> configParameters) {
        String[] classNames = null;
        String classNamesString = configParameters.get(FACTORY_CLASS_NAMES);
        if (classNamesString != null) {
            classNames = classNamesString.split("\\s*,\\s*");
        }
        if (classNames == null || classNames.length <= 0) {
            classNames = DEFAULT_FACTORY_CLASS_NAMES;
        }
        this.factories = new ArrayList<TilesContextFactory>();
        for (int i = 0; i < classNames.length; ++i) {
            try {
                TilesContextFactory factory;
                Class<?> clazz = Class.forName(classNames[i]);
                if (TilesContextFactory.class.isAssignableFrom(clazz)) {
                    factory = (TilesContextFactory)clazz.newInstance();
                    if (factory instanceof TilesRequestContextFactoryAware) {
                        ((TilesRequestContextFactoryAware)((Object)factory)).setRequestContextFactory(this);
                    }
                } else {
                    throw new IllegalArgumentException("The class " + classNames[i] + " does not implement TilesContextFactory");
                }
                this.factories.add(factory);
                continue;
            }
            catch (ClassNotFoundException e) {
                this.log.warn((Object)("Cannot find TilesContextFactory class " + classNames[i]));
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Cannot find TilesContextFactory class " + classNames[i]), (Throwable)e);
                continue;
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Cannot instantiate TilesFactoryClass " + classNames[i], e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot access TilesFactoryClass " + classNames[i] + " default constructor", e);
            }
        }
    }

    @Override
    public TilesApplicationContext createApplicationContext(Object context) {
        TilesApplicationContext retValue = null;
        Iterator<TilesContextFactory> factoryIt = this.factories.iterator();
        while (factoryIt.hasNext() && retValue == null) {
            retValue = factoryIt.next().createApplicationContext(context);
        }
        if (retValue == null) {
            throw new IllegalArgumentException("Cannot find a factory to create the application context");
        }
        return retValue;
    }

    @Override
    public TilesRequestContext createRequestContext(TilesApplicationContext context, Object ... requestItems) {
        TilesRequestContext retValue = null;
        Iterator<TilesContextFactory> factoryIt = this.factories.iterator();
        while (factoryIt.hasNext() && retValue == null) {
            retValue = factoryIt.next().createRequestContext(context, requestItems);
        }
        if (retValue == null) {
            throw new IllegalArgumentException("Cannot find a factory to create the request context");
        }
        return retValue;
    }
}

