/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.context;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.awareness.TilesRequestContextFactoryAware;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.context.TilesRequestContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedTilesRequestContextFactory
implements TilesRequestContextFactory {
    public static final String FACTORY_CLASS_NAMES = "org.apache.tiles.context.ChainedTilesRequestContextFactory.FACTORY_CLASS_NAMES";
    public static final String[] DEFAULT_FACTORY_CLASS_NAMES = new String[]{"org.apache.tiles.servlet.context.ServletTilesRequestContextFactory", "org.apache.tiles.portlet.context.PortletTilesRequestContextFactory", "org.apache.tiles.jsp.context.JspTilesRequestContextFactory"};
    private final Log log = LogFactory.getLog(ChainedTilesRequestContextFactory.class);
    private List<TilesRequestContextFactory> factories;

    public void setFactories(List<TilesRequestContextFactory> factories) {
        this.factories = factories;
        this.injectParentTilesContextFactory();
    }

    public void init(Map<String, String> configParameters) {
        String[] classNames = null;
        String classNamesString = configParameters.get(FACTORY_CLASS_NAMES);
        if (classNamesString != null) {
            classNames = classNamesString.split("\\s*,\\s*");
        }
        if (classNames == null || classNames.length <= 0) {
            classNames = DEFAULT_FACTORY_CLASS_NAMES;
        }
        this.factories = new ArrayList<TilesRequestContextFactory>();
        for (int i = 0; i < classNames.length; ++i) {
            try {
                Class<?> clazz = Class.forName(classNames[i]);
                if (!TilesRequestContextFactory.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException("The class " + classNames[i] + " does not implement TilesRequestContextFactory");
                }
                TilesRequestContextFactory factory = (TilesRequestContextFactory)clazz.newInstance();
                this.factories.add(factory);
                continue;
            }
            catch (ClassNotFoundException e) {
                this.log.warn((Object)("Cannot find TilesRequestContextFactory class " + classNames[i]));
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Cannot find TilesRequestContextFactory class " + classNames[i]), (Throwable)e);
                continue;
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Cannot instantiate TilesRequestContextFactory class " + classNames[i], e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot access TilesRequestContextFactory class " + classNames[i] + " default constructor", e);
            }
        }
        this.injectParentTilesContextFactory();
    }

    @Override
    public TilesRequestContext createRequestContext(TilesApplicationContext context, Object ... requestItems) {
        TilesRequestContext retValue = null;
        Iterator<TilesRequestContextFactory> factoryIt = this.factories.iterator();
        while (factoryIt.hasNext() && retValue == null) {
            retValue = factoryIt.next().createRequestContext(context, requestItems);
        }
        if (retValue == null) {
            throw new IllegalArgumentException("Cannot find a factory to create the request context");
        }
        return retValue;
    }

    protected void injectParentTilesContextFactory() {
        for (TilesRequestContextFactory factory : this.factories) {
            if (!(factory instanceof TilesRequestContextFactoryAware)) continue;
            ((TilesRequestContextFactoryAware)((Object)factory)).setRequestContextFactory(this);
        }
    }
}

