/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition.dao;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tiles.Attribute;
import org.apache.tiles.Definition;
import org.apache.tiles.definition.DefinitionsFactoryException;
import org.apache.tiles.definition.NoSuchDefinitionException;
import org.apache.tiles.definition.Refreshable;
import org.apache.tiles.definition.dao.BaseLocaleUrlDefinitionDAO;
import org.apache.tiles.util.LocaleUtil;
import org.apache.tiles.util.WildcardHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingLocaleUrlDefinitionDAO
extends BaseLocaleUrlDefinitionDAO
implements Refreshable {
    public static final String CHECK_REFRESH_INIT_PARAMETER = "org.apache.tiles.definition.dao.LocaleUrlDefinitionDAO.CHECK_REFRESH";
    protected Map<Locale, Map<String, Definition>> locale2definitionMap;
    protected boolean checkRefresh = false;
    protected WildcardHelper wildcardHelper = new WildcardHelper();
    protected Map<Locale, List<WildcardMapping>> localePatternPaths = new HashMap<Locale, List<WildcardMapping>>();

    public CachingLocaleUrlDefinitionDAO() {
        this.locale2definitionMap = new HashMap<Locale, Map<String, Definition>>();
    }

    @Override
    public void init(Map<String, String> params) {
        super.init(params);
        String param = params.get(CHECK_REFRESH_INIT_PARAMETER);
        this.checkRefresh = "true".equals(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Definition getDefinition(String name, Locale customizationKey) {
        Map<String, Definition> definitions;
        Definition retValue = null;
        if (customizationKey == null) {
            customizationKey = LocaleUtil.NULL_LOCALE;
        }
        if ((definitions = this.getDefinitions(customizationKey)) != null && (retValue = definitions.get(name)) == null && this.localePatternPaths.containsKey(customizationKey) && (retValue = this.resolveWildcardDefinition(this.localePatternPaths.get(customizationKey), name)) != null) {
            try {
                Map<String, Definition> map = definitions;
                synchronized (map) {
                    definitions.put(name, retValue);
                }
            }
            catch (NoSuchDefinitionException ex) {
                throw new IllegalStateException("Unable to resolve wildcard mapping", (Throwable)((Object)ex));
            }
        }
        return retValue;
    }

    @Override
    public Map<String, Definition> getDefinitions(Locale customizationKey) {
        Map<String, Definition> retValue;
        if (customizationKey == null) {
            customizationKey = LocaleUtil.NULL_LOCALE;
        }
        if ((retValue = this.locale2definitionMap.get(customizationKey)) == null || this.checkRefresh && this.refreshRequired()) {
            retValue = this.checkAndloadDefinitions(customizationKey);
        }
        return retValue;
    }

    @Override
    public synchronized void refresh() {
        if (this.refreshRequired()) {
            this.locale2definitionMap.clear();
        }
    }

    public void setCheckRefresh(boolean checkRefresh) {
        this.checkRefresh = checkRefresh;
    }

    protected synchronized Map<String, Definition> checkAndloadDefinitions(Locale customizationKey) {
        if (this.checkRefresh && this.refreshRequired()) {
            this.locale2definitionMap.clear();
        }
        return this.loadDefinitions(customizationKey);
    }

    protected Map<String, Definition> loadDefinitions(Locale customizationKey) {
        Map<String, Definition> localeDefsMap = this.locale2definitionMap.get(customizationKey);
        if (localeDefsMap != null) {
            return localeDefsMap;
        }
        localeDefsMap = this.loadDefinitionsFromURLs(customizationKey);
        return localeDefsMap;
    }

    protected Map<String, Definition> loadDefinitionsFromURLs(Locale customizationKey) {
        Map<String, Definition> parentDefs;
        String postfix = LocaleUtil.calculatePostfix(customizationKey);
        Locale parentLocale = LocaleUtil.getParentLocale(customizationKey);
        HashMap<String, Definition> localeDefsMap = new HashMap<String, Definition>();
        if (parentLocale != null && (parentDefs = this.loadParentDefinitions(parentLocale)) != null) {
            localeDefsMap.putAll(parentDefs);
        }
        for (URL url : this.sourceURLs) {
            String path = url.toExternalForm();
            String newPath = LocaleUtil.concatPostfix(path, postfix);
            try {
                URL newUrl = new URL(newPath);
                Map<String, Definition> defsMap = this.loadDefinitionsFromURL(newUrl);
                if (defsMap == null) continue;
                localeDefsMap.putAll(defsMap);
            }
            catch (MalformedURLException e) {
                throw new DefinitionsFactoryException("Error parsing URL " + newPath, e);
            }
        }
        this.locale2definitionMap.put(customizationKey, localeDefsMap);
        this.postDefinitionLoadOperations(localeDefsMap, customizationKey);
        return localeDefsMap;
    }

    protected Map<String, Definition> loadParentDefinitions(Locale parentLocale) {
        return this.loadDefinitions(parentLocale);
    }

    protected void postDefinitionLoadOperations(Map<String, Definition> localeDefsMap, Locale customizationKey) {
        List<WildcardMapping> lpaths = this.localePatternPaths.get(customizationKey);
        if (lpaths == null) {
            lpaths = new ArrayList<WildcardMapping>();
            this.localePatternPaths.put(customizationKey, lpaths);
        }
        this.addWildcardPaths(lpaths, localeDefsMap);
    }

    protected void addWildcardPaths(List<WildcardMapping> paths, Map<String, Definition> defsMap) {
        for (Map.Entry<String, Definition> de : defsMap.entrySet()) {
            if (de.getKey().indexOf(42) == -1) continue;
            paths.add(new WildcardMapping(de.getKey(), de.getValue()));
        }
    }

    protected Definition resolveWildcardDefinition(List<WildcardMapping> paths, String name) {
        HashMap<Integer, String> vars = new HashMap<Integer, String>();
        Definition d = null;
        for (WildcardMapping wm : paths) {
            if (!this.wildcardHelper.match(vars, name, wm.getPattern())) continue;
            d = this.replaceDefinition(wm.getDefinition(), name, vars);
            break;
        }
        return d;
    }

    protected Definition replaceDefinition(Definition d, String name, Map<Integer, String> vars) {
        Definition nudef = new Definition();
        nudef.setExtends(this.replace(d.getExtends(), vars));
        nudef.setName(name);
        nudef.setPreparer(this.replace(d.getPreparer(), vars));
        nudef.setTemplateAttribute(this.replaceVarsInAttribute(d.getTemplateAttribute(), vars));
        for (String attributeName : d.getLocalAttributeNames()) {
            Attribute attr = d.getLocalAttribute(attributeName);
            Attribute nuattr = this.replaceVarsInAttribute(attr, vars);
            nudef.putAttribute(this.replace(attributeName, vars), nuattr);
        }
        return nudef;
    }

    private Attribute replaceVarsInAttribute(Attribute attr, Map<Integer, String> vars) {
        Attribute nuattr = new Attribute();
        nuattr.setRole(this.replace(attr.getRole(), vars));
        nuattr.setRenderer(attr.getRenderer());
        nuattr.setExpression(attr.getExpression());
        Object value = attr.getValue();
        if (value instanceof String) {
            value = this.replace((String)value, vars);
        }
        nuattr.setValue(value);
        return nuattr;
    }

    protected String replace(String st, Map<Integer, String> vars) {
        return WildcardHelper.convertParam(st, vars);
    }

    protected class WildcardMapping {
        private int[] pattern;
        private Definition definition;

        public WildcardMapping(String pattern, Definition definition) {
            this.pattern = CachingLocaleUrlDefinitionDAO.this.wildcardHelper.compilePattern(pattern);
            this.definition = definition;
        }

        public Definition getDefinition() {
            return this.definition;
        }

        public int[] getPattern() {
            return this.pattern;
        }
    }
}

