/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.diagnostics.Console;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.Propagation;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.CompositeTransactionImp;
import com.atomikos.icatch.imp.TransactionServiceImp;
import com.atomikos.icatch.system.Configuration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;

public class BaseTransactionManager
implements CompositeTransactionManager,
SubTxAwareParticipant {
    private Hashtable threadtotxmap_ = new Hashtable();
    private Hashtable txtothreadmap_ = new Hashtable();
    private TransactionServiceImp service_;
    private boolean initialized_ = false;

    protected BaseTransactionManager() {
    }

    protected void printMsg(String msg, int level) {
        try {
            Console console = Configuration.getConsole();
            if (console != null) {
                console.println(msg, level);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread getThread(CompositeTransaction ct) {
        Thread thread = null;
        Hashtable hashtable = this.txtothreadmap_;
        synchronized (hashtable) {
            thread = (Thread)this.txtothreadmap_.get(ct);
        }
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stack removeThreadMappings(Thread thread) {
        Stack ret = null;
        Hashtable hashtable = this.threadtotxmap_;
        synchronized (hashtable) {
            ret = (Stack)this.threadtotxmap_.remove(thread);
            CompositeTransaction tx = (CompositeTransaction)ret.peek();
            this.txtothreadmap_.remove(tx);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setThreadMappings(CompositeTransaction ct, Thread thread) throws IllegalStateException, SysException {
        ct.addSubTxAwareParticipant((SubTxAwareParticipant)this);
        Hashtable hashtable = this.threadtotxmap_;
        synchronized (hashtable) {
            if (TxState.ACTIVE.equals(ct.getState())) {
                Stack<CompositeTransaction> txs = (Stack<CompositeTransaction>)this.threadtotxmap_.get(thread);
                if (txs == null) {
                    txs = new Stack<CompositeTransaction>();
                }
                txs.push(ct);
                this.threadtotxmap_.put(thread, txs);
                this.txtothreadmap_.put(ct, thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreThreadMappings(Stack stack, Thread thread) throws IllegalStateException {
        CompositeTransaction tx = (CompositeTransaction)stack.peek();
        tx.addSubTxAwareParticipant((SubTxAwareParticipant)this);
        Hashtable hashtable = this.threadtotxmap_;
        synchronized (hashtable) {
            Object state = tx.getState();
            if (TxState.ACTIVE.equals(state) || TxState.MARKED_ABORT.equals(state)) {
                Stack txs = (Stack)this.threadtotxmap_.get(thread);
                if (txs != null) {
                    throw new IllegalStateException("Thread already has subtx stack");
                }
                this.threadtotxmap_.put(thread, stack);
                this.txtothreadmap_.put(tx, thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeTransactionImp getCurrentTx() {
        Thread thread = Thread.currentThread();
        Hashtable hashtable = this.threadtotxmap_;
        synchronized (hashtable) {
            Stack txs = (Stack)this.threadtotxmap_.get(thread);
            if (txs == null) {
                return null;
            }
            return (CompositeTransactionImp)txs.peek();
        }
    }

    public void init(TransactionServiceImp service, Properties properties) throws SysException {
        this.service_ = service;
        this.service_.init(properties);
        this.initialized_ = true;
    }

    public Participant getParticipant(String root) {
        return this.service_.getParticipant(root);
    }

    public void committed(CompositeTransaction tx) {
        this.removeTransaction(tx);
    }

    public void rolledback(CompositeTransaction tx) {
        this.removeTransaction(tx);
    }

    public CompositeTransaction getCompositeTransaction() throws SysException {
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        CompositeTransactionImp ct = null;
        ct = this.getCurrentTx();
        if (ct != null) {
            this.printMsg("getCompositeTransaction()  returning instance with id " + ct.getTid(), 3);
        } else {
            this.printMsg("getCompositeTransaction() returning NULL!", 3);
        }
        return ct;
    }

    public CompositeTransaction getCompositeTransaction(String tid) throws SysException {
        CompositeTransaction ret = this.service_.getCompositeTransaction(tid);
        if (ret != null) {
            this.printMsg("getCompositeTransaction ( " + tid + " ) returning instance with tid " + ret.getTid(), 3);
        } else {
            this.printMsg("getCompositeTransaction ( " + tid + " ) returning NULL!", 3);
        }
        return ret;
    }

    protected synchronized CompositeTransaction recreateCompositeTransaction(Propagation context, boolean orphancheck, boolean heur_commit) throws SysException {
        CompositeTransactionImp ct = null;
        ct = this.getCurrentTx();
        if (ct != null) {
            String msg = "Recreating a transaction with existing transaction: " + ct.getTid();
            this.printMsg(msg, 1);
        }
        ct = this.service_.recreateCompositeTransaction(context, orphancheck, heur_commit);
        Thread t = Thread.currentThread();
        this.setThreadMappings(ct, t);
        return ct;
    }

    public CompositeTransaction suspend() throws SysException {
        Thread thread = Thread.currentThread();
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        CompositeTransactionImp ret = this.getCurrentTx();
        if (ret != null) {
            this.printMsg("suspend() for transaction " + ret.getTid(), 2);
            this.removeThreadMappings(thread);
        } else {
            this.printMsg("suspend() called without a transaction context", 2);
        }
        return ret;
    }

    public void resume(CompositeTransaction ct) throws IllegalStateException, SysException {
        Thread thread = Thread.currentThread();
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        Stack ancestors = new Stack();
        Stack<CompositeTransaction> tmp = new Stack<CompositeTransaction>();
        Stack lineage = (Stack)ct.getLineage().clone();
        boolean done = false;
        while (!lineage.isEmpty() && !done) {
            CompositeTransaction parent = (CompositeTransaction)lineage.pop();
            if (!parent.isLocal()) {
                done = true;
                continue;
            }
            tmp.push(parent);
        }
        while (!tmp.isEmpty()) {
            ancestors.push(tmp.pop());
        }
        ancestors.push(ct);
        this.restoreThreadMappings(ancestors, thread);
        this.printMsg("resume ( " + ct + " ) done for transaction " + ct.getTid(), 2);
    }

    public void shutdown(boolean force) throws SysException, IllegalStateException {
        this.service_.shutdown(force);
    }

    protected void startlistening(CompositeTransaction transaction) throws SysException {
        transaction.addSubTxAwareParticipant((SubTxAwareParticipant)this);
    }

    private void removeTransaction(CompositeTransaction ct) {
        if (ct == null) {
            return;
        }
        Thread thread = this.getThread(ct);
        if (thread == null) {
            return;
        }
        Stack mappings = this.removeThreadMappings(thread);
        if (mappings != null && !mappings.empty()) {
            mappings.pop();
            if (!mappings.empty()) {
                this.restoreThreadMappings(mappings, thread);
            }
        }
    }

    public CompositeTransaction createCompositeTransaction(long timeout) throws SysException {
        Stack errors = new Stack();
        CompositeTransactionImp ct = null;
        CompositeTransaction ret = null;
        Thread thread = Thread.currentThread();
        ct = this.getCurrentTx();
        if (ct == null) {
            ret = this.service_.createCompositeTransaction(timeout);
            this.printMsg("createCompositeTransaction ( " + timeout + " ): " + "created new ROOT transaction with id " + ret.getTid(), 2);
        } else {
            this.printMsg("createCompositeTransaction ( " + timeout + " )", 2);
            ret = ct.getTransactionControl().createSubTransaction();
        }
        this.setThreadMappings(ret, thread);
        return ret;
    }
}

