/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.AtomikosJMSException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import javax.jms.JMSException;

abstract class AbstractJmsProxy
implements InvocationHandler {
    AbstractJmsProxy() {
    }

    protected void convertProxyError(Throwable ex, String msg) throws JMSException {
        if (ex instanceof Error) {
            Error err = (Error)ex;
            Configuration.logWarning((String)msg, (Throwable)err);
            throw err;
        }
        if (ex instanceof RuntimeException) {
            RuntimeException rte = (RuntimeException)ex;
            Configuration.logWarning((String)msg, (Throwable)ex);
            throw rte;
        }
        if (ex instanceof JMSException) {
            JMSException driverError = (JMSException)ex;
            Configuration.logWarning((String)msg, (Throwable)ex);
            throw driverError;
        }
        if (ex instanceof InvocationTargetException) {
            InvocationTargetException ite = (InvocationTargetException)ex;
            Throwable cause = ite.getCause();
            if (cause != null) {
                Configuration.logDebug((String)msg, (Throwable)ite);
                this.convertProxyError(cause, msg);
            } else {
                AtomikosJMSException.throwAtomikosJMSException(msg, ite);
            }
        }
        AtomikosJMSException.throwAtomikosJMSException(msg, ex);
    }
}

