/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms.extra;

import com.atomikos.icatch.jta.UserTransactionManager;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.AtomikosConnectionFactoryBean;
import com.atomikos.jms.extra.DestinationHelper;
import com.atomikos.jms.extra.MessageConsumerSessionProperties;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

class MessageConsumerSession {
    private AtomikosConnectionFactoryBean factory;
    private String user;
    private String password;
    private Destination destination;
    private String destinationName;
    private MessageConsumerSessionProperties properties;
    private boolean notifyListenerOnClose;
    private String messageSelector;
    private boolean daemonThreads;
    private transient MessageListener listener;
    protected transient ReceiverThread current;
    private UserTransactionManager tm;
    private boolean active;
    private ExceptionListener exceptionListener;
    private boolean noLocal;
    private String subscriberName;

    protected MessageConsumerSession(MessageConsumerSessionProperties properties) {
        this.properties = properties;
        this.tm = new UserTransactionManager();
        this.noLocal = false;
        this.subscriberName = null;
    }

    protected String getSubscriberName() {
        return this.subscriberName;
    }

    protected void setSubscriberName(String name) {
        this.subscriberName = name;
    }

    protected void setNoLocal(boolean value) {
        this.noLocal = value;
    }

    protected boolean getNoLocal() {
        return this.noLocal;
    }

    protected void setAtomikosConnectionFactoryBean(AtomikosConnectionFactoryBean bean) {
        this.factory = bean;
    }

    protected AtomikosConnectionFactoryBean getAtomikosConnectionFactoryBean() {
        return this.factory;
    }

    public void setDaemonThreads(boolean value) {
        this.daemonThreads = value;
    }

    public boolean getDaemonThreads() {
        return this.daemonThreads;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String selector) {
        this.messageSelector = selector;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public int getTransactionTimeout() {
        return this.properties.getTransactionTimeout();
    }

    public void setMessageListener(MessageListener listener) {
        this.listener = listener;
    }

    public MessageListener getMessageListener() {
        return this.listener;
    }

    public void startListening() throws JMSException, SystemException {
        if (this.active) {
            throw new IllegalStateException("MessageConsumerSession: startListening() called a second time without stopListening() in between");
        }
        if (this.getDestinationName() == null) {
            throw new JMSException("Please set property 'destination' or 'destinationName' first");
        }
        if (this.factory == null) {
            throw new JMSException("Please set the ConnectionFactory first");
        }
        this.tm.setStartupTransactionService(true);
        this.tm.init();
        this.tm.setStartupTransactionService(false);
        this.active = true;
        this.startNewThread();
        StringBuffer msg = new StringBuffer();
        msg.append("MessageConsumerSession configured with [");
        msg.append("user=").append(this.getUser()).append(", ");
        msg.append("password=").append(this.password).append(", ");
        msg.append("transactionTimeout=").append(this.getTransactionTimeout()).append(", ");
        msg.append("destination=").append(this.getDestinationName()).append(", ");
        msg.append("notifyListenerOnClose= ").append(this.getNotifyListenerOnClose()).append(", ");
        msg.append("messageSelector=").append(this.getMessageSelector()).append(", ");
        msg.append("daemonThreads=").append(this.getDaemonThreads()).append(", ");
        msg.append("messageListener=").append(this.getMessageListener()).append(", ");
        msg.append("exceptionListener=").append(this.getExceptionListener()).append(", ");
        msg.append("connectionFactory=").append(this.getAtomikosConnectionFactoryBean());
        msg.append("]");
        Configuration.logDebug((String)msg.toString());
    }

    public String getDestinationName() {
        String ret = this.destinationName;
        if (ret == null) {
            if (this.destination instanceof Queue) {
                Queue q = (Queue)this.destination;
                try {
                    ret = q.getQueueName();
                }
                catch (JMSException e) {
                    Configuration.logDebug((String)"Error retrieving queue name", (Throwable)e);
                }
            } else if (this.destination instanceof Topic) {
                Topic t = (Topic)this.destination;
                try {
                    ret = t.getTopicName();
                }
                catch (JMSException e) {
                    Configuration.logDebug((String)"Error retrieving topic name", (Throwable)e);
                }
            }
        }
        return ret;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    protected void startNewThread() {
        if (this.active) {
            this.current = new ReceiverThread();
            this.current.setDaemon(this.daemonThreads);
            this.current.start();
            Configuration.logDebug((String)("MessageConsumerSession: started new thread: " + this.current));
        }
    }

    private synchronized void notifyExceptionListener(JMSException e) {
        if (this.exceptionListener != null) {
            this.exceptionListener.onException(e);
        }
    }

    public void stopListening() {
        if (this.current != null) {
            this.current.close(true);
        }
        this.current = null;
        this.tm.close();
        this.active = false;
    }

    public boolean getNotifyListenerOnClose() {
        return this.notifyListenerOnClose;
    }

    public void setNotifyListenerOnClose(boolean b) {
        this.notifyListenerOnClose = b;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    class ReceiverThread
    extends Thread {
        private Connection connection;
        private Session session;

        private ReceiverThread() {
        }

        private synchronized MessageConsumer refresh() throws JMSException {
            String subscriberName;
            Object ret = null;
            this.connection = MessageConsumerSession.this.user != null ? MessageConsumerSession.this.factory.createConnection(MessageConsumerSession.this.user, MessageConsumerSession.this.password) : MessageConsumerSession.this.factory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(true, 0);
            if (MessageConsumerSession.this.getDestination() == null) {
                Destination d = DestinationHelper.findDestination(MessageConsumerSession.this.getDestinationName(), this.session);
                MessageConsumerSession.this.setDestination(d);
            }
            ret = (subscriberName = MessageConsumerSession.this.getSubscriberName()) == null ? this.session.createConsumer(MessageConsumerSession.this.destination, MessageConsumerSession.this.getMessageSelector(), MessageConsumerSession.this.getNoLocal()) : this.session.createDurableSubscriber((Topic)MessageConsumerSession.this.destination, subscriberName, MessageConsumerSession.this.getMessageSelector(), MessageConsumerSession.this.getNoLocal());
            return ret;
        }

        private synchronized void close(boolean threadWillStop) {
            if (this.session != null) {
                if (threadWillStop && MessageConsumerSession.this.subscriberName != null && MessageConsumerSession.this.properties.getUnsubscribeOnClose()) {
                    try {
                        Configuration.logWarning((String)("MessageConsumerSession: unsubscribing " + MessageConsumerSession.this.subscriberName + "..."));
                        this.session.unsubscribe(MessageConsumerSession.this.subscriberName);
                    }
                    catch (JMSException e) {
                        Configuration.logInfo((String)"MessageConsumerSession: Error unsubscribing on JMS session", (Throwable)e);
                        Configuration.logInfo((String)"MessageConsumerSession: linked exception is ", (Throwable)e.getLinkedException());
                    }
                }
                try {
                    this.session.close();
                    this.session = null;
                }
                catch (JMSException e) {
                    Configuration.logInfo((String)"MessageConsumerSession: Error closing JMS session", (Throwable)e);
                    Configuration.logInfo((String)"MessageConsumerSession: linked exception is ", (Throwable)e.getLinkedException());
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                    this.connection = null;
                }
                catch (JMSException e) {
                    Configuration.logWarning((String)"MessageConsumerSession: Error closing JMS connection", (Throwable)e);
                    Configuration.logWarning((String)"MessageConsumerSession: linked exception is ", (Throwable)e.getLinkedException());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            MessageConsumer receiver = null;
            try {
                MessageConsumerSession.this.tm.setTransactionTimeout(MessageConsumerSession.this.getTransactionTimeout());
            }
            catch (SystemException e) {
                Configuration.logWarning((String)"MessageConsumerSession: Error in JMS thread while setting transaction timeout", (Throwable)e);
            }
            Configuration.logInfo((String)"MessageConsumerSession: Starting JMS listener thread.");
            while (Thread.currentThread() == MessageConsumerSession.this.current) {
                Exception fatal2222;
                SystemException err2222;
                Configuration.logDebug((String)"MessageConsumerSession: JMS listener thread iterating...");
                boolean refresh = false;
                boolean commit = true;
                Message msg = null;
                if (receiver == null) {
                    receiver = this.refresh();
                }
                MessageConsumerSession.this.tm.setTransactionTimeout(MessageConsumerSession.this.getTransactionTimeout());
                if (MessageConsumerSession.this.tm.getTransaction() != null) {
                    Configuration.logWarning((String)("MessageConsumerSession: Detected pending transaction: " + MessageConsumerSession.this.tm.getTransaction()));
                    throw new IllegalStateException("Can't reuse listener thread with pending transaction!");
                }
                MessageConsumerSession.this.tm.begin();
                msg = receiver.receive((long)(MessageConsumerSession.this.getTransactionTimeout() * 1000 / 2));
                try {
                    if (msg != null && MessageConsumerSession.this.listener != null && Thread.currentThread() == MessageConsumerSession.this.current) {
                        Configuration.logInfo((String)("MessageConsumerSession: Consuming message: " + msg.toString()));
                        MessageConsumerSession.this.listener.onMessage(msg);
                        Configuration.logDebug((String)("MessageConsumerSession: Consumed message: " + msg.toString()));
                    } else {
                        commit = false;
                    }
                }
                catch (Exception e) {
                    Configuration.logInfo((String)("MessageConsumerSession: Error during JMS processing of message " + msg.toString() + " - rolling back."), (Throwable)e);
                    commit = false;
                }
                Object var7_10 = null;
                try {
                    if (commit) {
                        MessageConsumerSession.this.tm.commit();
                    } else {
                        MessageConsumerSession.this.tm.rollback();
                    }
                }
                catch (RollbackException e2) {
                    Configuration.logWarning((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                }
                catch (HeuristicMixedException e2) {
                    Configuration.logWarning((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                }
                catch (HeuristicRollbackException e2) {
                    Configuration.logWarning((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                }
                catch (Exception e2) {
                    Configuration.logWarning((String)"MessageConsumerSession: Error ending thread tx association", (Throwable)e2);
                    try {
                        Configuration.logDebug((String)"MessageConsumerSession: Suspending any active transaction...");
                        MessageConsumerSession.this.tm.suspend();
                    }
                    catch (SystemException err2222) {
                        Configuration.logWarning((String)"MessageConsumerSession: Error suspending transaction", (Throwable)err2222);
                        try {
                            Configuration.logDebug((String)"MessageConsumerSession: Starting new thread...");
                            MessageConsumerSession.this.startNewThread();
                        }
                        catch (Exception fatal2222) {
                            Configuration.logWarning((String)"MessageConsumerSession: Error starting new thread - stopping listener", (Throwable)e2);
                            MessageConsumerSession.this.stopListening();
                        }
                    }
                }
                if (!refresh) continue;
                receiver = null;
                this.close(false);
                {
                    continue;
                    catch (JMSException e) {
                        Configuration.logWarning((String)"MessageConsumerSession: Error in JMS thread", (Throwable)e);
                        Exception linkedException = e.getLinkedException();
                        if (linkedException != null) {
                            Configuration.logWarning((String)"Linked JMS exception is: ", (Throwable)linkedException);
                        }
                        refresh = true;
                        commit = false;
                        MessageConsumerSession.this.notifyExceptionListener(e);
                        var7_10 = null;
                        try {
                            if (commit) {
                                MessageConsumerSession.this.tm.commit();
                            } else {
                                MessageConsumerSession.this.tm.rollback();
                            }
                        }
                        catch (RollbackException e2) {
                            Configuration.logWarning((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                        }
                        catch (HeuristicMixedException e2) {
                            Configuration.logWarning((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                        }
                        catch (HeuristicRollbackException e2) {
                            Configuration.logWarning((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                        }
                        catch (Exception e2) {
                            Configuration.logWarning((String)"MessageConsumerSession: Error ending thread tx association", (Throwable)e2);
                            try {
                                Configuration.logDebug((String)"MessageConsumerSession: Suspending any active transaction...");
                                MessageConsumerSession.this.tm.suspend();
                            }
                            catch (SystemException err2222) {
                                Configuration.logWarning((String)"MessageConsumerSession: Error suspending transaction", (Throwable)err2222);
                                try {
                                    Configuration.logDebug((String)"MessageConsumerSession: Starting new thread...");
                                    MessageConsumerSession.this.startNewThread();
                                }
                                catch (Exception fatal2222) {
                                    Configuration.logWarning((String)"MessageConsumerSession: Error starting new thread - stopping listener", (Throwable)e2);
                                    MessageConsumerSession.this.stopListening();
                                }
                            }
                        }
                        if (!refresh) continue;
                        receiver = null;
                        this.close(false);
                        continue;
                    }
                    catch (Throwable e) {
                        Configuration.logWarning((String)"MessageConsumerSession: Error in JMS thread", (Throwable)e);
                        refresh = true;
                        commit = false;
                        JMSException listenerError = new JMSException("Unexpected error - please see Atomikos console file for more info");
                        MessageConsumerSession.this.notifyExceptionListener(listenerError);
                        var7_10 = null;
                        try {
                            if (commit) {
                                MessageConsumerSession.this.tm.commit();
                            } else {
                                MessageConsumerSession.this.tm.rollback();
                            }
                        }
                        catch (RollbackException e2) {
                            Configuration.logWarning((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                        }
                        catch (HeuristicMixedException e2) {
                            Configuration.logWarning((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                        }
                        catch (HeuristicRollbackException e2) {
                            Configuration.logWarning((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                        }
                        catch (Exception e2) {
                            Configuration.logWarning((String)"MessageConsumerSession: Error ending thread tx association", (Throwable)e2);
                            try {
                                Configuration.logDebug((String)"MessageConsumerSession: Suspending any active transaction...");
                                MessageConsumerSession.this.tm.suspend();
                            }
                            catch (SystemException err2222) {
                                Configuration.logWarning((String)"MessageConsumerSession: Error suspending transaction", (Throwable)err2222);
                                try {
                                    Configuration.logDebug((String)"MessageConsumerSession: Starting new thread...");
                                    MessageConsumerSession.this.startNewThread();
                                }
                                catch (Exception fatal2222) {
                                    Configuration.logWarning((String)"MessageConsumerSession: Error starting new thread - stopping listener", (Throwable)e2);
                                    MessageConsumerSession.this.stopListening();
                                }
                            }
                        }
                        if (!refresh) continue;
                        receiver = null;
                        this.close(false);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var7_10 = null;
                    try {
                        if (commit) {
                            MessageConsumerSession.this.tm.commit();
                        } else {
                            MessageConsumerSession.this.tm.rollback();
                        }
                    }
                    catch (RollbackException e2) {
                        Configuration.logWarning((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                    }
                    catch (HeuristicMixedException e2) {
                        Configuration.logWarning((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                    }
                    catch (HeuristicRollbackException e2) {
                        Configuration.logWarning((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                    }
                    catch (Exception e2) {
                        Configuration.logWarning((String)"MessageConsumerSession: Error ending thread tx association", (Throwable)e2);
                        try {
                            Configuration.logDebug((String)"MessageConsumerSession: Suspending any active transaction...");
                            MessageConsumerSession.this.tm.suspend();
                        }
                        catch (SystemException err2222) {
                            Configuration.logWarning((String)"MessageConsumerSession: Error suspending transaction", (Throwable)err2222);
                            try {
                                Configuration.logDebug((String)"MessageConsumerSession: Starting new thread...");
                                MessageConsumerSession.this.startNewThread();
                            }
                            catch (Exception fatal2222) {
                                Configuration.logWarning((String)"MessageConsumerSession: Error starting new thread - stopping listener", (Throwable)e2);
                                MessageConsumerSession.this.stopListening();
                            }
                        }
                    }
                    if (refresh) {
                        receiver = null;
                        this.close(false);
                    }
                    throw throwable;
                }
            }
            Configuration.logInfo((String)"MessageConsumerSession: JMS listener thread exiting.");
            if (MessageConsumerSession.this.listener != null && MessageConsumerSession.this.current == null && MessageConsumerSession.this.notifyListenerOnClose) {
                MessageConsumerSession.this.listener.onMessage(null);
            }
        }
    }
}

