/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.ResumePreviousTransactionSubTxAwareParticipant;
import com.atomikos.icatch.jta.ExtendedSystemException;
import com.atomikos.icatch.jta.TransactionImp;
import com.atomikos.icatch.jta.TransactionManagerFactory;
import com.atomikos.icatch.system.Configuration;
import java.util.Hashtable;
import java.util.Stack;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class TransactionManagerImp
implements TransactionManager,
SubTxAwareParticipant,
Referenceable {
    public static final String JTA_PROPERTY_NAME = "com.atomikos.icatch.jta.transaction";
    private static TransactionManagerImp singleton_ = null;
    private static int defaultTimeout;
    private static boolean default_serial;
    private int timeout_;
    private Hashtable txmap_;
    private CompositeTransactionManager ctm_;
    private int count_;
    private boolean automaticResourceRegistration_;

    private static final void raiseNoTransaction() {
        StringBuffer msg = new StringBuffer();
        msg.append("This method needs a transaction for the calling thread and none exists.\n");
        msg.append("Possible causes: either you didn't start a transaction,\n");
        msg.append("it rolledback due to timeout, or it was committed already.\n");
        msg.append("ACTIONS: You can try one of the following: \n");
        msg.append("1. Make sure you started a transaction for the thread.\n");
        msg.append("2. Make sure you didn't terminate it yet.\n");
        msg.append("3. Increase the transaction timeout to avoid automatic rollback of long transactions;\n");
        msg.append("   check http://www.atomikos.com/Documentation/JtaProperties for how to do this.");
        Configuration.logWarning((String)msg.toString());
        throw new IllegalStateException(msg.toString());
    }

    public static void setDefaultSerial(boolean serial) {
        default_serial = serial;
    }

    public static boolean getDefaultSerial() {
        return default_serial;
    }

    public static void setDefaultTimeout(int defaultTimeoutValue) {
        defaultTimeout = defaultTimeoutValue;
    }

    public static int getDefaultTimeout() {
        return defaultTimeout;
    }

    public static synchronized void installTransactionManager(CompositeTransactionManager ctm, boolean automaticResourceRegistration) {
        singleton_ = ctm == null ? null : new TransactionManagerImp(ctm, automaticResourceRegistration);
    }

    public static TransactionManager getTransactionManager() {
        return singleton_;
    }

    private TransactionManagerImp(CompositeTransactionManager ctm, boolean automaticResourceRegistration) {
        this.ctm_ = ctm;
        this.count_ = 0;
        this.timeout_ = defaultTimeout;
        this.txmap_ = new Hashtable();
        this.automaticResourceRegistration_ = automaticResourceRegistration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToMap(String tid, TransactionImp tx) {
        Hashtable hashtable = this.txmap_;
        synchronized (hashtable) {
            this.txmap_.put(tid.toString(), tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMap(String tid) {
        Hashtable hashtable = this.txmap_;
        synchronized (hashtable) {
            this.txmap_.remove(tid.toString());
        }
    }

    private CompositeTransaction getCompositeTransaction() throws ExtendedSystemException {
        CompositeTransaction ct = null;
        try {
            ct = this.ctm_.getCompositeTransaction();
        }
        catch (SysException se) {
            String msg = "Error while retrieving the transaction for the calling thread";
            Configuration.logWarning((String)msg, (Throwable)se);
            throw new ExtendedSystemException(msg, se.getErrors());
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionImp getPreviousInstance(String tid) {
        Hashtable hashtable = this.txmap_;
        synchronized (hashtable) {
            if (this.txmap_.containsKey(tid.toString())) {
                return (TransactionImp)this.txmap_.get(tid.toString());
            }
            return null;
        }
    }

    public Transaction getTransaction(String tid) {
        return this.getPreviousInstance(tid);
    }

    public void begin() throws NotSupportedException, SystemException {
        this.begin(this.timeout_);
    }

    public void begin(int timeout) throws NotSupportedException, SystemException {
        TransactionImp tx = null;
        CompositeTransaction ct = null;
        ResumePreviousTransactionSubTxAwareParticipant resumeParticipant = null;
        ct = this.ctm_.getCompositeTransaction();
        if (ct != null && ct.getProperty(JTA_PROPERTY_NAME) == null) {
            Configuration.logWarning((String)("JTA: temporarily suspending incompatible transaction: " + ct.getTid() + " (will be resumed after JTA transaction ends)"));
            ct = this.ctm_.suspend();
            resumeParticipant = new ResumePreviousTransactionSubTxAwareParticipant(ct);
        }
        try {
            ct = this.ctm_.createCompositeTransaction((long)timeout * 1000L);
            if (resumeParticipant != null) {
                ct.addSubTxAwareParticipant(resumeParticipant);
            }
            if (ct.isRoot() && TransactionManagerImp.getDefaultSerial()) {
                ct.getTransactionControl().setSerial();
            }
            ct.setProperty(JTA_PROPERTY_NAME, "true");
        }
        catch (SysException se) {
            String msg = "Error in begin()";
            Configuration.logWarning((String)msg, (Throwable)se);
            throw new ExtendedSystemException(msg, se.getErrors());
        }
        tx = new TransactionImp(ct, this.automaticResourceRegistration_);
        this.addToMap(ct.getTid(), tx);
        ct.addSubTxAwareParticipant((SubTxAwareParticipant)this);
    }

    public Transaction getTransaction() throws SystemException {
        TransactionImp ret = null;
        CompositeTransaction ct = null;
        ct = this.getCompositeTransaction();
        if (ct == null || ct.getProperty(JTA_PROPERTY_NAME) == null) {
            ret = null;
        } else {
            ret = this.getPreviousInstance(ct.getTid());
            if (ret == null && ct.getState().equals(TxState.ACTIVE)) {
                ret = new TransactionImp(ct, this.automaticResourceRegistration_);
                this.addToMap(ct.getTid(), ret);
                ct.addSubTxAwareParticipant((SubTxAwareParticipant)this);
            }
        }
        return ret;
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds > 0) {
            this.timeout_ = seconds;
        } else if (seconds == 0) {
            this.timeout_ = defaultTimeout;
        } else {
            String msg = "setTransactionTimeout: value must be >= 0";
            Configuration.logWarning((String)msg);
            throw new SystemException(msg);
        }
    }

    public int getTransactionTimeout() {
        return this.timeout_;
    }

    public Transaction suspend() throws SystemException {
        this.getTransaction();
        TransactionImp ret = null;
        CompositeTransaction ct = null;
        try {
            ct = this.ctm_.suspend();
        }
        catch (SysException se) {
            String msg = "Unexpected error while suspending the existing transaction for the current thread";
            Configuration.logWarning((String)msg, (Throwable)se);
            throw new ExtendedSystemException(msg, se.getErrors());
        }
        if (ct != null) {
            ret = this.getPreviousInstance(ct.getTid());
        }
        return ret;
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (tobj == null || !(tobj instanceof TransactionImp)) {
            String msg = "The specified transaction object is invalid for this configuration: " + tobj;
            Configuration.logWarning((String)msg);
            throw new InvalidTransactionException(msg);
        }
        TransactionImp tximp = (TransactionImp)tobj;
        try {
            this.ctm_.resume(tximp.getCT());
        }
        catch (SysException se) {
            String msg = "Unexpected error while resuming the transaction in the calling thread";
            Configuration.logWarning((String)msg, (Throwable)se);
            throw new ExtendedSystemException(msg, se.getErrors());
        }
    }

    public int getStatus() throws SystemException {
        int ret = 6;
        this.getTransaction();
        TransactionImp tx = null;
        CompositeTransaction ct = this.getCompositeTransaction();
        if (ct == null) {
            ret = 6;
        } else {
            tx = this.getPreviousInstance(ct.getTid());
            ret = tx.getStatus();
        }
        return ret;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, IllegalStateException, SecurityException {
        TransactionImp tx = null;
        CompositeTransaction ct = null;
        this.getTransaction();
        ct = this.getCompositeTransaction();
        if (ct == null) {
            TransactionManagerImp.raiseNoTransaction();
        } else {
            tx = this.getPreviousInstance(ct.getTid());
            tx.commit();
        }
    }

    public void rollback() throws IllegalStateException, SystemException, SecurityException {
        TransactionImp tx = null;
        CompositeTransaction ct = null;
        this.getTransaction();
        ct = this.getCompositeTransaction();
        if (ct == null) {
            TransactionManagerImp.raiseNoTransaction();
        } else {
            tx = this.getPreviousInstance(ct.getTid());
            tx.rollback();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Stack<SecurityException> errors = new Stack<SecurityException>();
        Transaction tx = this.getTransaction();
        if (tx == null) {
            TransactionManagerImp.raiseNoTransaction();
        }
        try {
            tx.setRollbackOnly();
        }
        catch (SecurityException se) {
            errors.push(se);
            String msg = "Unexpected error during setRollbackOnly";
            Configuration.logWarning((String)msg, (Throwable)se);
            throw new ExtendedSystemException(msg, errors);
        }
    }

    public void committed(CompositeTransaction tx) {
        this.removeFromMap(tx.getTid());
    }

    public void rolledback(CompositeTransaction tx) {
        this.removeFromMap(tx.getTid());
    }

    public Reference getReference() throws NamingException {
        return new Reference(this.getClass().getName(), new StringRefAddr("name", "TransactionManager"), TransactionManagerFactory.class.getName(), null);
    }

    static {
        default_serial = false;
    }
}

