/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.List;

public class ClassLoadingHelper {
    public static Object newProxyInstance(List initialClassLoaders, Class[] interfaces, InvocationHandler delegate) throws IllegalArgumentException {
        for (int i = 0; i < interfaces.length; ++i) {
            Class c = interfaces[i];
            initialClassLoaders.add(c.getClassLoader());
        }
        final Object[] loaders = initialClassLoaders.toArray();
        ClassLoader l = new ClassLoader(){

            public Class findClass(String name) throws ClassNotFoundException {
                Class<?> ret = null;
                for (int i = 0; ret == null && i < loaders.length; ++i) {
                    try {
                        ClassLoader loader = (ClassLoader)loaders[i];
                        ret = loader.loadClass(name);
                        continue;
                    }
                    catch (ClassNotFoundException notFound) {
                        // empty catch block
                    }
                }
                if (ret == null) {
                    throw new IllegalArgumentException("Class not found: " + name);
                }
                return ret;
            }

            public URL getResource(String name) {
                URL ret = null;
                for (int i = 0; ret == null && i < loaders.length; ++i) {
                    ClassLoader loader = (ClassLoader)loaders[i];
                    ret = loader.getResource(name);
                }
                return ret;
            }
        };
        return Proxy.newProxyInstance(l, interfaces, delegate);
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException nf) {
            clazz = Class.forName(className);
        }
        return clazz;
    }
}

