/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.WebSocketHandlerDecorator;

public class ExceptionWebSocketHandlerDecorator
extends WebSocketHandlerDecorator {
    private static final Log logger = LogFactory.getLog(ExceptionWebSocketHandlerDecorator.class);

    public ExceptionWebSocketHandlerDecorator(WebSocketHandler delegate) {
        super(delegate);
    }

    @Override
    public void afterConnectionEstablished(WebSocketSession session) {
        try {
            this.getDelegate().afterConnectionEstablished(session);
        }
        catch (Throwable ex) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(session, ex, logger);
        }
    }

    @Override
    public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) {
        try {
            this.getDelegate().handleMessage(session, message);
        }
        catch (Throwable ex) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(session, ex, logger);
        }
    }

    @Override
    public void handleTransportError(WebSocketSession session, Throwable exception) {
        try {
            this.getDelegate().handleTransportError(session, exception);
        }
        catch (Throwable ex) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(session, ex, logger);
        }
    }

    @Override
    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) {
        block2: {
            try {
                this.getDelegate().afterConnectionClosed(session, closeStatus);
            }
            catch (Throwable ex) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error((Object)("Unhandled error for " + this), ex);
            }
        }
    }

    public static void tryCloseWithError(WebSocketSession session, Throwable exception, Log logger) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Closing due to exception for " + session), exception);
        }
        if (session.isOpen()) {
            try {
                session.close(CloseStatus.SERVER_ERROR);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

