/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.OutputStream;
import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class DataPacket
extends Packet
implements SQLnetDef {
    static final boolean DEBUG2 = false;
    protected int pktOffset;
    protected int dataFlags;
    protected boolean isBufferFull = false;
    protected boolean isBufferEmpty = false;
    protected int availableBytesToSend = 0;
    protected int availableBytesToRead = 0;

    public DataPacket(SessionAtts sessionAtts, int n2) {
        super(sessionAtts, n2, 6, 0);
        this.initialize(n2);
    }

    public DataPacket(SessionAtts sessionAtts) {
        this(sessionAtts, sessionAtts.getSDU());
    }

    @Override
    protected void receive() throws IOException, NetException {
        super.receive();
        this.pktOffset = 10;
        this.dataOff = 10;
        this.dataLen = this.length - this.dataOff;
        this.dataFlags = this.buffer[8] & 0xFF;
        this.dataFlags <<= 8;
        this.dataFlags |= this.buffer[9] & 0xFF;
        if (this.type == 6 && (this.dataFlags & 0x40) != 0) {
            this.sAtts.dataEOF = true;
        }
        if (this.type == 6 && 0 == this.dataLen) {
            this.type = 7;
        }
    }

    @Override
    protected void send() throws IOException {
        this.send(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(int n2) throws IOException {
        this.buffer[8] = (byte)(n2 / 256);
        this.buffer[9] = (byte)(n2 % 256);
        this.setBufferLength(this.pktOffset);
        OutputStream outputStream = this.sAtts.ntOutputStream;
        synchronized (outputStream) {
            this.sAtts.ntOutputStream.write(this.buffer, 0, this.pktOffset);
        }
        this.pktOffset = 10;
        this.availableBytesToSend = 0;
        this.isBufferFull = false;
    }

    protected int putDataInBuffer(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = n4 = this.buffer.length - this.pktOffset <= n3 ? this.buffer.length - this.pktOffset : n3;
        if (n4 > 0) {
            System.arraycopy(byArray, n2, this.buffer, this.pktOffset, n4);
            this.pktOffset += n4;
            this.isBufferFull = this.pktOffset == this.buffer.length;
            this.availableBytesToSend = this.dataOff < this.pktOffset ? this.pktOffset - this.dataOff : 0;
        }
        return n4;
    }

    protected int getDataFromBuffer(byte[] byArray, int n2, int n3) throws NetException {
        int n4;
        int n5 = n4 = this.length - this.pktOffset <= n3 ? this.length - this.pktOffset : n3;
        if (n4 > 0) {
            System.arraycopy(this.buffer, this.pktOffset, byArray, n2, n4);
            this.pktOffset += n4;
            this.isBufferEmpty = this.pktOffset == this.length;
            this.availableBytesToRead = this.dataOff + this.dataLen - this.pktOffset;
        }
        return n4;
    }

    protected void setBufferLength(int n2) throws NetException {
        this.buffer[0] = (byte)(n2 / 256);
        this.buffer[1] = (byte)(n2 % 256);
    }

    protected void initialize(int n2) {
        this.pktOffset = 10;
        this.dataOff = 10;
        this.dataLen = n2 - this.dataOff;
        this.dataFlags = 0;
    }
}

