/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleConnection;
import oracle.jpub.runtime.Util;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.ORADataFactory;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class MutableStruct {
    int length;
    STRUCT pickled;
    Datum[] datums;
    Object[] attributes;
    CustomDatumFactory[] old_factories;
    ORADataFactory[] factories;
    int[] sqlTypes;
    boolean pickledCorrect;
    boolean[] isNChar;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Dec_02_19:13:26_PST_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public MutableStruct(STRUCT sTRUCT, int[] nArray, ORADataFactory[] oRADataFactoryArray) {
        this.length = oRADataFactoryArray.length;
        this.pickled = sTRUCT;
        this.factories = oRADataFactoryArray;
        this.sqlTypes = nArray;
        this.initNChar(nArray.length);
        this.pickledCorrect = true;
    }

    public MutableStruct(Object[] objectArray, int[] nArray, ORADataFactory[] oRADataFactoryArray) {
        this.length = oRADataFactoryArray.length;
        this.attributes = objectArray;
        this.factories = oRADataFactoryArray;
        this.sqlTypes = nArray;
        this.initNChar(nArray.length);
        this.pickledCorrect = false;
    }

    public MutableStruct(STRUCT sTRUCT, int[] nArray, CustomDatumFactory[] customDatumFactoryArray) {
        this.length = customDatumFactoryArray.length;
        this.pickled = sTRUCT;
        this.old_factories = customDatumFactoryArray;
        this.sqlTypes = nArray;
        this.initNChar(nArray.length);
        this.pickledCorrect = true;
    }

    public MutableStruct(Object[] objectArray, int[] nArray, CustomDatumFactory[] customDatumFactoryArray) {
        this.length = customDatumFactoryArray.length;
        this.attributes = objectArray;
        this.old_factories = customDatumFactoryArray;
        this.sqlTypes = nArray;
        this.initNChar(nArray.length);
        this.pickledCorrect = false;
    }

    public Datum toDatum(Connection connection, String string) throws SQLException {
        if (!this.pickledCorrect) {
            this.pickled = new STRUCT(StructDescriptor.createDescriptor(string, connection), connection, this.getDatumAttributes(connection));
            this.pickledCorrect = true;
        }
        return this.pickled;
    }

    public Datum toDatum(oracle.jdbc.OracleConnection oracleConnection, String string) throws SQLException {
        return this.toDatum((Connection)oracleConnection, string);
    }

    public Datum toDatum(OracleConnection oracleConnection, String string) throws SQLException {
        return this.toDatum((Connection)oracleConnection, string);
    }

    public Object getAttribute(int n2) throws SQLException {
        Object object = this.getLazyAttributes()[n2];
        if (object == null) {
            Datum datum = this.getLazyDatums()[n2];
            if (this.old_factories == null) {
                this.attributes[n2] = object = Util.convertToObject(datum, this.sqlTypes[n2], this.factories[n2]);
                if (Util.isMutable(datum, this.factories[n2])) {
                    this.resetDatum(n2);
                }
            } else {
                this.attributes[n2] = object = Util.convertToObject(datum, this.sqlTypes[n2], this.old_factories[n2]);
                if (Util.isMutable(datum, this.old_factories[n2])) {
                    this.resetDatum(n2);
                }
            }
        }
        return object;
    }

    public Object getOracleAttribute(int n2) throws SQLException {
        Object object;
        if (this.old_factories == null) {
            if (this.factories[n2] == null) {
                object = this.getDatumAttribute(n2, null);
                Datum datum = this.getLazyDatums()[n2];
                if (Util.isMutable(datum, this.factories[n2])) {
                    this.pickledCorrect = false;
                }
            } else {
                object = this.getAttribute(n2);
            }
        } else if (this.old_factories[n2] == null) {
            object = this.getDatumAttribute(n2, null);
            Datum datum = this.getLazyDatums()[n2];
            if (Util.isMutable(datum, this.old_factories[n2])) {
                this.pickledCorrect = false;
            }
        } else {
            object = this.getAttribute(n2);
        }
        return object;
    }

    public Object[] getAttributes() throws SQLException {
        for (int i2 = 0; i2 < this.length; ++i2) {
            this.getAttribute(i2);
        }
        return this.attributes;
    }

    public Object[] getOracleAttributes() throws SQLException {
        Object[] objectArray = new Object[this.length];
        for (int i2 = 0; i2 < this.length; ++i2) {
            objectArray[i2] = this.getOracleAttribute(i2);
        }
        return objectArray;
    }

    public void setAttribute(int n2, Object object) throws SQLException {
        if (object == null) {
            this.getLazyDatums();
        }
        this.resetDatum(n2);
        this.getLazyAttributes()[n2] = object;
    }

    public void setDoubleAttribute(int n2, double d2) throws SQLException {
        this.setAttribute(n2, d2);
    }

    public void setFloatAttribute(int n2, float f2) throws SQLException {
        this.setAttribute(n2, Float.valueOf(f2));
    }

    public void setIntAttribute(int n2, int n3) throws SQLException {
        this.setAttribute(n2, n3);
    }

    public void setOracleAttribute(int n2, Object object) throws SQLException {
        if (this.old_factories == null) {
            if (this.factories[n2] == null) {
                this.setDatumAttribute(n2, (Datum)object);
            } else {
                this.setAttribute(n2, object);
            }
        } else if (this.old_factories[n2] == null) {
            this.setDatumAttribute(n2, (Datum)object);
        } else {
            this.setAttribute(n2, object);
        }
    }

    Datum getDatumAttribute(int n2, Connection connection) throws SQLException {
        Datum datum = this.getLazyDatums()[n2];
        if (datum == null) {
            Object object = this.getLazyAttributes()[n2];
            this.datums[n2] = datum = Util.convertToOracle(object, connection, this.isNChar(n2));
        }
        return datum;
    }

    void setDatumAttribute(int n2, Datum datum) throws SQLException {
        this.resetAttribute(n2);
        this.getLazyDatums()[n2] = datum;
        this.pickledCorrect = false;
    }

    Datum[] getDatumAttributes(Connection connection) throws SQLException {
        for (int i2 = 0; i2 < this.length; ++i2) {
            this.getDatumAttribute(i2, connection);
        }
        return (Datum[])this.datums.clone();
    }

    void resetAttribute(int n2) throws SQLException {
        if (this.attributes != null) {
            this.attributes[n2] = null;
        }
    }

    void resetDatum(int n2) throws SQLException {
        if (this.datums != null) {
            this.datums[n2] = null;
        }
        this.pickledCorrect = false;
    }

    Object[] getLazyAttributes() {
        if (this.attributes == null) {
            this.attributes = new Object[this.length];
        }
        return this.attributes;
    }

    Datum[] getLazyDatums() throws SQLException {
        if (this.datums == null) {
            if (this.pickled != null) {
                this.datums = this.pickled.getOracleAttributes();
                this.pickledCorrect = true;
                if (this.attributes != null) {
                    for (int i2 = 0; i2 < this.length; ++i2) {
                        if (this.attributes[i2] == null) continue;
                        this.datums[i2] = null;
                        this.pickledCorrect = false;
                    }
                }
            } else {
                this.datums = new Datum[this.length];
            }
        }
        return this.datums;
    }

    private void initNChar(int n2) {
        this.isNChar = new boolean[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.isNChar[i2] = false;
        }
    }

    public void setNChar(int n2) throws SQLException {
        this.isNChar[n2] = true;
    }

    public boolean isNChar(int n2) throws SQLException {
        boolean bl = this.isNChar[n2];
        return bl;
    }
}

