/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.GeneratedScrollableResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;

class InsensitiveScrollableResultSet
extends GeneratedScrollableResultSet {
    protected boolean isAllFetched;
    protected boolean isDoneFetchingRows = false;
    protected final int maxRows;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    InsensitiveScrollableResultSet(PhysicalConnection physicalConnection, OracleStatement oracleStatement) throws SQLException {
        super(physicalConnection, oracleStatement);
        this.fetchedRowCount = oracleStatement.validRows;
        this.isAllFetched = oracleStatement.isAllFetched;
        this.maxRows = oracleStatement.getMaxRows();
        if (this.maxRows > 0 && this.maxRows < this.fetchedRowCount) {
            this.fetchedRowCount = this.maxRows;
            this.doneFetchingRows(false);
        }
    }

    protected boolean isForwardOnly() {
        return false;
    }

    @Override
    public int getType() {
        return 1004;
    }

    @Override
    public int getConcurrency() {
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                return;
            }
            super.close();
            if (this.statement.numReturnParams > 0) {
                return;
            }
            this.doneFetchingRows(false);
            this.statement.endOfResultSet(false);
            this.statement.closeCursorOnPlainStatement();
            this.statement.closeByDependent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "wasNull");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.wasNullValue(this.currentRow);
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getMetaData");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getMetaData");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (!this.statement.isOpen) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 144, "getMetaData");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getResultSetMetaData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement getStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getStatement");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getStatement");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.wrapper == null ? this.statement : this.statement.wrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getColumnIndex(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.statement.setPrefetchInternal(n2, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getPrefetchInternal(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBeforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "isBeforeFirst");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "isBeforeFirst");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return !this.isEmptyResultSet() && this.currentRow == -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "isAfterLast");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "isAfterLast");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.currentRow == this.fetchedRowCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "isFirst");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "isFirst");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return !this.isEmptyResultSet() && this.currentRow == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "isLast");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "isLast");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isForwardOnly()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "isLast");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (!this.isAllFetched && this.currentRow + 1 == this.fetchedRowCount) {
                this.fetchMoreRows();
            }
            assert (this.isAllFetched || this.fetchedRowCount > this.currentRow + 1) : "isAllFetched: " + this.isAllFetched + ", fetchedRowCount: " + this.fetchedRowCount + ", currentRow: " + this.currentRow;
            if (this.fetchedRowCount == 0) {
                return false;
            }
            return this.isAllFetched && this.currentRow + 1 == this.fetchedRowCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getRow");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getRow");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isEmptyResultSet()) {
                return 0;
            }
            if (this.currentRow == this.fetchedRowCount) {
                return 0;
            }
            return this.currentRow + 1;
        }
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "absolute");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.connection.isClosed()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "absolute");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.statement.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "absolute");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.isForwardOnly()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "absolute");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.absoluteInternal(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "first");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "first");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "first");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isForwardOnly()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "first");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.absoluteInternal(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.statement.sqlKind.isPlsqlOrCall()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 166, "next");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "next");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "next");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "next");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.absoluteInternal(this.currentRow + 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean previous() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "previous");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "previous");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "previous");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isForwardOnly()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "previous");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow > -1) {
                return this.absoluteInternal(this.currentRow);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "last");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "last");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "last");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isForwardOnly()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "last");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isEmptyResultSet()) {
                return false;
            }
            while (!this.isAllFetched) {
                this.fetchMoreRows();
            }
            this.currentRow = this.fetchedRowCount - 1;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "beforeFirst");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "beforeFirst");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "beforeFirst");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isForwardOnly()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "beforeFirst");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.absolute(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "afterLast");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "afterLast");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "afterLast");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isForwardOnly()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "afterLast");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (!this.isEmptyResultSet()) {
                while (!this.isAllFetched) {
                    this.fetchMoreRows();
                }
                this.currentRow = this.fetchedRowCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean relative(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "relative");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.connection.isClosed()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "relative");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "relative");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isForwardOnly()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "relative");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 == 0) {
                return this.isValidRow();
            }
            if (n2 == 1) {
                return this.next();
            }
            if (n2 == -1) {
                return this.previous();
            }
            if (this.currentRow + n2 < 0) {
                return this.absoluteInternal(0);
            }
            return this.absoluteInternal(this.currentRow + n2 + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (!this.statement.isRowidPrepended) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "refreshRow");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "refreshRow");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "refreshRow");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0 || this.currentRow >= this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            try {
                int n2 = this.currentRow;
                if (this.getFetchDirection() == 1001) {
                    n2 = Math.max(0, this.currentRow - this.getFetchSize());
                }
                this.refreshRows(n2, this.getFetchSize());
            }
            catch (SQLRecoverableException sQLRecoverableException) {
                throw sQLRecoverableException;
            }
            catch (SQLException sQLException) {
                SQLException sQLException2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Unsupported syntax for refreshRow()", (Throwable)sQLException);
                sQLException2.fillInStackTrace();
                throw sQLException2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfColumns()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getObject(this.currentRow, n2, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentRow == this.fetchedRowCount) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.getAuthorizationIndicator(this.currentRow, n2);
        }
    }

    void hackLast() throws SQLException {
        assert (this.isAfterLast()) : "not after last";
        this.currentRow = this.fetchedRowCount - 1;
    }

    protected boolean absoluteInternal(int n2) throws SQLException {
        int n3 = n2 - 1;
        if (n2 == 0) {
            this.currentRow = n3;
        } else if (n3 >= 0 && n3 < this.fetchedRowCount) {
            this.currentRow = n3;
        } else if (n3 >= 0) {
            while (!this.isAllFetched && this.fetchedRowCount <= n3) {
                this.fetchMoreRows();
            }
            if (n3 < this.fetchedRowCount) {
                this.currentRow = n3;
            } else {
                assert (this.isAllFetched) : "isAllFetched: " + this.isAllFetched;
                this.currentRow = this.fetchedRowCount;
                if (this.isForwardOnly()) {
                    this.doneFetchingRows(false);
                }
            }
        } else {
            while (!this.isAllFetched) {
                this.fetchMoreRows();
            }
            n3 = this.fetchedRowCount + n2;
            this.currentRow = n3 >= 0 && n3 < this.fetchedRowCount ? n3 : -1;
        }
        assert (this.currentRow < this.fetchedRowCount || this.isAllFetched) : "currentRow: " + this.currentRow + ", fetchedRowCount: " + this.fetchedRowCount + ", isAllFetched: " + this.isAllFetched;
        assert (-1 <= this.currentRow && this.currentRow <= this.fetchedRowCount) : "currentRow: " + this.currentRow + ", fetchedRowCount: " + this.fetchedRowCount;
        return this.currentRow > -1 && this.currentRow < this.fetchedRowCount;
    }

    protected void fetchMoreRows() throws SQLException {
        assert (!this.isAllFetched) : "isAllFetched: " + this.isAllFetched;
        this.clearWarnings();
        this.fetchedRowCount += this.statement.fetchMoreRows(this.fetchedRowCount);
        this.isAllFetched = this.statement.isAllFetched;
        if (this.currentRow == this.fetchedRowCount && this.isForwardOnly()) {
            this.doneFetchingRows(false);
        }
        if (this.maxRows > 0 && this.fetchedRowCount > this.maxRows) {
            this.fetchedRowCount = this.maxRows;
            this.doneFetchingRows(false);
            this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 275);
        }
    }

    @Override
    protected void doneFetchingRows(boolean bl) throws SQLException {
        if (this.isDoneFetchingRows) {
            return;
        }
        this.isDoneFetchingRows = true;
        this.isAllFetched = true;
        try {
            this.statement.closeQuery();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected boolean isEmptyResultSet() throws SQLException {
        if (this.fetchedRowCount > 0) {
            return false;
        }
        if (this.isAllFetched) {
            return true;
        }
        this.fetchMoreRows();
        assert (this.fetchedRowCount >= 0) : "fetchedRowCount: " + this.fetchedRowCount;
        return this.fetchedRowCount == 0;
    }

    @Override
    boolean isValidRow() throws SQLException {
        return this.currentRow > -1 && this.currentRow < this.fetchedRowCount;
    }

    protected int getValidRows() {
        return this.fetchedRowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OracleStatement getOracleStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.statement;
        }
    }

    @Override
    void removeCurrentRowFromCache() throws SQLException {
        assert (this.currentRow < this.fetchedRowCount) : "currentRow:" + this.currentRow + " fetchedRowCount:" + this.fetchedRowCount;
        if (!this.isAllFetched && this.currentRow + 1 == this.fetchedRowCount) {
            this.fetchMoreRows();
        }
        this.statement.removeRowFromCache(this.currentRow);
        --this.fetchedRowCount;
    }

    @Override
    int refreshRows(int n2, int n3) throws SQLException {
        return this.statement.refreshRows(n2, n3);
    }

    @Override
    void insertRow(RowId rowId) throws SQLException {
        if (this.currentRow < this.fetchedRowCount) {
            this.statement.insertRow(this.currentRow + 1, rowId);
            ++this.currentRow;
        } else {
            this.statement.insertRow(this.currentRow, rowId);
        }
        ++this.fetchedRowCount;
    }

    @Override
    int getColumnCount() throws SQLException {
        if (this.statement.accessors != null) {
            return this.statement.numberOfDefinePositions - (1 + this.statement.offsetOfFirstUserColumn);
        }
        return this.getMetaData().getColumnCount();
    }

    RowId getPrependedRowId() throws SQLException {
        return this.statement.getPrependedRowId(this.currentRow);
    }
}

