package com.jang.doc.controller;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.jang.doc.logic.UserService;
import com.jang.doc.model.User;

@Controller
public class UserEditController {
	
	@Resource(name = "userService")
	private UserService userService;
	
	@Resource(name="messageSource")
	private MessageSource messageSource;
	
	/*set 과 <bean>을 사용할 경우
	  public void setMessageSource(MessageSource messageSource){
	  this.messageSource = messageSource;
	  }
	  
	  public void setUserService(UserService userService){
	  this.userService = userService;
	  }
	 */
	@RequestMapping(value="/userEdit", method = RequestMethod.GET)
	public String toUserEditView(HttpServletRequest request, Model model) {
		User user = new User();//command (전달) 객체 생성
		
		MessageSourceAccessor accessor = new MessageSourceAccessor(this.messageSource);
	/*	
		user.setId(accessor.getMessage("user.userId.default"));
		user.setName(accessor.getMessage("user.userName.default"));
		user.setPass(accessor.getMessage("error.required.user.pass"));
		user.setAddr1(accessor.getMessage("error.required.user.addr1"));
		user.setAddr2(accessor.getMessage("error.required.user.addr2"));
		user.setEmail(accessor.getMessage("error.required.user.email"));
		user.setPhone(accessor.getMessage("error.required.user.phone"));
		user.setZip(accessor.getMessage("error.required.user.zip"));
	*/	
		String userId = request.getParameter("userId");
		
		try {
			user = this.userService.getUser(userId);
			model.addAttribute("user", user);
			return "userEditForm";
		}
		catch (EmptyResultDataAccessException e) {
			model.addAttribute("user", user);
			return "userEditForm";
		}
	}
	@RequestMapping(value="/userEdit", method = RequestMethod.POST)
	public String onSubmit( @Valid User user, BindingResult result, Model model)throws Exception{
		if(result.hasErrors()) {
			model.addAllAttributes(result.getModel());
			return "userEditForm";
		}
		try {
			this.userService.updateUser(user);
			model.addAttribute("user", user);
			return "userEntrySuccess";
		}
		catch (DataIntegrityViolationException e) {
			result.reject("error.duplicate.user");
			model.addAllAttributes(result.getModel());
			return "userEditForm";
		}
	}
}
