package com.jang.doc.dao;

import org.apache.tomcat.jdbc.pool.DataSource;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

import com.jang.doc.model.User;

public class UserDaoImpl implements UserDao {

	private JdbcTemplate jdbcTemplate;
	private NamedParameterJdbcTemplate jdbcTemplate2;
	
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
		this.jdbcTemplate2 = new NamedParameterJdbcTemplate(dataSource);
	}
	
	@Override
	public void update(User user) {
		String SQL_UP = "UPDATE member_tbl SET pass=:pass, zip=:zip, addr1=:addr1, addr2=:addr2, "
					+ " phone=:phone, email=:email WHERE id = :id";
		
		SqlParameterSource parameterSource = new BeanPropertySqlParameterSource(user);
		
		this.jdbcTemplate2.update(SQL_UP, parameterSource);
	}
	
	@Override
	public User findUser(String userId, String password) {
		
		String GETUSER_IDPASS = "SELECT id, pass, name,  zip,"
				+ " addr1, addr2, phone, email FROM member_tbl WHERE id = ? AND pass = ?";
		/*String SQL_USER = "SELECT id,pass,name,zip,addr1,addr2,phone,email" 
							+ " FROM member_tbl WHERE id =? AND pass =?"; */
		RowMapper<User> mapper = new BeanPropertyRowMapper<User>(User.class);
		
		return this.jdbcTemplate.queryForObject(GETUSER_IDPASS, mapper, userId, password);
		//return this.jdbcTemplate.queryForObject(SQL_USER, mapper, userId, password);
	}
	

	@Override
	public User findUser(String userId) {
		String GETUSER_ID = "SELECT id, pass, neme, zip,"
				+ " addr1, addr2, phone, email FROM member_tbl WHERE id = ?";
		RowMapper<User> mapper = new BeanPropertyRowMapper<User>(User.class);
		
		return this.jdbcTemplate.queryForObject(GETUSER_ID, mapper, userId);
	}

	@Override
	protected Object clone() throws CloneNotSupportedException {
		// TODO Auto-generated method stub
		return super.clone();
	}

	@Override
	public boolean equals(Object arg0) {
		// TODO Auto-generated method stub
		return super.equals(arg0);
	}

	@Override
	protected void finalize() throws Throwable {
		// TODO Auto-generated method stub
		super.finalize();
	}

	@Override
	public int hashCode() {
		// TODO Auto-generated method stub
		return super.hashCode();
	}

	@Override
	public String toString() {
		// TODO Auto-generated method stub
		return super.toString();
	}
}