package com.jang.doc.dao;

import org.apache.tomcat.jdbc.pool.DataSource;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

import com.jang.doc.model.User;

public class UserDaoImpl implements UserDao {
	
	private JdbcTemplate jdbcTemplate;
	private NamedParameterJdbcTemplate jdbcTemplate2;
	
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
		this.jdbcTemplate2 = new NamedParameterJdbcTemplate(dataSource);
	}

	@Override
	public User findUser(String userId, String password) {
		// TODO Auto-generated method stub
		
		String SQL_USER = "SELECT id, pass, name, zip, addr1, addr2, phone, email " + "FROM member_tbl WHERE id = ? AND pass = ?";
		
		//System.out.println("UserDaoImpl findUser -> !");
		RowMapper<User> mapper = new BeanPropertyRowMapper<User>(User.class);
		
		return this.jdbcTemplate.queryForObject(SQL_USER, mapper, userId, password);
	}
	public User findUser(String userId) {
		// TODO Auto-generated method stub
		String GETUSER_ID = "SELECT id, pass, name, zip," + " addr1, addr2, phone, email FROM member_tbl WHERE id = ?";
		
		RowMapper<User> mapper = new BeanPropertyRowMapper<User>(User.class);
		
		return this.jdbcTemplate.queryForObject(GETUSER_ID, mapper, userId);
	}

	public void update(User user) {
		// TODO Auto-generated method stub
		String SQL_UP = "UPDATE member_tbl SET pass=:pass, zip=:zip, addr1=:addr1, addr2=:addr2, " + "phone=:phone, email=:email WHERE id = :id";
		
		SqlParameterSource parameterSource = new BeanPropertySqlParameterSource(user);
		
		this.jdbcTemplate2.update(SQL_UP, parameterSource);
	}
	
	public void insert(User user) {
		// TODO Auto-generated method stub
		String SQL_INS = "INSERT INTO member_tbl (id, pass, name, zip ,addr1, addr2, phone, email)" + " VALUES(:Id, :pass, :Name, :zip, :addr1, :addr2, :phone, :eamil)";
		
		SqlParameterSource parameterSource = new BeanPropertySqlParameterSource(user);
		
		this.jdbcTemplate2.update(SQL_INS, parameterSource);
	}

	public User findId(String name) {
		// TODO Auto-generated method stub
		String SQL_GETID = "select id from member_tbl where name=?";
		
		RowMapper<User> mapper = new BeanPropertyRowMapper<User>(User.class);
		
		return this.jdbcTemplate.queryForObject(SQL_GETID, mapper, name);
	}

	public User findPass(String userId, String name) {
		// TODO Auto-generated method stub
		String SQL_GETPASS = "select pass from member_tbl where id=? and name=?";
		
		RowMapper<User> mapper = new BeanPropertyRowMapper<User>(User.class);
		
		return this.jdbcTemplate.queryForObject(SQL_GETPASS, mapper, name);
	}

	public void delete(String userId, String password) {
		// TODO Auto-generated method stub
		this.jdbcTemplate.update("delete from member_tbl where id = ? AND pass = ?", userId, password);
	}
}