package com.jang.doc.controller;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import com.jang.doc.logic.UserService;
import com.jang.doc.model.User;

@Controller
public class UserJoinController {

	@Resource(name = "userService")
	private UserService userService;

	@RequestMapping(value="/userJoin.do", method = RequestMethod.GET) // login 회원가입
	public String toUserEntryView(Model model) {
		model.addAttribute("user", new User());
		return "userJoinForm";
	}
	
	@RequestMapping(value="/checkid.do", method = RequestMethod.GET) // ID중복체크
	public String duplicatedId(HttpServletRequest request, Model model) {
		String userId = request.getParameter("userId");
		
		String message="";
		int reDiv = 0;
		try {
			User loginUser = this.userService.getUser(userId);
			message="이미 사용된 아이디 입니다.";
			reDiv=0;
			userId="";
		} catch(EmptyResultDataAccessException e) {
			message="사용 가능한 아이디 입니다.";
			reDiv=1;
		}
		model.addAttribute("user", new User());
		model.addAttribute("message", message);
		model.addAttribute("reDiv", reDiv);
		model.addAttribute("userId", userId);
		
		return "userJoinForm";
	}
	
	@RequestMapping(value="/userJoin.do", method = RequestMethod.POST) // 회원가입완료
	public String onSubmit(@Valid User user, BindingResult result, Model model) throws Exception {
		if (result.hasErrors()) {
			model.addAllAttributes(result.getModel());
			return "userJoinForm";
		}
		
		try {
			this.userService.insertUser(user);
			model.addAttribute("user", user);
			return "userEntrySuccess";
		} catch(DataIntegrityViolationException e) {
			result.reject("error.duplicate.user");
			model.addAllAttributes(result.getModel());
			return "userJoinFrom";
		}
	}
}