package com.jang.doc.dao;

import org.apache.tomcat.jdbc.pool.DataSource;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

import com.jang.doc.model.User;

public class UserDaoImpl implements UserDao {

	private JdbcTemplate jdbcTemplate;
	private NamedParameterJdbcTemplate jdbcTemplate2;

	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
		this.jdbcTemplate2 = new NamedParameterJdbcTemplate(dataSource);
	}

	public User findUser(String userId, String password) {
		String sql_user = "select id, pass, name, zip, addr1, addr2, phone, email"
				+ " from member_tbl where id=? and pass=?";

		RowMapper<User> mapper = new BeanPropertyRowMapper<User>(User.class);

		return this.jdbcTemplate.queryForObject(sql_user, mapper, userId, password);
	}

	public User findUser(String userId) {
		String SQL_USER = "select id, pass, name, zip, addr1, addr2, phone, email" + " from member_tbl where id=?";

		RowMapper<User> mapper = new BeanPropertyRowMapper<User>(User.class);

		return this.jdbcTemplate.queryForObject(SQL_USER, mapper, userId);
	}

	public void update(User user) {
		String SQL_UP = "update member_tbl set pass=:pass, zip=:zip, addr1=:addr1, addr2=:addr2, phone=:phone, email=:email where id=:id";

		SqlParameterSource parameterSource = new BeanPropertySqlParameterSource(user);

		this.jdbcTemplate2.update(SQL_UP, parameterSource);
	}

	public void insert(User user) {
		String SQL_INS = "insert into member_tbl (id, pass, name, zip, addr1, addr2, phone, email)"
				+ " values(:id, :pass, :name, :zip. :addr1, :addr2, :phone, :email)";

		SqlParameterSource parameterSource = new BeanPropertySqlParameterSource(user);

		this.jdbcTemplate2.update(SQL_INS, parameterSource);
	}

}
