package com.jang.doc.controller;

import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import com.jang.doc.logic.UserService;
import com.jang.doc.model.User;

@Controller
public class LoginController {
	
	@Resource(name = "userService") //@Autowired
	private UserService userService;
	
	@RequestMapping(value="/login", method = RequestMethod.GET)
	public String toLoginView() {
		return "loginForm"; //리턴 타입이 String이면 리턴 값은 뷰 이름으로 사용
	}
	
	/*
	public String toLoginView(Model model) {
		
		model.addAttribute("user", new User());
		return "loginForm"; //리턴 타입이 String이면 리턴 값은 뷰 이름으로 사용
	}
	*/
	
	@ModelAttribute("user")
	public User setUpForm() {
		return new User();
	}
	
	@RequestMapping(value="/login", method = RequestMethod.POST)
	public ModelAndView onSubmit(@ModelAttribute("user") @Valid User user, BindingResult result) {
		
		//this.loginValidator.validate(user, bindingResult);
		
		ModelAndView model = new ModelAndView();
		
		//모든 필드에서 하나라도 에러 발생 if(result.hasErros())
		if (result.hasFieldErrors("id")||result.hasFieldErrors("pass")) {
			//model.addAllObjects(result.getModel());
			//model.setViewName("loginForm");
			//return model;
			model.addAllObjects(result.getModel());
			model.setViewName("loginForm");
			
			return model;
		}
		try {
			User loginUser = this.userService.getUser(user.getId(), user.getPass());
			//model.addAttribute("loginUser", loginUser);
			//return "loginSucess";
			model.setViewName("loginSucess");
			model.addObject("loginUser", loginUser);
			return model;
		} catch (EmptyResultDataAccessException e) { //id pass 가 입력되었으나 틀린 경우
			//.reject 에러 메시지를 MessageSource 객체에서 검색하여 모델에 추가
			result.reject("error.login.user"); //error.login.user=아이디나 패스워드가 일치하지 않습니다.
			//model.addAllAttributes(result.getModel());
			//return "loginForm";
			model.addAllObjects(result.getModel());
			model.setViewName("loginForm");
			return model;
		}
	}

}
