package com.jang.doc.controller;

import javax.annotation.Resource;
import javax.validation.Valid;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

import com.jang.doc.logic.UserService;
import com.jang.doc.model.User;

@Controller

public class LoginController {

	@Resource(name = "userService")
	private UserService userService;
	
	@RequestMapping(value="/login", method = RequestMethod.GET)
	public String toLginView() {
		return "loginForm";
	}
	@ModelAttribute("user")
	public User setUpForm() {
		return new User();
	}
	@RequestMapping(value="/login", method = RequestMethod.POST)
	public ModelAndView onSubmit(@ModelAttribute("user") @Valid User user, BindingResult result) {
	ModelAndView model = new ModelAndView();
		
	if(result.hasFieldErrors("id")||result.hasFieldErrors("pass")) {
		model.addAllObjects(result.getModel());
		model.setViewName("loginForm");
		
		return model;
	}
	
			try {
			User loginUser = this.userService.getUser(user.getId(),user.getPass());
			
			model.addObject("loginUser",loginUser);
			model.setViewName("loginSucess");
			return model;
		}catch(EmptyResultDataAccessException e) {
			result.reject("error.login.user");
			model.addAllObjects(result.getModel());
			model.setViewName("loginForm");
			return model;
		}
		
		
	}
}
