package com.jang.doc.dao;

import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.apache.tomcat.jdbc.pool.DataSource;
import com.jang.doc.model.User;

public class UserDaoImpl implements UserDao {

	private JdbcTemplate jdbcTemplate;
	private NamedParameterJdbcTemplate jdbcTeplate2;
	
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
		this.jdbcTeplate2 = new NamedParameterJdbcTemplate(dataSource);
		
	}
	
	public User findUser(String userId, String password) {
		
		String SQL_USER = "SELECT id,pass,name,zip,addr1,addr2,phone,email"
				+" FROM member_tbl WHERE id = ? AND pass = ?";
		RowMapper<User> mapper = new BeanPropertyRowMapper<User>(User.class);
		
		return this.jdbcTemplate.queryForObject(SQL_USER, mapper, userId, password);
	
	}
	public User findUser(String userId) {
		String GETUSER_ID = "SELECT id, pass, name, zip,"
				+"addr1,addr2,phone,email FROM member_tbl WHERE id= ?";
		
		RowMapper<User> mapper = new BeanPropertyRowMapper<User>(User.class);
		return this.jdbcTemplate.queryForObject(GETUSER_ID, mapper,userId);
	}

	public void update(User user) {
		// TODO Auto-generated method stub
		
	}

}
