package com.jang.doc.controller;

import javax.annotation.Resource;
import javax.validation.Valid;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

import com.jang.doc.logic.UserService;
import com.jang.doc.model.User;

@Controller
public class LoginController {
	
	@Resource(name = "userService")
	private UserService userService;
	
	@RequestMapping(value="/login", method = RequestMethod.GET)
	
	public String toLoginView(Model model) {
		model.addAttribute("user", new User());
		return "loginForm";
	}
	
	
	
	@RequestMapping(value="/login", method = RequestMethod.POST)

	public String onSubmit(@Valid User user, BindingResult result, Model model) {
		

		
		if(result.hasFieldErrors("id")||result.hasFieldErrors("pass")) {
			
			model.addAllAttributes(result.getModel());
			return "loginForm";
		}
		try {
			User loginUser = this.userService.getUser(user.getId(), user.getPass());
			
			model.addAttribute("loginUser", loginUser);
			return "loginSuccess";
		}catch(EmptyResultDataAccessException e) {
			result.reject("error.login.user");
			
			model.addAllAttributes(result.getModel());
			return "loginForm";
		}
	}

}
