package com.jang.doc.controller;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.jang.doc.logic.UserService;
import com.jang.doc.model.User;

@Controller      // �̰� ������ ���� Ŭ������ �ڵ����� ��ü�� �����ϰ� �ϴ°� (servlet-context�� �ִ� component-scan �� ���� ����)
public class FindIdController {

	@Autowired                           // @Resource(name="userService")
	private UserService userService;     // private UserService userService;  �� ���� �ǹ�

	@RequestMapping(value = "/findId_form", method = RequestMethod.GET)   // url�� findId_form �̸�
	public String toFindidView(Model model){
		model.addAttribute("user", new User());
		return "findId_form";                                            // findId_form.jsp �� �����
	}

	@RequestMapping(value="/findId_form", method=RequestMethod.POST)
	public String onSubmit(@Valid User user, BindingResult result, Model model){     // User user �� DTO ��ü�� ���ε� �ϴ°�   , BindingResult result �� ��ȿ�� �˻� �κ�
		
		if(result.hasFieldErrors("name") || result.hasFieldErrors("email")){
			model.addAllAttributes(result.getModel());
			return "findId_form";
		}

		try{
			User loginUser=this.userService.getUserId(user.getName());
			model.addAttribute("loginUser", loginUser);
			model.addAttribute(result.getModel());
			return "findIdSuccess";
			
		} catch(EmptyResultDataAccessException e){
			result.reject("error.find.userid");
			model.addAllAttributes(result.getModel());
			return "findId_form";
		}
	}
}