package com.jang.doc.controller;

import javax.annotation.Resource;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.jang.doc.logic.UserService;
import com.jang.doc.model.User;

@Controller
public class FindPassController {

	@Autowired                           // @Resource(name="userService")
	private UserService userService;     // private UserService userService;    ǹ
	
	@RequestMapping(value = "/findPass_form", method = RequestMethod.GET)
	public String toFindpwView(Model model){
		model.addAttribute("user", new User());
		return "findPass_form";
	}

	@RequestMapping(value="/findPass_form", method=RequestMethod.POST)
	public String onSubmit(@Valid User user, BindingResult result, Model model){
		
		if(result.hasFieldErrors("id") || result.hasFieldErrors("name")){
			model.addAllAttributes(result.getModel());
			return "findPass_form";
		}
		
		try{
			User loginUser=this.userService.getUserPass(user.getId(), user.getName());
			model.addAttribute("loginUser", loginUser);
			model.addAttribute(result.getModel());
			return "findPassSuccess";
		} catch(EmptyResultDataAccessException e){
			result.reject("error.find.userpw");
			model.addAllAttributes(result.getModel());
			return "findPass_form";
		}
	}
}
